`timescale 1ns/1ps

module pma_model(
    input           i_rst_n,
    input   [1:0]   i_rate,

    output          TX_CLK,
    input   [63:0]  TXD,


    output          RX_CLK,
    output  [63:0]  RXD
    );


real FREQ;
logic   tx_clk;
logic   rx_clk;


always_comb begin
    case(i_rate)
        2'b00 : FREQ = 74.25;
        2'b01 : FREQ = 148.5;
        2'b10 : FREQ = 148.5;
        2'b11 : FREQ = 297.0;
        default : FREQ = 297.0;
    endcase
end

localparam FIFO_DEPTH   = 32;
localparam AW           = $clog2(FIFO_DEPTH);
logic   [FIFO_DEPTH-1:0][63:0]  fifo;

initial begin
    for(int i = 0; i < FIFO_DEPTH; i ++)
        fifo[i] = 0;
end

logic   [AW-1:0]    waddr;
logic   [AW-1:0]    raddr;

always @(posedge tx_clk or negedge i_rst_n)
    if(!i_rst_n)
        waddr <= FIFO_DEPTH - 3;
    else
        waddr <= waddr + 1'b1;


always @(posedge tx_clk or negedge i_rst_n)
    if(!i_rst_n)
        raddr <= '0;
    else
        raddr <= raddr + 1'b1;

always @(posedge tx_clk)
    fifo[waddr] <= TXD;

logic   [63:0]  rdata;

always @(posedge rx_clk)
    rdata <= fifo[raddr];


initial begin
    #1;
    forever begin
        #(1000/FREQ/2);
        tx_clk = ~tx_clk;
    end
end

initial begin
    #1;
    forever begin
        #(1000/FREQ/2);
        rx_clk = ~rx_clk;
    end
end


initial begin
    tx_clk = 1'b0;
    rx_clk = 1'b1;
end


assign TX_CLK = tx_clk;
assign RX_CLK = rx_clk;
assign RXD = rdata;

endmodule
