#!/bin/bash

if [ $# == 1 ]; then
	echo "Simulation Start"
elif [ $# == 2 ]; then
	echo "GUI Simulation Start"
else
	echo "Usage: sim.sh [scenario]"
	exit 0
fi


if [ -e ./scenario/$1.sv ]; then
  \cp ./scenario/$1.sv scenario.sv
else
	echo "No Scenario File"
	exit 0
fi

rm -rf work

vlib work

vlog ./tb/test.sv \
-lint \
-incr \
+delay_mode_zero \
+notimingchecks \
-sv \
-timescale 1ns/1ps \
+libext+.v+.h+.vo+.sv \
-f filelist.f \
-l log/$1.vlog.log \
-time

if [ $# == 1 ]; then
	vsim work.test \
	-c \
	-l ./log/$1.vsim.log \
	+nowarn8233 \
	-do "run -all;quit"
elif [ "$2" == "-gui" ]; then
	vsim -suppress 12110 -novopt work.test \
	-l ./log/$1.vsim.log \
	+nowarn8233 \
	-do ./wave.do
else
	echo "Error"
fi

date

rm ./scenario.sv

if [ "$2" == "-gui" ]; then
	rm ./*.wlf
fi
