
1. System Requirement:
 - Linux operating system.
 - Questasim or Modelsim.
 - Compiled Efinity project. -- The project should include the fifos.

2. Directories and Files
```
.
├─ log                      -- Log directory
│
├─ scenario
│     ├─ tst_ds4_6g.sv      -- 6G-SDI test scenario
│     ├─ tst_ds4_3g.sv      -- 3G-SDI test scenario
│     └─ tst_ds4_hd.sv      -- HD-SDI test scenario
│
├─ filelist.f               -- source file list
│
├─ sim.sh                   -- run script
│
├─ wave.do                  -- Wave dump option
│
└─ tb
   ├─ pma_model.sv          -- simple TX/RX model
   ├─ sdi_tx_model.sv       -- SDI Source model
   ├─ task_common.sv        -- Common tasks
   └─ test.sv               -- Test bench
```

3. Run simulation
- Without GUI
  - ./sim.sh [scenario]
  - ex) ./sim.sh tst_ds8_12g

- With GUI window and dump wave
  - ./sim.sh [scenario] -gui
  - ex) ./sim.sh tst_ds8_12g -gui

4. Test bench Overview
```
  +----------------+          +------------------+        +-----------+
  | SDI TX Source  |          | sdi_tx_wrapper   |        |           |
  | (sdi_tx_model) |-----+--> |                  | -----> | PMA model |
  |                |     |    |                  |        |           |
  +----------------+     |    +------------------+        |           |
                         |                                |           |
                         |                                |           |
  +----------------+     |    +------------------+        |           |
  |                | <---+    | sdi_rx_wrapper   |        |           |
  | Data Comparison| <--------|                  | <----- |           |
  |                |          |                  |        |           |
  +----------------+          +------------------+        +-----------+
```
