`define simple_log 1


integer errnum = 0;
integer infonum = 0;
integer warningnum= 0;

event ev_sim_end;

task sim_end;
  begin
    -> ev_sim_end;
    #10;
                    $display("        :::::::::::::::::::::::");
    if(errnum != 0) $display("        :: Result |   FAIL   ::");
    else            $display("        :: Result |   PASS   ::");
                    $display("        ::--------+----------::");
                    $display("        :: Total  | %8d ::",errnum);
                    $display("        :::::::::::::::::::::::");
    $display("======================================");
    $display("Info   : %d", infonum);
    $display("Waring : %d", warningnum);
    $display("Error  : %d", errnum);
    $finish;
  end
endtask

task tb_err(input string msg, input string fname, input integer line);
  begin
    errnum = errnum + 1;
`ifdef simple_log 
    $display(":: Error   :: %t, %s",$time, msg);
`else
    $display(":: Error   :: %t, %s @(%s [%4d])",$time, msg, fname, line);
`endif
  end
endtask

task tb_info(input string msg, input string fname, input integer line);
  begin
    infonum = infonum + 1;
`ifdef simple_log 
    $display(":: Info    :: %t, %s",$time, msg);
`else
    $display(":: Info    :: %t, %s @(%s [%4d])",$time, msg, fname, line);
`endif
  end
endtask

task tb_warning(input string msg, input string fname, input integer line);
  begin
    warningnum = warningnum + 1;
`ifdef simple_log 
    $display(":: Warning :: %t, %s",$time, msg);
`else
    $display(":: Warning :: %t, %s @(%s [%4d])",$time, msg, fname, line);
`endif
  end
endtask

`define sim_error(msg) \
  tb_err(msg, `__FILE__, `__LINE__)

`define sim_info(msg) \
  tb_info(msg, `__FILE__, `__LINE__)

`define sim_warning(msg) \
  tb_warning(msg, `__FILE__, `__LINE__)


task watch_dog_time;
begin
    #100ms;
    `sim_error("Watch Dog Time!!!!!!");
    $finish;
end
endtask

initial begin
    watch_dog_time();
end



