
module sdi_tx_model #(
    parameter DS_NUM = 4
)(
    input                       i_clk,
    input                       i_rst,

    input                       i_level_b,
    input                       i_type2,
    input   [1:0]               i_sdi_mode,


    output  [DS_NUM-1:0][9:0]   o_data_ds,
    output  [10:0]              o_tx_line,
    output                      o_sav,
    output                      o_frame_start

);

// Config
logic           p_level_b;
logic           p_type2;
logic   [1:0]   p_sdi_mode;
logic           dual_mode;
logic   [15:0]  p_hmax;
logic   [3:0]   p_tx_ptn = '0;

assign p_level_b = i_level_b;
assign p_type2   = i_type2;
assign p_sdi_mode = i_sdi_mode;


assign p_hmax = (p_level_b || p_type2) ? 16'd4400 : 16'd2200;
assign dual_mode = p_level_b || p_type2;

// Internal
logic   [15:0]  hcnt;
logic           hd;
logic   [15:0]  vcnt;
logic           lval;
logic           fval_a;
logic           fval_b;
logic           fval;
logic           field;
logic   [9:0]   xyz;
logic           ce;
logic   [15:0]  lval_buf;
logic           all_one;
logic           all_zero;
logic           sav_en;
logic           eav_en;
logic           xyz_en;
logic   [DS_NUM-1:0][9:0] data;
logic   [DS_NUM-1:0][9:0] data_d1;
logic           y_valid;
logic           c_valid;
logic           ln0_en;
logic           crc0_en;
logic           crc1_en;
logic           c_crc0_en;
logic           c_crc1_en;
logic           y_crc0_en;
logic           y_crc1_en;
logic           y_crc_clr;
logic           y_crc_calc;
logic           y_crc_calc_en;
logic           c_crc_clr;
logic           c_crc_calc;
logic           c_crc_calc_en;

always @(posedge i_clk)
    if(i_rst)
        hcnt <= '0;
    else if(hd)
        hcnt <= '0;
    else
        hcnt <= hcnt + 1'b1;

assign hd = hcnt == p_hmax - 1'b1;

always @(posedge i_clk)
    if(i_rst)
        vcnt <= p_level_b ? 21-5 : 42-5;
    else if(p_level_b || p_type2) begin
        if(hcnt == 3839) begin
            if(vcnt == 1125) vcnt <= 1;
            else             vcnt <= vcnt + 1;
        end
    end
    else begin
        if(hcnt == 1919) begin
            if(vcnt == 1125) vcnt <= 1;
            else             vcnt <= vcnt + 1;
        end
    end

assign lval   = (p_level_b|p_type2) ? hcnt > 12'd3839 : hcnt > 12'd1919;
assign fval_a = (vcnt < 11'd42) | (vcnt > 11'd1121);
assign fval_b = (vcnt < 11'd21) | ((vcnt > 11'd560) & (vcnt < 11'd584)) | (vcnt > 11'd1123);
assign fval   = p_level_b ? fval_b : fval_a;
assign field  = p_level_b ? (vcnt > 11'd563) : 1'b0;

// xyz(TRS code)
always_comb begin
    case({field, fval, lval})
        3'b000  :   xyz = 10'h200;     // field0 SAV o_f active line
        3'b001  :   xyz = 10'h274;     // field0 EAV o_f active line
        3'b010  :   xyz = 10'h2ac;     // field0 SAV o_f vertical blanking
        3'b011  :   xyz = 10'h2d8;     // field0 EAV o_f vertical blanking
        3'b100  :   xyz = 10'h31c;     // field1 SAV o_f active line
        3'b101  :   xyz = 10'h368;     // field1 EAV o_f active line
        3'b110  :   xyz = 10'h3b0;     // field1 SAV o_f vertical blanking
        3'b111  :   xyz = 10'h3c4;     // field1 EAV o_f vertical blanking
    endcase
end

assign ce = dual_mode ? hcnt[0] : 1'b1;

always @(posedge i_clk)
    if(i_rst)
        lval_buf <= '1;
    else if(ce)
        lval_buf <= {lval_buf[14:0], lval};

assign all_one = ({lval_buf[0], lval} == 2'b10) |
                 (lval_buf[4:3]       == 2'b01) ;


assign all_zero = (lval_buf[1:0] == 2'b10) |
                  (lval_buf[2:1] == 2'b10) |
                  (lval_buf[5:4] == 2'b01) |
                  (lval_buf[6:5] == 2'b01) ;

assign xyz_en = (lval_buf[3:2] == 2'b10) |
                (lval_buf[7:6] == 2'b01) ;

always @(posedge i_clk)
    if(i_rst)
        for (int i = 0; i < DS_NUM; i++) data[i] <= '0;
    else if(all_one)
        for (int i = 0; i < DS_NUM; i++) data[i] <= '1;
    else if(all_zero)
        for (int i = 0; i < DS_NUM; i++) data[i] <= '0;
    else if(xyz_en)
        for (int i = 0; i < DS_NUM; i++) data[i] <= xyz;
    else begin
        for (int i = 0; i < DS_NUM; i++) begin
            if(p_tx_ptn == 4'd0)      data[i] <= $urandom_range(10'h004, 10'h3FB);
            else if(p_tx_ptn == 4'd1) data[i] <= i[0] ? 10'h200 : 10'h040;
        end
    end

always @(posedge i_clk)
    if(i_rst)
        data_d1 <= '0;
    else
        data_d1 <= data;

logic   [7:0]   sav_buf;

always @(posedge i_clk)
    if(i_rst) begin
        sav_buf <= '0;
    end
    else begin
        sav_buf <= {sav_buf[6:0], (lval_buf[3:2] == 2'b10)};
    end


assign o_sav = (p_level_b || p_type2) ? (sav_buf[1]) : (sav_buf[0]);

logic    sav;
assign sav = (p_level_b || p_type2) ? sav_buf[1] : sav_buf[0];

assign o_frame_start = p_level_b ? (sav & (vcnt == 21)) : (sav & (vcnt == 42));

// Output
assign o_data_ds    = dual_mode ? data_d1 : data;
assign o_tx_line    = vcnt;

endmodule
