﻿ 
`timescale 1ns / 1ns
 
module ddr_cfg#(
)
(
input                           clk,
input                           rstn,

output  wire                    cfg_start,
output  wire                    cfg_reset,
output  wire                    cfg_sel,
output  wire                    ddr_arstn,
input                           cfg_done

 
);

//Parameter Define
 
//Register Define
reg 	[1:0]					ddr_cfg_ok_dly; 

//Wire Define
wire 							ddr_cfg_ok ; 
//Encryption begin
/*----------------------------------------------------------------------------------*\
                                The main code
\*----------------------------------------------------------------------------------*/
 
/*------------------------------ Common Region -----------------------------*/
always@(posedge clk)
begin
	ddr_cfg_ok_dly <= {ddr_cfg_ok_dly[0],ddr_cfg_ok} ;
	// rstn		   <= ddr_cfg_ok_dly[1];
end 

localparam [1:0]    IDLE        = 2'b00,
                    CFG_START   = 2'b01,
                    CFG_DONE    = 2'b11;

reg 	[1:0]   cfg_st, cfg_next;
reg 	[7:0]   cfg_count;
reg     [7:0]   rst_delay_cnt ;
//Reset and PLL

always@(posedge clk or negedge rstn)
begin
    if(rstn == 1'b0) 
        cfg_count <= 8'h0;
    else if (cfg_st == IDLE)
        cfg_count <= cfg_count + 1'b1;
    else 
        cfg_count <= 8'h0;  
end


always@(posedge clk or negedge rstn)
begin
    if(rstn == 1'b0) 
        cfg_st <= IDLE;
    else 
        cfg_st <= cfg_next;   
end


always@(*)
begin
    case(cfg_st)
    IDLE:
    begin
        if(cfg_count == 8'hff)
            cfg_next = CFG_START;
        else
            cfg_next = IDLE;
    end
    CFG_START:
    begin
        if(cfg_done == 1'b1)
            cfg_next = CFG_DONE;
        else
            cfg_next = CFG_START;
    end
    CFG_DONE:
        cfg_next = CFG_DONE;
    default:
        cfg_next = IDLE;
    endcase
end

always @(posedge clk or negedge rstn)
begin
	if(rstn == 1'b0) 
		rst_delay_cnt <= 0; 
	else if((cfg_next == CFG_DONE) && (rst_delay_cnt[7] == 1'b0)) 
		rst_delay_cnt <= rst_delay_cnt + 1;
	 
end 

assign ddr_cfg_ok = rst_delay_cnt[7] ;//(cfg_st == CFG_DONE);

assign cfg_start  = (cfg_st != IDLE);
assign cfg_reset  = (cfg_st == IDLE);
assign cfg_sel    = 1'b0;

assign ddr_arstn  = (cfg_st == CFG_DONE);//ddr_cfg_ok;

//Encryption end
endmodule
