`timescale 1ns / 1ns

module wr_downsizer #(
    parameter                       AXI_AW   = 32,
    parameter                       S_AXI_DW = 64,
    parameter                       M_AXI_DW = 32,
    parameter                       ID_WTH   = 8,
    parameter                       FAMILY   = "TITANIUM"
)
(
//Global Signals
input                           clk,
input                           rstn,
//Slave AXI4 Bus Interface
//--Slave AXI4 Write
input                           s_axi_awvalid,
output  reg                     s_axi_awready,
input           [AXI_AW-1:0]    s_axi_awaddr,
input           [7:0]           s_axi_awlen,
input           [ID_WTH-1:0]    s_axi_awid,
input                           s_axi_wvalid,
output  reg                     s_axi_wready,
input           [S_AXI_DW-1:0]  s_axi_wdata,
input           [S_AXI_DW/8-1:0]s_axi_wstrb,
input                           s_axi_wlast,
output  reg                     s_axi_bvalid,
input                           s_axi_bready,
output  reg     [1:0]           s_axi_bresp,
output  reg     [ID_WTH-1:0]    s_axi_bid,

//Master AXI4 Bus Interface
//--Master AXI4 Bus Write 
output  reg                     m_axi_awvalid,
input                           m_axi_awready,
output  reg     [AXI_AW-1:0]    m_axi_awaddr,
output  reg     [7:0]           m_axi_awlen,
output  reg     [ID_WTH-1:0]    m_axi_awid,
output  wire    [2:0]           m_axi_awsize,
output  wire    [1:0]           m_axi_awburst,
output  wire    [1:0]           m_axi_awlock,
output  wire    [3:0]           m_axi_awcache,
output  wire    [2:0]           m_axi_awprot,
output  reg                     m_axi_wvalid,
input                           m_axi_wready,
output  wire    [M_AXI_DW-1:0]  m_axi_wdata,
output  wire    [M_AXI_DW/8-1:0]m_axi_wstrb,
output  wire                    m_axi_wlast,
input                           m_axi_bvalid,
output  reg                     m_axi_bready,
input           [1:0]           m_axi_bresp,
input           [ID_WTH-1:0]    m_axi_bid

);
//Parameter Define
localparam                      RATIO       = S_AXI_DW/M_AXI_DW;
localparam                      RATIO_W     = ($clog2(RATIO) == 0) ? 1 : $clog2(RATIO);
localparam                      S_AXI_SW    = S_AXI_DW/8;
localparam                      M_AXI_SW    = M_AXI_DW/8;
localparam                      S_BURST_WTH = RATIO_W + 8; 

//Register Define
reg     [S_BURST_WTH:0]         s_burst_cnt;
reg     [S_BURST_WTH:0]         s_burst_cnt_r;
reg     [RATIO_W:0]             split_cmd_cnt;
reg     [RATIO_W:0]             split_cmd_cnt_r;
reg     [S_AXI_DW-1:0]          in_data;
reg     [S_AXI_SW-1:0]          in_strb;
reg                             in_last;
reg     [RATIO_W:0]             in_cnt;
reg                             sr_en;
reg     [1:0]                   sr_cnt;
reg     [M_AXI_DW-1:0]          sr_data_r1;
reg     [M_AXI_SW-1:0]          sr_strb_r1;
reg                             sr_last_r1;
reg     [M_AXI_DW-1:0]          sr_data_r0;
reg     [M_AXI_SW-1:0]          sr_strb_r0;
reg                             sr_last_r0;
reg                             temp_wlast;
reg     [7:0]                   m_axi_cnt;
reg     [RATIO_W-1:0]           sr_last_cnt;
reg                             wvalid_en_next;
reg     [RATIO_W-1:0]           bresp_cnt;

//Wire Define
wire                            u0_wen;
wire    [RATIO_W:0]             u0_wdata;
wire                            u0_almfull;
wire                            u0_ren;
wire    [RATIO_W:0]             u0_rdata;
wire                            u0_empty;
wire                            in_en;
wire                            out_en;


`pragma protect begin_protected
`pragma protect version=1
`pragma protect encrypt_agent="ipecrypt"
`pragma protect encrypt_agent_info="http://ipencrypter.com Version: 20.0.8"
`pragma protect author="author-a"
`pragma protect author_info="author-a-details"
`pragma protect data_method="aes256-cbc"

`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIF-SIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
CNWBHmONvCIO5TRwmo5zzhvTEPrv9YYVHgZB9OHww0FVRz+q3ccH/emYGJTsq7ZS
oqDOanEy280TqmMH2e8POCaOv6pE+qrFRWM1Yh6eKCRvA/zjnFbdA0ylJij2vz+V
3+rbf8NpCblNdj6uZn9UM4KERasZoafcRa7SpN04r4o=
`pragma protect key_keyowner="Aldec"
`pragma protect key_method="rsa"
`pragma protect key_keyname="ALDEC15_001"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
xZZUOe/hBBAAgvB33fwcicJdrYz6M2l6petuNAveVcGNdI7hvRljZ/lVuKxi+laB
FmFUsPdxx3alQyIU+0yYJ66d/SL2k+p79S6IHLZwGJkGNaqhSJjAnL51bO5wCizD
d5jPOT72CWv16GDetWRLzL09gN62BuidNccZnzxIi1IlajXfZKmrVjgiYSs4xXA5
+MlpDsbcHr7QlY/RqNZUOXDHE+9PYl9xG5aQzVs7X7IUrWvJnOvp8wXLumnPgs6T
OsaZAFRjLM+uJqLrhhFNsFaOOqZ1NqtF9e6TuD6jxcH+IlGW92YoNc3zB8O6QqKF
YTlpCFRBnTBI0Idn6JFxfw==
`pragma protect key_keyowner="Synopsys"
`pragma protect key_method="rsa"
`pragma protect key_keyname="SNPS-VCS-RSA-2"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
qaRYPOYe5B+qvzjjGiaNFYvHL9l20NEUkQxABHd0vQh6ecdS3pVnhv6sEJqllT1Z
Fvzh21LN/Mysiyae0kUXBpSEc0o79sNteOkfxC1RnWViEe3mbGzf/ObD67nF8Jq3
1vM17j1GJ7fjHFh+/2iB0WZWTVxabOJ3yJKYVF4z0LA=
`pragma protect key_keyowner="Cadence Design Systems."
`pragma protect key_method="rsa"
`pragma protect key_keyname="CDS_RSA_KEY_VER_1"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
lquQK5WGfMYs1qBan4obuVT2BlxrW0Ysta5GsP/JKn3ClVUDR/buG0B03A9Y4Bvx
QjgndKf2rtM2fVyHiXeao6i5Mjrdh3cRKCL4cDSLxpx3TJnaNW9vNNek60KTHi6N
wJH0pMTiyljRKja1IF7SQGRKlOt0IDpUzQ4iXzjEwWJez56Oy0RgocAfHX1U5xn/
yqqlhg7PRVfQ6bBme0frGfe4o/0KKVCYwhWRrPBpiUqnJ5vjKPXgnRtF33ehkL9m
T6QPYDtjvBoLPBvszm2Dx3cnl9rZ329Zqps1aNE9SVKN2E/MrIOqUzLA1KCWrLKK
RN8ZbltHSn6C0QGOyblzWw==
`pragma protect key_keyowner="Efinix Inc."
`pragma protect key_keyname="EFX_K01"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
jaKnU5/iI0C3d9yhrvLD8lO9QkIUDINrySzwTb4UVoiaIsjDjpsg4akQGlTzZ+hJ
MZxfLXa+BmEgB0n3WssYmiFCUghyklK7/YPlCZPSDT9lT1FJnEAW7BorJiJrB6ZN
3NDUW2ntirEHvbVUOr1lg0ykGHgzHLHfnqvLeO6IKkvlER/ilJNDu1kHIafhNZlV
VZqvZK3Sd53pnWzr4fkQibVpztuNP/fluprrFvWGb9l1dowC/rRl4Wc5E/iho3fR
xJJWr4PyfavDGdORa6wLzB9Zqh2CkI97TsLWBAlcntpLKoi3hgSuobD7bqw0sA/H
+GccsVF3y0nkgH49eAVT4Q==
`pragma protect encoding=(enctype="base64", line_length=64, bytes=15664)
`pragma protect data_block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`pragma protect end_protected
endmodule
