`timescale 1ns / 1ns

module axi_adapter#(
    parameter                       AXI_AW                  = 32,
    parameter                       S_AXI_DW                = 32,
    parameter                       M_AXI_DW                = 32,
    parameter                       ID_WTH                  = 8,
    parameter                       FAMILY                  = "TITANIUM",
    parameter                       ASYNC                   = 1'b0,
    parameter                       ASYNC_FIFO_AW_DEPTH     = 512, 
    parameter                       ASYNC_FIFO_W_DEPTH      = 512, 
    parameter                       ASYNC_FIFO_B_DEPTH      = 16, 
    parameter                       ASYNC_FIFO_AR_DEPTH     = 512, 
    parameter                       ASYNC_FIFO_R_DEPTH      = 512, 
    parameter                       ASYNC_FIFO_AW_RAM_STYLE = "block_ram", 
    parameter                       ASYNC_FIFO_W_RAM_STYLE  = "block_ram", 
    parameter                       ASYNC_FIFO_B_RAM_STYLE  = "register", 
    parameter                       ASYNC_FIFO_AR_RAM_STYLE = "block_ram", 
    parameter                       ASYNC_FIFO_R_RAM_STYLE  = "block_ram", 
    parameter                       S_AXI_REG_EN            = 5'b00000,
    parameter                       M_AXI_REG_EN            = 5'b00000
)
(

//Slave AXI4 Bus Interface
//--Slave Global Signals
input                           s_axi_clk,
input                           s_axi_rstn,
//--Slave AXI4 Write
input                           s_axi_awvalid,
output  wire                    s_axi_awready,
input           [AXI_AW-1:0]    s_axi_awaddr,
input           [7:0]           s_axi_awlen,
input           [ID_WTH-1:0]    s_axi_awid,
input                           s_axi_wvalid,
output  wire                    s_axi_wready,
input           [S_AXI_DW-1:0]  s_axi_wdata,
input           [S_AXI_DW/8-1:0]s_axi_wstrb,
input                           s_axi_wlast,
output  wire                    s_axi_bvalid,
input                           s_axi_bready,
output  wire    [1:0]           s_axi_bresp,
output  wire    [ID_WTH-1:0]    s_axi_bid,
//--Slave AXI4 Read
input                           s_axi_arvalid,
output  wire                    s_axi_arready,
input           [AXI_AW-1:0]    s_axi_araddr,
input           [7:0]           s_axi_arlen,
input           [ID_WTH-1:0]    s_axi_arid,
output  wire                    s_axi_rvalid,
input                           s_axi_rready,
output  wire    [S_AXI_DW-1:0]  s_axi_rdata,
output  wire                    s_axi_rlast,
output  wire                    s_axi_rresp,
output  wire    [ID_WTH-1:0]    s_axi_rid,

//Master AXI4 Bus Interface
//--Master Global Signals
input                           m_axi_clk,
input                           m_axi_rstn,
//--Master AXI4 Bus Write 
output  wire                    m_axi_awvalid,
input                           m_axi_awready,
output  wire    [AXI_AW-1:0]    m_axi_awaddr,
output  wire    [7:0]           m_axi_awlen,
output  wire    [ID_WTH-1:0]    m_axi_awid,
output  wire    [2:0]           m_axi_awsize,
output  wire    [1:0]           m_axi_awburst,
output  wire    [1:0]           m_axi_awlock,
output  wire    [3:0]           m_axi_awcache,
output  wire    [2:0]           m_axi_awprot,
output  wire                    m_axi_wvalid,
input                           m_axi_wready,
output  wire    [M_AXI_DW-1:0]  m_axi_wdata,
output  wire    [M_AXI_DW/8-1:0]m_axi_wstrb,
output  wire                    m_axi_wlast,
input                           m_axi_bvalid,
output  wire                    m_axi_bready,
input           [1:0]           m_axi_bresp,
input           [ID_WTH-1:0]    m_axi_bid,
//--Master AXI4 Bus Read 
output  wire                    m_axi_arvalid,
input                           m_axi_arready,
output  wire    [AXI_AW-1:0]    m_axi_araddr,
output  wire    [7:0]           m_axi_arlen,
output  wire    [ID_WTH-1:0]    m_axi_arid,
output  wire    [2:0]           m_axi_arsize,
output  wire    [1:0]           m_axi_arburst,
output  wire    [1:0]           m_axi_arlock,
output  wire    [3:0]           m_axi_arcache,
output  wire    [2:0]           m_axi_arprot,
input                           m_axi_rvalid,
output  wire                    m_axi_rready,
input           [M_AXI_DW-1:0]  m_axi_rdata,
input                           m_axi_rlast,
input           [1:0]           m_axi_rresp,
input           [ID_WTH-1:0]    m_axi_rid

);

//Parameter Define

//Register Define

//Wire Define


`pragma protect begin_protected
`pragma protect version=1
`pragma protect encrypt_agent="ipecrypt"
`pragma protect encrypt_agent_info="http://ipencrypter.com Version: 20.0.8"
`pragma protect author="author-a"
`pragma protect author_info="author-a-details"
`pragma protect data_method="aes256-cbc"

`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIF-SIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
pMCGZaXJWtAQvxkvNiCkmgocnBz6Kpd+LBPIAUHuq71RWuHs2p7f4CzyV9oUzjMK
falNp6/Whu8ab4jiXOH687tt6s/0WNuMVf4q73+nIQgLch3COGkQFLn46lCHjWDg
7Y9p7063g2XeaXKG9HxWsZqkGM2lIXsOtlv1OWl4eiE=
`pragma protect key_keyowner="Aldec"
`pragma protect key_method="rsa"
`pragma protect key_keyname="ALDEC15_001"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
Zn+YxHb0/OqEY9dHVdUi1TA5QXru616KXqXnKT7cukjO9MHOxrfig/3/GFdqP+DY
sn8Cm5Smy8rUhqsLkKmLONRLJXLSu/DagTFGbdK9MhykPmLb/x3QSh07VwS5ttsu
XDWiTnQ4dQdZLFoACIM2grD2cTZx7dgoFdfXnzAtamENFAu//M4L/GZ1NKkeLhZG
dYH+kBDDOyeBCDqJxWH1w4kxV6vtE6USbJ8u8f/t4EEdL4jgiUuYcazG9hbPeEy0
G77M/7mwD/58d8qYSzXNMDh+/YV4vNW8oOIwmmuP+h1E5ppomhzDo3EefDSsKKIY
ikrPessbkVlXYRifFHFgoA==
`pragma protect key_keyowner="Synopsys"
`pragma protect key_method="rsa"
`pragma protect key_keyname="SNPS-VCS-RSA-2"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
Clv2x2EHPC7WIa8W3EPltIsAvIHbNzL2tMg9/KVSuVoSZDYGRjfYnfqXjGOvCqJK
15+dTZG4yw4QZ+k/P4aWaaEkzRAk/NFlNhSHFGlSmwFEpOy8VcdnVGRWjSH+i/2S
S0BANr7SbmE/sBsFsti9wkB9gXSJEQJpD2drSyNXIoQ=
`pragma protect key_keyowner="Cadence Design Systems."
`pragma protect key_method="rsa"
`pragma protect key_keyname="CDS_RSA_KEY_VER_1"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
N0yA4MzcUAkgHbOniGLhoq5f3IG8IwQcROTQALg1Dyym/IWrDeTkcWyzlqXXaXh5
6Qh+/hrXk2hYVUlMnNuwewZ12riJ52z/Mh3/MtTdF8ZrjiwwQ1LLl8jk/sJX28Vo
iM1/4l/Z4x8dbPAs25k6JhihON2XI8AMujhxmim7PqAGWHM1gJlP/GZKQYwigJ40
7svAZTzxlCfC9tR2nX+6I9JiH2DtApqxRv9LfK5Ai5uyWHKUgoLYPQGoEjfARZ5A
kZMPagakyMU4UBFyRoss11HQnpBt9fIemgpueGoh1n0sYq02okh3KpWeoqQE3v9m
Ds4v6uWuWguZoVVKODMDeg==
`pragma protect key_keyowner="Efinix Inc."
`pragma protect key_keyname="EFX_K01"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
NnCyfMPj8iEeSf0lt37wmeIZkj7D31C96a3b1JF1T1Hy0XFFCQPHgn4Wh1GjxHxY
PZJLrouAcWlN+9VwHRco9VDY1VzYYQNLLsy89oviumb8ynZCfQF+PBojRuViPowv
eVWWtAe04V2sGI4eFNeC+vhlMBEUE48co0hzUM18Td+uuMuaHtDE4oVuP6iutOQC
M7A4LctKJ/fmpBoppyJgcfOKo38uHqVAK3rlJ+9w68WE48HFCAnZO8O4e9tlDMYh
dZAhQQR2WekQyHce0IZZpsRKdLiF3Y5Cmi05dKrsRExoSNToBOPsZmHkqpU7K8aZ
5pVBDzaNyVA28jCTlk9W9A==
`pragma protect encoding=(enctype="base64", line_length=64, bytes=19856)
`pragma protect data_block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`pragma protect end_protected
endmodule
