`timescale 1ns / 1ns

module system_reg#(
    parameter                       ADDR_WTH = 10
)
(
input                           s_apb3_clk,
input                           s_apb3_rstn,
input           [ADDR_WTH-1:0]  s_apb3_paddr,
input                           s_apb3_psel,
input                           s_apb3_penable,
output  wire                    s_apb3_pready,
input                           s_apb3_pwrite,//0:rd; 1:wr;
input           [31:0]          s_apb3_pwdata,
output  reg     [31:0]          s_apb3_prdata,
output  wire                    s_apb3_pslverror,

//DMA irq test
output  reg     [3:0]           msi_enable,
output  reg     [3:0]           msix_enable,
output  reg     [15:0]          usr_irq_req,
input           [15:0]          usr_irq_ack, 

input           [31:0]          cth_sts,
input           [31:0]          htc_sts,

output  reg                     apb_start
);
//Parameter Define

//Register Define

//APB3 REG
reg             [ADDR_WTH-3:0]  loc_addr;
reg                             loc_wr_vld;
reg                             loc_rd_vld;

//irq REG
reg             [15:0]          interrupt_status;
reg             [15:0]          interrupt_mask;
reg             [31:0]          interrupt_cnt;
reg                             pready_wite;
reg                             pready_wite_ff1;
reg                             pready_wite_ff2;
//Wire Define
wire            [15:0]          interrupt_trs;
//Encryption begin
/*--------------------------------------------------------------*\
                       The main code
\*--------------------------------------------------------------*/
//apb3 interface
always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        loc_addr <= {ADDR_WTH-2{1'b0}};
	else if((s_apb3_psel == 1'b1) && (s_apb3_penable == 1'b0))
		loc_addr <= s_apb3_paddr[2+:ADDR_WTH-2];
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        loc_wr_vld <= 1'b0;
	else if((s_apb3_psel == 1'b1) && (s_apb3_penable == 1'b0) && (s_apb3_pwrite == 1'b1))
		loc_wr_vld <= 1'b1;
    else
        loc_wr_vld <= 1'b0;
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        loc_rd_vld <= 1'b0;
	else if((s_apb3_psel == 1'b1) && (s_apb3_penable == 1'b0) && (s_apb3_pwrite == 1'b0))
		loc_rd_vld <= 1'b1;
    else
        loc_rd_vld <= 1'b0;
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        pready_wite <= 1'b0;
	else if((loc_wr_vld == 1'b1) || (loc_rd_vld == 1'b1))
		pready_wite <= 1'b1;
    else
        pready_wite <= 1'b0;
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        begin
            pready_wite_ff1 <= 1'b0;        
            pready_wite_ff2 <= 1'b0;        
        end
	else
        begin
            pready_wite_ff1 <= pready_wite;        
            pready_wite_ff2 <= pready_wite_ff1; 
        end
end

assign s_apb3_pready = (pready_wite_ff1 == 1'b0) && (pready_wite_ff2 == 1'b1);

//可有主机控制的中断
assign s_apb3_pslverror = 1'b0;

//reg rd
always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        s_apb3_prdata <= 32'h0;
	else if(loc_rd_vld == 1'b1)
        begin
            case(loc_addr)
            //irq reg
            'h080 : s_apb3_prdata <= {24'h0,msi_enable,msix_enable};
            'h081 : s_apb3_prdata <= {16'h0,interrupt_mask}; 
            'h082 : s_apb3_prdata <= {16'h0,interrupt_status};
            'h083 : s_apb3_prdata <= interrupt_cnt;
            
            'h090 : s_apb3_prdata <= cth_sts;
            'h091 : s_apb3_prdata <= htc_sts;
            
            'h0a0 : s_apb3_prdata <= {31'h0,apb_start};


            default : s_apb3_prdata = 32'hfefefefe;
            endcase
        end
end

//irq test wr reg
always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        begin
            msi_enable <= 4'h0;
            msix_enable <= 4'h1;
        end
	else if((loc_wr_vld == 1'b1) && (loc_addr == 'h080))
        begin
            msi_enable <= s_apb3_pwdata[7:4];
            msix_enable <= s_apb3_pwdata[3:0];
        end
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        interrupt_mask <= 16'b0;
	else if((loc_wr_vld == 1'b1) && (loc_addr == 'h081))
        interrupt_mask <= s_apb3_pwdata[15:0];
end

//irq test status
genvar j;
generate
for (j=0; j<16; j=j+1)begin
    
always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
            usr_irq_req[j] <= 1'h0;
	else 
            usr_irq_req[j]  <= ((interrupt_status[j] == 1'b1) && (interrupt_mask[j] == 1'b0));
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        interrupt_status[j] <= 1'b0;
    else if((loc_wr_vld == 1'b1) && (loc_addr == 'h082))
        interrupt_status[j] <= s_apb3_pwdata[j];
    else if(usr_irq_ack[j] == 1'b1)
        interrupt_status[j] <= 1'b0;
end

assign interrupt_trs[j] = (usr_irq_ack[j] == 1'b1) && (interrupt_status[j] == 1'b1);

end

endgenerate

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        interrupt_cnt <= 32'b0;
    else if((loc_wr_vld == 1'b1) && (loc_addr == 'h083))
        interrupt_cnt <= s_apb3_pwdata;
    else 
        interrupt_cnt <= interrupt_cnt + interrupt_trs[0]  + interrupt_trs [1]  + interrupt_trs[2]  + interrupt_trs [3]
                                       + interrupt_trs[4]  + interrupt_trs [5]  + interrupt_trs[6]  + interrupt_trs [7]
                                       + interrupt_trs[8]  + interrupt_trs [9]  + interrupt_trs[10] + interrupt_trs [11]
                                       + interrupt_trs[12] + interrupt_trs [13] + interrupt_trs[14] + interrupt_trs [15];
end

//apb mux reg
always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        apb_start <= 1'h0;
	else if((loc_wr_vld == 1'b1) && (loc_addr == 'h0a0))
        apb_start <= s_apb3_pwdata[0];
end
//Encryption end
endmodule

