`timescale 1 ns / 1 ns
module apb3_ram#(
    parameter                       ADDR_WTH = 10,
    parameter                       DATA_WTH = 32
)
(
//Globle Signals
//
//APB3 Slave Interface
input                           s_apb3_clk,
input                           s_apb3_rstn,
input           [ADDR_WTH-1:0]  s_apb3_paddr,
input                           s_apb3_psel,
input                           s_apb3_penable,
output  reg                     s_apb3_pready,
input                           s_apb3_pwrite,//0:rd; 1:wr;
input           [DATA_WTH-1:0]  s_apb3_pwdata,
output  reg     [DATA_WTH-1:0]  s_apb3_prdata,
output  wire                    s_apb3_pslverror
//Cfg Space Registers
//--Example Registers Field
);
// Parameter Define 
reg [DATA_WTH-1:0] mem[(2**ADDR_WTH)-1:0];

// Register Define
reg     [ADDR_WTH-1:0]          loc_addr;
reg                             loc_wr_vld;
reg                             loc_rd_vld;

// Wire Define

/*----------------------------------------------------------------------------------*\
                                 The main code
\*----------------------------------------------------------------------------------*/
//apb3 interface
always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        loc_addr <= {ADDR_WTH{1'b0}};
	else if((s_apb3_psel == 1'b1) && (s_apb3_penable == 1'b0))
		loc_addr <= s_apb3_paddr;
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        loc_wr_vld <= 1'b0;
	else if((s_apb3_psel == 1'b1) && (s_apb3_penable == 1'b0) && (s_apb3_pwrite == 1'b1))
		loc_wr_vld <= 1'b1;
    else
        loc_wr_vld <= 1'b0;
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        loc_rd_vld <= 1'b0;
	else if((s_apb3_psel == 1'b1) && (s_apb3_penable == 1'b0) && (s_apb3_pwrite == 1'b0))
		loc_rd_vld <= 1'b1;
    else
        loc_rd_vld <= 1'b0;
end

always @(posedge s_apb3_clk or negedge s_apb3_rstn)
begin
    if(s_apb3_rstn == 1'b0)
        s_apb3_pready <= 1'b0;
	else if((loc_wr_vld == 1'b1) || (loc_rd_vld == 1'b1))
		s_apb3_pready <= 1'b1;
    else
        s_apb3_pready <= 1'b0;
end
/*----------------------------------------------------------------------------------*\
                                 APB memory
\*----------------------------------------------------------------------------------*/
always @(posedge s_apb3_clk)
begin
	if(loc_rd_vld == 1'b1)
        s_apb3_prdata <= mem[loc_addr];
end

always @(posedge s_apb3_clk)
begin
    if(loc_wr_vld == 1'b1)
        mem[loc_addr] <= s_apb3_pwdata;
end

assign s_apb3_pslverror = 1'b0;

endmodule
