//`define DEBUG

module pcie_dma_example(
//-----------------------------------------------------
//-- Global Singals
//-----------------------------------------------------
input                           ddr_pll_LOCKED,
input                           dma_pll_LOCKED,
input                           osc_pcie_CLKOUT,
input                           apb_clk_100m,
input                           axi_clk_250m,
input                           axi_clk_200m,
input                           axi_clk_125m,

//perstn
input                           perstn,
//-----------------------------------------------------
`ifdef DEBUG 
input                           jtag_inst1_CAPTURE,
input                           jtag_inst1_DRCK,
input                           jtag_inst1_RESET,
input                           jtag_inst1_RUNTEST,
input                           jtag_inst1_SEL,
input                           jtag_inst1_SHIFT,
input                           jtag_inst1_TCK,
input                           jtag_inst1_TDI,
input                           jtag_inst1_TMS,
input                           jtag_inst1_UPDATE,
output  wire                    jtag_inst1_TDO,
`endif
//-----------------------------------------------------
//-- Ddr Core Interface
//-----------------------------------------------------
//Reset 
output  wire                    ddr1_axi_arstn,
//Config
input                           ddr1_cfg_done,
output                          ddr1_cfg_start,
output                          ddr1_cfg_reset,
output                          ddr1_cfg_sel,
//-----------------------------------------------------
//-- Ddr Core Axi Interface
//Read Address Channel
output  wire    [5:0]           ddr1_axi_arid,
input                           ddr1_axi_arready,
output  wire                    ddr1_axi_arvalid,
output  wire    [7:0]           ddr1_axi_arlen,
output  wire    [2:0]           ddr1_axi_arsize,
output  wire    [1:0]           ddr1_axi_arburst,
output  wire                    ddr1_axi_arlock,
output  wire                    ddr1_axi_arqos,
output  wire    [32:0]          ddr1_axi_araddr,
output  wire                    ddr1_axi_arapcmd,
//Read Data Channel
input           [511:0]         ddr1_axi_rdata,
input           [5:0]           ddr1_axi_rid,
input                           ddr1_axi_rlast,
output  wire                    ddr1_axi_rready,
input           [1:0]           ddr1_axi_rresp,
input                           ddr1_axi_rvalid,
//Write Address Channel
output  wire    [5:0]           ddr1_axi_awid,
input                           ddr1_axi_awready,
output  wire                    ddr1_axi_awvalid,
output  wire    [7:0]           ddr1_axi_awlen,
output  wire    [2:0]           ddr1_axi_awsize,
output  wire    [1:0]           ddr1_axi_awburst,
output  wire                    ddr1_axi_awlock,
output  wire    [3:0]           ddr1_axi_awcache,
output  wire                    ddr1_axi_awqos,
output  wire    [32:0]          ddr1_axi_awaddr, 
output  wire                    ddr1_axi_awallstrb,
output  wire                    ddr1_axi_awapcmd,
output  wire                    ddr1_axi_awcobuf,
//Write Data Channel
output  wire    [511:0]         ddr1_axi_wdata,
output  wire                    ddr1_axi_wlast,
input                           ddr1_axi_wready,
output  wire    [63:0]          ddr1_axi_wstrb,
output  wire                    ddr1_axi_wvalid,
//Write Response Channel
input           [5:0]           ddr1_axi_bid,
output  wire                    ddr1_axi_bready,
input                           ddr1_axi_bvalid,
input           [1:0]           ddr1_axi_bresp,
//-----------------------------------------------------
//-- Pcie Core Interface
//-----------------------------------------------------
input                           in_user,                  

output   wire                   pcie0_reset_ack,
input                           pcie0_reset_req,
//output   wire                   pcie0_user_reset_n_in,
output   wire                   pcie0_user_axi_reset_n,

input           [5:0]           pcie0_ltssm_state,
input           [1:0]           pcie0_link_status,
input           [1:0]           pcie0_pipe_p00_rate,
input                           pcie0_pma_cmn_ready,
input           [3:0]           pcie0_flr_in_progress,
//-----------------------------------------------------
//-- Master Apb Interface
output  wire    [23:0]          m_apb_q0_pcie_paddr,
output  wire                    m_apb_q0_pcie_penable,
input           [3:0]           m_apb_q0_pcie_prdata_par,
input           [31:0]          m_apb_q0_pcie_prdata,
input                           m_apb_q0_pcie_pready,
output  wire                    m_apb_q0_pcie_psel,
output  wire                    m_apb_q0_pcie_pstrb_par,
output  wire    [3:0]           m_apb_q0_pcie_pstrb,
output  wire    [3:0]           m_apb_q0_pcie_pwdata_par,
output  wire    [31:0]          m_apb_q0_pcie_pwdata,
output  wire                    m_apb_q0_pcie_pwrite,
//-----------------------------------------------------
//-- Master Axi Interface
//Read Address Channel
output  wire    [7:0]           m_axi_pcie0_arid,
input                           m_axi_pcie0_arready,
output  wire                    m_axi_pcie0_arvalid,
output  wire    [7:0]           m_axi_pcie0_arlen,
output  wire    [2:0]           m_axi_pcie0_arsize,
output  wire    [87:0]          m_axi_pcie0_aruser,
output  wire    [63:0]          m_axi_pcie0_araddr,
//Read Data Channel
input           [31:0]          m_axi_pcie0_rdata_par,
input           [255:0]         m_axi_pcie0_rdata,
input                           m_axi_pcie0_rid_par,
input           [7:0]           m_axi_pcie0_rid,
input                           m_axi_pcie0_rlast,
output  wire                    m_axi_pcie0_rready,
input                           m_axi_pcie0_rresp_par,
input           [1:0]           m_axi_pcie0_rresp,
input                           m_axi_pcie0_ruser_par,
input           [6:0]           m_axi_pcie0_ruser,
input                           m_axi_pcie0_rvalid,
//Write Address Channel
output  wire    [7:0]           m_axi_pcie0_awid,
input                           m_axi_pcie0_awready,
output  wire                    m_axi_pcie0_awvalid,
output  wire    [7:0]           m_axi_pcie0_awlen,
output  wire    [2:0]           m_axi_pcie0_awsize,
output  wire    [87:0]          m_axi_pcie0_awuser,
output  wire    [63:0]          m_axi_pcie0_awaddr,
//Write Data Channel
output  wire    [31:0]          m_axi_pcie0_wdata_par,
output  wire    [255:0]         m_axi_pcie0_wdata,
output  wire                    m_axi_pcie0_wlast,
input                           m_axi_pcie0_wready,
output  wire    [3:0]           m_axi_pcie0_wstrb_par,
output  wire    [31:0]          m_axi_pcie0_wstrb,
output  wire                    m_axi_pcie0_wvalid,
//Write Response Channel
input                           m_axi_pcie0_bid_par,
input           [7:0]           m_axi_pcie0_bid,
output  wire                    m_axi_pcie0_bready,
input                           m_axi_pcie0_bresp_par,
input                           m_axi_pcie0_bvalid,
input           [1:0]           m_axi_pcie0_bresp,
input                           m_axi_pcie0_buser_par,
input           [4:0]           m_axi_pcie0_buser,
//-----------------------------------------------------
//-- Slave Axi Interface
//Read Address Channel
input           [7:0]           s_axi_pcie0_arid,
output  wire                    s_axi_pcie0_arready,
input                           s_axi_pcie0_arvalid,
input           [7:0]           s_axi_pcie0_arlen,
input           [2:0]           s_axi_pcie0_arsize,
input           [87:0]          s_axi_pcie0_aruser,
input           [63:0]          s_axi_pcie0_araddr,
//Read Data Channel
output  wire    [31:0]          s_axi_pcie0_rdata_par,
output  wire    [255:0]         s_axi_pcie0_rdata,
output  wire                    s_axi_pcie0_rid_par,
output  wire    [7:0]           s_axi_pcie0_rid,
output  wire                    s_axi_pcie0_rlast,
input                           s_axi_pcie0_rready,
output  wire                    s_axi_pcie0_rresp_par,
output  wire    [1:0]           s_axi_pcie0_rresp,
output  wire                    s_axi_pcie0_rvalid,
//Write Address Channel
input           [7:0]           s_axi_pcie0_awid,
output  wire                    s_axi_pcie0_awready,
input                           s_axi_pcie0_awvalid,
input           [7:0]           s_axi_pcie0_awlen,
input           [2:0]           s_axi_pcie0_awsize,
input           [87:0]          s_axi_pcie0_awuser,
input           [63:0]          s_axi_pcie0_awaddr,
//Write Data Channel
output  wire                    s_axi_pcie0_wready,
input           [31:0]          s_axi_pcie0_wdata_par,
input           [255:0]         s_axi_pcie0_wdata,
input                           s_axi_pcie0_wlast,
input           [3:0]           s_axi_pcie0_wstrb_par,
input           [31:0]          s_axi_pcie0_wstrb,
input                           s_axi_pcie0_wvalid,
//Write Response Channel
output  wire                    s_axi_pcie0_bid_par,
output  wire    [7:0]           s_axi_pcie0_bid,
input                           s_axi_pcie0_bready,
output  wire                    s_axi_pcie0_bresp_par,
output  wire                    s_axi_pcie0_bvalid,
output  wire    [1:0]           s_axi_pcie0_bresp,
//Flr
output  wire    [3:0]           pcie0_flr_done,
//Error Indication
output  wire                    pcie0_correctable_error_in,
output  wire                    pcie0_uncorrectable_error_in,
//Status 
input           [2:0]           pcie0_max_payload_size,
input           [2:0]           pcie0_max_read_req_size,
//interrupt
output                          q0_pcie_INTA_IN,
output                          q0_pcie_INTB_IN,
output                          q0_pcie_INTC_IN,
output                          q0_pcie_INTD_IN,
input                           q0_pcie_INT_ACK,
output          [3:0]           q0_pcie_INT_PENDING_STATUS,
//Configration Snoop
output  wire    [31:0]          pcie0_config_read_data,
output  wire    [3:0]           pcie0_config_read_data_par,
output  wire                    pcie0_target_non_posted_rej,
output  wire                    pcie0_config_read_data_valid
);

//Localpara Define

//--dma_ip parameter   
parameter                       AXI_DATA_WIDTH = 256;
parameter                       AXI_ADDR_WIDTH = 64;
parameter                       AXI_ID_WIDTH = 8;
parameter                       DMA_ST_EN = 1'b0;
parameter                       S_APB_USR_EN = 1;
parameter                       M_APB_USR_EN = 1;
parameter                       DATA_PROTECT = 0;
parameter                       M_AXI_BYP_EN = 1;
parameter                       USR_INT_NUM = 4;
parameter                       MSI_ENABLE ='hf;
parameter                       MSIX_ENABLE ='hf;
parameter                       MSIX_VEC_NUM = 32;
parameter                       CTH_CH_NUM = 1;
parameter                       HTC_CH_NUM = 1;
parameter                       CTH_DSC_DTH = 32;
parameter                       HTC_DSC_DTH = 32;
parameter                       CTH_DSC_BYP_EN = 1;
parameter                       HTC_DSC_BYP_EN = 1;
parameter                       M0_BASE_ADDR = 64'h0;
parameter                       M0_ADDR_SPACE = 64'h80000;
parameter                       M1_BASE_ADDR =  64'h90000;
parameter                       M1_ADDR_SPACE = 64'h2000;
parameter                       M2_BASE_ADDR = 64'ha0000;
parameter                       M2_ADDR_SPACE = 64'h4000;
//--system_reg
parameter                       ADDR_WTH = 32;
//--reset_control
parameter                       NUM_EXTERNAL_RESETS = 1;
parameter                       NUM_DOMAINS = 4;
parameter                       SEQUENTIAL_RELEASE = 1'b0;
//--axi_adapter
parameter                       FAMILY = "TITANIUM";
parameter                       ASYNC_FIFO_AW_DEPTH = 512; 
parameter                       ASYNC_FIFO_W_DEPTH = 512; 
parameter                       ASYNC_FIFO_B_DEPTH = 16; 
parameter                       ASYNC_FIFO_AR_DEPTH = 512; 
parameter                       ASYNC_FIFO_R_DEPTH = 512; 
parameter                       ASYNC_FIFO_AW_RAM_STYLE = "block_ram"; 
parameter                       ASYNC_FIFO_W_RAM_STYLE = "block_ram"; 
parameter                       ASYNC_FIFO_B_RAM_STYLE = "register"; 
parameter                       ASYNC_FIFO_AR_RAM_STYLE = "block_ram"; 
parameter                       ASYNC_FIFO_R_RAM_STYLE = "block_ram"; 
parameter                       S_AXI_REG_EN = 5'b11111;
parameter                       M_AXI_REG_EN = 5'b11111;
//--apb3_ram
parameter                       APB_ADDR_WIDTH = 8;
parameter                       APB_DATA_WIDTH = 32;
//--axi_ram
parameter                       PIPELINE_OUTPUT = 0;
//--pcie_apb_master
parameter                       ROM_MIF = "./efx_rom_mif.mem";
parameter                       RAM_ADDR_W = 3;
parameter                       ROM_DEPTH = 5;
parameter                       PADDR_WIDTH = 24;
parameter                       PDATA_WIDTH = 32;

localparam                      DDR_AXI_DATA_WIDTH = 512;
localparam                      PCIE_AXI_DATA_WIDTH = 256; 
localparam                      DDR_ASYNC = 1'b1;
localparam                      PCIE_ASYNC = 1'b1;         

parameter                       PCIE_IF_REG_EN = 1;

//Register Define

// aytan dbg
wire m_apb_q0_pcie_pslverror;
wire pcie0_user_reset_n_in;

//Wire Define
wire                            m_apb_usr_pready;
wire                            m_apb_usr_psel;
wire                            m_apb_usr_pwrite;
wire                            m_apb_usr_penable;
wire    [31:0]                  m_apb_usr_paddr;
wire    [31:0]                  m_apb_usr_pwdata;
wire    [31:0]                  m_apb_usr_prdata;
wire                            m_apb_usr_pslverror;
wire                            s_apb_usr_pready;
wire                            s_apb_usr_psel;
wire                            s_apb_usr_pwrite;
wire                            s_apb_usr_penable;
wire    [PADDR_WIDTH-1:0]       s_apb_usr_paddr_m;
wire    [31:0]                  s_apb_usr_paddr;
wire    [31:0]                  s_apb_usr_pwdata;
wire    [31:0]                  s_apb_usr_prdata;
wire                            s_apb_usr_pslverror;
wire                            m_axi_usr_awready;
wire                            m_axi_usr_awvalid;
wire    [AXI_ADDR_WIDTH-1:0]    m_axi_usr_awaddr;
wire    [AXI_ID_WIDTH-1:0]      m_axi_usr_awid;
wire    [7:0]                   m_axi_usr_awlen;
wire    [2:0]                   m_axi_usr_awsize;
wire                            m_axi_usr_wready;
wire                            m_axi_usr_wvalid;
wire    [AXI_DATA_WIDTH-1:0]    m_axi_usr_wdata;
wire    [(AXI_DATA_WIDTH/8)-1:0]     
                                m_axi_usr_wdata_par;
wire    [(AXI_DATA_WIDTH/8)-1:0]                       
                                m_axi_usr_wstrb;
wire    [(AXI_DATA_WIDTH/64)-1:0]                      
                                m_axi_usr_wstrb_par;
wire                            m_axi_usr_wlast;
wire                            m_axi_usr_bready;
wire                            m_axi_usr_bvalid;
wire    [1:0]                   m_axi_usr_bresp;
wire    [AXI_ID_WIDTH-1:0]      m_axi_usr_bid;
wire                            m_axi_usr_arready;
wire                            m_axi_usr_arvalid;
wire    [AXI_ID_WIDTH-1:0]      m_axi_usr_arid;
wire    [AXI_ADDR_WIDTH-1:0]    m_axi_usr_araddr;
wire    [7:0]                   m_axi_usr_arlen;
wire    [2:0]                   m_axi_usr_arsize;
wire                            m_axi_usr_rready;
wire                            m_axi_usr_rvalid;
wire    [AXI_ID_WIDTH-1:0]      m_axi_usr_rid;
wire    [AXI_DATA_WIDTH - 1:0]  m_axi_usr_rdata;
wire    [(AXI_DATA_WIDTH/8)-1:0]                        
                                m_axi_usr_rdata_par;
wire    [1:0]                   m_axi_usr_rresp;
wire                            m_axi_usr_rlast;


//-----------------------------------------------------
//Slave Axi-St For User
wire    [CTH_CH_NUM - 1:0]      s_axis_usr_tready;
wire    [CTH_CH_NUM - 1:0]      s_axis_usr_tvalid;
wire    [(AXI_DATA_WIDTH*CTH_CH_NUM)-1:0]            
                                s_axis_usr_tdata;
wire    [((AXI_DATA_WIDTH/8)*CTH_CH_NUM)-1:0]             
                                s_axis_usr_tdata_par;
wire    [((AXI_DATA_WIDTH/8)*CTH_CH_NUM)-1:0]             
                                s_axis_usr_tkeep;
wire    [CTH_CH_NUM-1:0]        s_axis_usr_tlast;
//wire    [(64 *CTH_CH_NUM)-1:0]  s_axis_usr_tuser;
//-----------------------------------------------------
//Master Axi-St For User
wire    [HTC_CH_NUM-1:0]        m_axis_usr_tready;
wire    [(AXI_DATA_WIDTH*HTC_CH_NUM)-1:0]     
                                m_axis_usr_tdata;
wire    [((AXI_DATA_WIDTH/8)*HTC_CH_NUM)-1:0] 
                                m_axis_usr_tdata_par;
//wire    [(64*HTC_CH_NUM)-1:0]   m_axis_usr_tuser;
wire    [HTC_CH_NUM-1:0]        m_axis_usr_tlast;
wire    [HTC_CH_NUM-1:0]        m_axis_usr_tvalid;
wire    [((AXI_DATA_WIDTH/8)*HTC_CH_NUM)-1:0] 
                                m_axis_usr_tkeep;
//-----------------------------------------------------
//User To Ep
wire    [CTH_CH_NUM-1:0]        u2e_dsc_byp_ready;
wire    [64*CTH_CH_NUM-1:0]     u2e_dsc_byp_src_addr;
wire    [64*CTH_CH_NUM-1:0]     u2e_dsc_byp_dst_addr;
wire    [28*CTH_CH_NUM-1:0]     u2e_dsc_byp_len;
wire    [3*CTH_CH_NUM-1:0]      u2e_dsc_byp_ctl;
wire    [CTH_CH_NUM-1:0]        u2e_dsc_byp_load;
//Ep To User 
wire    [HTC_CH_NUM-1:0]        e2u_dsc_byp_ready;
wire    [64*HTC_CH_NUM-1:0]     e2u_dsc_byp_src_addr;
wire    [64*HTC_CH_NUM-1:0]     e2u_dsc_byp_dst_addr;
wire    [28*HTC_CH_NUM-1:0]     e2u_dsc_byp_len;
wire    [3*HTC_CH_NUM-1:0]      e2u_dsc_byp_ctl;
wire    [HTC_CH_NUM-1:0]        e2u_dsc_byp_load;
//-----------------------------------------------------
// Bypass Axi
wire    [AXI_ID_WIDTH-1:0]      m_axi_byp_awid;
wire                            m_axi_byp_awvalid;
wire    [AXI_ADDR_WIDTH-1:0]    m_axi_byp_awaddr;
wire    [7:0]                   m_axi_byp_awlen;
wire    [2:0]                   m_axi_byp_awsize;
wire                            m_axi_byp_awready;
wire                            m_axi_byp_wvalid;
wire    [AXI_DATA_WIDTH-1:0]    m_axi_byp_wdata;
wire    [(AXI_DATA_WIDTH / 8) - 1:0]  
                                m_axi_byp_wdata_par;
wire    [(AXI_DATA_WIDTH / 8) - 1:0]  
                                m_axi_byp_wstrb;
wire                            m_axi_byp_wlast;
wire                            m_axi_byp_wready;
wire    [AXI_ID_WIDTH-1:0]      m_axi_byp_bid;
wire    [1:0]                   m_axi_byp_bresp;
wire                            m_axi_byp_bvalid;
wire                            m_axi_byp_bready;
wire    [AXI_ID_WIDTH-1:0]      m_axi_byp_arid;
wire                            m_axi_byp_arvalid;
wire    [AXI_ADDR_WIDTH-1:0]    m_axi_byp_araddr;
wire    [7:0]                   m_axi_byp_arlen;
wire    [2:0]                   m_axi_byp_arsize;
wire                            m_axi_byp_arready;
wire    [AXI_ID_WIDTH-1:0]      m_axi_byp_rid;
wire                            m_axi_byp_rvalid;
wire    [AXI_DATA_WIDTH-1:0]    m_axi_byp_rdata;
wire                            m_axi_byp_rlast;
wire    [1:0]                   m_axi_byp_rresp;
wire                            m_axi_byp_rready;

wire    [HTC_CH_NUM-1:0]        htc_running;
wire    [HTC_CH_NUM-1:0]        htc_busy;
wire    [HTC_CH_NUM-1:0]        htc_interrupt;
wire    [HTC_CH_NUM-1:0]        htc_dsc_done;

wire    [CTH_CH_NUM-1:0]        cth_running;
wire    [CTH_CH_NUM-1:0]        cth_busy;
wire    [CTH_CH_NUM-1:0]        cth_interrupt;
wire    [CTH_CH_NUM-1:0]        cth_dsc_done;

wire    [USR_INT_NUM-1:0]       usr_irq;
wire    [USR_INT_NUM-1:0]       usr_irq_ack;
wire    [3:0]                   cfg_msi_enable;
wire    [3:0]                   cfg_msix_enable;

wire    [3:0]                   legacy_irq;
wire                            legacy_irq_ack;

wire    [2:0]                   cfg_max_payload_size;
wire    [2:0]                   cfg_max_read_req_size;
wire                            clk_200m_rstn;
wire                            clk_250m_rstn;
wire                            clk_100m_rstn;

//--S REG AXI4 Interface
wire    [7:0]                   s_axi_pcie0_reg_arid;
wire                            s_axi_pcie0_reg_arready;
wire                            s_axi_pcie0_reg_arvalid;
wire    [7:0]                   s_axi_pcie0_reg_arlen;
wire    [2:0]                   s_axi_pcie0_reg_arsize;
wire    [87:0]                  s_axi_pcie0_reg_aruser;
wire    [63:0]                  s_axi_pcie0_reg_araddr;
wire    [31:0]                  s_axi_pcie0_reg_rdata_par;
wire    [255:0]                 s_axi_pcie0_reg_rdata;
wire                            s_axi_pcie0_reg_rid_par;
wire    [7:0]                   s_axi_pcie0_reg_rid;
wire                            s_axi_pcie0_reg_rlast;
wire                            s_axi_pcie0_reg_rready;
wire                            s_axi_pcie0_reg_rresp_par;
wire    [1:0]                   s_axi_pcie0_reg_rresp;
wire                            s_axi_pcie0_reg_rvalid;
wire    [7:0]                   s_axi_pcie0_reg_awid;
wire                            s_axi_pcie0_reg_awready;
wire                            s_axi_pcie0_reg_awvalid;
wire    [7:0]                   s_axi_pcie0_reg_awlen;
wire    [2:0]                   s_axi_pcie0_reg_awsize;
wire    [87:0]                  s_axi_pcie0_reg_awuser;
wire    [63:0]                  s_axi_pcie0_reg_awaddr;
wire                            s_axi_pcie0_reg_wready;
wire    [31:0]                  s_axi_pcie0_reg_wdata_par;
wire    [255:0]                 s_axi_pcie0_reg_wdata;
wire                            s_axi_pcie0_reg_wlast;
wire    [3:0]                   s_axi_pcie0_reg_wstrb_par;
wire    [31:0]                  s_axi_pcie0_reg_wstrb;
wire                            s_axi_pcie0_reg_wvalid;
wire                            s_axi_pcie0_reg_bid_par;
wire    [7:0]                   s_axi_pcie0_reg_bid;
wire                            s_axi_pcie0_reg_bready;
wire                            s_axi_pcie0_reg_bresp_par;
wire                            s_axi_pcie0_reg_bvalid;
wire    [1:0]                   s_axi_pcie0_reg_bresp;

//-- M REG Axi Interface
wire    [7:0]                   m_axi_pcie0_reg_arid;
wire                            m_axi_pcie0_reg_arready;
wire                            m_axi_pcie0_reg_arvalid;
wire    [7:0]                   m_axi_pcie0_reg_arlen;
wire    [2:0]                   m_axi_pcie0_reg_arsize;
wire    [87:0]                  m_axi_pcie0_reg_aruser;
wire    [63:0]                  m_axi_pcie0_reg_araddr;
wire    [31:0]                  m_axi_pcie0_reg_rdata_par;
wire    [255:0]                 m_axi_pcie0_reg_rdata;
wire                            m_axi_pcie0_reg_rid_par;
wire    [7:0]                   m_axi_pcie0_reg_rid;
wire                            m_axi_pcie0_reg_rlast;
wire                            m_axi_pcie0_reg_rready;
wire                            m_axi_pcie0_reg_rresp_par;
wire    [1:0]                   m_axi_pcie0_reg_rresp;
wire                            m_axi_pcie0_reg_ruser_par;
wire    [6:0]                   m_axi_pcie0_reg_ruser;
wire                            m_axi_pcie0_reg_rvalid;
wire    [7:0]                   m_axi_pcie0_reg_awid;
wire                            m_axi_pcie0_reg_awready;
wire                            m_axi_pcie0_reg_awvalid;
wire    [7:0]                   m_axi_pcie0_reg_awlen;
wire    [2:0]                   m_axi_pcie0_reg_awsize;
wire    [87:0]                  m_axi_pcie0_reg_awuser;
wire    [63:0]                  m_axi_pcie0_reg_awaddr;
wire    [31:0]                  m_axi_pcie0_reg_wdata_par;
wire    [255:0]                 m_axi_pcie0_reg_wdata;
wire                            m_axi_pcie0_reg_wlast;
wire                            m_axi_pcie0_reg_wready;
wire    [3:0]                   m_axi_pcie0_reg_wstrb_par;
wire    [31:0]                  m_axi_pcie0_reg_wstrb;
wire                            m_axi_pcie0_reg_wvalid;
wire                            m_axi_pcie0_reg_bid_par;
wire    [7:0]                   m_axi_pcie0_reg_bid;
wire                            m_axi_pcie0_reg_bready;
wire                            m_axi_pcie0_reg_bresp_par;
wire                            m_axi_pcie0_reg_bvalid;
wire    [1:0]                   m_axi_pcie0_reg_bresp;
wire                            m_axi_pcie0_reg_buser_par;
wire    [4:0]                   m_axi_pcie0_reg_buser;

/*------------------------reset_control Inst Module -----------------------*/
defparam u_sys_rstn.NUM_EXTERNAL_RESETS = 1;
defparam u_sys_rstn.NUM_DOMAINS = 3;
defparam u_sys_rstn.SEQUENTIAL_RELEASE = 1'b0; 
reset_control                           u1_reset_control                                       
(                                      
    .external_rstn                      ({dma_pll_LOCKED,dma_pll_LOCKED,ddr_pll_LOCKED}          ),//i
    .clk                                ({axi_clk_250m ,axi_clk_200m ,apb_clk_100m}  ),//i 
    .rstn                               ({clk_250m_rstn,clk_200m_rstn,clk_100m_rstn} ) //o
);
/*--------------------------ddr_cfg Inst Module ---------------------------*/
ddr_cfg u_ddr_cfg(
    .clk                                (apb_clk_100m                       ),//i  
    .rstn                               (clk_100m_rstn                      ),//i
    .cfg_start                          (ddr1_cfg_start                     ),//o
    .cfg_reset                          (ddr1_cfg_reset                     ),//o
    .cfg_sel                            (ddr1_cfg_sel                       ),//o
    .ddr_arstn                          (ddr1_axi_arstn                     ),//o
    .cfg_done                           (ddr1_cfg_done                      ) //i
);

/*-----------------------------PCIE initial Inst Module -------------------------*/
pcie_apb_master #(
    .ROM_MIF                            ("efx_pcie_rom_mif.mem"             ),
    .ROM_DEPTH                          (ROM_DEPTH                          ),
    .RAM_ADDR_W                         (RAM_ADDR_W                         ),
    .PADDR_WIDTH                        (PADDR_WIDTH                        ),
    .PDATA_WIDTH                        (PDATA_WIDTH                        )
) u_pcie_apb_master(    
    .PCLK                               (apb_clk_100m                       ),//i
    .PRESETn                            (perstn                             ),//i
    .apb_halt_i                         (0                                  ),
    .PSEL                               (s_apb_usr_psel                     ),//o
    .PWRITE                             (s_apb_usr_pwrite                   ),//o
    .PENABLE                            (s_apb_usr_penable                  ),//o
    .PADDR                              (s_apb_usr_paddr_m                  ),//o
    .PWDATA                             (s_apb_usr_pwdata                   ),//o
    .PWDATA_PAR                         (                                   ),//o
    .PSTRB                              (                                   ),//o  
    .PSTRB_PAR                          (                                   ),//o      
    .PRDATA                             (s_apb_usr_prdata                   ),//i
    .PREADY                             (s_apb_usr_pready                   ),//i
    .PSLVERR                            (s_apb_usr_pslverror                ) //i
);

assign s_apb_usr_paddr = 32'h8000_0000 |s_apb_usr_paddr_m;
// EP reset
assign pcie0_user_reset_n_in        = 1'b1;
assign pcie0_reset_ack              = pcie0_reset_req;
assign pcie0_user_axi_reset_n       = 1'b1;

// EP
assign pcie0_config_read_data       = 'b0;
assign pcie0_config_read_data_par   = 'b0;
assign pcie0_config_read_data_valid = 'b0;
assign pcie0_correctable_error_in   = 'b0;
assign pcie0_uncorrectable_error_in = 'b0;

assign pcie0_target_non_posted_rej  = 'b0;
assign pcie0_flr_done               = 'b0;

assign q0_pcie_INTA_IN             = legacy_irq;
assign q0_pcie_INTB_IN             = 1'b0;
assign q0_pcie_INTC_IN             = 1'b0;
assign q0_pcie_INTD_IN             = 1'b0;
assign q0_pcie_INT_PENDING_STATUS  = 4'b0;
assign legacy_irq_ack              = q0_pcie_INT_ACK;
/*----------------------------dma_ip Inst Module ---------------------------*/
reg [ 15:0] user_reset_r;
wire        user_reset;

always@(posedge axi_clk_250m)
begin
    if (in_user == 1'b0) begin
        user_reset_r <= 16'hffff;
    end else begin
        user_reset_r[0] <= 1'b0;
        user_reset_r[15:1] <= user_reset_r[14:0];
    end
end

assign user_reset = user_reset_r[15];
assign m_apb_q0_pcie_pslverror = 1'b0;
generate 
if (PCIE_IF_REG_EN == 0) begin:PCIE_AXI_REG_DIS

efx_pcie_dma #( 
    .DMA_ST_EN                          (DMA_ST_EN                          )
)
u_dma_ip
(
    //-----------------------------------------------------
    //-- AXI Global
    .axi_clk                            (axi_clk_250m                       ),//i
    .dma_rstn                           (!user_reset                        ),//i
    .apb_clk                            (apb_clk_100m                       ),//i
    .apb_rstn                           (clk_100m_rstn                      ),//i
    //-----------------------------------------------------
    //Master Apb For User
    .m_apb_usr_pready                   (m_apb_usr_pready                   ),//i
    .m_apb_usr_psel                     (m_apb_usr_psel                     ),//o
    .m_apb_usr_pwrite                   (m_apb_usr_pwrite                   ),//o
    .m_apb_usr_penable                  (m_apb_usr_penable                  ),//o
    .m_apb_usr_paddr                    (m_apb_usr_paddr                    ),//o  
    .m_apb_usr_pwdata                   (m_apb_usr_pwdata                   ),//o
    .m_apb_usr_prdata                   (m_apb_usr_prdata                   ),//i
    .m_apb_usr_pslverror                (m_apb_usr_pslverror                ),//i
    //-----------------------------------------------------
    //Master Apb For Pcie

    .m_apb_pcie_pready                  (m_apb_q0_pcie_pready               ),//i
    .m_apb_pcie_psel                    (m_apb_q0_pcie_psel                 ),//o
    .m_apb_pcie_pwrite                  (m_apb_q0_pcie_pwrite               ),//o
    .m_apb_pcie_penable                 (m_apb_q0_pcie_penable              ),//o
    .m_apb_pcie_paddr                   (m_apb_q0_pcie_paddr                ),//o
    .m_apb_pcie_pwdata                  (m_apb_q0_pcie_pwdata               ),//o
    .m_apb_pcie_pwdata_par              (m_apb_q0_pcie_pwdata_par           ),//o
    .m_apb_pcie_pstrb                   (m_apb_q0_pcie_pstrb                ),//o
    .m_apb_pcie_pstrb_par               (m_apb_q0_pcie_pstrb_par            ),//o
    .m_apb_pcie_prdata                  (m_apb_q0_pcie_prdata               ),//i
    .m_apb_pcie_prdata_par              (m_apb_q0_pcie_prdata_par           ),//i
    .m_apb_pcie_pslverror               (m_apb_q0_pcie_pslverror            ),//i

    //-----------------------------------------------------
    //Slave Apb For Pcie
    .s_apb_usr_pready                   (s_apb_usr_pready                   ),//o
    .s_apb_usr_psel                     (s_apb_usr_psel                     ),//i
    .s_apb_usr_pwrite                   (s_apb_usr_pwrite                   ),//i
    .s_apb_usr_penable                  (s_apb_usr_penable                  ),//i
    .s_apb_usr_paddr                    (s_apb_usr_paddr                    ),//i
    .s_apb_usr_pwdata                   (s_apb_usr_pwdata                   ),//i
    .s_apb_usr_prdata                   (s_apb_usr_prdata                   ),//o
    .s_apb_usr_pslverror                (s_apb_usr_pslverror                ),//o
    //-----------------------------------------------------
    //Master Axi For User
    .m_axi_usr_awready                  (m_axi_usr_awready                  ),//i
    .m_axi_usr_awvalid                  (m_axi_usr_awvalid                  ),//o
    .m_axi_usr_awaddr                   (m_axi_usr_awaddr                   ),//o
    .m_axi_usr_awid                     (m_axi_usr_awid                     ),//o
    .m_axi_usr_awlen                    (m_axi_usr_awlen                    ),//o
    .m_axi_usr_awsize                   (m_axi_usr_awsize                   ),//o
    .m_axi_usr_wready                   (m_axi_usr_wready                   ),//i
    .m_axi_usr_wvalid                   (m_axi_usr_wvalid                   ),//o
    .m_axi_usr_wdata                    (m_axi_usr_wdata                    ),//o
    .m_axi_usr_wdata_par                (m_axi_usr_wdata_par                ),//o
    .m_axi_usr_wstrb                    (m_axi_usr_wstrb                    ),//o
    .m_axi_usr_wstrb_par                (m_axi_usr_wstrb_par                ),//o
    .m_axi_usr_wlast                    (m_axi_usr_wlast                    ),//o
    .m_axi_usr_bready                   (m_axi_usr_bready                   ),//o
    .m_axi_usr_bvalid                   (m_axi_usr_bvalid                   ),//i
    .m_axi_usr_bresp                    (m_axi_usr_bresp                    ),//i
    .m_axi_usr_bid                      (m_axi_usr_bid                      ),//i
    .m_axi_usr_arready                  (m_axi_usr_arready                  ),//i
    .m_axi_usr_arvalid                  (m_axi_usr_arvalid                  ),//o
    .m_axi_usr_arid                     (m_axi_usr_arid                     ),//o
    .m_axi_usr_araddr                   (m_axi_usr_araddr                   ),//o
    .m_axi_usr_arlen                    (m_axi_usr_arlen                    ),//o
    .m_axi_usr_arsize                   (m_axi_usr_arsize                   ),//o
    .m_axi_usr_rready                   (m_axi_usr_rready                   ),//o
    .m_axi_usr_rvalid                   (m_axi_usr_rvalid                   ),//i
    .m_axi_usr_rid                      (m_axi_usr_rid                      ),//i
    .m_axi_usr_rdata                    (m_axi_usr_rdata                    ),//i
    .m_axi_usr_rdata_par                (m_axi_usr_rdata_par                ),//i
    .m_axi_usr_rresp                    (m_axi_usr_rresp                    ),//i
    .m_axi_usr_rlast                    (m_axi_usr_rlast                    ),//i
    //--------------------------------- --------------------
    //Slve Axi-St For User   
    .s_axis_usr_tready                  (s_axis_usr_tready                  ),//o
    .s_axis_usr_tvalid                  (s_axis_usr_tvalid                  ),//i
    .s_axis_usr_tdata                   (s_axis_usr_tdata                   ),//i
    .s_axis_usr_tdata_par               (s_axis_usr_tdata_par               ),//i
    .s_axis_usr_tkeep                   (s_axis_usr_tkeep                   ),//i
    .s_axis_usr_tlast                   (s_axis_usr_tlast                   ),//i
    //.s_axis_usr_tuser                   (s_axis_usr_tuser                   ),//i
    //-----------------------------------------------------
    //Master Axi-St For User 
    .m_axis_usr_tready                  (m_axis_usr_tready                  ),//i
    .m_axis_usr_tdata                   (m_axis_usr_tdata                   ),//o
    .m_axis_usr_tdata_par               (m_axis_usr_tdata_par               ),//o
    //.m_axis_usr_tuser                   (m_axis_usr_tuser                   ),//o
    .m_axis_usr_tlast                   (m_axis_usr_tlast                   ),//o
    .m_axis_usr_tvalid                  (m_axis_usr_tvalid                  ),//o
    .m_axis_usr_tkeep                   (m_axis_usr_tkeep                   ),//o
    //-----------------------------------------------------
    //Uer To Ep Byp
    .u2e_dsc_byp_ready                  (u2e_dsc_byp_ready                  ),//o
    .u2e_dsc_byp_src_addr               (u2e_dsc_byp_src_addr               ),//i
    .u2e_dsc_byp_dst_addr               (u2e_dsc_byp_dst_addr               ),//i
    .u2e_dsc_byp_len                    (u2e_dsc_byp_len                    ),//i
    .u2e_dsc_byp_ctl                    (u2e_dsc_byp_ctl                    ),//i
    .u2e_dsc_byp_load                   (u2e_dsc_byp_load                   ),//i
    //Ep To User Byp    
    .e2u_dsc_byp_ready                  (e2u_dsc_byp_ready                  ),//o
    .e2u_dsc_byp_src_addr               (e2u_dsc_byp_src_addr               ),//i
    .e2u_dsc_byp_dst_addr               (e2u_dsc_byp_dst_addr               ),//i
    .e2u_dsc_byp_len                    (e2u_dsc_byp_len                    ),//i
    .e2u_dsc_byp_ctl                    (e2u_dsc_byp_ctl                    ),//i
    .e2u_dsc_byp_load                   (e2u_dsc_byp_load                   ),//i
    //-----------------------------------------------------
    //Bypass Axi
    .m_axi_byp_awid                     (m_axi_byp_awid                     ),//o
    .m_axi_byp_awvalid                  (m_axi_byp_awvalid                  ),//o
    .m_axi_byp_awaddr                   (m_axi_byp_awaddr                   ),//o
    .m_axi_byp_awlen                    (m_axi_byp_awlen                    ),//o
    .m_axi_byp_awsize                   (m_axi_byp_awsize                   ),//o
    .m_axi_byp_awready                  (m_axi_byp_awready                  ),//i
    .m_axi_byp_wvalid                   (m_axi_byp_wvalid                   ),//o
    .m_axi_byp_wdata                    (m_axi_byp_wdata                    ),//o
    .m_axi_byp_wdata_par                (m_axi_byp_wdata_par                ),//o
    .m_axi_byp_wstrb                    (m_axi_byp_wstrb                    ),//o
    .m_axi_byp_wlast                    (m_axi_byp_wlast                    ),//o
    .m_axi_byp_wready                   (m_axi_byp_wready                   ),//i
    .m_axi_byp_bid                      (m_axi_byp_bid                      ),//i
    .m_axi_byp_bresp                    (m_axi_byp_bresp                    ),//i
    .m_axi_byp_bvalid                   (m_axi_byp_bvalid                   ),//i
    .m_axi_byp_bready                   (m_axi_byp_bready                   ),//o
    .m_axi_byp_arid                     (m_axi_byp_arid                     ),//o
    .m_axi_byp_arvalid                  (m_axi_byp_arvalid                  ),//o
    .m_axi_byp_araddr                   (m_axi_byp_araddr                   ),//o
    .m_axi_byp_arlen                    (m_axi_byp_arlen                    ),//o
    .m_axi_byp_arsize                   (m_axi_byp_arsize                   ),//o
    .m_axi_byp_arready                  (m_axi_byp_arready                  ),//i
    .m_axi_byp_rid                      (m_axi_byp_rid                      ),//i
    .m_axi_byp_rvalid                   (m_axi_byp_rvalid                   ),//i
    .m_axi_byp_rdata                    (m_axi_byp_rdata                    ),//i
    .m_axi_byp_rlast                    (m_axi_byp_rlast                    ),//i
    .m_axi_byp_rresp                    (m_axi_byp_rresp                    ),//i
    .m_axi_byp_rready                   (m_axi_byp_rready                   ),//o
    //-----------------------------------------------------
    //Master Axi For Pcie Core
    .m_axi_pcie_awaddr                  (m_axi_pcie0_awaddr                 ),//o
    .m_axi_pcie_awid                    (m_axi_pcie0_awid                   ),//o
    .m_axi_pcie_awlen                   (m_axi_pcie0_awlen                  ),//o
    .m_axi_pcie_awsize                  (m_axi_pcie0_awsize                 ),//o
    .m_axi_pcie_awburst                 (m_axi_pcie0_awburst                ),//o
    .m_axi_pcie_awprot                  (m_axi_pcie0_awprot                 ),//o
    .m_axi_pcie_awvalid                 (m_axi_pcie0_awvalid                ),//o
    .m_axi_pcie_awready                 (m_axi_pcie0_awready                ),//i
    .m_axi_pcie_awlock                  (m_axi_pcie0_awlock                 ),//o
    .m_axi_pcie_awcache                 (m_axi_pcie0_awcache                ),//o
    .m_axi_pcie_wdata                   (m_axi_pcie0_wdata                  ),//o
    .m_axi_pcie_wdata_par               (m_axi_pcie0_wdata_par              ),//o
    .m_axi_pcie_wstrb                   (m_axi_pcie0_wstrb                  ),//o
    .m_axi_pcie_wlast                   (m_axi_pcie0_wlast                  ),//o
    .m_axi_pcie_wvalid                  (m_axi_pcie0_wvalid                 ),//o
    .m_axi_pcie_wready                  (m_axi_pcie0_wready                 ),//i
    .m_axi_pcie_bresp                   (m_axi_pcie0_bresp                  ),//i
    .m_axi_pcie_bid                     (m_axi_pcie0_bid                    ),//i
    .m_axi_pcie_bvalid                  (m_axi_pcie0_bvalid                 ),//i
    .m_axi_pcie_bready                  (m_axi_pcie0_bready                 ),//o
    .m_axi_pcie_arid                    (m_axi_pcie0_arid                   ),//o
    .m_axi_pcie_araddr                  (m_axi_pcie0_araddr                 ),//o
    .m_axi_pcie_arlen                   (m_axi_pcie0_arlen                  ),//o
    .m_axi_pcie_arsize                  (m_axi_pcie0_arsize                 ),//o
    .m_axi_pcie_arburst                 (m_axi_pcie0_arburst                ),//o
    .m_axi_pcie_arprot                  (m_axi_pcie0_arprot                 ),//o
    .m_axi_pcie_arvalid                 (m_axi_pcie0_arvalid                ),//o
    .m_axi_pcie_arready                 (m_axi_pcie0_arready                ),//i
    .m_axi_pcie_arlock                  (m_axi_pcie0_arlock                 ),//o
    .m_axi_pcie_arcache                 (m_axi_pcie0_arcache                ),//o
    .m_axi_pcie_rid                     (m_axi_pcie0_rid                    ),//i
    .m_axi_pcie_rdata                   (m_axi_pcie0_rdata                  ),//i
    .m_axi_pcie_rdata_par               (m_axi_pcie0_rdata_par              ),//i
    .m_axi_pcie_rresp                   (m_axi_pcie0_rresp                  ),//i
    .m_axi_pcie_rlast                   (m_axi_pcie0_rlast                  ),//i
    .m_axi_pcie_rvalid                  (m_axi_pcie0_rvalid                 ),//i
    .m_axi_pcie_rready                  (m_axi_pcie0_rready                 ),//o
    //-----------------------------------------------------
    //Slave Axi For Pcie Core
    .s_axi_pcie_awid                    (s_axi_pcie0_awid                   ),//i
    .s_axi_pcie_awvalid                 (s_axi_pcie0_awvalid                ),//i
    .s_axi_pcie_awaddr                  (s_axi_pcie0_awaddr                 ),//i
    .s_axi_pcie_awlen                   (s_axi_pcie0_awlen                  ),//i
    .s_axi_pcie_awsize                  (s_axi_pcie0_awsize                 ),//i
    .s_axi_pcie_awready                 (s_axi_pcie0_awready                ),//o
    .s_axi_pcie_wvalid                  (s_axi_pcie0_wvalid                 ),//i
    .s_axi_pcie_wdata                   (s_axi_pcie0_wdata                  ),//i
    .s_axi_pcie_wstrb                   (s_axi_pcie0_wstrb                  ),//i
    .s_axi_pcie_wlast                   (s_axi_pcie0_wlast                  ),//i
    .s_axi_pcie_wready                  (s_axi_pcie0_wready                 ),//o
    .s_axi_pcie_bid                     (s_axi_pcie0_bid                    ),//o
    .s_axi_pcie_bresp                   (s_axi_pcie0_bresp                  ),//o
    .s_axi_pcie_bvalid                  (s_axi_pcie0_bvalid                 ),//o
    .s_axi_pcie_bready                  (s_axi_pcie0_bready                 ),//i
    .s_axi_pcie_arid                    (s_axi_pcie0_arid                   ),//i
    .s_axi_pcie_arvalid                 (s_axi_pcie0_arvalid                ),//i
    .s_axi_pcie_araddr                  (s_axi_pcie0_araddr                 ),//i
    .s_axi_pcie_arlen                   (s_axi_pcie0_arlen                  ),//i
    .s_axi_pcie_arsize                  (s_axi_pcie0_arsize                 ),//i
    .s_axi_pcie_arready                 (s_axi_pcie0_arready                ),//o
    .s_axi_pcie_rid                     (s_axi_pcie0_rid                    ),//o
    .s_axi_pcie_rvalid                  (s_axi_pcie0_rvalid                 ),//o
    .s_axi_pcie_rdata                   (s_axi_pcie0_rdata                  ),//o
    .s_axi_pcie_rlast                   (s_axi_pcie0_rlast                  ),//o
    .s_axi_pcie_rresp                   (s_axi_pcie0_rresp                  ),//o
    .s_axi_pcie_rready                  (s_axi_pcie0_rready                 ),//i
    //-----------------------------------------------------
    //Htc
    .htc_running                        (htc_running                        ),//o
    .htc_busy                           (htc_busy                           ),//o
    .htc_interrupt                      (htc_interrupt                      ),//o
    .htc_dsc_done                       (htc_dsc_done                       ),//o
    //Cth   
    .cth_running                        (cth_running                        ),//o
    .cth_busy                           (cth_busy                           ),//o
    .cth_interrupt                      (cth_interrupt                      ),//o
    .cth_dsc_done                       (cth_dsc_done                       ),//o
    //-----------------------------------------------------
    .usr_irq                            (usr_irq                            ),//i
    .usr_irq_ack                        (usr_irq_ack                        ),//o
    .cfg_msi_enable                     (cfg_msi_enable                     ),//i
    .cfg_msix_enable                    (cfg_msix_enable                    ),//i
    .legacy_irq                         (legacy_irq                         ),//o
    .legacy_irq_ack                     (legacy_irq_ack                     ),//i
    .cfg_max_payload_size               (pcie0_max_payload_size             ),//i
    .cfg_max_read_req_size              (pcie0_max_read_req_size            ) //i
);
end

else begin:PCIE_AXI_REG_EN

axi_reg#
(
    .DATA_WIDTH                         (256                                ),
    // Width of address bus in bits
    .ADDR_WIDTH                         (64                                 )
)
u_s_axi_pcie0_register 
(
    .clk                                (axi_clk_250m                       ),
    .rst                                (~clk_250m_rstn                     ),
    //AXI slave interface
    .s_axi_awid                         (s_axi_pcie0_awid                   ),
    .s_axi_awaddr                       (s_axi_pcie0_awaddr                 ),
    .s_axi_awlen                        (s_axi_pcie0_awlen                  ),
    .s_axi_awsize                       (s_axi_pcie0_awsize                 ),
    .s_axi_awburst                      (                                   ),
    .s_axi_awlock                       (                                   ),
    .s_axi_awcache                      (                                   ),
    .s_axi_awprot                       (                                   ),
    .s_axi_awqos                        (                                   ),
    .s_axi_awregion                     (                                   ),
    .s_axi_awuser                       (s_axi_pcie0_awuser                 ),
    .s_axi_awvalid                      (s_axi_pcie0_awvalid                ),
    .s_axi_awready                      (s_axi_pcie0_awready                ),
    .s_axi_wdata                        (s_axi_pcie0_wdata                  ),
    .s_axi_wdata_par                    (s_axi_pcie0_wdata_par              ),
    .s_axi_wstrb                        (s_axi_pcie0_wstrb                  ),
    .s_axi_wstrb_par                    (s_axi_pcie0_wstrb_par              ),
    .s_axi_wlast                        (s_axi_pcie0_wlast                  ),
    .s_axi_wuser                        (                                   ),
    .s_axi_wvalid                       (s_axi_pcie0_wvalid                 ),
    .s_axi_wready                       (s_axi_pcie0_wready                 ),
    .s_axi_bid                          (s_axi_pcie0_bid                    ),
    .s_axi_bid_par                      (s_axi_pcie0_bid_par                ),
    .s_axi_bresp                        (s_axi_pcie0_bresp                  ),
    .s_axi_bresp_par                    (s_axi_pcie0_bresp_par              ),
    .s_axi_buser                        (                                   ),
    .s_axi_bvalid                       (s_axi_pcie0_bvalid                 ),
    .s_axi_bready                       (s_axi_pcie0_bready                 ),
    .s_axi_arid                         (s_axi_pcie0_arid                   ),
    .s_axi_araddr                       (s_axi_pcie0_araddr                 ),
    .s_axi_arlen                        (s_axi_pcie0_arlen                  ),
    .s_axi_arsize                       (s_axi_pcie0_arsize                 ),
    .s_axi_arburst                      (                                   ),
    .s_axi_arlock                       (                                   ),
    .s_axi_arcache                      (                                   ),
    .s_axi_arprot                       (                                   ),
    .s_axi_arqos                        (                                   ),
    .s_axi_arregion                     (                                   ),
    .s_axi_aruser                       (s_axi_pcie0_aruser                 ),
    .s_axi_arvalid                      (s_axi_pcie0_arvalid                ),
    .s_axi_arready                      (s_axi_pcie0_arready                ),
    .s_axi_rid                          (s_axi_pcie0_rid                    ),
    .s_axi_rid_par                      (s_axi_pcie0_rid_par                ),
    .s_axi_rdata                        (s_axi_pcie0_rdata                  ),
    .s_axi_rdata_par                    (s_axi_pcie0_rdata_par              ),
    .s_axi_rresp                        (s_axi_pcie0_rresp                  ),
    .s_axi_rresp_par                    (s_axi_pcie0_rresp_par              ),
    .s_axi_rlast                        (s_axi_pcie0_rlast                  ),
    .s_axi_ruser                        (                                   ),
    .s_axi_rvalid                       (s_axi_pcie0_rvalid                 ),
    .s_axi_rready                       (s_axi_pcie0_rready                 ),  
    //AXI master interface
    .m_axi_awid                         (s_axi_pcie0_reg_awid               ),
    .m_axi_awaddr                       (s_axi_pcie0_reg_awaddr             ),
    .m_axi_awlen                        (s_axi_pcie0_reg_awlen              ),
    .m_axi_awsize                       (s_axi_pcie0_reg_awsize             ),
    .m_axi_awburst                      (                                   ),
    .m_axi_awlock                       (                                   ),
    .m_axi_awcache                      (                                   ),
    .m_axi_awprot                       (                                   ),
    .m_axi_awqos                        (                                   ),
    .m_axi_awregion                     (                                   ),
    .m_axi_awuser                       (s_axi_pcie0_reg_awuser             ),
    .m_axi_awvalid                      (s_axi_pcie0_reg_awvalid            ),
    .m_axi_awready                      (s_axi_pcie0_reg_awready            ),
    .m_axi_wdata                        (s_axi_pcie0_reg_wdata              ),
    .m_axi_wdata_par                    (s_axi_pcie0_reg_wdata_par          ),
    .m_axi_wstrb                        (s_axi_pcie0_reg_wstrb              ),
    .m_axi_wstrb_par                    (s_axi_pcie0_reg_wstrb_par          ),
    .m_axi_wlast                        (s_axi_pcie0_reg_wlast              ),
    .m_axi_wuser                        (                                   ),
    .m_axi_wvalid                       (s_axi_pcie0_reg_wvalid             ),
    .m_axi_wready                       (s_axi_pcie0_reg_wready             ),
    .m_axi_bid                          (s_axi_pcie0_reg_bid                ),
    // .m_axi_bid_par                      (s_axi_pcie0_reg_bid_par            ),
    .m_axi_bid_par                      (0                                  ),
    .m_axi_bresp                        (s_axi_pcie0_reg_bresp              ),
    // .m_axi_bresp_par                    (s_axi_pcie0_reg_bresp_par          ),
    .m_axi_bresp_par                    (0                                  ),
    .m_axi_buser                        (                                   ),
    .m_axi_bvalid                       (s_axi_pcie0_reg_bvalid             ),
    .m_axi_bready                       (s_axi_pcie0_reg_bready             ),

    .m_axi_arid                         (s_axi_pcie0_reg_arid               ),
    .m_axi_araddr                       (s_axi_pcie0_reg_araddr             ),
    .m_axi_arlen                        (s_axi_pcie0_reg_arlen              ),
    .m_axi_arsize                       (s_axi_pcie0_reg_arsize             ),
    .m_axi_arburst                      (                                   ),
    .m_axi_arlock                       (                                   ),
    .m_axi_arcache                      (                                   ),
    .m_axi_arprot                       (                                   ),
    .m_axi_arqos                        (                                   ),
    .m_axi_arregion                     (                                   ),
    .m_axi_aruser                       (s_axi_pcie0_reg_aruser             ),
    .m_axi_arvalid                      (s_axi_pcie0_reg_arvalid            ),
    .m_axi_arready                      (s_axi_pcie0_reg_arready            ),
    .m_axi_rid                          (s_axi_pcie0_reg_rid                ),
    // .m_axi_rid_par                      (s_axi_pcie0_reg_rid_par            ),
    .m_axi_rid_par                      (0                                  ),
    .m_axi_rdata                        (s_axi_pcie0_reg_rdata              ),
    // .m_axi_rdata_par                    (s_axi_pcie0_reg_rdata_par          ),
    .m_axi_rdata_par                    (0                                  ),
    .m_axi_rresp                        (s_axi_pcie0_reg_rresp              ),
    // .m_axi_rresp_par                    (s_axi_pcie0_reg_rresp_par          ),
    .m_axi_rresp_par                    (0                                  ),
    .m_axi_rlast                        (s_axi_pcie0_reg_rlast              ),
    .m_axi_ruser                        (                                   ),
    .m_axi_rvalid                       (s_axi_pcie0_reg_rvalid             ),
    .m_axi_rready                       (s_axi_pcie0_reg_rready             )
);

axi_reg#
(
    .DATA_WIDTH                         (256                                ),
    // Width of address bus in bits
    .ADDR_WIDTH                         (64                                 )
)
u_m_axi_pcie0_register 
(
    .clk                                (axi_clk_250m                       ),
    .rst                                (~clk_250m_rstn                     ),
    //AXI slave interface
    .s_axi_awid                         (m_axi_pcie0_reg_awid               ),
    .s_axi_awaddr                       (m_axi_pcie0_reg_awaddr             ),
    .s_axi_awlen                        (m_axi_pcie0_reg_awlen              ),
    .s_axi_awsize                       (m_axi_pcie0_reg_awsize             ),
    .s_axi_awburst                      (                                   ),
    .s_axi_awlock                       (                                   ),
    .s_axi_awcache                      (                                   ),
    .s_axi_awprot                       (                                   ),
    .s_axi_awqos                        (                                   ),
    .s_axi_awregion                     (                                   ),
    .s_axi_awuser                       (m_axi_pcie0_reg_awuser             ),
    .s_axi_awvalid                      (m_axi_pcie0_reg_awvalid            ),
    .s_axi_awready                      (m_axi_pcie0_reg_awready            ),
    .s_axi_wdata                        (m_axi_pcie0_reg_wdata              ),
    .s_axi_wdata_par                    (m_axi_pcie0_reg_wdata_par          ),
    .s_axi_wstrb                        (m_axi_pcie0_reg_wstrb              ),
    // .s_axi_wstrb_par                    (m_axi_pcie0_reg_wstrb_par          ),
    .s_axi_wstrb_par                    (0                                  ),
    .s_axi_wlast                        (m_axi_pcie0_reg_wlast              ),
    .s_axi_wuser                        (                                   ),
    .s_axi_wvalid                       (m_axi_pcie0_reg_wvalid             ),
    .s_axi_wready                       (m_axi_pcie0_reg_wready             ),
    .s_axi_bid                          (m_axi_pcie0_reg_bid                ),
    .s_axi_bid_par                      (m_axi_pcie0_reg_bid_par            ),
    .s_axi_bresp                        (m_axi_pcie0_reg_bresp              ),
    .s_axi_bresp_par                    (m_axi_pcie0_reg_bresp_par          ),
    .s_axi_buser                        (                                   ),
    .s_axi_bvalid                       (m_axi_pcie0_reg_bvalid             ),
    .s_axi_bready                       (m_axi_pcie0_reg_bready             ),
    .s_axi_arid                         (m_axi_pcie0_reg_arid               ),
    .s_axi_araddr                       (m_axi_pcie0_reg_araddr             ),
    .s_axi_arlen                        (m_axi_pcie0_reg_arlen              ),
    .s_axi_arsize                       (m_axi_pcie0_reg_arsize             ),
    .s_axi_arburst                      (                                   ),
    .s_axi_arlock                       (                                   ),
    .s_axi_arcache                      (                                   ),
    .s_axi_arprot                       (                                   ),
    .s_axi_arqos                        (                                   ),
    .s_axi_arregion                     (                                   ),
    .s_axi_aruser                       (m_axi_pcie0_reg_aruser             ),
    .s_axi_arvalid                      (m_axi_pcie0_reg_arvalid            ),
    .s_axi_arready                      (m_axi_pcie0_reg_arready            ),
    .s_axi_rid                          (m_axi_pcie0_reg_rid                ),
    .s_axi_rid_par                      (m_axi_pcie0_reg_rid_par            ),
    .s_axi_rdata                        (m_axi_pcie0_reg_rdata              ),
    .s_axi_rdata_par                    (m_axi_pcie0_reg_rdata_par          ),
    .s_axi_rresp                        (m_axi_pcie0_reg_rresp              ),
    .s_axi_rresp_par                    (m_axi_pcie0_reg_rresp_par          ),
    .s_axi_rlast                        (m_axi_pcie0_reg_rlast              ),
    .s_axi_ruser                        (                                   ),
    .s_axi_rvalid                       (m_axi_pcie0_reg_rvalid             ),
    .s_axi_rready                       (m_axi_pcie0_reg_rready             ),
    //AXI master interface
    .m_axi_awid                         (m_axi_pcie0_awid                   ),
    .m_axi_awaddr                       (m_axi_pcie0_awaddr                 ),
    .m_axi_awlen                        (m_axi_pcie0_awlen                  ),
    .m_axi_awsize                       (m_axi_pcie0_awsize                 ),
    .m_axi_awburst                      (                                   ),
    .m_axi_awlock                       (                                   ),
    .m_axi_awcache                      (                                   ),
    .m_axi_awprot                       (                                   ),
    .m_axi_awqos                        (                                   ),
    .m_axi_awregion                     (                                   ),
    .m_axi_awuser                       (m_axi_pcie0_awuser                 ),
    .m_axi_awvalid                      (m_axi_pcie0_awvalid                ),
    .m_axi_awready                      (m_axi_pcie0_awready                ),
    .m_axi_wdata                        (m_axi_pcie0_wdata                  ),
    .m_axi_wdata_par                    (m_axi_pcie0_wdata_par              ),
    .m_axi_wstrb                        (m_axi_pcie0_wstrb                  ),
    .m_axi_wstrb_par                    (m_axi_pcie0_wstrb_par              ),
    .m_axi_wlast                        (m_axi_pcie0_wlast                  ),
    .m_axi_wuser                        (                                   ),
    .m_axi_wvalid                       (m_axi_pcie0_wvalid                 ),
    .m_axi_wready                       (m_axi_pcie0_wready                 ),
    .m_axi_bid                          (m_axi_pcie0_bid                    ),
    .m_axi_bid_par                      (m_axi_pcie0_bid_par                ),
    .m_axi_bresp                        (m_axi_pcie0_bresp                  ),
    .m_axi_bresp_par                    (m_axi_pcie0_bresp_par              ),
    .m_axi_buser                        (                                   ),
    .m_axi_bvalid                       (m_axi_pcie0_bvalid                 ),
    .m_axi_bready                       (m_axi_pcie0_bready                 ),

    .m_axi_arid                         (m_axi_pcie0_arid                   ),
    .m_axi_araddr                       (m_axi_pcie0_araddr                 ),
    .m_axi_arlen                        (m_axi_pcie0_arlen                  ),
    .m_axi_arsize                       (m_axi_pcie0_arsize                 ),
    .m_axi_arburst                      (                                   ),
    .m_axi_arlock                       (                                   ),
    .m_axi_arcache                      (                                   ),
    .m_axi_arprot                       (                                   ),
    .m_axi_arqos                        (                                   ),
    .m_axi_arregion                     (                                   ),
    .m_axi_aruser                       (m_axi_pcie0_aruser                 ),
    .m_axi_arvalid                      (m_axi_pcie0_arvalid                ),
    .m_axi_arready                      (m_axi_pcie0_arready                ),
    .m_axi_rid                          (m_axi_pcie0_rid                    ),
    .m_axi_rid_par                      (m_axi_pcie0_rid_par                ),
    .m_axi_rdata                        (m_axi_pcie0_rdata                  ),
    .m_axi_rdata_par                    (m_axi_pcie0_rdata_par              ),
    .m_axi_rresp                        (m_axi_pcie0_rresp                  ),
    .m_axi_rresp_par                    (m_axi_pcie0_rresp_par              ),
    .m_axi_rlast                        (m_axi_pcie0_rlast                  ),
    .m_axi_ruser                        (                                   ),
    .m_axi_rvalid                       (m_axi_pcie0_rvalid                 ),
    .m_axi_rready                       (m_axi_pcie0_rready                 )
);

efx_pcie_dma #( 
    .DMA_ST_EN                          (DMA_ST_EN                          )
)
u_dma_ip
(
    //-----------------------------------------------------
    //-- AXI Global
    .axi_clk                            (axi_clk_250m                       ),//i
    .dma_rstn                           (!user_reset                        ),//i
    .apb_clk                            (apb_clk_100m                       ),//i
    .apb_rstn                           (clk_100m_rstn                      ),//i
    //-----------------------------------------------------
    //Master Apb For User
    .m_apb_usr_pready                   (m_apb_usr_pready                   ),//i
    .m_apb_usr_psel                     (m_apb_usr_psel                     ),//o
    .m_apb_usr_pwrite                   (m_apb_usr_pwrite                   ),//o
    .m_apb_usr_penable                  (m_apb_usr_penable                  ),//o
    .m_apb_usr_paddr                    (m_apb_usr_paddr                    ),//o  
    .m_apb_usr_pwdata                   (m_apb_usr_pwdata                   ),//o
    .m_apb_usr_prdata                   (m_apb_usr_prdata                   ),//i
    .m_apb_usr_pslverror                (m_apb_usr_pslverror                ),//i
    //-----------------------------------------------------
    //Master Apb For Pcie

    .m_apb_pcie_pready                  (m_apb_q0_pcie_pready               ),//i
    .m_apb_pcie_psel                    (m_apb_q0_pcie_psel                 ),//o
    .m_apb_pcie_pwrite                  (m_apb_q0_pcie_pwrite               ),//o
    .m_apb_pcie_penable                 (m_apb_q0_pcie_penable              ),//o
    .m_apb_pcie_paddr                   (m_apb_q0_pcie_paddr                ),//o
    .m_apb_pcie_pwdata                  (m_apb_q0_pcie_pwdata               ),//o
    .m_apb_pcie_pwdata_par              (m_apb_q0_pcie_pwdata_par           ),//o
    .m_apb_pcie_pstrb                   (m_apb_q0_pcie_pstrb                ),//o
    .m_apb_pcie_pstrb_par               (m_apb_q0_pcie_pstrb_par            ),//o
    .m_apb_pcie_prdata                  (m_apb_q0_pcie_prdata               ),//i
    .m_apb_pcie_prdata_par              (m_apb_q0_pcie_prdata_par           ),//i
    .m_apb_pcie_pslverror               (m_apb_q0_pcie_pslverror            ),//i

    //-----------------------------------------------------
    //Slave Apb For Pcie
    .s_apb_usr_pready                   (s_apb_usr_pready                   ),//o
    .s_apb_usr_psel                     (s_apb_usr_psel                     ),//i
    .s_apb_usr_pwrite                   (s_apb_usr_pwrite                   ),//i
    .s_apb_usr_penable                  (s_apb_usr_penable                  ),//i
    .s_apb_usr_paddr                    (s_apb_usr_paddr                    ),//i
    .s_apb_usr_pwdata                   (s_apb_usr_pwdata                   ),//i
    .s_apb_usr_prdata                   (s_apb_usr_prdata                   ),//o
    .s_apb_usr_pslverror                (s_apb_usr_pslverror                ),//o
    //-----------------------------------------------------
    //Master Axi For User
    .m_axi_usr_awready                  (m_axi_usr_awready                  ),//i
    .m_axi_usr_awvalid                  (m_axi_usr_awvalid                  ),//o
    .m_axi_usr_awaddr                   (m_axi_usr_awaddr                   ),//o
    .m_axi_usr_awid                     (m_axi_usr_awid                     ),//o
    .m_axi_usr_awlen                    (m_axi_usr_awlen                    ),//o
    .m_axi_usr_awsize                   (m_axi_usr_awsize                   ),//o
    .m_axi_usr_wready                   (m_axi_usr_wready                   ),//i
    .m_axi_usr_wvalid                   (m_axi_usr_wvalid                   ),//o
    .m_axi_usr_wdata                    (m_axi_usr_wdata                    ),//o
    .m_axi_usr_wdata_par                (m_axi_usr_wdata_par                ),//o
    .m_axi_usr_wstrb                    (m_axi_usr_wstrb                    ),//o
    .m_axi_usr_wstrb_par                (m_axi_usr_wstrb_par                ),//o
    .m_axi_usr_wlast                    (m_axi_usr_wlast                    ),//o
    .m_axi_usr_bready                   (m_axi_usr_bready                   ),//o
    .m_axi_usr_bvalid                   (m_axi_usr_bvalid                   ),//i
    .m_axi_usr_bresp                    (m_axi_usr_bresp                    ),//i
    .m_axi_usr_bid                      (m_axi_usr_bid                      ),//i
    .m_axi_usr_arready                  (m_axi_usr_arready                  ),//i
    .m_axi_usr_arvalid                  (m_axi_usr_arvalid                  ),//o
    .m_axi_usr_arid                     (m_axi_usr_arid                     ),//o
    .m_axi_usr_araddr                   (m_axi_usr_araddr                   ),//o
    .m_axi_usr_arlen                    (m_axi_usr_arlen                    ),//o
    .m_axi_usr_arsize                   (m_axi_usr_arsize                   ),//o
    .m_axi_usr_rready                   (m_axi_usr_rready                   ),//o
    .m_axi_usr_rvalid                   (m_axi_usr_rvalid                   ),//i
    .m_axi_usr_rid                      (m_axi_usr_rid                      ),//i
    .m_axi_usr_rdata                    (m_axi_usr_rdata                    ),//i
    .m_axi_usr_rdata_par                (m_axi_usr_rdata_par                ),//i
    .m_axi_usr_rresp                    (m_axi_usr_rresp                    ),//i
    .m_axi_usr_rlast                    (m_axi_usr_rlast                    ),//i
    //--------------------------------- --------------------
    //Slve Axi-St For User   
    .s_axis_usr_tready                  (s_axis_usr_tready                  ),//o
    .s_axis_usr_tvalid                  (s_axis_usr_tvalid                  ),//i
    .s_axis_usr_tdata                   (s_axis_usr_tdata                   ),//i
    .s_axis_usr_tdata_par               (s_axis_usr_tdata_par               ),//i
    .s_axis_usr_tkeep                   (s_axis_usr_tkeep                   ),//i
    .s_axis_usr_tlast                   (s_axis_usr_tlast                   ),//i
    //.s_axis_usr_tuser                   (s_axis_usr_tuser                   ),//i
    //-----------------------------------------------------
    //Master Axi-St For User 
    .m_axis_usr_tready                  (m_axis_usr_tready                  ),//i
    .m_axis_usr_tdata                   (m_axis_usr_tdata                   ),//o
    .m_axis_usr_tdata_par               (m_axis_usr_tdata_par               ),//o
    //.m_axis_usr_tuser                   (m_axis_usr_tuser                   ),//o
    .m_axis_usr_tlast                   (m_axis_usr_tlast                   ),//o
    .m_axis_usr_tvalid                  (m_axis_usr_tvalid                  ),//o
    .m_axis_usr_tkeep                   (m_axis_usr_tkeep                   ),//o
    //-----------------------------------------------------
    //Uer To Ep Byp
    .u2e_dsc_byp_ready                  (u2e_dsc_byp_ready                  ),//o
    .u2e_dsc_byp_src_addr               (u2e_dsc_byp_src_addr               ),//i
    .u2e_dsc_byp_dst_addr               (u2e_dsc_byp_dst_addr               ),//i
    .u2e_dsc_byp_len                    (u2e_dsc_byp_len                    ),//i
    .u2e_dsc_byp_ctl                    (u2e_dsc_byp_ctl                    ),//i
    .u2e_dsc_byp_load                   (u2e_dsc_byp_load                   ),//i
    //Ep To User Byp    
    .e2u_dsc_byp_ready                  (e2u_dsc_byp_ready                  ),//o
    .e2u_dsc_byp_src_addr               (e2u_dsc_byp_src_addr               ),//i
    .e2u_dsc_byp_dst_addr               (e2u_dsc_byp_dst_addr               ),//i
    .e2u_dsc_byp_len                    (e2u_dsc_byp_len                    ),//i
    .e2u_dsc_byp_ctl                    (e2u_dsc_byp_ctl                    ),//i
    .e2u_dsc_byp_load                   (e2u_dsc_byp_load                   ),//i
    //-----------------------------------------------------
    //Bypass Axi
    .m_axi_byp_awid                     (m_axi_byp_awid                     ),//o
    .m_axi_byp_awvalid                  (m_axi_byp_awvalid                  ),//o
    .m_axi_byp_awaddr                   (m_axi_byp_awaddr                   ),//o
    .m_axi_byp_awlen                    (m_axi_byp_awlen                    ),//o
    .m_axi_byp_awsize                   (m_axi_byp_awsize                   ),//o
    .m_axi_byp_awready                  (m_axi_byp_awready                  ),//i
    .m_axi_byp_wvalid                   (m_axi_byp_wvalid                   ),//o
    .m_axi_byp_wdata                    (m_axi_byp_wdata                    ),//o
    .m_axi_byp_wdata_par                (m_axi_byp_wdata_par                ),//o
    .m_axi_byp_wstrb                    (m_axi_byp_wstrb                    ),//o
    .m_axi_byp_wlast                    (m_axi_byp_wlast                    ),//o
    .m_axi_byp_wready                   (m_axi_byp_wready                   ),//i
    .m_axi_byp_bid                      (m_axi_byp_bid                      ),//i
    .m_axi_byp_bresp                    (m_axi_byp_bresp                    ),//i
    .m_axi_byp_bvalid                   (m_axi_byp_bvalid                   ),//i
    .m_axi_byp_bready                   (m_axi_byp_bready                   ),//o
    .m_axi_byp_arid                     (m_axi_byp_arid                     ),//o
    .m_axi_byp_arvalid                  (m_axi_byp_arvalid                  ),//o
    .m_axi_byp_araddr                   (m_axi_byp_araddr                   ),//o
    .m_axi_byp_arlen                    (m_axi_byp_arlen                    ),//o
    .m_axi_byp_arsize                   (m_axi_byp_arsize                   ),//o
    .m_axi_byp_arready                  (m_axi_byp_arready                  ),//i
    .m_axi_byp_rid                      (m_axi_byp_rid                      ),//i
    .m_axi_byp_rvalid                   (m_axi_byp_rvalid                   ),//i
    .m_axi_byp_rdata                    (m_axi_byp_rdata                    ),//i
    .m_axi_byp_rlast                    (m_axi_byp_rlast                    ),//i
    .m_axi_byp_rresp                    (m_axi_byp_rresp                    ),//i
    .m_axi_byp_rready                   (m_axi_byp_rready                   ),//o
    //-----------------------------------------------------
    //Master Axi For Pcie Core
    .m_axi_pcie_awaddr                  (m_axi_pcie0_reg_awaddr             ),//o
    .m_axi_pcie_awid                    (m_axi_pcie0_reg_awid               ),//o
    .m_axi_pcie_awlen                   (m_axi_pcie0_reg_awlen              ),//o
    .m_axi_pcie_awsize                  (m_axi_pcie0_reg_awsize             ),//o
    .m_axi_pcie_awburst                 (m_axi_pcie0_reg_awburst            ),//o
    .m_axi_pcie_awprot                  (m_axi_pcie0_reg_awprot             ),//o
    .m_axi_pcie_awvalid                 (m_axi_pcie0_reg_awvalid            ),//o
    .m_axi_pcie_awready                 (m_axi_pcie0_reg_awready            ),//i
    .m_axi_pcie_awlock                  (m_axi_pcie0_reg_awlock             ),//o
    .m_axi_pcie_awcache                 (m_axi_pcie0_reg_awcache            ),//o
    .m_axi_pcie_wdata                   (m_axi_pcie0_reg_wdata              ),//o
    .m_axi_pcie_wdata_par               (m_axi_pcie0_reg_wdata_par          ),//o
    .m_axi_pcie_wstrb                   (m_axi_pcie0_reg_wstrb              ),//o
    .m_axi_pcie_wlast                   (m_axi_pcie0_reg_wlast              ),//o
    .m_axi_pcie_wvalid                  (m_axi_pcie0_reg_wvalid             ),//o
    .m_axi_pcie_wready                  (m_axi_pcie0_reg_wready             ),//i
    .m_axi_pcie_bresp                   (m_axi_pcie0_reg_bresp              ),//i
    .m_axi_pcie_bid                     (m_axi_pcie0_reg_bid                ),//i
    .m_axi_pcie_bvalid                  (m_axi_pcie0_reg_bvalid             ),//i
    .m_axi_pcie_bready                  (m_axi_pcie0_reg_bready             ),//o
    .m_axi_pcie_arid                    (m_axi_pcie0_reg_arid               ),//o
    .m_axi_pcie_araddr                  (m_axi_pcie0_reg_araddr             ),//o
    .m_axi_pcie_arlen                   (m_axi_pcie0_reg_arlen              ),//o
    .m_axi_pcie_arsize                  (m_axi_pcie0_reg_arsize             ),//o
    .m_axi_pcie_arburst                 (m_axi_pcie0_reg_arburst            ),//o
    .m_axi_pcie_arprot                  (m_axi_pcie0_reg_arprot             ),//o
    .m_axi_pcie_arvalid                 (m_axi_pcie0_reg_arvalid            ),//o
    .m_axi_pcie_arready                 (m_axi_pcie0_reg_arready            ),//i
    .m_axi_pcie_arlock                  (m_axi_pcie0_reg_arlock             ),//o
    .m_axi_pcie_arcache                 (m_axi_pcie0_reg_arcache            ),//o
    .m_axi_pcie_rid                     (m_axi_pcie0_reg_rid                ),//i
    .m_axi_pcie_rdata                   (m_axi_pcie0_reg_rdata              ),//i
    .m_axi_pcie_rdata_par               (m_axi_pcie0_reg_rdata_par          ),//i
    .m_axi_pcie_rresp                   (m_axi_pcie0_reg_rresp              ),//i
    .m_axi_pcie_rlast                   (m_axi_pcie0_reg_rlast              ),//i
    .m_axi_pcie_rvalid                  (m_axi_pcie0_reg_rvalid             ),//i
    .m_axi_pcie_rready                  (m_axi_pcie0_reg_rready             ),//o
    //-----------------------------------------------------
    //Slave Axi For Pcie Core
    .s_axi_pcie_awid                    (s_axi_pcie0_reg_awid               ),//i
    .s_axi_pcie_awvalid                 (s_axi_pcie0_reg_awvalid            ),//i
    .s_axi_pcie_awaddr                  (s_axi_pcie0_reg_awaddr             ),//i
    .s_axi_pcie_awlen                   (s_axi_pcie0_reg_awlen              ),//i
    .s_axi_pcie_awsize                  (s_axi_pcie0_reg_awsize             ),//i
    .s_axi_pcie_awready                 (s_axi_pcie0_reg_awready            ),//o
    .s_axi_pcie_wvalid                  (s_axi_pcie0_reg_wvalid             ),//i
    .s_axi_pcie_wdata                   (s_axi_pcie0_reg_wdata              ),//i
    .s_axi_pcie_wstrb                   (s_axi_pcie0_reg_wstrb              ),//i
    .s_axi_pcie_wlast                   (s_axi_pcie0_reg_wlast              ),//i
    .s_axi_pcie_wready                  (s_axi_pcie0_reg_wready             ),//o
    .s_axi_pcie_bid                     (s_axi_pcie0_reg_bid                ),//o
    .s_axi_pcie_bresp                   (s_axi_pcie0_reg_bresp              ),//o
    .s_axi_pcie_bvalid                  (s_axi_pcie0_reg_bvalid             ),//o
    .s_axi_pcie_bready                  (s_axi_pcie0_reg_bready             ),//i
    .s_axi_pcie_arid                    (s_axi_pcie0_reg_arid               ),//i
    .s_axi_pcie_arvalid                 (s_axi_pcie0_reg_arvalid            ),//i
    .s_axi_pcie_araddr                  (s_axi_pcie0_reg_araddr             ),//i
    .s_axi_pcie_arlen                   (s_axi_pcie0_reg_arlen              ),//i
    .s_axi_pcie_arsize                  (s_axi_pcie0_reg_arsize             ),//i
    .s_axi_pcie_arready                 (s_axi_pcie0_reg_arready            ),//o
    .s_axi_pcie_rid                     (s_axi_pcie0_reg_rid                ),//o
    .s_axi_pcie_rvalid                  (s_axi_pcie0_reg_rvalid             ),//o
    .s_axi_pcie_rdata                   (s_axi_pcie0_reg_rdata              ),//o
    .s_axi_pcie_rlast                   (s_axi_pcie0_reg_rlast              ),//o
    .s_axi_pcie_rresp                   (s_axi_pcie0_reg_rresp              ),//o
    .s_axi_pcie_rready                  (s_axi_pcie0_reg_rready             ),//i
    //-----------------------------------------------------
    /*
    //Htc
    .htc_running                        (htc_running                        ),//o
    .htc_busy                           (htc_busy                           ),//o
    .htc_interrupt                      (htc_interrupt                      ),//o
    .htc_dsc_done                       (htc_dsc_done                       ),//o
    //Cth   
    .cth_running                        (cth_running                        ),//o
    .cth_busy                           (cth_busy                           ),//o
    .cth_interrupt                      (cth_interrupt                      ),//o
    .cth_dsc_done                       (cth_dsc_done                       ),//o
    //-----------------------------------------------------
    */
    .usr_irq                            (usr_irq                            ),//i
    .usr_irq_ack                        (usr_irq_ack                        ),//o
    .cfg_msi_enable                     (cfg_msi_enable                     ),//i
    .cfg_msix_enable                    (cfg_msix_enable                    ),//i
    .legacy_irq                         (legacy_irq                         ),//o
    .legacy_irq_ack                     (legacy_irq_ack                     ),//i
    .cfg_max_payload_size               (pcie0_max_payload_size             ),//i
    .cfg_max_read_req_size              (pcie0_max_read_req_size            ) //i
);

end endgenerate

// AXI STREAM interface local loopback for test
// assign m_axis_usr_tready    = s_axis_usr_tready;
// assign s_axis_usr_tvalid    = m_axis_usr_tvalid;
// assign s_axis_usr_tdata     = m_axis_usr_tdata;
// assign s_axis_usr_tdata_par = m_axis_usr_tdata_par;   
// assign s_axis_usr_tlast     = m_axis_usr_tlast;
// assign s_axis_usr_tkeep     = m_axis_usr_tkeep; 
//assign s_axis_usr_tuser     = m_axis_usr_tuser;

// AXI ST FIFO STORAGE
generate
    if (DMA_ST_EN == 1'b1) begin : AXI_ST_RAM
        localparam FIFO_WIDTH =  (AXI_DATA_WIDTH+1+(AXI_DATA_WIDTH/8))*CTH_CH_NUM;
        
        wire fifo_full, fifo_empty, fifo_wen, fifo_ren,fifo_rst;
        wire [FIFO_WIDTH-1:0] fifo_wdata, fifo_rdata;
        
        assign m_axis_usr_tready = ~fifo_full;
        assign s_axis_usr_tvalid = ~fifo_empty;
        assign fifo_wen = m_axis_usr_tready & m_axis_usr_tvalid;
        assign fifo_ren = s_axis_usr_tready & s_axis_usr_tvalid;
        
        assign fifo_wdata = {m_axis_usr_tdata,m_axis_usr_tlast,m_axis_usr_tkeep};
        assign              {s_axis_usr_tdata,s_axis_usr_tlast,s_axis_usr_tkeep} = fifo_rdata;

common_efx_fifo_wrapper#(
    .FAMILY             ("TITANIUM"  ),
    .SYNC_CLK           (0           ),
    .SYNC_STAGE         (2           ),
    .DATA_WIDTH         (FIFO_WIDTH  ),
    .MODE               ("FWFT"      ),
    .OUTPUT_REG         (0           ),
    .PROG_FULL_ASSERT   (            ),
    .PROGRAMMABLE_FULL  ("NONE"      ),
    .PROG_FULL_NEGATE   (            ),
    .PROGRAMMABLE_EMPTY ("NONE"      ),
    .PROG_EMPTY_ASSERT  (0           ),
    .PROG_EMPTY_NEGATE  (0           ),
    .OPTIONAL_FLAGS     (1           ),
    .PIPELINE_REG       (1           ),
    .DEPTH              (2048        ),
    .ASYM_WIDTH_RATIO   (4           ),
    .BYPASS_RESET_SYNC  (0           ) 
)
asyncfifo_inst1
(
    .full_o             (fifo_full   ),
    .empty_o            (fifo_empty  ),
    .rdata              (fifo_rdata  ),
    .wdata              (fifo_wdata  ),
    .clk_i              (axi_clk_250m),
    .wr_clk_i           (axi_clk_250m),
    .rd_clk_i           (axi_clk_250m),
    .wr_en_i            (fifo_wen    ),
    .rd_en_i            (fifo_ren    ),
    .a_rst_i            (user_reset  )

    //.a_wr_rst_i    ,
    //.a_rd_rst_i    ,
    //.almost_full_o ,
    //.prog_full_o   ,
    //.overflow_o    ,
    //.wr_ack_o      ,
    //.datacount_o   ,
    //.wr_datacount_o,
    //.almost_empty_o,
    //.prog_empty_o  ,
    //.underflow_o   ,
    //.rd_valid_o    ,
    //.rd_datacount_o,
    //.rst_busy
); 


    end
endgenerate 

/*-----------------------M_APB system_reg Inst Module -----------------------*/
system_reg #( 
    .ADDR_WTH                           (ADDR_WTH                           )
)
u_system_reg
(   
//--apb interface
    .s_apb3_clk                         (apb_clk_100m                       ),//i
    .s_apb3_rstn                        (clk_100m_rstn                      ),//i                           
    .s_apb3_paddr                       (m_apb_usr_paddr                    ),//i                       
    .s_apb3_psel                        (m_apb_usr_psel                     ),//i                               
    .s_apb3_penable                     (m_apb_usr_penable                  ),//i                       
    .s_apb3_pready                      (m_apb_usr_pready                   ),//o                       
    .s_apb3_pwrite                      (m_apb_usr_pwrite                   ),//i                       
    .s_apb3_pwdata                      (m_apb_usr_pwdata                   ),//i                                   
    .s_apb3_prdata                      (m_apb_usr_prdata                   ),//o                           
    .s_apb3_pslverror                   (m_apb_usr_pslverror                ),//o 
//--apb start
    .apb_start                          (                                   ),//o
//--irq interface
    .msi_enable                         (cfg_msi_enable                     ),//o
    .msix_enable                        (cfg_msix_enable                    ),//o
    .usr_irq_req                        (usr_irq                            ),//o
    .usr_irq_ack                        (usr_irq_ack                        ),//i
//--sts interface
    .cth_sts                            (                                   ),//i
    .htc_sts                            (                                   ) //i
);



/*-----------------------M_USER ddr Inst Module -----------------------*/
axi_adapter #(
    .AXI_AW                             (AXI_ADDR_WIDTH                      ),
    .S_AXI_DW                           (AXI_DATA_WIDTH                      ),
    .M_AXI_DW                           (DDR_AXI_DATA_WIDTH                  ),
    .ID_WTH                             (AXI_ID_WIDTH                        ),
    .FAMILY                             (FAMILY                              ),
    .ASYNC                              (DDR_ASYNC                           ),
    .ASYNC_FIFO_AW_DEPTH                (ASYNC_FIFO_AW_DEPTH                 ),
    .ASYNC_FIFO_W_DEPTH                 (ASYNC_FIFO_W_DEPTH                  ),
    .ASYNC_FIFO_B_DEPTH                 (ASYNC_FIFO_B_DEPTH                  ),
    .ASYNC_FIFO_AR_DEPTH                (ASYNC_FIFO_AR_DEPTH                 ),
    .ASYNC_FIFO_R_DEPTH                 (ASYNC_FIFO_R_DEPTH                  ),
    .ASYNC_FIFO_AW_RAM_STYLE            (ASYNC_FIFO_AW_RAM_STYLE             ),
    .ASYNC_FIFO_W_RAM_STYLE             (ASYNC_FIFO_W_RAM_STYLE              ),
    .ASYNC_FIFO_B_RAM_STYLE             (ASYNC_FIFO_B_RAM_STYLE              ),    
    .ASYNC_FIFO_AR_RAM_STYLE            (ASYNC_FIFO_AR_RAM_STYLE             ),    
    .ASYNC_FIFO_R_RAM_STYLE             (ASYNC_FIFO_R_RAM_STYLE              ),    
    .S_AXI_REG_EN                       (S_AXI_REG_EN                        ),        
    .M_AXI_REG_EN                       (M_AXI_REG_EN                        )        
)
u0_axi_adapter
(
//--slave global signals
    .s_axi_clk                          (axi_clk_250m                        ), 
    .s_axi_rstn                         (clk_250m_rstn                       ),
//slave axi4 bus interface
//--slave axi4 write
    .s_axi_awvalid                      (m_axi_usr_awvalid                  ),//i
    .s_axi_awready                      (m_axi_usr_awready                  ),//o
    .s_axi_awaddr                       (m_axi_usr_awaddr                   ),//i
    .s_axi_awlen                        (m_axi_usr_awlen                    ),//i
    .s_axi_awid                         (m_axi_usr_awid                     ),//i
    .s_axi_wvalid                       (m_axi_usr_wvalid                   ),//i
    .s_axi_wready                       (m_axi_usr_wready                   ),//o
    .s_axi_wdata                        (m_axi_usr_wdata                    ),//i
    .s_axi_wstrb                        (m_axi_usr_wstrb                    ),//i
    .s_axi_wlast                        (m_axi_usr_wlast                    ),//i
    .s_axi_bvalid                       (m_axi_usr_bvalid                   ),//o
    .s_axi_bready                       (m_axi_usr_bready                   ),//i
    .s_axi_bresp                        (m_axi_usr_bresp                    ),//o
    .s_axi_bid                          (m_axi_usr_bid                      ),//o
//--slave axi4 read                                
    .s_axi_arvalid                      (m_axi_usr_arvalid                  ),//i
    .s_axi_arready                      (m_axi_usr_arready                  ),//o
    .s_axi_araddr                       (m_axi_usr_araddr                   ),//i
    .s_axi_arlen                        (m_axi_usr_arlen                    ),//i
    .s_axi_arid                         (m_axi_usr_arid                     ),//i
    .s_axi_rvalid                       (m_axi_usr_rvalid                   ),//o
    .s_axi_rready                       (m_axi_usr_rready                   ),//i
    .s_axi_rdata                        (m_axi_usr_rdata                    ),//o
    .s_axi_rlast                        (m_axi_usr_rlast                    ),//o
    .s_axi_rresp                        (m_axi_usr_rresp                    ),//o
    .s_axi_rid                          (m_axi_usr_rid                      ),//o
//master axi4 bus interface 
//--master global signals
    .m_axi_clk                          (axi_clk_200m                       ),//i
    .m_axi_rstn                         (clk_200m_rstn                      ),//i
//--master axi4 write    
    .m_axi_awvalid                      (ddr1_axi_awvalid                   ),//o
    .m_axi_awready                      (ddr1_axi_awready                   ),//i
    .m_axi_awaddr                       (ddr1_axi_awaddr                    ),//o
    .m_axi_awlen                        (ddr1_axi_awlen                     ),//o
    .m_axi_awid                         (ddr1_axi_awid                      ),//o
    .m_axi_awsize                       (ddr1_axi_awsize                    ),//o
    .m_axi_awburst                      (ddr1_axi_awburst                   ),//o
    .m_axi_awlock                       (ddr1_axi_awlock                    ),//o
    .m_axi_awcache                      (ddr1_axi_awcache                   ),//o
    .m_axi_awprot                       (                                   ),//o
    .m_axi_wvalid                       (ddr1_axi_wvalid                    ),//o
    .m_axi_wready                       (ddr1_axi_wready                    ),//i
    .m_axi_wdata                        (ddr1_axi_wdata                     ),//o
    .m_axi_wstrb                        (ddr1_axi_wstrb                     ),//o
    .m_axi_wlast                        (ddr1_axi_wlast                     ),//o
    .m_axi_bvalid                       (ddr1_axi_bvalid                    ),//i
    .m_axi_bready                       (ddr1_axi_bready                    ),//o
    .m_axi_bresp                        (ddr1_axi_bresp                     ),//i
    .m_axi_bid                          (ddr1_axi_bid                       ),//i
//--master axi4 read 
    .m_axi_arvalid                      (ddr1_axi_arvalid                   ),//o
    .m_axi_arready                      (ddr1_axi_arready                   ),//i  
    .m_axi_araddr                       (ddr1_axi_araddr                    ),//o  
    .m_axi_arlen                        (ddr1_axi_arlen                     ),//o  
    .m_axi_arid                         (ddr1_axi_arid                      ),//o  
    .m_axi_arsize                       (ddr1_axi_arsize                    ),//o  
    .m_axi_arburst                      (ddr1_axi_arburst                   ),//o  
    .m_axi_arlock                       (ddr1_axi_arlock                    ),//o  
    .m_axi_arcache                      (                                   ),//o  
    .m_axi_arprot                       (                                   ),//o  
    .m_axi_rvalid                       (ddr1_axi_rvalid                    ),//i  
    .m_axi_rready                       (ddr1_axi_rready                    ),//o  
    .m_axi_rdata                        (ddr1_axi_rdata                     ),//i  
    .m_axi_rlast                        (ddr1_axi_rlast                     ),//i  
    .m_axi_rresp                        (ddr1_axi_rresp                     ),//i  
    .m_axi_rid                          (ddr1_axi_rid                       ) //i
);
assign  ddr1_axi_awqos = 0; 
assign  ddr1_axi_awallstrb = 0;
assign  ddr1_axi_awapcmd = 0;
assign  ddr1_axi_awcobuf = 0;
assign  ddr1_axi_arqos = 0;
assign  ddr1_axi_arapcmd = 0;


/*-----------------------BYPASS Inst Module -----------------------*/
axi_ram#(
    .DATA_WIDTH                         (AXI_DATA_WIDTH                     ),    
    .ADDR_WIDTH                         (15                                 ),    
    .STRB_WIDTH                         (AXI_DATA_WIDTH/8                   ), 
    .ID_WIDTH                           (8                                  ),    
    .PIPELINE_OUTPUT                    (PIPELINE_OUTPUT                    )        
)
u_axi_ram
(
    .clk                                (axi_clk_250m                       ),//i 
    .rst                                (!clk_250m_rstn                     ),//i 
    .s_axi_awid                         (m_axi_byp_awid                     ),//i 
    .s_axi_awaddr                       (m_axi_byp_awaddr                   ),//i 
    .s_axi_awlen                        (m_axi_byp_awlen                    ),//i 
    .s_axi_awsize                       (m_axi_byp_awsize                   ),//i 
    .s_axi_awburst                      (                                   ),//i 
    .s_axi_awlock                       (                                   ),//i 
    .s_axi_awcache                      (                                   ),//i 
    .s_axi_awprot                       (                                   ),//i 
    .s_axi_awvalid                      (m_axi_byp_awvalid                  ),//i 
    .s_axi_awready                      (m_axi_byp_awready                  ),//o
    .s_axi_wdata                        (m_axi_byp_wdata                    ),//i 
    .s_axi_wstrb                        (m_axi_byp_wstrb                    ),//i 
    .s_axi_wlast                        (m_axi_byp_wlast                    ),//i 
    .s_axi_wvalid                       (m_axi_byp_wvalid                   ),//i 
    .s_axi_wready                       (m_axi_byp_wready                   ),//o
    .s_axi_bid                          (m_axi_byp_bid                      ),//o 
    .s_axi_bresp                        (m_axi_byp_bresp                    ),//o 
    .s_axi_bvalid                       (m_axi_byp_bvalid                   ),//o 
    .s_axi_bready                       (m_axi_byp_bready                   ),//i 
    .s_axi_arid                         (m_axi_byp_arid                     ),//i 
    .s_axi_araddr                       (m_axi_byp_araddr                   ),//i 
    .s_axi_arlen                        (m_axi_byp_arlen                    ),//i 
    .s_axi_arsize                       (m_axi_byp_arsize                   ),//i 
    .s_axi_arburst                      (                                   ),//i 
    .s_axi_arlock                       (                                   ),//i 
    .s_axi_arcache                      (                                   ),//i 
    .s_axi_arprot                       (                                   ),//i 
    .s_axi_arvalid                      (m_axi_byp_arvalid                  ),//i 
    .s_axi_arready                      (m_axi_byp_arready                  ),//o
    .s_axi_rid                          (m_axi_byp_rid                      ),//o
    .s_axi_rdata                        (m_axi_byp_rdata                    ),//o
    .s_axi_rresp                        (m_axi_byp_rresp                    ),//o
    .s_axi_rlast                        (m_axi_byp_rlast                    ),//o
    .s_axi_rvalid                       (m_axi_byp_rvalid                   ),//o
    .s_axi_rready                       (m_axi_byp_rready                   ) //i
);

//-----------------------------------------------------------------------------------
//debug
//-----------------------------------------------------------------------------------
`ifdef DEBUG
edb_top edb_top_inst (
    .bscan_CAPTURE                      (jtag_inst1_CAPTURE                 ),
    .bscan_DRCK                         (jtag_inst1_DRCK                    ),
    .bscan_RESET                        (jtag_inst1_RESET                   ),
    .bscan_RUNTEST                      (jtag_inst1_RUNTEST                 ),
    .bscan_SEL                          (jtag_inst1_SEL                     ),
    .bscan_SHIFT                        (jtag_inst1_SHIFT                   ),
    .bscan_TCK                          (jtag_inst1_TCK                     ),
    .bscan_TDI                          (jtag_inst1_TDI                     ),
    .bscan_TMS                          (jtag_inst1_TMS                     ),
    .bscan_UPDATE                       (jtag_inst1_UPDATE                  ),
    .bscan_TDO                          (jtag_inst1_TDO                     ),

    .vio0_clk                           (apb_clk_100m                       ),
    .vio0_q0_ltssm_state                (pcie0_ltssm_state                  ),
    .vio0_q0_link_status                (pcie0_link_status                  ),
    .vio0_q0_pipe_p00_rate              (pcie0_pipe_p00_rate                ),
    .vio0_q0_cmn_ready                  (pcie0_pma_cmn_ready                ),
    .vio0_q0_flr_in_progress            (pcie0_flr_in_progress              ),
    .vio0_in_user                       (in_user                            ),

    .la0_clk                            (axi_clk_250m                       ), 
    .la0_m_pcie_axi_awid                (m_axi_pcie0_awid                   ),
    .la0_m_pcie_axi_awaddr              (m_axi_pcie0_awaddr                 ),
    .la0_m_pcie_axi_awvalid             (m_axi_pcie0_awvalid                ),
    .la0_m_pcie_axi_awready             (m_axi_pcie0_awready                ),
    .la0_m_pcie_axi_wdata               (m_axi_pcie0_wdata                  ),
    .la0_m_pcie_axi_wlast               (m_axi_pcie0_wlast                  ),
    .la0_m_pcie_axi_wvalid              (m_axi_pcie0_wvalid                 ),
    .la0_m_pcie_axi_wready              (m_axi_pcie0_wready                 ),
    .la0_m_pcie_axi_bresp               (m_axi_pcie0_bresp                  ),
    .la0_m_pcie_axi_bvalid              (m_axi_pcie0_bvalid                 ),
    .la0_m_pcie_axi_bready              (m_axi_pcie0_bready                 ),
    .la0_m_pcie_axi_arid                (m_axi_pcie0_arid                   ),
    .la0_m_pcie_axi_araddr              (m_axi_pcie0_araddr                 ),
    .la0_m_pcie_axi_arvalid             (m_axi_pcie0_arvalid                ),
    .la0_m_pcie_axi_arready             (m_axi_pcie0_arready                ),
    .la0_m_pcie_axi_rdata               (m_axi_pcie0_rdata                  ),
    .la0_m_pcie_axi_rresp               (m_axi_pcie0_rresp                  ),
    .la0_m_pcie_axi_rlast               (m_axi_pcie0_rlast                  ),
    .la0_m_pcie_axi_rid                 (m_axi_pcie0_rid                    ),
    .la0_m_pcie_axi_rvalid              (m_axi_pcie0_rvalid                 ),
    .la0_m_pcie_axi_rready              (m_axi_pcie0_rready                 ),

    .la0_s_pcie_axi_awid                (s_axi_pcie0_awid                   ),
    .la0_s_pcie_axi_awaddr              (s_axi_pcie0_awaddr                 ),
    .la0_s_pcie_axi_awvalid             (s_axi_pcie0_awvalid                ),
    .la0_s_pcie_axi_awready             (s_axi_pcie0_awready                ),
    .la0_s_pcie_axi_wdata               (s_axi_pcie0_wdata                  ),
    .la0_s_pcie_axi_wlast               (s_axi_pcie0_wlast                  ),
    .la0_s_pcie_axi_wvalid              (s_axi_pcie0_wvalid                 ),
    .la0_s_pcie_axi_wready              (s_axi_pcie0_wready                 ),
    .la0_s_pcie_axi_bresp               (s_axi_pcie0_bresp                  ),
    .la0_s_pcie_axi_bvalid              (s_axi_pcie0_bvalid                 ),
    .la0_s_pcie_axi_bready              (s_axi_pcie0_bready                 ),
    .la0_s_pcie_axi_arid                (s_axi_pcie0_arid                   ),
    .la0_s_pcie_axi_araddr              (s_axi_pcie0_araddr                 ),
    .la0_s_pcie_axi_arvalid             (s_axi_pcie0_arvalid                ),
    .la0_s_pcie_axi_arready             (s_axi_pcie0_arready                ),
    .la0_s_pcie_axi_rdata               (s_axi_pcie0_rdata                  ),
    .la0_s_pcie_axi_rresp               (s_axi_pcie0_rresp                  ),
    .la0_s_pcie_axi_rlast               (s_axi_pcie0_rlast                  ),
    .la0_s_pcie_axi_rvalid              (s_axi_pcie0_rvalid                 ),
    .la0_s_pcie_axi_rready              (s_axi_pcie0_rready                 ),

    .la1_clk                            (axi_clk_250m                       ), 
    .la1_dma_axi_awaddr                 (m_axi_usr_awaddr                   ),
    .la1_dma_axi_awid                   (m_axi_usr_awid                     ),
    .la1_dma_axi_awvalid                (m_axi_usr_awvalid                  ),
    .la1_dma_axi_awready                (m_axi_usr_awready                  ),
    .la1_dma_axi_wdata                  (m_axi_usr_wdata                    ),
    .la1_dma_axi_wlast                  (m_axi_usr_wlast                    ),
    .la1_dma_axi_wvalid                 (m_axi_usr_wvalid                   ),
    .la1_dma_axi_wready                 (m_axi_usr_wready                   ),
    .la1_dma_axi_bresp                  (m_axi_usr_bresp                    ),
    .la1_dma_axi_bvalid                 (m_axi_usr_bvalid                   ),
    .la1_dma_axi_bready                 (m_axi_usr_bready                   ),
    .la1_dma_axi_araddr                 (m_axi_usr_araddr                   ),
    .la1_dma_axi_arid                   (m_axi_usr_arid                     ),
    .la1_dma_axi_arvalid                (m_axi_usr_arvalid                  ),
    .la1_dma_axi_arready                (m_axi_usr_arready                  ),
    .la1_dma_axi_rdata                  (m_axi_usr_rdata                    ),
    .la1_dma_axi_rid                    (m_axi_usr_rid                      ),
    .la1_dma_axi_rlast                  (m_axi_usr_rlast                    ),
    .la1_dma_axi_rresp                  (m_axi_usr_rresp                    ),
    .la1_dma_axi_rvalid                 (m_axi_usr_rvalid                   ),
    .la1_dma_axi_rready                 (m_axi_usr_rready                   ),
    .la1_legacy_irq                     (legacy_irq                         ),
    .la1_legacy_irq_ack                 (legacy_irq_ack                     ),

    .la2_clk                            (axi_clk_200m                       ),
    .la2_ddr1_axi_awaddr                (ddr1_axi_awaddr                    ),
    .la2_ddr1_axi_awid                  (ddr1_axi_awid                      ),
    .la2_ddr1_axi_awvalid               (ddr1_axi_awvalid                   ),
    .la2_ddr1_axi_awready               (ddr1_axi_awready                   ),
    .la2_ddr1_axi_wdata                 (ddr1_axi_wdata                     ),
    .la2_ddr1_axi_wlast                 (ddr1_axi_wlast                     ),
    .la2_ddr1_axi_wvalid                (ddr1_axi_wvalid                    ),
    .la2_ddr1_axi_wready                (ddr1_axi_wready                    ),
    .la2_ddr1_axi_bresp                 (ddr1_axi_bresp                     ),
    .la2_ddr1_axi_bvalid                (ddr1_axi_bvalid                    ),
    .la2_ddr1_axi_bready                (ddr1_axi_bready                    ),
    .la2_ddr1_axi_araddr                (ddr1_axi_araddr                    ),
    .la2_ddr1_axi_arid                  (ddr1_axi_arid                      ),
    .la2_ddr1_axi_arvalid               (ddr1_axi_arvalid                   ),
    .la2_ddr1_axi_arready               (ddr1_axi_arready                   ),
    .la2_ddr1_axi_rdata                 (ddr1_axi_rdata                     ),
    .la2_ddr1_axi_rid                   (ddr1_axi_rid                       ),
    .la2_ddr1_axi_rlast                 (ddr1_axi_rlast                     ),
    .la2_ddr1_axi_rresp                 (ddr1_axi_rresp                     ),
    .la2_ddr1_axi_rvalid                (ddr1_axi_rvalid                    ),
    .la2_ddr1_axi_rready                (ddr1_axi_rready                    ),
    .la2_ddr1_axi_arstn                 (ddr1_axi_arstn                     ),
    .la2_ddr1_cfg_done                  (ddr1_cfg_done                      ),
    .la2_ddr1_cfg_reset                 (ddr1_cfg_reset                     ),
    .la2_ddr1_cfg_sel                   (ddr1_cfg_sel                       ),
    .la2_ddr1_cfg_start                 (ddr1_cfg_start                     ),
    
    
    .la3_clk                            (apb_clk_100m                       ),
    .la3_usr_apb_paddr                  (s_apb_usr_paddr                    ),
    .la3_usr_apb_psel                   (s_apb_usr_psel                     ),
    .la3_usr_apb_penable                (s_apb_usr_penable                  ),
    .la3_usr_apb_pready                 (s_apb_usr_pready                   ),
    .la3_usr_apb_pwrite                 (s_apb_usr_pwrite                   ),
    .la3_usr_apb_pwdata                 (s_apb_usr_pwdata                   ),
    .la3_usr_apb_prdata                 (s_apb_usr_prdata                   ),
    .la3_usr_apb_pslverror              (s_apb_usr_pslverror                ),
    .la3_pcie_apb_paddr                 (m_apb_q0_pcie_paddr                ),
    .la3_pcie_apb_psel                  (m_apb_q0_pcie_psel                 ),
    .la3_pcie_apb_penable               (m_apb_q0_pcie_penable              ),
    .la3_pcie_apb_pready                (m_apb_q0_pcie_pready               ),
    .la3_pcie_apb_pwrite                (m_apb_q0_pcie_pwrite               ),
    .la3_pcie_apb_pwdata                (m_apb_q0_pcie_pwdata               ),
    .la3_pcie_apb_prdata                (m_apb_q0_pcie_prdata               ),
    .la3_pcie_apb_pslverror             (m_apb_q0_pcie_pslverror            )    

);
`endif


endmodule