//***************************************************************/
//   ______   _   _   _                  _            _
//  |  ____| | | (_) | |                | |          | |
//  | |__    | |  _  | |_    ___   ___  | |_    ___  | | __
//  |  __|   | | | | | __|  / _ \ / __| | __|  / _ \ | |/ /
//  | |____  | | | | | |_  |  __/ \__ \ | |_  |  __/ |   <  
//  |______| |_| |_|  \__|  \___| |___/  \__|  \___| |_|\_\
//
// Moudel Name    : sfifo.v
// Version        : 1.0
// Author         : name
// Email          : name@elitestek.com
// Date Created   : 2025-02-25 11:18:27
// Last Modified  : 
// Abstract       : ---
//
//Copyright (c) 2020-2025 Elitestek,Inc. All Rights Reserved.
//
//***************************************************************/
//Modification History

//***************************************************************/
module sfifo #(
parameter 				DATA_WIDTH = 256,
parameter 				DEPTH = 512,
parameter 				AF_THRESHOLD = DEPTH - 2,  // almost full threshold
parameter 				AE_THRESHOLD = DEPTH >> 2  // almost empty threshold --> Divide by 4
)
(
input 							clk,
input 							rstn,
input 			[DATA_WIDTH - 1:0] 	
								data,
output 	wire 	[DATA_WIDTH - 1:0] 	
								q,
input 							wrreq,
input 							rdreq,
output 	reg 					almost_empty,
output 	reg 					almost_full,
output 	reg 					empty,
output 	reg 					full
);
//Localparam Define
localparam 				ADDR_WIDTH = (DEPTH <= 2 	? 1 : 
									 (DEPTH <= 4 	? 2 : 
									 (DEPTH <= 8 	? 3 : 
									 (DEPTH <= 16 	? 4 : 
									 (DEPTH <= 32 	? 5 : 
									 (DEPTH <= 64 	? 6 : 
									 (DEPTH <= 128 	? 7 : 
									 (DEPTH <= 256 	? 8 : 
									 (DEPTH <= 512 	? 9 : 
									 (DEPTH <= 1024 ? 10 : 
									 		-1))))))))));
//Register Define
reg 	[DATA_WIDTH - 1:0] 		ram	[DEPTH - 1:0];
reg 	[ADDR_WIDTH - 1:0] 		waddr;
reg 	[ADDR_WIDTH - 1:0] 		raddr;
reg     [ADDR_WIDTH:0]      	datacount;
//Encryption begin
/*--------------------------------------------------------------*\
                       The main code
\*--------------------------------------------------------------*/
always @(posedge clk)
begin
	if (rstn == 1'b0)
		waddr <= 'd0;
	else if (wrreq)
		waddr <= waddr + 'd1;	//wr addr increase
end

always @(posedge clk)
begin
	if (rstn == 1'b0)
		raddr <= 'd0;
	else if (rdreq)
		raddr <= raddr + 'd1;	//rd addr increase
end

always @(posedge clk)
begin
	if (wrreq)
		ram[waddr] <= data;
end
assign 	q = ram[raddr];
//data in fifo count
always @(posedge clk)
begin
	if (rstn == 1'b0)
		datacount <= 'd0;
	else if ((wrreq & rdreq) | (~wrreq & ~rdreq))  	// Hold when wr and rd both high or low
		datacount <= datacount;
	else if (wrreq)
		datacount <= datacount + 'd1;			   	// only wr
	else
		datacount <= datacount - 'd1;				// only rd
end
//empty
always @(posedge clk)
begin
	if (rstn == 1'b0)
		empty <= 1'b1;
	else if ((datacount == 0) || ((datacount == 1) && rdreq))
		empty <= 1'b1;
	else if (datacount > 0)
		empty <= 1'b0;
end
//almost empty
always @(posedge clk)
begin
	if (rstn == 1'b0)
		almost_empty <= 1'b1;
	else if (datacount > AE_THRESHOLD) 
		almost_empty <= 1'b0;
	else if (datacount <= AE_THRESHOLD)
		almost_empty <= 1'b1;
end
//full 	
always @(posedge clk)
begin
	if (rstn == 1'b0)
		full <= 1'b0;
	else if ((datacount == DEPTH) || ((datacount == (DEPTH - 1)) && wrreq))
		full <= 1'b1;
	else if (datacount < DEPTH)
		full <= 1'b0;
end
//almost full
always @(posedge clk)
begin
	if (rstn == 1'b0)
		almost_full <= 1'b0;
	else if (datacount > AF_THRESHOLD) 
		almost_full <= 1'b1;
	else if (datacount <= AF_THRESHOLD)
		almost_full <= 1'b0;
end
//Encryption end
endmodule