`timescale 1ns / 1ns

module wr_upsizer #(
    parameter                       AXI_AW   = 32,
    parameter                       S_AXI_DW = 32,
    parameter                       M_AXI_DW = 64,
    parameter                       ID_WTH   = 8 
)
(
//Slave AXI4 Bus Interface
//--Slave Global Signals
input                           clk,
input                           rstn,
//--Slave AXI4 Write
input                           s_axi_awvalid,
output  reg                     s_axi_awready,
input           [AXI_AW-1:0]    s_axi_awaddr,
input           [7:0]           s_axi_awlen,
input           [ID_WTH-1:0]    s_axi_awid,
input                           s_axi_wvalid,
output  reg                     s_axi_wready,
input           [S_AXI_DW-1:0]  s_axi_wdata,
input           [S_AXI_DW/8-1:0]s_axi_wstrb,
input                           s_axi_wlast,
output  wire                    s_axi_bvalid,
input                           s_axi_bready,
output  wire    [1:0]           s_axi_bresp,
output  wire    [ID_WTH-1:0]    s_axi_bid,

//Master AXI4 Bus Interface
//--Master AXI4 Bus Write 
output  reg                     m_axi_awvalid,
input                           m_axi_awready,
output  reg     [AXI_AW-1:0]    m_axi_awaddr,
output  reg     [7:0]           m_axi_awlen,
output  wire    [2:0]           m_axi_awsize,
output  reg     [ID_WTH-1:0]    m_axi_awid,
output  wire    [1:0]           m_axi_awburst,
output  wire    [1:0]           m_axi_awlock,
output  wire    [3:0]           m_axi_awcache,
output  wire    [2:0]           m_axi_awprot,
output  reg                     m_axi_wvalid,
input                           m_axi_wready,
output  wire    [M_AXI_DW-1:0]  m_axi_wdata,
output  wire    [M_AXI_DW/8-1:0]m_axi_wstrb,
output  reg                     m_axi_wlast,
input                           m_axi_bvalid,
output  wire                    m_axi_bready,
input           [1:0]           m_axi_bresp,
input           [ID_WTH-1:0]    m_axi_bid
);

//Parameter Define
localparam                      RATIO    = M_AXI_DW/S_AXI_DW;
localparam                      RATIO_W  = $clog2(RATIO);
localparam                      S_AXI_SW = S_AXI_DW/8;
localparam                      M_AXI_SW = M_AXI_DW/8;

//Register Define
reg                             s_w_busy_r;
reg     [S_AXI_DW-1:0]          in_data_r1;
reg     [S_AXI_SW-1:0]          in_strb_r1;
reg                             in_last_r1;
reg     [RATIO_W-1:0]           in_sr_addr_r1;
reg     [S_AXI_DW-1:0]          in_data_r0;
reg     [S_AXI_SW-1:0]          in_strb_r0;
reg                             in_last_r0;
reg     [RATIO_W-1:0]           in_sr_addr_r0;

reg     [1:0]                   in_cnt;
reg     [RATIO_W-1:0]           sr_addr;
reg     [M_AXI_DW-1:0]          sr_data;
reg     [M_AXI_SW-1:0]          sr_strb;

//Wire Define
wire                            s_w_busy;
wire    [8:0]                   s_axi_awlen_temp;
wire                            in_en;
wire                            sr_en;
wire                            sr_addr_set;
wire    [$clog2(M_AXI_SW)-$clog2(S_AXI_SW)-1:0]
                                sr_addr_value; 

`pragma protect begin_protected
`pragma protect version=1
`pragma protect encrypt_agent="ipecrypt"
`pragma protect encrypt_agent_info="http://ipencrypter.com Version: 20.0.8"
`pragma protect author="author-a"
`pragma protect author_info="author-a-details"
`pragma protect data_method="aes256-cbc"

`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIF-SIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
Cxflxz5GJg5A+Q/lZtwBVaLNrwlMTHmHHKIte1qBva0UOzUeZls7ZcCGlaNfMUd7
epXSrIKqBWf2+pnwkng6UE1iQnZNtio5Vy4TKpTJfjxXJ8pvlpcs2pgcxwaxGYx1
TRHCpNu26O8opFg44R8AldQ6C0CCV6zRGsrtjICSRaA=
`pragma protect key_keyowner="Aldec"
`pragma protect key_method="rsa"
`pragma protect key_keyname="ALDEC15_001"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
WTkAQ/1w4q6JbgqgWNKC4cGnwLZmNoXihU7aHcqOfeJaBSXXH7IshHQxrohgpq5s
cmVv/enHjQ91wPr/zpIufW4obSrcDjq4lalXhzg1j7bohdTbXCoFMbynS/9j1nP2
FAgl8yoZdtp+HrCb+y8OO1TmdACoOV0xAqWA9QtGQL54xMDNGPqBL53wrWaUdEKM
imROYubtGJ599gjKB/2YAhKhobG30RswZ4JH3zV2I9ISMp5ztI6H1QyiRBzXHEHP
cyyqlatBQEBQvcutaMBaKIIXFTwEuoto0A1NQRGosFgGDsQ0whIqTC4l/s5tfMwq
SQpSwj8M/+C8b9mWBeNeeQ==
`pragma protect key_keyowner="Synopsys"
`pragma protect key_method="rsa"
`pragma protect key_keyname="SNPS-VCS-RSA-2"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
MOWDpM0wcRM7Ubwy9C3RxeJja5pvZ4JqrNk7/Gedw0a8Hl3QsZTRkQpSvcmeD8qC
q8K2aM+C5AoCDOXKh/pZJpwO2FhtjzFg+ez6GOkv/xnKC+E0UpQ8uuguyW6OaxcL
a8KAt22vU3jXe1L4rRBHgyMwa8HN4+Z2ZOFaABn3PeM=
`pragma protect key_keyowner="Cadence Design Systems."
`pragma protect key_method="rsa"
`pragma protect key_keyname="CDS_RSA_KEY_VER_1"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
ZA+BQm638cNHbcAKNasQHemPyst9Th3m++mMu+4JquexUYvr0MHEudBDrS1rZKUn
sPjper+6pSRnZQcfwLN3b3WHm22X3dwAU5SIyU1QBjuWC4zv5LO4WW19jMMrgENr
m65xlUkmdlp8RM1W9QKKV8FR4aieRh66B24HsmbQ5vH8/xtZZOsqKvJEjMMb4d3v
/nXemlNqObAFzeF3eJaNA2i5cCM1RuXKOBK51OaHKDwuBp4gxfLjne+xdiq/IfNo
BQk8ENZIoO5LO2aUzWh8MGnugDTphsj3Jc0YSsLqa2owu10I+tXiI85AlGwaRbOC
Rnx452QAjJ4THxHnobHudw==
`pragma protect key_keyowner="Efinix Inc."
`pragma protect key_keyname="EFX_K01"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
h6+xhz1awgYvWdcvw9wf457fbFwFc5/RwD1f0I1LDiglGV87zMAouO6ir6x20f2C
Orb3Udhqg731YznPxnHO53fr9Rdva83C0HSc3kOL4Jd9kpNpODcoQZx3SkzwCpIj
sooswEvY/t0Vo3xXyifGNhUt7smxeOm/fXU+ohu344dD7T9h4Chuz4m51q5wBf8Y
RteVeCaONV8kXL9LycaHXT+XNZOrwGzDec/h9COESfOWaZzNCl1k9VEgRc8jUgIv
gQkPIsqsm7l5TXSkgijzhbfAvGawMFbCCVyYVd8BlhYnBsh6ei72Su7VlrTqeHeG
clQGqB9cFmnxF6lNQe+ITQ==
`pragma protect encoding=(enctype="base64", line_length=64, bytes=9104)
`pragma protect data_block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`pragma protect end_protected
endmodule
