`timescale 1ns / 1ns

module rd_downsizer #(
    parameter                       AXI_AW    = 32,
    parameter                       S_AXI_DW  = 32,
    parameter                       M_AXI_DW  = 32,
    parameter                       ID_WTH    = 8,
    parameter                       FAMILY    = "TITANIUM"
    
)
(

//Global Signals
input                           clk,
input                           rstn,
//Slave AXI4 Bus Interface
//--Slave AXI4 Read
input                           s_axi_arvalid,
output  reg                     s_axi_arready,
input           [AXI_AW-1:0]    s_axi_araddr,
input           [7:0]           s_axi_arlen,
input           [ID_WTH-1:0]    s_axi_arid,
output  reg                     s_axi_rvalid,
input                           s_axi_rready,
output  wire    [S_AXI_DW-1:0]  s_axi_rdata,
output  wire                    s_axi_rlast,
output  wire    [1:0]           s_axi_rresp,
output  wire    [ID_WTH-1:0]    s_axi_rid,

//Master AXI4 Bus Interface
//--Master AXI4 Bus Read 
output  reg                     m_axi_arvalid,
input                           m_axi_arready,
output  reg     [AXI_AW-1:0]    m_axi_araddr,
output  reg     [7:0]           m_axi_arlen,
output  reg     [ID_WTH-1:0]    m_axi_arid,
output  wire    [2:0]           m_axi_arsize,
output  wire    [1:0]           m_axi_arburst,
output  wire    [1:0]           m_axi_arlock,
output  wire    [3:0]           m_axi_arcache,
output  wire    [2:0]           m_axi_arprot,
input                           m_axi_rvalid,
output  reg                     m_axi_rready,
input           [M_AXI_DW-1:0]  m_axi_rdata,
input                           m_axi_rlast,
input           [1:0]           m_axi_rresp,
input           [ID_WTH-1:0]    m_axi_rid

);
//Parameter Define
localparam                      RATIO       = S_AXI_DW/M_AXI_DW;
localparam                      RATIO_W     = ($clog2(RATIO) == 0) ? 1 : $clog2(RATIO);
localparam                      S_AXI_SW    = S_AXI_DW/8;
localparam                      M_AXI_SW    = M_AXI_DW/8;
localparam                      S_BURST_WTH = RATIO_W + 8;

//Register Define
reg     [S_BURST_WTH:0]         s_burst_cnt;
reg     [S_BURST_WTH:0]         s_burst_cnt_r;
reg     [RATIO_W:0]             split_cmd_cnt;
reg     [RATIO_W:0]             split_cmd_cnt_r;
reg     [M_AXI_DW-1:0]          in_data_r1;
reg                             in_last_r1;
reg     [ID_WTH-1:0]            in_id_r1;
reg     [M_AXI_DW-1:0]          in_data_r0;
reg                             in_last_r0;
reg     [ID_WTH-1:0]            in_id_r0;
reg     [1:0]                   in_cnt;
reg     [S_AXI_DW-1:0]          sr_data;
reg     [ID_WTH-1:0]            sr_id;
reg                             temp_last;
reg     [RATIO_W:0]             in_last_cnt;
reg     [RATIO_W-1:0]           sr_addr;

//Wire Define
wire                            u0_wen;
wire    [RATIO_W:0]             u0_wdata;
wire                            u0_almfull;
wire                            u0_ren;
wire    [RATIO_W:0]             u0_rdata;
wire                            u0_empty;
wire                            in_en;
wire                            sr_en;


`pragma protect begin_protected
`pragma protect version=1
`pragma protect encrypt_agent="ipecrypt"
`pragma protect encrypt_agent_info="http://ipencrypter.com Version: 20.0.8"
`pragma protect author="author-a"
`pragma protect author_info="author-a-details"
`pragma protect data_method="aes256-cbc"

`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIF-SIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
I5XObakvbzeFsPx15oLCcqqkNUY3+fTPAlYnHB3otGclxOYvXfCErJRcRm0T2vxt
rwf4fNjVN7amTkMiOwwUcJ808afaJLNaP7Fo0fb8yXZuuJ4AD6hs53cKjSEKPMRo
oU/dwZ2YLw/gmZ85yDADBtn86vBPKTLr0Iz/XbbctLw=
`pragma protect key_keyowner="Aldec"
`pragma protect key_method="rsa"
`pragma protect key_keyname="ALDEC15_001"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
tu2tYSa7bAKAa3m35qOgtTsk2yliCu9cGdXbHyqZ526ZYdSxxrCDI+aW6MfGr6/6
ltk+rPgJWuKTIR4YJMb1DJhVhjq2naHjVyjsNBAa7GTCguM9O7/EXQ/9r1mtwdxW
N4Xj2rSph5TqCzYj7Pi9PGNid/sLdEg4c97kC+zmYguSKMrXVN92+yWhQxk6b8zL
fwhwBBDAfsLOW8rLcAdUE3Lxd9V2fCbqCF1vSIslqkoYX7CKCZgWQKeaBWAr70Rs
o7ETDmJoH2wU4/fnJCVLQ2vB8aicvcEtfIO0zxM4+tQA93MatW2YPaTUmUQA9JwK
FApBKZyeWjfEoEWsM51/wA==
`pragma protect key_keyowner="Synopsys"
`pragma protect key_method="rsa"
`pragma protect key_keyname="SNPS-VCS-RSA-2"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
uRarf0AitGo1arZg2swokHVrt2dImetGg4CvSFuuSyQNSr0BT8p7HOaPo84Ir1Ef
VfawwoX2sTXu8e8kyjvBo9tKLR8WCvEMmH4Qjc9t7/xDBAiL+owtOr1RmFu8CuNu
n2DP6MDIfXT3CGauUudr7M0HKAoPXuJ8r3KVFOjUdF8=
`pragma protect key_keyowner="Cadence Design Systems."
`pragma protect key_method="rsa"
`pragma protect key_keyname="CDS_RSA_KEY_VER_1"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
BYlGiIEitYaLGzR8CXoD6qGc2VMsdOoipsWfLPg7+c/T4vRHpw8KGDIb0JPSB4nL
aBtyEmMgDqEc0iMeSpiAnsUkeY9W4RUXfPNI8w7kf2PL0N8L7Di2xt2jZd2K00+h
QXA0r6zj0tkWQfsWaKhx+B7E+I0wdUc27Fixw2m9yXDx1zX5odnhLxFYBWyJPU9n
fBKu9BR748A40OYSgfCOndulLjaqpeL1iUtpnIB/xSzQbzfDor5NfSnad3Ibdav7
8JYSYNNPoRmZI+z7VEz0z09mCfVOZk1ITw0j4u0fvJpse9rinlyvrv/EB5AjL8eM
bxielqUacVySycpISl75Wg==
`pragma protect key_keyowner="Efinix Inc."
`pragma protect key_keyname="EFX_K01"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
AJC2+KM+MbhRwfHhaIFn2I4XesM2nR6V8dZF7SXweCMM4hbKjvzGlVwQtRe5V/pR
JgLLpE3ghfZTPmnsIg6WFIY1YWG+Jmz9bJiOOQmyy0ztgJ2fxCo8wz7pdgAm0xiT
5yOXLC3RYce+FQAUm6uoT8ez/xnxCj5HhhG7rHkRZRzhLy/rwSINesiq1rI6gfTc
iBrgByMEplocT2gDFs1M9XlyEnlU1bN1wmbHSJ3jNV2oJ5w+JsRQgZLy3YunGasJ
bcIRkMG1XCB53CnhhjGbS+kwhhVWu27WrHXmeghVUJYjg8mTbpwdcEpDYfGHDjyZ
hXKDtp6hulWY1svn4le8ag==
`pragma protect encoding=(enctype="base64", line_length=64, bytes=12384)
`pragma protect data_block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`pragma protect end_protected
endmodule
