/*

Copyright (c) 2018 Alex Forencich

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

// Language: Verilog 2001

`resetall
`timescale 1ns / 1ps
`default_nettype none

/*
 * AXI4 register
 */
module axi_register #
(
    // Width of data bus in bits
    parameter DATA_WIDTH = 32,
    // Width of address bus in bits
    parameter ADDR_WIDTH = 32,
    // Width of wstrb (width of data bus in words)
    parameter STRB_WIDTH = (DATA_WIDTH/8),
    // Width of ID signal
    parameter ID_WIDTH = 8,
    // Propagate awuser signal
    parameter AWUSER_ENABLE = 0,
    // Width of awuser signal
    parameter AWUSER_WIDTH = 1,
    // Propagate wuser signal
    parameter WUSER_ENABLE = 0,
    // Width of wuser signal
    parameter WUSER_WIDTH = 1,
    // Propagate buser signal
    parameter BUSER_ENABLE = 0,
    // Width of buser signal
    parameter BUSER_WIDTH = 1,
    // Propagate aruser signal
    parameter ARUSER_ENABLE = 0,
    // Width of aruser signal
    parameter ARUSER_WIDTH = 1,
    // Propagate ruser signal
    parameter RUSER_ENABLE = 0,
    // Width of ruser signal
    parameter RUSER_WIDTH = 1,
    // AW channel register type
    // 0 to bypass, 1 for simple buffer, 2 for skid buffer
    parameter AW_REG_TYPE = 1,
    // W channel register type
    // 0 to bypass, 1 for simple buffer, 2 for skid buffer
    parameter W_REG_TYPE = 2,
    // B channel register type
    // 0 to bypass, 1 for simple buffer, 2 for skid buffer
    parameter B_REG_TYPE = 1,
    // AR channel register type
    // 0 to bypass, 1 for simple buffer, 2 for skid buffer
    parameter AR_REG_TYPE = 1,
    // R channel register type
    // 0 to bypass, 1 for simple buffer, 2 for skid buffer
    parameter R_REG_TYPE = 2
)
(
    input  wire                     clk,
    input  wire                     rst,

    /*
     * AXI slave interface
     */
    input  wire [ID_WIDTH-1:0]      s_axi_awid,
    input  wire [ADDR_WIDTH-1:0]    s_axi_awaddr,
    input  wire [7:0]               s_axi_awlen,
    input  wire [2:0]               s_axi_awsize,
    input  wire [1:0]               s_axi_awburst,
    input  wire                     s_axi_awlock,
    input  wire [3:0]               s_axi_awcache,
    input  wire [2:0]               s_axi_awprot,
    input  wire [3:0]               s_axi_awqos,
    input  wire [3:0]               s_axi_awregion,
    input  wire [AWUSER_WIDTH-1:0]  s_axi_awuser,
    input  wire                     s_axi_awvalid,
    output wire                     s_axi_awready,
    input  wire [DATA_WIDTH-1:0]    s_axi_wdata,
    input  wire [STRB_WIDTH-1:0]    s_axi_wstrb,
    input  wire                     s_axi_wlast,
    input  wire [WUSER_WIDTH-1:0]   s_axi_wuser,
    input  wire                     s_axi_wvalid,
    output wire                     s_axi_wready,
    output wire [ID_WIDTH-1:0]      s_axi_bid,
    output wire [1:0]               s_axi_bresp,
    output wire [BUSER_WIDTH-1:0]   s_axi_buser,
    output wire                     s_axi_bvalid,
    input  wire                     s_axi_bready,
    input  wire [ID_WIDTH-1:0]      s_axi_arid,
    input  wire [ADDR_WIDTH-1:0]    s_axi_araddr,
    input  wire [7:0]               s_axi_arlen,
    input  wire [2:0]               s_axi_arsize,
    input  wire [1:0]               s_axi_arburst,
    input  wire                     s_axi_arlock,
    input  wire [3:0]               s_axi_arcache,
    input  wire [2:0]               s_axi_arprot,
    input  wire [3:0]               s_axi_arqos,
    input  wire [3:0]               s_axi_arregion,
    input  wire [ARUSER_WIDTH-1:0]  s_axi_aruser,
    input  wire                     s_axi_arvalid,
    output wire                     s_axi_arready,
    output wire [ID_WIDTH-1:0]      s_axi_rid,
    output wire [DATA_WIDTH-1:0]    s_axi_rdata,
    output wire [1:0]               s_axi_rresp,
    output wire                     s_axi_rlast,
    output wire [RUSER_WIDTH-1:0]   s_axi_ruser,
    output wire                     s_axi_rvalid,
    input  wire                     s_axi_rready,

    /*
     * AXI master interface
     */
    output wire [ID_WIDTH-1:0]      m_axi_awid,
    output wire [ADDR_WIDTH-1:0]    m_axi_awaddr,
    output wire [7:0]               m_axi_awlen,
    output wire [2:0]               m_axi_awsize,
    output wire [1:0]               m_axi_awburst,
    output wire                     m_axi_awlock,
    output wire [3:0]               m_axi_awcache,
    output wire [2:0]               m_axi_awprot,
    output wire [3:0]               m_axi_awqos,
    output wire [3:0]               m_axi_awregion,
    output wire [AWUSER_WIDTH-1:0]  m_axi_awuser,
    output wire                     m_axi_awvalid,
    input  wire                     m_axi_awready,
    output wire [DATA_WIDTH-1:0]    m_axi_wdata,
    output wire [STRB_WIDTH-1:0]    m_axi_wstrb,
    output wire                     m_axi_wlast,
    output wire [WUSER_WIDTH-1:0]   m_axi_wuser,
    output wire                     m_axi_wvalid,
    input  wire                     m_axi_wready,
    input  wire [ID_WIDTH-1:0]      m_axi_bid,
    input  wire [1:0]               m_axi_bresp,
    input  wire [BUSER_WIDTH-1:0]   m_axi_buser,
    input  wire                     m_axi_bvalid,
    output wire                     m_axi_bready,
    output wire [ID_WIDTH-1:0]      m_axi_arid,
    output wire [ADDR_WIDTH-1:0]    m_axi_araddr,
    output wire [7:0]               m_axi_arlen,
    output wire [2:0]               m_axi_arsize,
    output wire [1:0]               m_axi_arburst,
    output wire                     m_axi_arlock,
    output wire [3:0]               m_axi_arcache,
    output wire [2:0]               m_axi_arprot,
    output wire [3:0]               m_axi_arqos,
    output wire [3:0]               m_axi_arregion,
    output wire [ARUSER_WIDTH-1:0]  m_axi_aruser,
    output wire                     m_axi_arvalid,
    input  wire                     m_axi_arready,
    input  wire [ID_WIDTH-1:0]      m_axi_rid,
    input  wire [DATA_WIDTH-1:0]    m_axi_rdata,
    input  wire [1:0]               m_axi_rresp,
    input  wire                     m_axi_rlast,
    input  wire [RUSER_WIDTH-1:0]   m_axi_ruser,
    input  wire                     m_axi_rvalid,
    output wire                     m_axi_rready
);


`pragma protect begin_protected
`pragma protect version=1
`pragma protect encrypt_agent="ipecrypt"
`pragma protect encrypt_agent_info="http://ipencrypter.com Version: 20.0.8"
`pragma protect author="author-a"
`pragma protect author_info="author-a-details"
`pragma protect data_method="aes256-cbc"

`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIF-SIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
IAaWDIa5ZN19p3uku/0bvl8I6g1eMn1OTJWq/wAwYjt2o/iyx1hJ11gfOBv7t5IZ
7iHdbAoxyJCkaNm+t/49In9/zJUWvX4CKxafZyrLRuuW3WLdmZRwxNVtxPP3u1pc
i7eybbzIpM1heNwB1c4zow04//8VrCZhNmnluk+8XTQ=
`pragma protect key_keyowner="Aldec"
`pragma protect key_method="rsa"
`pragma protect key_keyname="ALDEC15_001"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
cyGLnZrqLxzCYnUfug8MaiTEMCnNet5TErjifl7tYOvVg6L417eKQWd3grad3Ryq
9QDSB46yXxM247stQcJ5eTdHqAqc0MlNV30adug9NLp2WgtTBJCXHCcrvt0TcAfL
VL4CgNIFf69ueSsAbP+ac8V+U/fHRwMDF+eBzZvCXKUckPjDO876e8Z6n6cySK0D
5Y5Ba97kuCcYDzgnh/5vUZ6rISje/hG6D8eJv3TZQr4Hewt2bx13t8GKf8HKLEd7
8Qq0l2CNZlccTLS/Wir1Lefc3LfIk2riK/9A9EFFdF/YRDF4ummx7oAko7EWz7Eu
+M2UH8+V5zkGBIFQ/StZ8Q==
`pragma protect key_keyowner="Synopsys"
`pragma protect key_method="rsa"
`pragma protect key_keyname="SNPS-VCS-RSA-2"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_block
h/ox8bU58SausaqxAiM87evn7Eo73Aajo+8mPqECoIHnww3mdgLMhfomOD90Shmo
bYo+wRHr6FtcbKlyxt/7sWaVfLN6zhG9vaaxnBhjPDWakSHIDknhyyv7POWuPjHE
91hh9MTlahnK0kMV/xUW8tuiybyvYg9DBLnd5HFwS3g=
`pragma protect key_keyowner="Cadence Design Systems."
`pragma protect key_method="rsa"
`pragma protect key_keyname="CDS_RSA_KEY_VER_1"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
i5zMcvRdV7P1npvlcXd0vzjt4m22swVcg89mcEkdM+WRXF02igzgcDcfU1RHyqZi
oxqUbT4wkyTKXBICZl/cDlrHY/Rf30yq4bawqiIRv5a3cwD8wzhNchttbVSFDxPe
WRkp5MAfEjPF1KEASFWEe9Ityzxyfb0r1XZcMNMRz42ycjpEBHAFF9BEL01nzANo
KfoPyxeeIc0SorqnV4jaBLS85vqQiRkWOWinncNlwGjHc8VKsngWhb9MsbXwNbs5
VYr2vXQbfchFvloPvLOXcIrFVaYbovpirCOcuKJQsK5dV9qDizso9/Y2an9qUYra
4ot8HWrefwynyanWkWXbPw==
`pragma protect key_keyowner="Efinix Inc."
`pragma protect key_keyname="EFX_K01"
`pragma protect key_method="rsa"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_block
P64FG8M0IpZbVTd3o4LcKlGttVlILD76N+5x+tuCagEVBpMO1n9KWEVGArCDNm6K
eRssj7f0gWBeChU/35IAIDdLDHtBwNNHYgFqemSbb8se5XKdMUHlYrQRArDgLgtq
fd6rk0rtNcAwUbfZ2Zxr8L02rsmruVK22OaZ3llc6XfKrLkp7fjYqm2krDWpWz8G
Gm57FgK2NvzkaI1W6aZzVwNazl0elKoS1iKlD7FjfUAj/eHVvvAf9sJGH3osCn/y
6BXRlOaKVjBNJ4rXQzTaaZzA3WynBkM/lUGiUlq2nqRROOhaDCcrwMlswqKHcRG2
PnlZHQHoGhXMXeg86NGrFg==
`pragma protect encoding=(enctype="base64", line_length=64, bytes=3904)
`pragma protect data_block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`pragma protect end_protected
endmodule

`resetall
