# Titanium Ti375N1156 DMA Example Design

This repository contains an example design for testing DMA functionality using the Titanium Ti375N1156 Development Kit. It includes Linux drivers and a user application to perform DMA read/write verification.

---

## Requirements

- Linux test computer  
  _(Tested on Linux Kernel version `6.8.0.59-generic`, Ubuntu 22.04.1)_
- Efinity® software version `2024.2.294.1` or higher
- Titanium Ti375N1156 Development Kit
- USB-C Data Cable

---

## What's in the Package

```
.
│ README.md
├───apps
│ │ dma_test.cpp
│ │ Makefile
│ └───bin
│ │ dma_test.bin
├───driver
│ cdev_ioctl.h
│ common.h
│ device.c
│ dma.c
│ dma.h
│ dma_regs.h
│ file_io.c
│ file_io.h
│ interrupt.c
│ Makefile
│ misc.c
│ misc.h
│ poll.c
│ poll.h
├───efinity_project
│ <efinity_project files>
```

---

## Hardware Setup

1. Power on the **Ti375N1156 Development Kit (Ti375 DK)** and connect it to the test computer via **USB-C cable**.
2. Open **Efinity Programmer**.
3. Set the programming mode to **`SPI Active using JTAG Bridge (new)`**
4. Program the FPGA:
   - For **AXI MM mode**, use `<MM_MODE BITSTREAM NAME>.hex` from `/efinity_project/bitstream/`.
   - For **AXI ST mode**, use `<ST_MODE BITSTREAM NAME>.hex` from `/efinity_project/bitstream/`.
5. Connect the Ti375 DK to the test device (motherboard) as described in the **Ti375N1156 User Guide**.
6. Verify PCIe device detection:

```bash
sudo lspci -vv -d 1f7a:0100
```

## Installing the Linux Driver
1. Navigate to the driver/ directory and build the Linux DMA driver:
```bash
make
```

2. Load the driver in MSI-X interrupt mode:
```bash
sudo insmod pcie_dma.ko intr=3
```
3. Verify successful installation using this command:

```bash
sudo dmesg
```
Expected Output Snippet:


```css
[ 6183.221787] [PROBE] EDMA driver create cdev interfaces!
...
[ 6183.222221] [PROBE] Pcie dma driver probe Efinix device Done!
```

## Running the User Driver Application

A test application is included to perform read-write at random address with random sized payload.

1. Run the DMA test binary with root privileges:
```bash
sudo ./apps/bin/dma_test.bin
```
Expected Output Example:

```
/dev/pcie_dma0_htc_0: 3
/dev/pcie_dma0_cth_0: 4

******************************************
TEST : Random size write at random address
******************************************
Transfer & Readback  314 B at 0x3e23f363 ... completed in 173 us
Transfer & Readback   65 B at 0x32b1fb36 ... completed in 489 us
...
```

## Reference

- Efinix® PCIe Scatter-Gather Direct Memory Access (SGDMA) IP User Guide

## Contact

For support, please contact Efinix sales/marketing team through our website at https://www.efinixinc.com/
