----------------------------------------------------------------------------------------------------
-- Copyright (c) ReFLEX CES 1998-2012
--
-- Use of this source code through a simulator and/or a compiler tool
-- is illegal if not authorised through ReFLEX CES License agreement.
----------------------------------------------------------------------------------------------------
-- Project     : 
----------------------------------------------------------------------------------------------------
-- Top level   : top.vhd
-- File        : nfc_chk.vhd
-- Author      : flavenant@reflexces.com
-- Company     : ReFLEX CES
--               2, rue du gevaudan
--               91047 LISSES
--               FRANCE
--               http://www.reflexces.com
-- Plateforme  : Windows XP
-- Simulator   : Mentor Graphics ModelSim
-- Synthesis   : Quartus II
-- Target      : Stratix IV
-- Dependency  :
----------------------------------------------------------------------------------------------------
-- Description :
-- NFC checker.
--  
----------------------------------------------------------------------------------------------------
-- Version      Date            Author              Description
-- 0.1          2012/01/19      FLA                 Creation
----------------------------------------------------------------------------------------------------
library ieee;
use     ieee.std_logic_1164.all;
use     ieee.numeric_std.all;
use     ieee.std_logic_unsigned.all;

entity nfc_chk is
    generic (
          COUNTER_WIDTH         : integer := 32         -- Number of bits for the frame counter
    );
    port (
        -- Reset and clocks
          rst_n                 : in    std_logic
        ; clk                   : in    std_logic
        
        -- NFC
        ; nfc_vld               : in    std_logic
        ; nfc_d                 : in    std_logic_vector(3 downto 0)
        
        -- Control / Status
        ; wait_cnt              : out   std_logic_vector(COUNTER_WIDTH-1 downto 0)      -- add nfc_d+1 on every nfc received
        ; reset_cnt             : in    std_logic
    );
end entity nfc_chk;

architecture rtl of nfc_chk is
	----------------------------------------------------------------
	-- Type declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Function declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Component declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Constant declarations
	----------------------------------------------------------------

	----------------------------------------------------------------
	-- Signal declarations
	----------------------------------------------------------------
    signal s_wait_cnt       : std_logic_vector(COUNTER_WIDTH-1 downto 0);
    
begin

    --##############################################################
    -- Main process
    --##############################################################  
    p_main : process (clk, rst_n)
    begin
    if rst_n='0' then 
        s_wait_cnt  <= (others=>'0');
        
    elsif rising_edge(clk) then
        ----------------------------------------------------------------------------------------------------
        -- Frame counter
        ----------------------------------------------------------------------------------------------------
           if reset_cnt='1' then s_wait_cnt <= (others=>'0');
        elsif nfc_vld='1'   then s_wait_cnt <= s_wait_cnt + nfc_d + 1; end if;
    end if;
    end process p_main;
    
    --##############################################################
    -- Internal / Ports assignments
    --############################################################## 
    wait_cnt   <= s_wait_cnt;
    
end architecture rtl;
