-- Copyright 1986-2022 Xilinx, Inc. All Rights Reserved.
-- Copyright 2022-2023 Advanced Micro Devices, Inc. All Rights Reserved.
-- --------------------------------------------------------------------------------
-- Tool Version: Vivado v.2023.2 (lin64) Build 4029153 Fri Oct 13 20:13:54 MDT 2023
-- Date        : Mon May  5 12:16:36 2025
-- Host        : francois-corei7 running 64-bit Ubuntu 20.04.6 LTS
-- Command     : write_vhdl -force -mode funcsim
--               /home/fbatard/__SSTR/ALSE/Aurora/aurora_8b10b/src/boards/xilinx/Vivado_STLV7325/aurora_8b10b_x1_16b/aurora_8b10b_x1_16b_sim_netlist.vhdl
-- Design      : aurora_8b10b_x1_16b
-- Purpose     : This VHDL netlist is a functional simulation representation of the design and should not be modified or
--               synthesized. This netlist cannot be used for SDF annotated simulation.
-- Device      : xc7k325tffg676-2L
-- --------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_AXI_TO_LL is
  port (
    new_pkt_r_reg_0 : out STD_LOGIC;
    new_pkt_r : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_AXI_TO_LL;

architecture STRUCTURE of aurora_8b10b_x1_16b_AXI_TO_LL is
begin
new_pkt_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => new_pkt_r,
      Q => new_pkt_r_reg_0,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_CHANNEL_ERR_DETECT is
  port (
    HARD_ERR : out STD_LOGIC;
    reset_channel_i : out STD_LOGIC;
    SOFT_ERR : out STD_LOGIC;
    wait_for_lane_up_r0 : out STD_LOGIC;
    hard_err_i : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    LANE_UP : in STD_LOGIC;
    soft_err_flop_r0 : in STD_LOGIC;
    verify_r_reg : in STD_LOGIC;
    POWER_DOWN : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_CHANNEL_ERR_DETECT;

architecture STRUCTURE of aurora_8b10b_x1_16b_CHANNEL_ERR_DETECT is
  signal RESET_CHANNEL_Buffer_i_1_n_0 : STD_LOGIC;
  signal hard_err_r : STD_LOGIC;
  signal lane_up_r : STD_LOGIC;
  signal \^reset_channel_i\ : STD_LOGIC;
  signal soft_err_r_reg_srl3_n_0 : STD_LOGIC;
  attribute srl_name : string;
  attribute srl_name of soft_err_r_reg_srl3 : label is "U0/\global_logic_i/channel_err_detect_i/soft_err_r_reg_srl3 ";
begin
  reset_channel_i <= \^reset_channel_i\;
CHANNEL_HARD_ERR_Buffer_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '1'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => hard_err_r,
      Q => HARD_ERR,
      R => '0'
    );
CHANNEL_SOFT_ERR_Buffer_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '1'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => soft_err_r_reg_srl3_n_0,
      Q => SOFT_ERR,
      R => '0'
    );
RESET_CHANNEL_Buffer_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => POWER_DOWN,
      I1 => lane_up_r,
      O => RESET_CHANNEL_Buffer_i_1_n_0
    );
RESET_CHANNEL_Buffer_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '1'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => RESET_CHANNEL_Buffer_i_1_n_0,
      Q => \^reset_channel_i\,
      R => '0'
    );
hard_err_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => hard_err_i,
      Q => hard_err_r,
      R => '0'
    );
lane_up_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => LANE_UP,
      Q => lane_up_r,
      R => '0'
    );
soft_err_r_reg_srl3: unisim.vcomponents.SRL16E
    generic map(
      INIT => X"0000"
    )
        port map (
      A0 => '0',
      A1 => '1',
      A2 => '0',
      A3 => '0',
      CE => '1',
      CLK => user_clk,
      D => soft_err_flop_r0,
      Q => soft_err_r_reg_srl3_n_0
    );
verify_r_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \^reset_channel_i\,
      I1 => verify_r_reg,
      O => wait_for_lane_up_r0
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_CHANNEL_INIT_SM is
  port (
    SR : out STD_LOGIC_VECTOR ( 0 to 0 );
    gen_ver_i : out STD_LOGIC;
    CHANNEL_UP : out STD_LOGIC;
    gtrxreset_i : out STD_LOGIC;
    START_RX_Buffer_reg_inv_0 : out STD_LOGIC_VECTOR ( 0 to 0 );
    begin_r0 : out STD_LOGIC;
    p_0_in : out STD_LOGIC;
    D1_out : out STD_LOGIC;
    user_clk : in STD_LOGIC;
    got_v_i : in STD_LOGIC;
    wait_for_lane_up_r0 : in STD_LOGIC;
    txver_count_r0 : in STD_LOGIC;
    START_RX_Buffer_reg_inv_1 : in STD_LOGIC;
    hard_err_reset_i : in STD_LOGIC;
    reset_channel_i : in STD_LOGIC;
    did_ver_i : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_CHANNEL_INIT_SM;

architecture STRUCTURE of aurora_8b10b_x1_16b_CHANNEL_INIT_SM is
  signal \^channel_up\ : STD_LOGIC;
  signal D : STD_LOGIC;
  signal GTRXRESET_OUT_i_1_n_0 : STD_LOGIC;
  signal GTRXRESET_OUT_i_2_n_0 : STD_LOGIC;
  signal Q : STD_LOGIC;
  signal \^sr\ : STD_LOGIC_VECTOR ( 0 to 0 );
  signal all_lanes_v_r : STD_LOGIC;
  signal bad_v_r : STD_LOGIC;
  signal bad_v_r0 : STD_LOGIC;
  signal \free_count_r[13]_i_2_n_0\ : STD_LOGIC;
  signal \free_count_r[13]_i_3_n_0\ : STD_LOGIC;
  signal \free_count_r[13]_i_4_n_0\ : STD_LOGIC;
  signal \free_count_r[13]_i_5_n_0\ : STD_LOGIC;
  signal \free_count_r[1]_i_2_n_0\ : STD_LOGIC;
  signal \free_count_r[1]_i_3_n_0\ : STD_LOGIC;
  signal \free_count_r[5]_i_2_n_0\ : STD_LOGIC;
  signal \free_count_r[5]_i_3_n_0\ : STD_LOGIC;
  signal \free_count_r[5]_i_4_n_0\ : STD_LOGIC;
  signal \free_count_r[5]_i_5_n_0\ : STD_LOGIC;
  signal \free_count_r[9]_i_2_n_0\ : STD_LOGIC;
  signal \free_count_r[9]_i_3_n_0\ : STD_LOGIC;
  signal \free_count_r[9]_i_4_n_0\ : STD_LOGIC;
  signal \free_count_r[9]_i_5_n_0\ : STD_LOGIC;
  signal free_count_r_reg : STD_LOGIC_VECTOR ( 0 to 13 );
  signal \free_count_r_reg[13]_i_1_n_0\ : STD_LOGIC;
  signal \free_count_r_reg[13]_i_1_n_1\ : STD_LOGIC;
  signal \free_count_r_reg[13]_i_1_n_2\ : STD_LOGIC;
  signal \free_count_r_reg[13]_i_1_n_3\ : STD_LOGIC;
  signal \free_count_r_reg[13]_i_1_n_4\ : STD_LOGIC;
  signal \free_count_r_reg[13]_i_1_n_5\ : STD_LOGIC;
  signal \free_count_r_reg[13]_i_1_n_6\ : STD_LOGIC;
  signal \free_count_r_reg[13]_i_1_n_7\ : STD_LOGIC;
  signal \free_count_r_reg[1]_i_1_n_3\ : STD_LOGIC;
  signal \free_count_r_reg[1]_i_1_n_6\ : STD_LOGIC;
  signal \free_count_r_reg[1]_i_1_n_7\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_0\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_1\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_2\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_3\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_4\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_5\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_6\ : STD_LOGIC;
  signal \free_count_r_reg[5]_i_1_n_7\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_0\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_1\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_2\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_3\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_4\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_5\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_6\ : STD_LOGIC;
  signal \free_count_r_reg[9]_i_1_n_7\ : STD_LOGIC;
  signal \^gen_ver_i\ : STD_LOGIC;
  signal got_first_v_r : STD_LOGIC;
  signal got_first_v_r_i_1_n_0 : STD_LOGIC;
  signal gtrxreset_extend_r : STD_LOGIC_VECTOR ( 7 downto 0 );
  signal next_ready_c : STD_LOGIC;
  signal next_verify_c : STD_LOGIC;
  signal p_2_out : STD_LOGIC_VECTOR ( 31 to 31 );
  signal p_3_in : STD_LOGIC;
  signal ready_r : STD_LOGIC;
  signal ready_r2 : STD_LOGIC;
  signal rxver_count_r0 : STD_LOGIC;
  signal \rxver_count_r_reg[1]_srl2_n_0\ : STD_LOGIC;
  signal \rxver_count_r_reg_n_0_[2]\ : STD_LOGIC;
  signal \txver_count_r_reg[6]_srl7_n_0\ : STD_LOGIC;
  signal \txver_count_r_reg_n_0_[7]\ : STD_LOGIC;
  signal \v_count_r_reg[30]_srl31_n_0\ : STD_LOGIC;
  signal \v_count_r_reg_n_0_[31]\ : STD_LOGIC;
  signal verify_watchdog_r0 : STD_LOGIC;
  signal \verify_watchdog_r_reg[14]_srl15_i_2_n_0\ : STD_LOGIC;
  signal \verify_watchdog_r_reg[14]_srl15_i_3_n_0\ : STD_LOGIC;
  signal \verify_watchdog_r_reg[14]_srl15_n_0\ : STD_LOGIC;
  signal \verify_watchdog_r_reg_n_0_[15]\ : STD_LOGIC;
  signal wait_for_lane_up_r : STD_LOGIC;
  signal \NLW_free_count_r_reg[1]_i_1_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 1 );
  signal \NLW_free_count_r_reg[1]_i_1_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 2 );
  signal \NLW_v_count_r_reg[30]_srl31_Q31_UNCONNECTED\ : STD_LOGIC;
  attribute inverted : string;
  attribute inverted of START_RX_Buffer_reg_inv : label is "yes";
  attribute ADDER_THRESHOLD : integer;
  attribute ADDER_THRESHOLD of \free_count_r_reg[13]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \free_count_r_reg[1]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \free_count_r_reg[5]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \free_count_r_reg[9]_i_1\ : label is 11;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of gen_v_flop_0_i_i_1 : label is "soft_lutpair36";
  attribute SOFT_HLUTNM of got_first_v_r_i_1 : label is "soft_lutpair35";
  attribute BOX_TYPE : string;
  attribute BOX_TYPE of gtreset_flop_0_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM : string;
  attribute XILINX_LEGACY_PRIM of gtreset_flop_0_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP : string;
  attribute XILINX_TRANSFORM_PINMAP of gtreset_flop_0_i : label is "VCC:CE GND:R";
  attribute SOFT_HLUTNM of gtreset_flop_0_i_i_1 : label is "soft_lutpair36";
  attribute SOFT_HLUTNM of \ready_r_i_1__0\ : label is "soft_lutpair37";
  attribute BOX_TYPE of reset_lanes_flop_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of reset_lanes_flop_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of reset_lanes_flop_i : label is "VCC:CE GND:R";
  attribute srl_bus_name : string;
  attribute srl_bus_name of \rxver_count_r_reg[1]_srl2\ : label is "U0/\global_logic_i/channel_init_sm_i/rxver_count_r_reg ";
  attribute srl_name : string;
  attribute srl_name of \rxver_count_r_reg[1]_srl2\ : label is "U0/\global_logic_i/channel_init_sm_i/rxver_count_r_reg[1]_srl2 ";
  attribute srl_bus_name of \txver_count_r_reg[6]_srl7\ : label is "U0/\global_logic_i/channel_init_sm_i/txver_count_r_reg ";
  attribute srl_name of \txver_count_r_reg[6]_srl7\ : label is "U0/\global_logic_i/channel_init_sm_i/txver_count_r_reg[6]_srl7 ";
  attribute srl_bus_name of \v_count_r_reg[30]_srl31\ : label is "U0/\global_logic_i/channel_init_sm_i/v_count_r_reg ";
  attribute srl_name of \v_count_r_reg[30]_srl31\ : label is "U0/\global_logic_i/channel_init_sm_i/v_count_r_reg[30]_srl31 ";
  attribute SOFT_HLUTNM of \v_count_r_reg[30]_srl31_i_1\ : label is "soft_lutpair35";
  attribute SOFT_HLUTNM of verify_r_i_2 : label is "soft_lutpair37";
  attribute srl_bus_name of \verify_watchdog_r_reg[14]_srl15\ : label is "U0/\global_logic_i/channel_init_sm_i/verify_watchdog_r_reg ";
  attribute srl_name of \verify_watchdog_r_reg[14]_srl15\ : label is "U0/\global_logic_i/channel_init_sm_i/verify_watchdog_r_reg[14]_srl15 ";
begin
  CHANNEL_UP <= \^channel_up\;
  SR(0) <= \^sr\(0);
  gen_ver_i <= \^gen_ver_i\;
CHANNEL_UP_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ready_r2,
      Q => \^channel_up\,
      R => '0'
    );
GTRXRESET_OUT_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFFFFFE"
    )
        port map (
      I0 => gtrxreset_extend_r(2),
      I1 => gtrxreset_extend_r(3),
      I2 => gtrxreset_extend_r(0),
      I3 => gtrxreset_extend_r(1),
      I4 => GTRXRESET_OUT_i_2_n_0,
      O => GTRXRESET_OUT_i_1_n_0
    );
GTRXRESET_OUT_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFE"
    )
        port map (
      I0 => gtrxreset_extend_r(5),
      I1 => gtrxreset_extend_r(4),
      I2 => gtrxreset_extend_r(7),
      I3 => gtrxreset_extend_r(6),
      O => GTRXRESET_OUT_i_2_n_0
    );
GTRXRESET_OUT_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => GTRXRESET_OUT_i_1_n_0,
      Q => gtrxreset_i,
      R => '0'
    );
START_RX_Buffer_reg_inv: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => wait_for_lane_up_r,
      Q => START_RX_Buffer_reg_inv_0(0),
      S => START_RX_Buffer_reg_inv_1
    );
align_r_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \^sr\(0),
      I1 => hard_err_reset_i,
      O => begin_r0
    );
all_lanes_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => got_v_i,
      Q => all_lanes_v_r,
      R => '0'
    );
bad_v_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"28"
    )
        port map (
      I0 => got_first_v_r,
      I1 => \v_count_r_reg_n_0_[31]\,
      I2 => all_lanes_v_r,
      O => bad_v_r0
    );
bad_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => bad_v_r0,
      Q => bad_v_r,
      R => '0'
    );
do_nfc_r_i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^channel_up\,
      O => p_0_in
    );
\free_count_r[13]_i_2\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(10),
      O => \free_count_r[13]_i_2_n_0\
    );
\free_count_r[13]_i_3\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(11),
      O => \free_count_r[13]_i_3_n_0\
    );
\free_count_r[13]_i_4\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(12),
      O => \free_count_r[13]_i_4_n_0\
    );
\free_count_r[13]_i_5\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(13),
      O => \free_count_r[13]_i_5_n_0\
    );
\free_count_r[1]_i_2\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(0),
      O => \free_count_r[1]_i_2_n_0\
    );
\free_count_r[1]_i_3\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(1),
      O => \free_count_r[1]_i_3_n_0\
    );
\free_count_r[5]_i_2\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(2),
      O => \free_count_r[5]_i_2_n_0\
    );
\free_count_r[5]_i_3\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(3),
      O => \free_count_r[5]_i_3_n_0\
    );
\free_count_r[5]_i_4\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(4),
      O => \free_count_r[5]_i_4_n_0\
    );
\free_count_r[5]_i_5\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(5),
      O => \free_count_r[5]_i_5_n_0\
    );
\free_count_r[9]_i_2\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(6),
      O => \free_count_r[9]_i_2_n_0\
    );
\free_count_r[9]_i_3\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(7),
      O => \free_count_r[9]_i_3_n_0\
    );
\free_count_r[9]_i_4\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(8),
      O => \free_count_r[9]_i_4_n_0\
    );
\free_count_r[9]_i_5\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => free_count_r_reg(9),
      O => \free_count_r[9]_i_5_n_0\
    );
\free_count_r_reg[0]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[1]_i_1_n_6\,
      Q => free_count_r_reg(0),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[10]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[13]_i_1_n_4\,
      Q => free_count_r_reg(10),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[11]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[13]_i_1_n_5\,
      Q => free_count_r_reg(11),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[12]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[13]_i_1_n_6\,
      Q => free_count_r_reg(12),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[13]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[13]_i_1_n_7\,
      Q => free_count_r_reg(13),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[13]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => \free_count_r_reg[13]_i_1_n_0\,
      CO(2) => \free_count_r_reg[13]_i_1_n_1\,
      CO(1) => \free_count_r_reg[13]_i_1_n_2\,
      CO(0) => \free_count_r_reg[13]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"1111",
      O(3) => \free_count_r_reg[13]_i_1_n_4\,
      O(2) => \free_count_r_reg[13]_i_1_n_5\,
      O(1) => \free_count_r_reg[13]_i_1_n_6\,
      O(0) => \free_count_r_reg[13]_i_1_n_7\,
      S(3) => \free_count_r[13]_i_2_n_0\,
      S(2) => \free_count_r[13]_i_3_n_0\,
      S(1) => \free_count_r[13]_i_4_n_0\,
      S(0) => \free_count_r[13]_i_5_n_0\
    );
\free_count_r_reg[1]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[1]_i_1_n_7\,
      Q => free_count_r_reg(1),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[1]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \free_count_r_reg[5]_i_1_n_0\,
      CO(3 downto 1) => \NLW_free_count_r_reg[1]_i_1_CO_UNCONNECTED\(3 downto 1),
      CO(0) => \free_count_r_reg[1]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0001",
      O(3 downto 2) => \NLW_free_count_r_reg[1]_i_1_O_UNCONNECTED\(3 downto 2),
      O(1) => \free_count_r_reg[1]_i_1_n_6\,
      O(0) => \free_count_r_reg[1]_i_1_n_7\,
      S(3 downto 2) => B"00",
      S(1) => \free_count_r[1]_i_2_n_0\,
      S(0) => \free_count_r[1]_i_3_n_0\
    );
\free_count_r_reg[2]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[5]_i_1_n_4\,
      Q => free_count_r_reg(2),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[3]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[5]_i_1_n_5\,
      Q => free_count_r_reg(3),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[4]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[5]_i_1_n_6\,
      Q => free_count_r_reg(4),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[5]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[5]_i_1_n_7\,
      Q => free_count_r_reg(5),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[5]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \free_count_r_reg[9]_i_1_n_0\,
      CO(3) => \free_count_r_reg[5]_i_1_n_0\,
      CO(2) => \free_count_r_reg[5]_i_1_n_1\,
      CO(1) => \free_count_r_reg[5]_i_1_n_2\,
      CO(0) => \free_count_r_reg[5]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"1111",
      O(3) => \free_count_r_reg[5]_i_1_n_4\,
      O(2) => \free_count_r_reg[5]_i_1_n_5\,
      O(1) => \free_count_r_reg[5]_i_1_n_6\,
      O(0) => \free_count_r_reg[5]_i_1_n_7\,
      S(3) => \free_count_r[5]_i_2_n_0\,
      S(2) => \free_count_r[5]_i_3_n_0\,
      S(1) => \free_count_r[5]_i_4_n_0\,
      S(0) => \free_count_r[5]_i_5_n_0\
    );
\free_count_r_reg[6]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[9]_i_1_n_4\,
      Q => free_count_r_reg(6),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[7]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[9]_i_1_n_5\,
      Q => free_count_r_reg(7),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[8]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[9]_i_1_n_6\,
      Q => free_count_r_reg(8),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[9]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => \free_count_r_reg[9]_i_1_n_7\,
      Q => free_count_r_reg(9),
      S => wait_for_lane_up_r0
    );
\free_count_r_reg[9]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \free_count_r_reg[13]_i_1_n_0\,
      CO(3) => \free_count_r_reg[9]_i_1_n_0\,
      CO(2) => \free_count_r_reg[9]_i_1_n_1\,
      CO(1) => \free_count_r_reg[9]_i_1_n_2\,
      CO(0) => \free_count_r_reg[9]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"1111",
      O(3) => \free_count_r_reg[9]_i_1_n_4\,
      O(2) => \free_count_r_reg[9]_i_1_n_5\,
      O(1) => \free_count_r_reg[9]_i_1_n_6\,
      O(0) => \free_count_r_reg[9]_i_1_n_7\,
      S(3) => \free_count_r[9]_i_2_n_0\,
      S(2) => \free_count_r[9]_i_3_n_0\,
      S(1) => \free_count_r[9]_i_4_n_0\,
      S(0) => \free_count_r[9]_i_5_n_0\
    );
gen_v_flop_0_i_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => \^gen_ver_i\,
      I1 => did_ver_i,
      O => D1_out
    );
got_first_v_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"E0"
    )
        port map (
      I0 => got_first_v_r,
      I1 => all_lanes_v_r,
      I2 => \^gen_ver_i\,
      O => got_first_v_r_i_1_n_0
    );
got_first_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => got_first_v_r_i_1_n_0,
      Q => got_first_v_r,
      R => '0'
    );
gtreset_flop_0_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => p_3_in,
      Q => Q,
      R => '0'
    );
gtreset_flop_0_i_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"AE00"
    )
        port map (
      I0 => \verify_watchdog_r_reg_n_0_[15]\,
      I1 => bad_v_r,
      I2 => \rxver_count_r_reg_n_0_[2]\,
      I3 => \^gen_ver_i\,
      O => p_3_in
    );
\gtrxreset_extend_r_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_extend_r(1),
      Q => gtrxreset_extend_r(0),
      R => START_RX_Buffer_reg_inv_1
    );
\gtrxreset_extend_r_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_extend_r(2),
      Q => gtrxreset_extend_r(1),
      R => START_RX_Buffer_reg_inv_1
    );
\gtrxreset_extend_r_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_extend_r(3),
      Q => gtrxreset_extend_r(2),
      R => START_RX_Buffer_reg_inv_1
    );
\gtrxreset_extend_r_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_extend_r(4),
      Q => gtrxreset_extend_r(3),
      R => START_RX_Buffer_reg_inv_1
    );
\gtrxreset_extend_r_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_extend_r(5),
      Q => gtrxreset_extend_r(4),
      R => START_RX_Buffer_reg_inv_1
    );
\gtrxreset_extend_r_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_extend_r(6),
      Q => gtrxreset_extend_r(5),
      R => START_RX_Buffer_reg_inv_1
    );
\gtrxreset_extend_r_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_extend_r(7),
      Q => gtrxreset_extend_r(6),
      R => START_RX_Buffer_reg_inv_1
    );
\gtrxreset_extend_r_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => Q,
      Q => gtrxreset_extend_r(7),
      R => START_RX_Buffer_reg_inv_1
    );
ready_r2_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ready_r,
      Q => ready_r2,
      R => '0'
    );
\ready_r_i_1__0\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FF80"
    )
        port map (
      I0 => \txver_count_r_reg_n_0_[7]\,
      I1 => \rxver_count_r_reg_n_0_[2]\,
      I2 => \^gen_ver_i\,
      I3 => ready_r,
      O => next_ready_c
    );
ready_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ready_c,
      Q => ready_r,
      R => wait_for_lane_up_r0
    );
reset_lanes_flop_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => D,
      Q => \^sr\(0),
      R => '0'
    );
reset_lanes_flop_i_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFAE"
    )
        port map (
      I0 => START_RX_Buffer_reg_inv_1,
      I1 => reset_channel_i,
      I2 => wait_for_lane_up_r,
      I3 => p_3_in,
      O => D
    );
\rxver_count_r_reg[1]_srl2\: unisim.vcomponents.SRL16E
     port map (
      A0 => '1',
      A1 => '0',
      A2 => '0',
      A3 => '0',
      CE => rxver_count_r0,
      CLK => user_clk,
      D => \^gen_ver_i\,
      Q => \rxver_count_r_reg[1]_srl2_n_0\
    );
\rxver_count_r_reg[1]_srl2_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"8F"
    )
        port map (
      I0 => \v_count_r_reg_n_0_[31]\,
      I1 => all_lanes_v_r,
      I2 => \^gen_ver_i\,
      O => rxver_count_r0
    );
\rxver_count_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => rxver_count_r0,
      D => \rxver_count_r_reg[1]_srl2_n_0\,
      Q => \rxver_count_r_reg_n_0_[2]\,
      R => '0'
    );
\txver_count_r_reg[6]_srl7\: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '1',
      A3 => '0',
      CE => txver_count_r0,
      CLK => user_clk,
      D => \^gen_ver_i\,
      Q => \txver_count_r_reg[6]_srl7_n_0\
    );
\txver_count_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => txver_count_r0,
      D => \txver_count_r_reg[6]_srl7_n_0\,
      Q => \txver_count_r_reg_n_0_[7]\,
      R => '0'
    );
\v_count_r_reg[30]_srl31\: unisim.vcomponents.SRLC32E
     port map (
      A(4 downto 0) => B"11110",
      CE => '1',
      CLK => user_clk,
      D => p_2_out(31),
      Q => \v_count_r_reg[30]_srl31_n_0\,
      Q31 => \NLW_v_count_r_reg[30]_srl31_Q31_UNCONNECTED\
    );
\v_count_r_reg[30]_srl31_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"F444"
    )
        port map (
      I0 => got_first_v_r,
      I1 => all_lanes_v_r,
      I2 => \^gen_ver_i\,
      I3 => \v_count_r_reg_n_0_[31]\,
      O => p_2_out(31)
    );
\v_count_r_reg[31]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \v_count_r_reg[30]_srl31_n_0\,
      Q => \v_count_r_reg_n_0_[31]\,
      R => '0'
    );
verify_r_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FF2A"
    )
        port map (
      I0 => \^gen_ver_i\,
      I1 => \txver_count_r_reg_n_0_[7]\,
      I2 => \rxver_count_r_reg_n_0_[2]\,
      I3 => wait_for_lane_up_r,
      O => next_verify_c
    );
verify_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_verify_c,
      Q => \^gen_ver_i\,
      R => wait_for_lane_up_r0
    );
\verify_watchdog_r_reg[14]_srl15\: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '1',
      A3 => '1',
      CE => verify_watchdog_r0,
      CLK => user_clk,
      D => \^gen_ver_i\,
      Q => \verify_watchdog_r_reg[14]_srl15_n_0\
    );
\verify_watchdog_r_reg[14]_srl15_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"0200FFFF"
    )
        port map (
      I0 => \verify_watchdog_r_reg[14]_srl15_i_2_n_0\,
      I1 => free_count_r_reg(12),
      I2 => free_count_r_reg(13),
      I3 => \verify_watchdog_r_reg[14]_srl15_i_3_n_0\,
      I4 => \^gen_ver_i\,
      O => verify_watchdog_r0
    );
\verify_watchdog_r_reg[14]_srl15_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000000001"
    )
        port map (
      I0 => free_count_r_reg(9),
      I1 => free_count_r_reg(8),
      I2 => free_count_r_reg(11),
      I3 => free_count_r_reg(10),
      I4 => free_count_r_reg(6),
      I5 => free_count_r_reg(7),
      O => \verify_watchdog_r_reg[14]_srl15_i_2_n_0\
    );
\verify_watchdog_r_reg[14]_srl15_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000000001"
    )
        port map (
      I0 => free_count_r_reg(3),
      I1 => free_count_r_reg(2),
      I2 => free_count_r_reg(5),
      I3 => free_count_r_reg(4),
      I4 => free_count_r_reg(0),
      I5 => free_count_r_reg(1),
      O => \verify_watchdog_r_reg[14]_srl15_i_3_n_0\
    );
\verify_watchdog_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => verify_watchdog_r0,
      D => \verify_watchdog_r_reg[14]_srl15_n_0\,
      Q => \verify_watchdog_r_reg_n_0_[15]\,
      R => '0'
    );
wait_for_lane_up_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => wait_for_lane_up_r0,
      Q => wait_for_lane_up_r,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_ERR_DETECT is
  port (
    hard_err_reset_i : out STD_LOGIC;
    hard_err_i : out STD_LOGIC;
    soft_err_flop_r0 : out STD_LOGIC;
    bucket_full_r_reg_0 : out STD_LOGIC;
    SR : in STD_LOGIC;
    hard_err_flop_r0 : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    \soft_err_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    enable_err_detect_i : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_ERR_DETECT;

architecture STRUCTURE of aurora_8b10b_x1_16b_ERR_DETECT is
  signal bucket_full_r_i_1_n_0 : STD_LOGIC;
  signal \count_r[0]_i_1_n_0\ : STD_LOGIC;
  signal \count_r[1]_i_1_n_0\ : STD_LOGIC;
  signal \count_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \good_count_r[0]_i_1_n_0\ : STD_LOGIC;
  signal \good_count_r[1]_i_1_n_0\ : STD_LOGIC;
  signal \good_count_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \^hard_err_reset_i\ : STD_LOGIC;
  signal p_0_in12_in : STD_LOGIC;
  signal p_0_in1_in : STD_LOGIC;
  signal soft_err_r : STD_LOGIC_VECTOR ( 1 to 1 );
  signal \soft_err_r_reg_n_0_[1]\ : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \good_count_r[0]_i_1\ : label is "soft_lutpair0";
  attribute SOFT_HLUTNM of \good_count_r[1]_i_1\ : label is "soft_lutpair0";
begin
  hard_err_reset_i <= \^hard_err_reset_i\;
HARD_ERR_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \^hard_err_reset_i\,
      Q => hard_err_i,
      R => SR
    );
bucket_full_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"C080C880C880C080"
    )
        port map (
      I0 => \count_r_reg_n_0_[1]\,
      I1 => p_0_in1_in,
      I2 => soft_err_r(1),
      I3 => \soft_err_r_reg_n_0_[1]\,
      I4 => \good_count_r_reg_n_0_[1]\,
      I5 => p_0_in12_in,
      O => bucket_full_r_i_1_n_0
    );
bucket_full_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => bucket_full_r_i_1_n_0,
      Q => bucket_full_r_reg_0,
      R => SR
    );
\count_r[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFEECE8CFFEEEE8C"
    )
        port map (
      I0 => \count_r_reg_n_0_[1]\,
      I1 => p_0_in1_in,
      I2 => p_0_in12_in,
      I3 => \soft_err_r_reg_n_0_[1]\,
      I4 => soft_err_r(1),
      I5 => \good_count_r_reg_n_0_[1]\,
      O => \count_r[0]_i_1_n_0\
    );
\count_r[1]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"EEDDAD4AEEDDDD4A"
    )
        port map (
      I0 => \count_r_reg_n_0_[1]\,
      I1 => p_0_in1_in,
      I2 => p_0_in12_in,
      I3 => \soft_err_r_reg_n_0_[1]\,
      I4 => soft_err_r(1),
      I5 => \good_count_r_reg_n_0_[1]\,
      O => \count_r[1]_i_1_n_0\
    );
\count_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \count_r[0]_i_1_n_0\,
      Q => p_0_in1_in,
      R => SR
    );
\count_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \count_r[1]_i_1_n_0\,
      Q => \count_r_reg_n_0_[1]\,
      R => SR
    );
\good_count_r[0]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0100"
    )
        port map (
      I0 => p_0_in12_in,
      I1 => \soft_err_r_reg_n_0_[1]\,
      I2 => soft_err_r(1),
      I3 => enable_err_detect_i,
      O => \good_count_r[0]_i_1_n_0\
    );
\good_count_r[1]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"3200"
    )
        port map (
      I0 => \good_count_r_reg_n_0_[1]\,
      I1 => \soft_err_r_reg_n_0_[1]\,
      I2 => soft_err_r(1),
      I3 => enable_err_detect_i,
      O => \good_count_r[1]_i_1_n_0\
    );
\good_count_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \good_count_r[0]_i_1_n_0\,
      Q => p_0_in12_in,
      R => '0'
    );
\good_count_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \good_count_r[1]_i_1_n_0\,
      Q => \good_count_r_reg_n_0_[1]\,
      R => '0'
    );
hard_err_flop_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => hard_err_flop_r0,
      Q => \^hard_err_reset_i\,
      R => SR
    );
\soft_err_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \soft_err_r_reg[0]_0\(1),
      Q => soft_err_r(1),
      R => SR
    );
\soft_err_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \soft_err_r_reg[0]_0\(0),
      Q => \soft_err_r_reg_n_0_[1]\,
      R => SR
    );
soft_err_r_reg_srl3_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => soft_err_r(1),
      I1 => \soft_err_r_reg_n_0_[1]\,
      O => soft_err_flop_r0
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_IDLE_AND_VER_GEN is
  port (
    gen_v_flop_0_i_0 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    gen_a_i : out STD_LOGIC;
    gen_k_flop_0_i_0 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    gen_r_flop_0_i_0 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    did_ver_i : out STD_LOGIC;
    txver_count_r0 : out STD_LOGIC;
    lfsr_last_flop_i_0 : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    D1_out : in STD_LOGIC;
    gen_ver_i : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_IDLE_AND_VER_GEN;

architecture STRUCTURE of aurora_8b10b_x1_16b_IDLE_AND_VER_GEN is
  signal D : STD_LOGIC;
  signal D0_out : STD_LOGIC;
  signal D2_out : STD_LOGIC;
  signal \^did_ver_i\ : STD_LOGIC;
  signal \downcounter_r[0]_i_1_n_0\ : STD_LOGIC;
  signal \downcounter_r[1]_i_1_n_0\ : STD_LOGIC;
  signal \downcounter_r[2]_i_1_n_0\ : STD_LOGIC;
  signal \downcounter_r[3]_i_1_n_0\ : STD_LOGIC;
  signal \downcounter_r_reg_n_0_[0]\ : STD_LOGIC;
  signal \downcounter_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \downcounter_r_reg_n_0_[2]\ : STD_LOGIC;
  signal \downcounter_r_reg_n_0_[3]\ : STD_LOGIC;
  signal gen_k_flop_0_i_i_1_n_0 : STD_LOGIC;
  signal gen_r_flop_0_i_i_1_n_0 : STD_LOGIC;
  signal gen_r_flop_1_i_i_1_n_0 : STD_LOGIC;
  signal gen_v_flop_1_i_i_1_n_0 : STD_LOGIC;
  signal lfsr_last_flop_r : STD_LOGIC;
  signal \lfsr_shift_register_r_reg[2]_srl3_n_0\ : STD_LOGIC;
  signal lfsr_taps_i_i_1_n_0 : STD_LOGIC;
  signal lfsr_taps_r : STD_LOGIC;
  signal prev_cycle_gen_ver_r : STD_LOGIC;
  signal ver_counter_r_0 : STD_LOGIC;
  signal ver_counter_r_1 : STD_LOGIC;
  attribute BOX_TYPE : string;
  attribute BOX_TYPE of gen_a_flop_0_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM : string;
  attribute XILINX_LEGACY_PRIM of gen_a_flop_0_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP : string;
  attribute XILINX_TRANSFORM_PINMAP of gen_a_flop_0_i : label is "VCC:CE GND:R";
  attribute BOX_TYPE of gen_k_flop_0_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of gen_k_flop_0_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of gen_k_flop_0_i : label is "VCC:CE GND:R";
  attribute BOX_TYPE of gen_k_flop_1_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of gen_k_flop_1_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of gen_k_flop_1_i : label is "VCC:CE GND:R";
  attribute BOX_TYPE of gen_r_flop_0_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of gen_r_flop_0_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of gen_r_flop_0_i : label is "VCC:CE GND:R";
  attribute BOX_TYPE of gen_r_flop_1_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of gen_r_flop_1_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of gen_r_flop_1_i : label is "VCC:CE GND:R";
  attribute BOX_TYPE of gen_v_flop_0_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of gen_v_flop_0_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of gen_v_flop_0_i : label is "VCC:CE GND:R";
  attribute BOX_TYPE of gen_v_flop_1_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of gen_v_flop_1_i : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of gen_v_flop_1_i : label is "VCC:CE GND:R";
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of gen_v_flop_1_i_i_1 : label is "soft_lutpair38";
  attribute BOX_TYPE of lfsr_last_flop_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of lfsr_last_flop_i : label is "FDR";
  attribute XILINX_TRANSFORM_PINMAP of lfsr_last_flop_i : label is "VCC:CE";
  attribute srl_bus_name : string;
  attribute srl_bus_name of \lfsr_shift_register_r_reg[2]_srl3\ : label is "U0/\global_logic_i/idle_and_ver_gen_i/lfsr_shift_register_r_reg ";
  attribute srl_name : string;
  attribute srl_name of \lfsr_shift_register_r_reg[2]_srl3\ : label is "U0/\global_logic_i/idle_and_ver_gen_i/lfsr_shift_register_r_reg[2]_srl3 ";
  attribute BOX_TYPE of lfsr_taps_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of lfsr_taps_i : label is "FDR";
  attribute XILINX_TRANSFORM_PINMAP of lfsr_taps_i : label is "VCC:CE";
  attribute BOX_TYPE of ver_counter_0_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of ver_counter_0_i : label is "SRL16";
  attribute XILINX_TRANSFORM_PINMAP of ver_counter_0_i : label is "VCC:CE";
  attribute srl_name of ver_counter_0_i : label is "U0/\global_logic_i/idle_and_ver_gen_i/ver_counter_0_i ";
  attribute SOFT_HLUTNM of ver_counter_0_i_i_1 : label is "soft_lutpair38";
  attribute BOX_TYPE of ver_counter_1_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM of ver_counter_1_i : label is "SRL16";
  attribute XILINX_TRANSFORM_PINMAP of ver_counter_1_i : label is "VCC:CE";
  attribute srl_name of ver_counter_1_i : label is "U0/\global_logic_i/idle_and_ver_gen_i/ver_counter_1_i ";
begin
  did_ver_i <= \^did_ver_i\;
\downcounter_r[0]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"44444441"
    )
        port map (
      I0 => lfsr_last_flop_i_0,
      I1 => \downcounter_r_reg_n_0_[0]\,
      I2 => \downcounter_r_reg_n_0_[2]\,
      I3 => \downcounter_r_reg_n_0_[1]\,
      I4 => \downcounter_r_reg_n_0_[3]\,
      O => \downcounter_r[0]_i_1_n_0\
    );
\downcounter_r[1]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00000000F0C3F0C2"
    )
        port map (
      I0 => \downcounter_r_reg_n_0_[0]\,
      I1 => \downcounter_r_reg_n_0_[2]\,
      I2 => \downcounter_r_reg_n_0_[1]\,
      I3 => \downcounter_r_reg_n_0_[3]\,
      I4 => lfsr_taps_r,
      I5 => lfsr_last_flop_i_0,
      O => \downcounter_r[1]_i_1_n_0\
    );
\downcounter_r[2]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00000000CC33CC32"
    )
        port map (
      I0 => \downcounter_r_reg_n_0_[0]\,
      I1 => \downcounter_r_reg_n_0_[2]\,
      I2 => \downcounter_r_reg_n_0_[1]\,
      I3 => \downcounter_r_reg_n_0_[3]\,
      I4 => D,
      I5 => lfsr_last_flop_i_0,
      O => \downcounter_r[2]_i_1_n_0\
    );
\downcounter_r[3]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"1111111111111110"
    )
        port map (
      I0 => lfsr_last_flop_i_0,
      I1 => \downcounter_r_reg_n_0_[3]\,
      I2 => lfsr_last_flop_r,
      I3 => \downcounter_r_reg_n_0_[1]\,
      I4 => \downcounter_r_reg_n_0_[2]\,
      I5 => \downcounter_r_reg_n_0_[0]\,
      O => \downcounter_r[3]_i_1_n_0\
    );
\downcounter_r_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \downcounter_r[0]_i_1_n_0\,
      Q => \downcounter_r_reg_n_0_[0]\,
      R => '0'
    );
\downcounter_r_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \downcounter_r[1]_i_1_n_0\,
      Q => \downcounter_r_reg_n_0_[1]\,
      R => '0'
    );
\downcounter_r_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \downcounter_r[2]_i_1_n_0\,
      Q => \downcounter_r_reg_n_0_[2]\,
      R => '0'
    );
\downcounter_r_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '1'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \downcounter_r[3]_i_1_n_0\,
      Q => \downcounter_r_reg_n_0_[3]\,
      R => '0'
    );
gen_a_flop_0_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => D2_out,
      Q => gen_a_i,
      R => '0'
    );
gen_a_flop_0_i_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00000001"
    )
        port map (
      I0 => \downcounter_r_reg_n_0_[3]\,
      I1 => \downcounter_r_reg_n_0_[1]\,
      I2 => \downcounter_r_reg_n_0_[2]\,
      I3 => \downcounter_r_reg_n_0_[0]\,
      I4 => ver_counter_r_0,
      O => D2_out
    );
gen_k_flop_0_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gen_k_flop_0_i_i_1_n_0,
      Q => gen_k_flop_0_i_0(1),
      R => '0'
    );
gen_k_flop_0_i_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFAAAAAAA8"
    )
        port map (
      I0 => lfsr_taps_r,
      I1 => \downcounter_r_reg_n_0_[0]\,
      I2 => \downcounter_r_reg_n_0_[2]\,
      I3 => \downcounter_r_reg_n_0_[1]\,
      I4 => \downcounter_r_reg_n_0_[3]\,
      I5 => ver_counter_r_0,
      O => gen_k_flop_0_i_i_1_n_0
    );
gen_k_flop_1_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => D,
      Q => gen_k_flop_0_i_0(0),
      R => '0'
    );
gen_r_flop_0_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gen_r_flop_0_i_i_1_n_0,
      Q => gen_r_flop_0_i_0(1),
      R => '0'
    );
gen_r_flop_0_i_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"1111111111111110"
    )
        port map (
      I0 => lfsr_taps_r,
      I1 => ver_counter_r_0,
      I2 => \downcounter_r_reg_n_0_[3]\,
      I3 => \downcounter_r_reg_n_0_[1]\,
      I4 => \downcounter_r_reg_n_0_[2]\,
      I5 => \downcounter_r_reg_n_0_[0]\,
      O => gen_r_flop_0_i_i_1_n_0
    );
gen_r_flop_1_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gen_r_flop_1_i_i_1_n_0,
      Q => gen_r_flop_0_i_0(0),
      R => '0'
    );
gen_r_flop_1_i_i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => D,
      O => gen_r_flop_1_i_i_1_n_0
    );
gen_v_flop_0_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => D1_out,
      Q => gen_v_flop_0_i_0(1),
      R => '0'
    );
gen_v_flop_1_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gen_v_flop_1_i_i_1_n_0,
      Q => gen_v_flop_0_i_0(0),
      R => '0'
    );
gen_v_flop_1_i_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"E0"
    )
        port map (
      I0 => ver_counter_r_0,
      I1 => \^did_ver_i\,
      I2 => gen_ver_i,
      O => gen_v_flop_1_i_i_1_n_0
    );
gen_ver_word_2_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ver_counter_r_0,
      Q => \^did_ver_i\,
      R => '0'
    );
lfsr_last_flop_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => D,
      Q => lfsr_last_flop_r,
      R => lfsr_last_flop_i_0
    );
\lfsr_shift_register_r_reg[2]_srl3\: unisim.vcomponents.SRL16E
    generic map(
      INIT => X"0000"
    )
        port map (
      A0 => '0',
      A1 => '1',
      A2 => '0',
      A3 => '0',
      CE => '1',
      CLK => user_clk,
      D => lfsr_taps_r,
      Q => \lfsr_shift_register_r_reg[2]_srl3_n_0\
    );
\lfsr_shift_register_r_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \lfsr_shift_register_r_reg[2]_srl3_n_0\,
      Q => D,
      R => '0'
    );
lfsr_taps_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => lfsr_taps_i_i_1_n_0,
      Q => lfsr_taps_r,
      R => lfsr_last_flop_i_0
    );
lfsr_taps_i_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"9"
    )
        port map (
      I0 => lfsr_last_flop_r,
      I1 => D,
      O => lfsr_taps_i_i_1_n_0
    );
prev_cycle_gen_ver_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_ver_i,
      Q => prev_cycle_gen_ver_r,
      R => '0'
    );
\txver_count_r_reg[6]_srl7_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => \^did_ver_i\,
      I1 => gen_ver_i,
      O => txver_count_r0
    );
ver_counter_0_i: unisim.vcomponents.SRL16E
    generic map(
      INIT => X"0000"
    )
        port map (
      A0 => '1',
      A1 => '1',
      A2 => '1',
      A3 => '1',
      CE => '1',
      CLK => user_clk,
      D => D0_out,
      Q => ver_counter_r_1
    );
ver_counter_0_i_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B0"
    )
        port map (
      I0 => \^did_ver_i\,
      I1 => prev_cycle_gen_ver_r,
      I2 => gen_ver_i,
      O => D0_out
    );
ver_counter_1_i: unisim.vcomponents.SRL16E
    generic map(
      INIT => X"0000"
    )
        port map (
      A0 => '0',
      A1 => '1',
      A2 => '1',
      A3 => '1',
      CE => '1',
      CLK => user_clk,
      D => ver_counter_r_1,
      Q => ver_counter_r_0
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_LANE_INIT_SM is
  port (
    LANE_UP : out STD_LOGIC;
    D_0 : out STD_LOGIC;
    align_r_reg_0 : out STD_LOGIC;
    ack_r : out STD_LOGIC;
    rst_r_reg_0 : out STD_LOGIC;
    enable_err_detect_i : out STD_LOGIC;
    rx_polarity_i : out STD_LOGIC;
    D : out STD_LOGIC_VECTOR ( 1 downto 0 );
    gen_spa_data_i : out STD_LOGIC_VECTOR ( 0 to 0 );
    gen_k_i : out STD_LOGIC;
    first_v_received_r_reg : out STD_LOGIC;
    ENABLE_ERR_DETECT_Buffer_reg_0 : out STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    user_clk : in STD_LOGIC;
    begin_r0 : in STD_LOGIC;
    counter4_r0 : in STD_LOGIC;
    \counter2_r_reg[15]_0\ : in STD_LOGIC;
    counter3_r0 : in STD_LOGIC;
    RX_NEG_Buffer : in STD_LOGIC;
    reset_count_r_reg_0 : in STD_LOGIC;
    rx_realign_i : in STD_LOGIC;
    first_v_received_r : in STD_LOGIC;
    \RX_CHAR_IS_COMMA_R_reg[1]_0\ : in STD_LOGIC_VECTOR ( 1 downto 0 )
  );
end aurora_8b10b_x1_16b_LANE_INIT_SM;

architecture STRUCTURE of aurora_8b10b_x1_16b_LANE_INIT_SM is
  signal \^d_0\ : STD_LOGIC;
  signal ENABLE_ERR_DETECT_Buffer0 : STD_LOGIC;
  signal RX_CHAR_IS_COMMA_R : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal \^ack_r\ : STD_LOGIC;
  signal ack_r_i_2_n_0 : STD_LOGIC;
  signal \^align_r_reg_0\ : STD_LOGIC;
  signal begin_r : STD_LOGIC;
  signal begin_r_i_2_n_0 : STD_LOGIC;
  signal comma_over_two_cycles_r : STD_LOGIC;
  signal comma_over_two_cycles_r_i_1_n_0 : STD_LOGIC;
  signal counter1_r0 : STD_LOGIC;
  signal \counter1_r[0]_i_4_n_0\ : STD_LOGIC;
  signal \counter1_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \counter1_r_reg_n_0_[3]\ : STD_LOGIC;
  signal \counter1_r_reg_n_0_[5]\ : STD_LOGIC;
  signal \counter1_r_reg_n_0_[6]\ : STD_LOGIC;
  signal \counter1_r_reg_n_0_[7]\ : STD_LOGIC;
  signal \counter2_r_reg[14]_srl14_n_0\ : STD_LOGIC;
  signal \counter2_r_reg_n_0_[15]\ : STD_LOGIC;
  signal \counter3_r_reg[2]_srl3_n_0\ : STD_LOGIC;
  signal \counter3_r_reg_n_0_[3]\ : STD_LOGIC;
  signal \counter4_r_reg[14]_srl15_n_0\ : STD_LOGIC;
  signal \counter4_r_reg_n_0_[15]\ : STD_LOGIC;
  signal counter5_r0 : STD_LOGIC;
  signal \counter5_r_reg[14]_srl15_n_0\ : STD_LOGIC;
  signal \counter5_r_reg_n_0_[15]\ : STD_LOGIC;
  signal do_watchdog_count_r : STD_LOGIC;
  signal do_watchdog_count_r_i_1_n_0 : STD_LOGIC;
  signal \^enable_err_detect_i\ : STD_LOGIC;
  signal inc_count_c : STD_LOGIC;
  signal inc_count_c1 : STD_LOGIC;
  signal next_ack_c : STD_LOGIC;
  signal next_ack_c12_in : STD_LOGIC;
  signal next_align_c : STD_LOGIC;
  signal next_begin_c : STD_LOGIC;
  signal next_polarity_c : STD_LOGIC;
  signal next_ready_c : STD_LOGIC;
  signal next_realign_c : STD_LOGIC;
  signal next_rst_c : STD_LOGIC;
  signal odd_word_r : STD_LOGIC;
  signal p_0_in : STD_LOGIC_VECTOR ( 7 downto 0 );
  signal polarity_r : STD_LOGIC;
  signal prev_char_was_comma_r : STD_LOGIC;
  signal prev_count_128d_done_r : STD_LOGIC;
  signal realign_r : STD_LOGIC;
  signal reset_count_r : STD_LOGIC;
  signal reset_count_r0 : STD_LOGIC;
  signal \^rst_r_reg_0\ : STD_LOGIC;
  signal \^rx_polarity_i\ : STD_LOGIC;
  signal rx_polarity_r_i_1_n_0 : STD_LOGIC;
  signal std_bool : STD_LOGIC;
  signal std_bool0_in : STD_LOGIC;
  signal std_bool6_in : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of ENABLE_ERR_DETECT_Buffer_i_1 : label is "soft_lutpair7";
  attribute SOFT_HLUTNM of align_r_i_2 : label is "soft_lutpair4";
  attribute SOFT_HLUTNM of comma_over_two_cycles_r_i_1 : label is "soft_lutpair5";
  attribute SOFT_HLUTNM of \counter1_r[0]_i_3\ : label is "soft_lutpair1";
  attribute SOFT_HLUTNM of \counter1_r[0]_i_4\ : label is "soft_lutpair2";
  attribute SOFT_HLUTNM of \counter1_r[1]_i_1\ : label is "soft_lutpair1";
  attribute SOFT_HLUTNM of \counter1_r[3]_i_1\ : label is "soft_lutpair2";
  attribute SOFT_HLUTNM of \counter1_r[4]_i_1\ : label is "soft_lutpair3";
  attribute SOFT_HLUTNM of \counter1_r[5]_i_1\ : label is "soft_lutpair3";
  attribute srl_bus_name : string;
  attribute srl_bus_name of \counter2_r_reg[14]_srl14\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter2_r_reg ";
  attribute srl_name : string;
  attribute srl_name of \counter2_r_reg[14]_srl14\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter2_r_reg[14]_srl14 ";
  attribute srl_bus_name of \counter3_r_reg[2]_srl3\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter3_r_reg ";
  attribute srl_name of \counter3_r_reg[2]_srl3\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter3_r_reg[2]_srl3 ";
  attribute srl_bus_name of \counter4_r_reg[14]_srl15\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter4_r_reg ";
  attribute srl_name of \counter4_r_reg[14]_srl15\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter4_r_reg[14]_srl15 ";
  attribute srl_bus_name of \counter5_r_reg[14]_srl15\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter5_r_reg ";
  attribute srl_name of \counter5_r_reg[14]_srl15\ : label is "U0/\aurora_lane_0_i/lane_init_sm_i/counter5_r_reg[14]_srl15 ";
  attribute SOFT_HLUTNM of gen_k_fsm_r_i_1 : label is "soft_lutpair6";
  attribute SOFT_HLUTNM of \gen_sp_data_r[0]_i_1\ : label is "soft_lutpair6";
  attribute SOFT_HLUTNM of \gen_sp_data_r[1]_i_1\ : label is "soft_lutpair7";
  attribute SOFT_HLUTNM of \gen_spa_data_r[0]_i_1\ : label is "soft_lutpair8";
  attribute BOX_TYPE : string;
  attribute BOX_TYPE of lane_up_flop_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM : string;
  attribute XILINX_LEGACY_PRIM of lane_up_flop_i : label is "FDR";
  attribute XILINX_TRANSFORM_PINMAP : string;
  attribute XILINX_TRANSFORM_PINMAP of lane_up_flop_i : label is "VCC:CE";
  attribute SOFT_HLUTNM of odd_word_r_i_1 : label is "soft_lutpair8";
  attribute SOFT_HLUTNM of prev_char_was_comma_r_i_1 : label is "soft_lutpair5";
  attribute SOFT_HLUTNM of rst_r_i_1 : label is "soft_lutpair4";
begin
  D_0 <= \^d_0\;
  ack_r <= \^ack_r\;
  align_r_reg_0 <= \^align_r_reg_0\;
  enable_err_detect_i <= \^enable_err_detect_i\;
  rst_r_reg_0 <= \^rst_r_reg_0\;
  rx_polarity_i <= \^rx_polarity_i\;
ENABLE_ERR_DETECT_Buffer_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \^ack_r\,
      I1 => \^d_0\,
      O => ENABLE_ERR_DETECT_Buffer0
    );
ENABLE_ERR_DETECT_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ENABLE_ERR_DETECT_Buffer0,
      Q => \^enable_err_detect_i\,
      R => '0'
    );
\RX_CHAR_IS_COMMA_R_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \RX_CHAR_IS_COMMA_R_reg[1]_0\(0),
      Q => RX_CHAR_IS_COMMA_R(0),
      R => '0'
    );
\RX_CHAR_IS_COMMA_R_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \RX_CHAR_IS_COMMA_R_reg[1]_0\(1),
      Q => RX_CHAR_IS_COMMA_R(1),
      R => '0'
    );
ack_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"04040404FF040404"
    )
        port map (
      I0 => RX_NEG_Buffer,
      I1 => polarity_r,
      I2 => odd_word_r,
      I3 => ack_r_i_2_n_0,
      I4 => \^ack_r\,
      I5 => \counter5_r_reg_n_0_[15]\,
      O => next_ack_c
    );
ack_r_i_2: unisim.vcomponents.LUT2
    generic map(
      INIT => X"7"
    )
        port map (
      I0 => \counter2_r_reg_n_0_[15]\,
      I1 => \counter3_r_reg_n_0_[3]\,
      O => ack_r_i_2_n_0
    );
ack_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ack_c,
      Q => \^ack_r\,
      R => begin_r0
    );
align_r_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"8F88"
    )
        port map (
      I0 => std_bool0_in,
      I1 => \^rst_r_reg_0\,
      I2 => std_bool,
      I3 => \^align_r_reg_0\,
      O => next_align_c
    );
align_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_align_c,
      Q => \^align_r_reg_0\,
      R => begin_r0
    );
begin_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"F8"
    )
        port map (
      I0 => polarity_r,
      I1 => RX_NEG_Buffer,
      I2 => begin_r_i_2_n_0,
      O => next_begin_c
    );
begin_r_i_2: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFF888F888F888"
    )
        port map (
      I0 => \counter4_r_reg_n_0_[15]\,
      I1 => \^d_0\,
      I2 => \^ack_r\,
      I3 => \counter5_r_reg_n_0_[15]\,
      I4 => rx_realign_i,
      I5 => realign_r,
      O => begin_r_i_2_n_0
    );
begin_r_reg: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => next_begin_c,
      Q => begin_r,
      S => begin_r0
    );
comma_over_two_cycles_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"56FF"
    )
        port map (
      I0 => prev_char_was_comma_r,
      I1 => RX_CHAR_IS_COMMA_R(0),
      I2 => RX_CHAR_IS_COMMA_R(1),
      I3 => \^align_r_reg_0\,
      O => comma_over_two_cycles_r_i_1_n_0
    );
comma_over_two_cycles_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => comma_over_two_cycles_r_i_1_n_0,
      Q => comma_over_two_cycles_r,
      R => '0'
    );
\counter1_r[0]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => reset_count_r,
      I1 => \^d_0\,
      O => counter1_r0
    );
\counter1_r[0]_i_2\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FD"
    )
        port map (
      I0 => \^align_r_reg_0\,
      I1 => RX_CHAR_IS_COMMA_R(1),
      I2 => RX_CHAR_IS_COMMA_R(0),
      O => inc_count_c
    );
\counter1_r[0]_i_3\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"7FFF8000"
    )
        port map (
      I0 => \counter1_r[0]_i_4_n_0\,
      I1 => \counter1_r_reg_n_0_[1]\,
      I2 => std_bool6_in,
      I3 => \counter1_r_reg_n_0_[3]\,
      I4 => std_bool,
      O => p_0_in(7)
    );
\counter1_r[0]_i_4\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"8000"
    )
        port map (
      I0 => \counter1_r_reg_n_0_[5]\,
      I1 => \counter1_r_reg_n_0_[7]\,
      I2 => \counter1_r_reg_n_0_[6]\,
      I3 => std_bool0_in,
      O => \counter1_r[0]_i_4_n_0\
    );
\counter1_r[1]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7F80"
    )
        port map (
      I0 => \counter1_r[0]_i_4_n_0\,
      I1 => \counter1_r_reg_n_0_[3]\,
      I2 => std_bool6_in,
      I3 => \counter1_r_reg_n_0_[1]\,
      O => p_0_in(6)
    );
\counter1_r[2]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFF80000000"
    )
        port map (
      I0 => \counter1_r_reg_n_0_[3]\,
      I1 => \counter1_r_reg_n_0_[5]\,
      I2 => \counter1_r_reg_n_0_[7]\,
      I3 => \counter1_r_reg_n_0_[6]\,
      I4 => std_bool0_in,
      I5 => std_bool6_in,
      O => p_0_in(5)
    );
\counter1_r[3]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"7FFF8000"
    )
        port map (
      I0 => std_bool0_in,
      I1 => \counter1_r_reg_n_0_[6]\,
      I2 => \counter1_r_reg_n_0_[7]\,
      I3 => \counter1_r_reg_n_0_[5]\,
      I4 => \counter1_r_reg_n_0_[3]\,
      O => p_0_in(4)
    );
\counter1_r[4]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7F80"
    )
        port map (
      I0 => \counter1_r_reg_n_0_[5]\,
      I1 => \counter1_r_reg_n_0_[7]\,
      I2 => \counter1_r_reg_n_0_[6]\,
      I3 => std_bool0_in,
      O => p_0_in(3)
    );
\counter1_r[5]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"78"
    )
        port map (
      I0 => \counter1_r_reg_n_0_[6]\,
      I1 => \counter1_r_reg_n_0_[7]\,
      I2 => \counter1_r_reg_n_0_[5]\,
      O => p_0_in(2)
    );
\counter1_r[6]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"6"
    )
        port map (
      I0 => \counter1_r_reg_n_0_[7]\,
      I1 => \counter1_r_reg_n_0_[6]\,
      O => p_0_in(1)
    );
\counter1_r[7]_i_1\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \counter1_r_reg_n_0_[7]\,
      O => p_0_in(0)
    );
\counter1_r_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(7),
      Q => std_bool,
      R => counter1_r0
    );
\counter1_r_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(6),
      Q => \counter1_r_reg_n_0_[1]\,
      R => counter1_r0
    );
\counter1_r_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(5),
      Q => std_bool6_in,
      R => counter1_r0
    );
\counter1_r_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(4),
      Q => \counter1_r_reg_n_0_[3]\,
      R => counter1_r0
    );
\counter1_r_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(3),
      Q => std_bool0_in,
      R => counter1_r0
    );
\counter1_r_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(2),
      Q => \counter1_r_reg_n_0_[5]\,
      R => counter1_r0
    );
\counter1_r_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(1),
      Q => \counter1_r_reg_n_0_[6]\,
      R => counter1_r0
    );
\counter1_r_reg[7]\: unisim.vcomponents.FDSE
    generic map(
      INIT => '1'
    )
        port map (
      C => user_clk,
      CE => inc_count_c,
      D => p_0_in(0),
      Q => \counter1_r_reg_n_0_[7]\,
      S => counter1_r0
    );
\counter2_r_reg[14]_srl14\: unisim.vcomponents.SRL16E
     port map (
      A0 => '1',
      A1 => '0',
      A2 => '1',
      A3 => '1',
      CE => '1',
      CLK => user_clk,
      D => \counter2_r_reg[15]_0\,
      Q => \counter2_r_reg[14]_srl14_n_0\
    );
\counter2_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \counter2_r_reg[14]_srl14_n_0\,
      Q => \counter2_r_reg_n_0_[15]\,
      R => '0'
    );
\counter3_r_reg[2]_srl3\: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '0',
      A3 => '0',
      CE => counter3_r0,
      CLK => user_clk,
      D => \^ack_r\,
      Q => \counter3_r_reg[2]_srl3_n_0\
    );
\counter3_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => counter3_r0,
      D => \counter3_r_reg[2]_srl3_n_0\,
      Q => \counter3_r_reg_n_0_[3]\,
      R => '0'
    );
\counter4_r_reg[14]_srl15\: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '1',
      A3 => '1',
      CE => counter4_r0,
      CLK => user_clk,
      D => \^d_0\,
      Q => \counter4_r_reg[14]_srl15_n_0\
    );
\counter4_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => counter4_r0,
      D => \counter4_r_reg[14]_srl15_n_0\,
      Q => \counter4_r_reg_n_0_[15]\,
      R => '0'
    );
\counter5_r_reg[14]_srl15\: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '1',
      A3 => '1',
      CE => counter5_r0,
      CLK => user_clk,
      D => \^ack_r\,
      Q => \counter5_r_reg[14]_srl15_n_0\
    );
\counter5_r_reg[14]_srl15_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => do_watchdog_count_r,
      I1 => \^ack_r\,
      O => counter5_r0
    );
\counter5_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => counter5_r0,
      D => \counter5_r_reg[14]_srl15_n_0\,
      Q => \counter5_r_reg_n_0_[15]\,
      R => '0'
    );
do_watchdog_count_r_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => std_bool,
      I1 => prev_count_128d_done_r,
      O => do_watchdog_count_r_i_1_n_0
    );
do_watchdog_count_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => do_watchdog_count_r_i_1_n_0,
      Q => do_watchdog_count_r,
      R => '0'
    );
gen_k_fsm_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B0"
    )
        port map (
      I0 => \^ack_r\,
      I1 => \^d_0\,
      I2 => odd_word_r,
      O => gen_k_i
    );
\gen_sp_data_r[0]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"01"
    )
        port map (
      I0 => \^d_0\,
      I1 => \^ack_r\,
      I2 => odd_word_r,
      O => D(1)
    );
\gen_sp_data_r[1]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^d_0\,
      I1 => \^ack_r\,
      O => D(0)
    );
\gen_spa_data_r[0]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \^ack_r\,
      I1 => odd_word_r,
      O => gen_spa_data_i(0)
    );
lane_up_flop_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \^d_0\,
      Q => LANE_UP,
      R => SR(0)
    );
left_aligned_r_i_2: unisim.vcomponents.LUT5
    generic map(
      INIT => X"14141400"
    )
        port map (
      I0 => first_v_received_r,
      I1 => \RX_CHAR_IS_COMMA_R_reg[1]_0\(1),
      I2 => \RX_CHAR_IS_COMMA_R_reg[1]_0\(0),
      I3 => \^d_0\,
      I4 => \^align_r_reg_0\,
      O => first_v_received_r_reg
    );
odd_word_r_i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => odd_word_r,
      O => next_ack_c12_in
    );
odd_word_r_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '1'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => next_ack_c12_in,
      Q => odd_word_r,
      R => '0'
    );
polarity_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"40404040FF404040"
    )
        port map (
      I0 => RX_NEG_Buffer,
      I1 => odd_word_r,
      I2 => polarity_r,
      I3 => realign_r,
      I4 => std_bool6_in,
      I5 => rx_realign_i,
      O => next_polarity_c
    );
polarity_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_polarity_c,
      Q => polarity_r,
      R => begin_r0
    );
prev_char_was_comma_r_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => RX_CHAR_IS_COMMA_R(0),
      I1 => RX_CHAR_IS_COMMA_R(1),
      O => inc_count_c1
    );
prev_char_was_comma_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => inc_count_c1,
      Q => prev_char_was_comma_r,
      R => '0'
    );
prev_count_128d_done_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool,
      Q => prev_count_128d_done_r,
      R => '0'
    );
ready_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0080FFFF00800080"
    )
        port map (
      I0 => \counter2_r_reg_n_0_[15]\,
      I1 => \counter3_r_reg_n_0_[3]\,
      I2 => \^ack_r\,
      I3 => \counter5_r_reg_n_0_[15]\,
      I4 => \counter4_r_reg_n_0_[15]\,
      I5 => \^d_0\,
      O => next_ready_c
    );
ready_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ready_c,
      Q => \^d_0\,
      R => begin_r0
    );
realign_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FF020202"
    )
        port map (
      I0 => realign_r,
      I1 => rx_realign_i,
      I2 => std_bool6_in,
      I3 => std_bool,
      I4 => \^align_r_reg_0\,
      O => next_realign_c
    );
realign_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_realign_c,
      Q => realign_r,
      R => begin_r0
    );
reset_count_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFF33D1"
    )
        port map (
      I0 => comma_over_two_cycles_r,
      I1 => \^rst_r_reg_0\,
      I2 => std_bool0_in,
      I3 => begin_r,
      I4 => SR(0),
      I5 => reset_count_r_reg_0,
      O => reset_count_r0
    );
reset_count_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => reset_count_r0,
      Q => reset_count_r,
      R => '0'
    );
rst_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"F4"
    )
        port map (
      I0 => std_bool0_in,
      I1 => \^rst_r_reg_0\,
      I2 => begin_r,
      O => next_rst_c
    );
rst_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_rst_c,
      Q => \^rst_r_reg_0\,
      R => begin_r0
    );
rx_polarity_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"78"
    )
        port map (
      I0 => polarity_r,
      I1 => RX_NEG_Buffer,
      I2 => \^rx_polarity_i\,
      O => rx_polarity_r_i_1_n_0
    );
rx_polarity_r_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_polarity_r_i_1_n_0,
      Q => \^rx_polarity_i\,
      R => '0'
    );
\soft_err_r[0]_i_1\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^enable_err_detect_i\,
      O => ENABLE_ERR_DETECT_Buffer_reg_0
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_RX_LL_NFC is
  port (
    load_nfc_r : out STD_LOGIC;
    xoff_r : out STD_LOGIC;
    Q : out STD_LOGIC_VECTOR ( 3 downto 0 );
    \nfc_counter_r_reg[0]_0\ : out STD_LOGIC;
    \nfc_counter_r_reg[8]_0\ : out STD_LOGIC;
    M_AXI_RX_SNF : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    xoff_r_reg_0 : in STD_LOGIC;
    tx_dst_rdy : in STD_LOGIC;
    D_0 : in STD_LOGIC;
    D : in STD_LOGIC_VECTOR ( 2 downto 0 );
    \nfc_counter_r_reg[1]_0\ : in STD_LOGIC;
    ufc_storage_data_r : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \nfc_counter_r_reg[3]_0\ : in STD_LOGIC;
    \nfc_counter_r_reg[2]_0\ : in STD_LOGIC;
    \nfc_counter_r_reg[4]_0\ : in STD_LOGIC;
    \nfc_counter_r_reg[5]_0\ : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_RX_LL_NFC;

architecture STRUCTURE of aurora_8b10b_x1_16b_RX_LL_NFC is
  signal \^q\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \^load_nfc_r\ : STD_LOGIC;
  signal \nfc_counter_r[0]_i_1_n_0\ : STD_LOGIC;
  signal \nfc_counter_r[1]_i_3_n_0\ : STD_LOGIC;
  signal \nfc_counter_r[4]_i_2_n_0\ : STD_LOGIC;
  signal \nfc_counter_r[8]_i_1_n_0\ : STD_LOGIC;
  signal \nfc_counter_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \nfc_counter_r_reg_n_0_[2]\ : STD_LOGIC;
  signal \nfc_counter_r_reg_n_0_[3]\ : STD_LOGIC;
  signal \nfc_counter_r_reg_n_0_[4]\ : STD_LOGIC;
  signal \nfc_counter_r_reg_n_0_[5]\ : STD_LOGIC;
  signal p_0_in : STD_LOGIC_VECTOR ( 7 downto 3 );
  signal \^xoff_r\ : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \nfc_counter_r[1]_i_3\ : label is "soft_lutpair84";
  attribute SOFT_HLUTNM of \nfc_counter_r[4]_i_2\ : label is "soft_lutpair84";
  attribute SOFT_HLUTNM of \nfc_counter_r[6]_i_3\ : label is "soft_lutpair85";
  attribute SOFT_HLUTNM of \nfc_counter_r[8]_i_1\ : label is "soft_lutpair85";
begin
  Q(3 downto 0) <= \^q\(3 downto 0);
  load_nfc_r <= \^load_nfc_r\;
  xoff_r <= \^xoff_r\;
load_nfc_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => M_AXI_RX_SNF,
      Q => \^load_nfc_r\,
      R => '0'
    );
\nfc_counter_r[0]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFF0002"
    )
        port map (
      I0 => tx_dst_rdy,
      I1 => D_0,
      I2 => \^xoff_r\,
      I3 => \^q\(3),
      I4 => \^load_nfc_r\,
      O => \nfc_counter_r[0]_i_1_n_0\
    );
\nfc_counter_r[0]_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"000000006AAAAAAA"
    )
        port map (
      I0 => \^q\(3),
      I1 => \nfc_counter_r_reg_n_0_[3]\,
      I2 => \nfc_counter_r_reg_n_0_[2]\,
      I3 => \nfc_counter_r_reg_n_0_[1]\,
      I4 => \nfc_counter_r[1]_i_3_n_0\,
      I5 => \^load_nfc_r\,
      O => \nfc_counter_r_reg[0]_0\
    );
\nfc_counter_r[1]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"ABBBBBBBBAAAAAAA"
    )
        port map (
      I0 => \nfc_counter_r_reg[1]_0\,
      I1 => \^load_nfc_r\,
      I2 => \nfc_counter_r[1]_i_3_n_0\,
      I3 => \nfc_counter_r_reg_n_0_[3]\,
      I4 => \nfc_counter_r_reg_n_0_[2]\,
      I5 => \nfc_counter_r_reg_n_0_[1]\,
      O => p_0_in(7)
    );
\nfc_counter_r[1]_i_3\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"80000000"
    )
        port map (
      I0 => \nfc_counter_r_reg_n_0_[5]\,
      I1 => \^q\(1),
      I2 => \^q\(0),
      I3 => \^q\(2),
      I4 => \nfc_counter_r_reg_n_0_[4]\,
      O => \nfc_counter_r[1]_i_3_n_0\
    );
\nfc_counter_r[2]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"404F4F4F4F404040"
    )
        port map (
      I0 => ufc_storage_data_r(1),
      I1 => \nfc_counter_r_reg[2]_0\,
      I2 => \^load_nfc_r\,
      I3 => \nfc_counter_r_reg_n_0_[3]\,
      I4 => \nfc_counter_r[1]_i_3_n_0\,
      I5 => \nfc_counter_r_reg_n_0_[2]\,
      O => p_0_in(6)
    );
\nfc_counter_r[3]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"404F4F40"
    )
        port map (
      I0 => ufc_storage_data_r(1),
      I1 => \nfc_counter_r_reg[3]_0\,
      I2 => \^load_nfc_r\,
      I3 => \nfc_counter_r[1]_i_3_n_0\,
      I4 => \nfc_counter_r_reg_n_0_[3]\,
      O => p_0_in(5)
    );
\nfc_counter_r[4]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"000F666600F06666"
    )
        port map (
      I0 => \nfc_counter_r_reg_n_0_[4]\,
      I1 => \nfc_counter_r[4]_i_2_n_0\,
      I2 => \nfc_counter_r_reg[4]_0\,
      I3 => ufc_storage_data_r(1),
      I4 => \^load_nfc_r\,
      I5 => ufc_storage_data_r(0),
      O => p_0_in(4)
    );
\nfc_counter_r[4]_i_2\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"8000"
    )
        port map (
      I0 => \^q\(2),
      I1 => \^q\(0),
      I2 => \^q\(1),
      I3 => \nfc_counter_r_reg_n_0_[5]\,
      O => \nfc_counter_r[4]_i_2_n_0\
    );
\nfc_counter_r[5]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"ABBBBBBBBAAAAAAA"
    )
        port map (
      I0 => \nfc_counter_r_reg[5]_0\,
      I1 => \^load_nfc_r\,
      I2 => \^q\(2),
      I3 => \^q\(0),
      I4 => \^q\(1),
      I5 => \nfc_counter_r_reg_n_0_[5]\,
      O => p_0_in(3)
    );
\nfc_counter_r[6]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => \^q\(0),
      I1 => \^q\(1),
      O => \nfc_counter_r_reg[8]_0\
    );
\nfc_counter_r[8]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^load_nfc_r\,
      I1 => \^q\(0),
      O => \nfc_counter_r[8]_i_1_n_0\
    );
\nfc_counter_r_reg[0]\: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => D(2),
      Q => \^q\(3),
      S => SR(0)
    );
\nfc_counter_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => p_0_in(7),
      Q => \nfc_counter_r_reg_n_0_[1]\,
      R => SR(0)
    );
\nfc_counter_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => p_0_in(6),
      Q => \nfc_counter_r_reg_n_0_[2]\,
      R => SR(0)
    );
\nfc_counter_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => p_0_in(5),
      Q => \nfc_counter_r_reg_n_0_[3]\,
      R => SR(0)
    );
\nfc_counter_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => p_0_in(4),
      Q => \nfc_counter_r_reg_n_0_[4]\,
      R => SR(0)
    );
\nfc_counter_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => p_0_in(3),
      Q => \nfc_counter_r_reg_n_0_[5]\,
      R => SR(0)
    );
\nfc_counter_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => D(1),
      Q => \^q\(2),
      R => SR(0)
    );
\nfc_counter_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => D(0),
      Q => \^q\(1),
      R => SR(0)
    );
\nfc_counter_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \nfc_counter_r[0]_i_1_n_0\,
      D => \nfc_counter_r[8]_i_1_n_0\,
      Q => \^q\(0),
      R => SR(0)
    );
xoff_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => xoff_r_reg_0,
      Q => \^xoff_r\,
      R => SR(0)
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_RX_LL_PDU_DATAPATH is
  port (
    FRAME_ERR : out STD_LOGIC;
    in_frame_r : out STD_LOGIC;
    M_AXI_RX_TVALID : out STD_LOGIC;
    M_AXI_RX_TDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    storage_v_r : out STD_LOGIC;
    M_AXI_RX_TKEEP : out STD_LOGIC_VECTOR ( 0 to 0 );
    M_AXI_RX_TLAST : out STD_LOGIC;
    E : in STD_LOGIC_VECTOR ( 0 to 0 );
    rx_pad_i : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    RX_EOF_N_Buffer_reg_0 : in STD_LOGIC;
    FRAME_ERR_Buffer0 : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    in_frame_r_reg_0 : in STD_LOGIC;
    src_rdy_n_c : in STD_LOGIC;
    D : in STD_LOGIC_VECTOR ( 15 downto 0 );
    rx_ecp_i : in STD_LOGIC;
    storage_v_r_reg_0 : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_RX_LL_PDU_DATAPATH;

architecture STRUCTURE of aurora_8b10b_x1_16b_RX_LL_PDU_DATAPATH is
  signal p_0_in_0 : STD_LOGIC;
  signal pad_in_storage_r : STD_LOGIC;
  signal rx_eof : STD_LOGIC;
  signal rx_rem : STD_LOGIC;
  signal storage_r : STD_LOGIC_VECTOR ( 0 to 15 );
  signal \^storage_v_r\ : STD_LOGIC;
  signal storage_v_r_i_1_n_0 : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \M_AXI_RX_TKEEP[1]_INST_0\ : label is "soft_lutpair86";
  attribute SOFT_HLUTNM of M_AXI_RX_TLAST_INST_0 : label is "soft_lutpair86";
  attribute inverted : string;
  attribute inverted of RX_SRC_RDY_N_Buffer_reg_inv : label is "yes";
begin
  storage_v_r <= \^storage_v_r\;
FRAME_ERR_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => FRAME_ERR_Buffer0,
      Q => FRAME_ERR,
      R => '0'
    );
\M_AXI_RX_TKEEP[1]_INST_0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => rx_eof,
      I1 => rx_rem,
      O => M_AXI_RX_TKEEP(0)
    );
M_AXI_RX_TLAST_INST_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => rx_eof,
      O => M_AXI_RX_TLAST
    );
\RX_D_Buffer_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(0),
      Q => M_AXI_RX_TDATA(7),
      R => '0'
    );
\RX_D_Buffer_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(10),
      Q => M_AXI_RX_TDATA(13),
      R => '0'
    );
\RX_D_Buffer_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(11),
      Q => M_AXI_RX_TDATA(12),
      R => '0'
    );
\RX_D_Buffer_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(12),
      Q => M_AXI_RX_TDATA(11),
      R => '0'
    );
\RX_D_Buffer_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(13),
      Q => M_AXI_RX_TDATA(10),
      R => '0'
    );
\RX_D_Buffer_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(14),
      Q => M_AXI_RX_TDATA(9),
      R => '0'
    );
\RX_D_Buffer_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(15),
      Q => M_AXI_RX_TDATA(8),
      R => '0'
    );
\RX_D_Buffer_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(1),
      Q => M_AXI_RX_TDATA(6),
      R => '0'
    );
\RX_D_Buffer_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(2),
      Q => M_AXI_RX_TDATA(5),
      R => '0'
    );
\RX_D_Buffer_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(3),
      Q => M_AXI_RX_TDATA(4),
      R => '0'
    );
\RX_D_Buffer_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(4),
      Q => M_AXI_RX_TDATA(3),
      R => '0'
    );
\RX_D_Buffer_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(5),
      Q => M_AXI_RX_TDATA(2),
      R => '0'
    );
\RX_D_Buffer_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(6),
      Q => M_AXI_RX_TDATA(1),
      R => '0'
    );
\RX_D_Buffer_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(7),
      Q => M_AXI_RX_TDATA(0),
      R => '0'
    );
\RX_D_Buffer_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(8),
      Q => M_AXI_RX_TDATA(15),
      R => '0'
    );
\RX_D_Buffer_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_r(9),
      Q => M_AXI_RX_TDATA(14),
      R => '0'
    );
RX_EOF_N_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_EOF_N_Buffer_reg_0,
      Q => rx_eof,
      R => '0'
    );
RX_REM_Buffer_i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => pad_in_storage_r,
      O => p_0_in_0
    );
RX_REM_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => p_0_in_0,
      Q => rx_rem,
      R => '0'
    );
RX_SRC_RDY_N_Buffer_reg_inv: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => src_rdy_n_c,
      Q => M_AXI_RX_TVALID,
      R => SR(0)
    );
in_frame_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => in_frame_r_reg_0,
      Q => in_frame_r,
      R => SR(0)
    );
pad_in_storage_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => rx_pad_i,
      Q => pad_in_storage_r,
      R => '0'
    );
\storage_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(15),
      Q => storage_r(0),
      R => '0'
    );
\storage_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(5),
      Q => storage_r(10),
      R => '0'
    );
\storage_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(4),
      Q => storage_r(11),
      R => '0'
    );
\storage_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(3),
      Q => storage_r(12),
      R => '0'
    );
\storage_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(2),
      Q => storage_r(13),
      R => '0'
    );
\storage_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(1),
      Q => storage_r(14),
      R => '0'
    );
\storage_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(0),
      Q => storage_r(15),
      R => '0'
    );
\storage_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(14),
      Q => storage_r(1),
      R => '0'
    );
\storage_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(13),
      Q => storage_r(2),
      R => '0'
    );
\storage_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(12),
      Q => storage_r(3),
      R => '0'
    );
\storage_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(11),
      Q => storage_r(4),
      R => '0'
    );
\storage_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(10),
      Q => storage_r(5),
      R => '0'
    );
\storage_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(9),
      Q => storage_r(6),
      R => '0'
    );
\storage_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(8),
      Q => storage_r(7),
      R => '0'
    );
\storage_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(7),
      Q => storage_r(8),
      R => '0'
    );
\storage_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => D(6),
      Q => storage_r(9),
      R => '0'
    );
storage_v_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"4F"
    )
        port map (
      I0 => rx_ecp_i,
      I1 => \^storage_v_r\,
      I2 => storage_v_r_reg_0,
      O => storage_v_r_i_1_n_0
    );
storage_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_v_r_i_1_n_0,
      Q => \^storage_v_r\,
      R => SR(0)
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_RX_LL_UFC_DATAPATH is
  port (
    ufc_storage_v_r : out STD_LOGIC;
    M_AXI_UFC_RX_TLAST : out STD_LOGIC;
    \ufc_storage_data_r_reg[8]_0\ : out STD_LOGIC_VECTOR ( 1 downto 0 );
    M_AXI_UFC_RX_TVALID : out STD_LOGIC;
    \ufc_storage_data_r_reg[10]_0\ : out STD_LOGIC;
    \ufc_storage_data_r_reg[9]_0\ : out STD_LOGIC_VECTOR ( 2 downto 0 );
    \ufc_storage_data_r_reg[9]_1\ : out STD_LOGIC;
    \ufc_storage_data_r_reg[10]_1\ : out STD_LOGIC;
    \ufc_storage_data_r_reg[9]_2\ : out STD_LOGIC;
    \ufc_storage_data_r_reg[11]_0\ : out STD_LOGIC;
    \ufc_storage_data_r_reg[10]_2\ : out STD_LOGIC;
    M_AXI_UFC_RX_TDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    ufc_data_v_i : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    UFC_RX_EOF_N_Buffer_reg_inv_0 : in STD_LOGIC;
    D : in STD_LOGIC_VECTOR ( 15 downto 0 );
    load_nfc_r : in STD_LOGIC;
    \nfc_counter_r_reg[0]\ : in STD_LOGIC;
    \nfc_counter_r_reg[6]\ : in STD_LOGIC;
    Q : in STD_LOGIC_VECTOR ( 2 downto 0 );
    xoff_r : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_RX_LL_UFC_DATAPATH;

architecture STRUCTURE of aurora_8b10b_x1_16b_RX_LL_UFC_DATAPATH is
  signal \nfc_counter_r[6]_i_2_n_0\ : STD_LOGIC;
  signal ufc_storage_data_r : STD_LOGIC_VECTOR ( 0 to 15 );
  signal \^ufc_storage_data_r_reg[8]_0\ : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal \^ufc_storage_v_r\ : STD_LOGIC;
  attribute inverted : string;
  attribute inverted of UFC_RX_EOF_N_Buffer_reg_inv : label is "yes";
  attribute inverted of UFC_RX_SRC_RDY_N_Buffer_reg_inv : label is "yes";
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \nfc_counter_r[1]_i_2\ : label is "soft_lutpair87";
  attribute SOFT_HLUTNM of \nfc_counter_r[2]_i_2\ : label is "soft_lutpair88";
  attribute SOFT_HLUTNM of \nfc_counter_r[3]_i_2\ : label is "soft_lutpair88";
  attribute SOFT_HLUTNM of \nfc_counter_r[5]_i_2\ : label is "soft_lutpair87";
begin
  \ufc_storage_data_r_reg[8]_0\(1 downto 0) <= \^ufc_storage_data_r_reg[8]_0\(1 downto 0);
  ufc_storage_v_r <= \^ufc_storage_v_r\;
\UFC_RX_DATA_Buffer_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(0),
      Q => M_AXI_UFC_RX_TDATA(7),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(10),
      Q => M_AXI_UFC_RX_TDATA(13),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(11),
      Q => M_AXI_UFC_RX_TDATA(12),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(12),
      Q => M_AXI_UFC_RX_TDATA(11),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(13),
      Q => M_AXI_UFC_RX_TDATA(10),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(14),
      Q => M_AXI_UFC_RX_TDATA(9),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(15),
      Q => M_AXI_UFC_RX_TDATA(8),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(1),
      Q => M_AXI_UFC_RX_TDATA(6),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(2),
      Q => M_AXI_UFC_RX_TDATA(5),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(3),
      Q => M_AXI_UFC_RX_TDATA(4),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(4),
      Q => M_AXI_UFC_RX_TDATA(3),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(5),
      Q => M_AXI_UFC_RX_TDATA(2),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(6),
      Q => M_AXI_UFC_RX_TDATA(1),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_storage_data_r(7),
      Q => M_AXI_UFC_RX_TDATA(0),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \^ufc_storage_data_r_reg[8]_0\(1),
      Q => M_AXI_UFC_RX_TDATA(15),
      R => '0'
    );
\UFC_RX_DATA_Buffer_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \^ufc_storage_data_r_reg[8]_0\(0),
      Q => M_AXI_UFC_RX_TDATA(14),
      R => '0'
    );
UFC_RX_EOF_N_Buffer_reg_inv: unisim.vcomponents.FDRE
    generic map(
      INIT => '1'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => UFC_RX_EOF_N_Buffer_reg_inv_0,
      Q => M_AXI_UFC_RX_TLAST,
      R => '0'
    );
UFC_RX_SRC_RDY_N_Buffer_reg_inv: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \^ufc_storage_v_r\,
      Q => M_AXI_UFC_RX_TVALID,
      R => SR(0)
    );
\nfc_counter_r[0]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"BFFEAAAAAAABAAAA"
    )
        port map (
      I0 => \nfc_counter_r_reg[0]\,
      I1 => \^ufc_storage_data_r_reg[8]_0\(0),
      I2 => ufc_storage_data_r(11),
      I3 => ufc_storage_data_r(10),
      I4 => load_nfc_r,
      I5 => \^ufc_storage_data_r_reg[8]_0\(1),
      O => \ufc_storage_data_r_reg[9]_0\(2)
    );
\nfc_counter_r[1]_i_2\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00FE0000"
    )
        port map (
      I0 => ufc_storage_data_r(10),
      I1 => ufc_storage_data_r(11),
      I2 => \^ufc_storage_data_r_reg[8]_0\(0),
      I3 => \^ufc_storage_data_r_reg[8]_0\(1),
      I4 => load_nfc_r,
      O => \ufc_storage_data_r_reg[10]_0\
    );
\nfc_counter_r[2]_i_2\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"7E"
    )
        port map (
      I0 => \^ufc_storage_data_r_reg[8]_0\(0),
      I1 => ufc_storage_data_r(11),
      I2 => ufc_storage_data_r(10),
      O => \ufc_storage_data_r_reg[9]_1\
    );
\nfc_counter_r[3]_i_2\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"5E"
    )
        port map (
      I0 => ufc_storage_data_r(10),
      I1 => ufc_storage_data_r(11),
      I2 => \^ufc_storage_data_r_reg[8]_0\(0),
      O => \ufc_storage_data_r_reg[10]_1\
    );
\nfc_counter_r[4]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => ufc_storage_data_r(11),
      I1 => ufc_storage_data_r(10),
      O => \ufc_storage_data_r_reg[11]_0\
    );
\nfc_counter_r[5]_i_2\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"04040400"
    )
        port map (
      I0 => \^ufc_storage_data_r_reg[8]_0\(0),
      I1 => load_nfc_r,
      I2 => \^ufc_storage_data_r_reg[8]_0\(1),
      I3 => ufc_storage_data_r(10),
      I4 => ufc_storage_data_r(11),
      O => \ufc_storage_data_r_reg[9]_2\
    );
\nfc_counter_r[6]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"606060FF60FF6060"
    )
        port map (
      I0 => ufc_storage_data_r(10),
      I1 => ufc_storage_data_r(11),
      I2 => \nfc_counter_r[6]_i_2_n_0\,
      I3 => load_nfc_r,
      I4 => \nfc_counter_r_reg[6]\,
      I5 => Q(2),
      O => \ufc_storage_data_r_reg[9]_0\(1)
    );
\nfc_counter_r[6]_i_2\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"04"
    )
        port map (
      I0 => \^ufc_storage_data_r_reg[8]_0\(1),
      I1 => load_nfc_r,
      I2 => \^ufc_storage_data_r_reg[8]_0\(0),
      O => \nfc_counter_r[6]_i_2_n_0\
    );
\nfc_counter_r[7]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"080808FF08FF0808"
    )
        port map (
      I0 => \nfc_counter_r[6]_i_2_n_0\,
      I1 => ufc_storage_data_r(11),
      I2 => ufc_storage_data_r(10),
      I3 => load_nfc_r,
      I4 => Q(0),
      I5 => Q(1),
      O => \ufc_storage_data_r_reg[9]_0\(0)
    );
\ufc_storage_data_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(15),
      Q => ufc_storage_data_r(0),
      R => '0'
    );
\ufc_storage_data_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(5),
      Q => ufc_storage_data_r(10),
      R => '0'
    );
\ufc_storage_data_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(4),
      Q => ufc_storage_data_r(11),
      R => '0'
    );
\ufc_storage_data_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(3),
      Q => ufc_storage_data_r(12),
      R => '0'
    );
\ufc_storage_data_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(2),
      Q => ufc_storage_data_r(13),
      R => '0'
    );
\ufc_storage_data_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(1),
      Q => ufc_storage_data_r(14),
      R => '0'
    );
\ufc_storage_data_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(0),
      Q => ufc_storage_data_r(15),
      R => '0'
    );
\ufc_storage_data_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(14),
      Q => ufc_storage_data_r(1),
      R => '0'
    );
\ufc_storage_data_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(13),
      Q => ufc_storage_data_r(2),
      R => '0'
    );
\ufc_storage_data_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(12),
      Q => ufc_storage_data_r(3),
      R => '0'
    );
\ufc_storage_data_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(11),
      Q => ufc_storage_data_r(4),
      R => '0'
    );
\ufc_storage_data_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(10),
      Q => ufc_storage_data_r(5),
      R => '0'
    );
\ufc_storage_data_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(9),
      Q => ufc_storage_data_r(6),
      R => '0'
    );
\ufc_storage_data_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(8),
      Q => ufc_storage_data_r(7),
      R => '0'
    );
\ufc_storage_data_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(7),
      Q => \^ufc_storage_data_r_reg[8]_0\(1),
      R => '0'
    );
\ufc_storage_data_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(6),
      Q => \^ufc_storage_data_r_reg[8]_0\(0),
      R => '0'
    );
ufc_storage_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ufc_data_v_i,
      Q => \^ufc_storage_v_r\,
      R => SR(0)
    );
xoff_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000FFFF80000000"
    )
        port map (
      I0 => ufc_storage_data_r(10),
      I1 => ufc_storage_data_r(11),
      I2 => \^ufc_storage_data_r_reg[8]_0\(1),
      I3 => \^ufc_storage_data_r_reg[8]_0\(0),
      I4 => load_nfc_r,
      I5 => xoff_r,
      O => \ufc_storage_data_r_reg[10]_2\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_STANDARD_CC_MODULE is
  port (
    WARN_CC : out STD_LOGIC;
    s_axi_ufc_tx_tvalid : out STD_LOGIC;
    Q : out STD_LOGIC;
    DO_CC_reg_0 : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    S_AXI_UFC_TX_REQ : in STD_LOGIC;
    \ufc_message_count_r_reg[2]\ : in STD_LOGIC;
    S_AXI_NFC_REQ : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_STANDARD_CC_MODULE;

architecture STRUCTURE of aurora_8b10b_x1_16b_STANDARD_CC_MODULE is
  signal DO_CC0_n_0 : STD_LOGIC;
  signal DO_CC_i_1_n_0 : STD_LOGIC;
  signal \^q\ : STD_LOGIC;
  signal \^warn_cc\ : STD_LOGIC;
  signal WARN_CC_i_1_n_0 : STD_LOGIC;
  signal \cc_count_r_reg_n_0_[5]\ : STD_LOGIC;
  signal cc_idle_count_done_c : STD_LOGIC;
  signal count_13d_flop_r_reg_r_n_0 : STD_LOGIC;
  signal \count_13d_srl_r_reg[10]_standard_cc_module_i_count_13d_srl_r_reg_r_9_n_0\ : STD_LOGIC;
  signal \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_i_1_n_0\ : STD_LOGIC;
  signal \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_n_0\ : STD_LOGIC;
  signal count_13d_srl_r_reg_gate_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_0_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_1_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_2_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_3_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_4_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_5_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_6_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_7_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_8_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_9_n_0 : STD_LOGIC;
  signal count_13d_srl_r_reg_r_n_0 : STD_LOGIC;
  signal count_16d_flop_r : STD_LOGIC;
  signal count_16d_flop_r_i_1_n_0 : STD_LOGIC;
  signal count_16d_srl_r0 : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[0]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[10]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[11]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[12]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[13]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[14]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[2]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[3]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[4]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[5]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[6]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[7]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[8]\ : STD_LOGIC;
  signal \count_16d_srl_r_reg_n_0_[9]\ : STD_LOGIC;
  signal count_24d_flop_r : STD_LOGIC;
  signal count_24d_flop_r_i_1_n_0 : STD_LOGIC;
  signal count_24d_srl_r0 : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[0]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[10]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[11]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[12]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[13]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[14]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[15]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[16]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[17]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[18]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[19]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[20]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[21]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[22]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[2]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[3]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[4]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[5]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[6]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[7]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[8]\ : STD_LOGIC;
  signal \count_24d_srl_r_reg_n_0_[9]\ : STD_LOGIC;
  signal p_2_in : STD_LOGIC_VECTOR ( 4 downto 0 );
  signal p_3_out : STD_LOGIC_VECTOR ( 5 to 5 );
  signal \prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5_n_0\ : STD_LOGIC;
  signal \prepare_count_r_reg[8]_standard_cc_module_i_count_13d_srl_r_reg_r_6_n_0\ : STD_LOGIC;
  signal prepare_count_r_reg_gate_n_0 : STD_LOGIC;
  signal reset_r : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of WARN_CC_i_1 : label is "soft_lutpair91";
  attribute srl_bus_name : string;
  attribute srl_bus_name of \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8\ : label is "U0/\standard_cc_module_i/count_13d_srl_r_reg ";
  attribute srl_name : string;
  attribute srl_name of \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8\ : label is "U0/\standard_cc_module_i/count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8 ";
  attribute SOFT_HLUTNM of \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_i_1\ : label is "soft_lutpair92";
  attribute SOFT_HLUTNM of count_24d_flop_r_i_1 : label is "soft_lutpair92";
  attribute srl_bus_name of \prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5\ : label is "U0/\standard_cc_module_i/prepare_count_r_reg ";
  attribute srl_name of \prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5\ : label is "U0/\standard_cc_module_i/prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5 ";
  attribute SOFT_HLUTNM of \prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5_i_1\ : label is "soft_lutpair91";
begin
  Q <= \^q\;
  WARN_CC <= \^warn_cc\;
DO_CC0: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => p_2_in(1),
      I1 => \cc_count_r_reg_n_0_[5]\,
      I2 => p_2_in(0),
      I3 => p_2_in(3),
      I4 => p_2_in(2),
      I5 => p_2_in(4),
      O => DO_CC0_n_0
    );
DO_CC_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FE"
    )
        port map (
      I0 => DO_CC0_n_0,
      I1 => p_3_out(5),
      I2 => reset_r,
      O => DO_CC_i_1_n_0
    );
DO_CC_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => DO_CC_i_1_n_0,
      Q => \^q\,
      R => DO_CC_reg_0
    );
WARN_CC_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"80FF8080"
    )
        port map (
      I0 => \count_24d_srl_r_reg_n_0_[22]\,
      I1 => \count_16d_srl_r_reg_n_0_[14]\,
      I2 => count_16d_srl_r0,
      I3 => p_3_out(5),
      I4 => \^warn_cc\,
      O => WARN_CC_i_1_n_0
    );
WARN_CC_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => WARN_CC_i_1_n_0,
      Q => \^warn_cc\,
      R => DO_CC_reg_0
    );
\cc_count_r_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => p_3_out(5),
      Q => p_2_in(4),
      R => DO_CC_reg_0
    );
\cc_count_r_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => p_2_in(4),
      Q => p_2_in(3),
      R => DO_CC_reg_0
    );
\cc_count_r_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => p_2_in(3),
      Q => p_2_in(2),
      R => DO_CC_reg_0
    );
\cc_count_r_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => p_2_in(2),
      Q => p_2_in(1),
      R => DO_CC_reg_0
    );
\cc_count_r_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => p_2_in(1),
      Q => p_2_in(0),
      R => DO_CC_reg_0
    );
\cc_count_r_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => p_2_in(0),
      Q => \cc_count_r_reg_n_0_[5]\,
      R => DO_CC_reg_0
    );
count_13d_flop_r_reg_r: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => '1',
      Q => count_13d_flop_r_reg_r_n_0,
      R => DO_CC_reg_0
    );
\count_13d_srl_r_reg[10]_standard_cc_module_i_count_13d_srl_r_reg_r_9\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_n_0\,
      Q => \count_13d_srl_r_reg[10]_standard_cc_module_i_count_13d_srl_r_reg_r_9_n_0\,
      R => '0'
    );
\count_13d_srl_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_gate_n_0,
      Q => count_16d_srl_r0,
      R => DO_CC_reg_0
    );
\count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8\: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '0',
      A3 => '1',
      CE => '1',
      CLK => user_clk,
      D => \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_i_1_n_0\,
      Q => \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_n_0\
    );
\count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => count_16d_srl_r0,
      I1 => reset_r,
      O => \count_13d_srl_r_reg[9]_srl11___standard_cc_module_i_count_13d_srl_r_reg_r_8_i_1_n_0\
    );
count_13d_srl_r_reg_gate: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => \count_13d_srl_r_reg[10]_standard_cc_module_i_count_13d_srl_r_reg_r_9_n_0\,
      I1 => count_13d_srl_r_reg_r_9_n_0,
      O => count_13d_srl_r_reg_gate_n_0
    );
count_13d_srl_r_reg_r: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_flop_r_reg_r_n_0,
      Q => count_13d_srl_r_reg_r_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_0: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_n_0,
      Q => count_13d_srl_r_reg_r_0_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_1: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_0_n_0,
      Q => count_13d_srl_r_reg_r_1_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_2: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_1_n_0,
      Q => count_13d_srl_r_reg_r_2_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_3: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_2_n_0,
      Q => count_13d_srl_r_reg_r_3_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_4: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_3_n_0,
      Q => count_13d_srl_r_reg_r_4_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_5: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_4_n_0,
      Q => count_13d_srl_r_reg_r_5_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_6: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_5_n_0,
      Q => count_13d_srl_r_reg_r_6_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_7: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_6_n_0,
      Q => count_13d_srl_r_reg_r_7_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_8: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_7_n_0,
      Q => count_13d_srl_r_reg_r_8_n_0,
      R => DO_CC_reg_0
    );
count_13d_srl_r_reg_r_9: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_13d_srl_r_reg_r_8_n_0,
      Q => count_13d_srl_r_reg_r_9_n_0,
      R => DO_CC_reg_0
    );
count_16d_flop_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FBF8"
    )
        port map (
      I0 => \count_16d_srl_r_reg_n_0_[14]\,
      I1 => count_16d_srl_r0,
      I2 => reset_r,
      I3 => count_16d_flop_r,
      O => count_16d_flop_r_i_1_n_0
    );
count_16d_flop_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_16d_flop_r_i_1_n_0,
      Q => count_16d_flop_r,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => count_16d_flop_r,
      Q => \count_16d_srl_r_reg_n_0_[0]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[9]\,
      Q => \count_16d_srl_r_reg_n_0_[10]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[10]\,
      Q => \count_16d_srl_r_reg_n_0_[11]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[11]\,
      Q => \count_16d_srl_r_reg_n_0_[12]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[12]\,
      Q => \count_16d_srl_r_reg_n_0_[13]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[13]\,
      Q => \count_16d_srl_r_reg_n_0_[14]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[0]\,
      Q => \count_16d_srl_r_reg_n_0_[1]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[1]\,
      Q => \count_16d_srl_r_reg_n_0_[2]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[2]\,
      Q => \count_16d_srl_r_reg_n_0_[3]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[3]\,
      Q => \count_16d_srl_r_reg_n_0_[4]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[4]\,
      Q => \count_16d_srl_r_reg_n_0_[5]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[5]\,
      Q => \count_16d_srl_r_reg_n_0_[6]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[6]\,
      Q => \count_16d_srl_r_reg_n_0_[7]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[7]\,
      Q => \count_16d_srl_r_reg_n_0_[8]\,
      R => DO_CC_reg_0
    );
\count_16d_srl_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_16d_srl_r0,
      D => \count_16d_srl_r_reg_n_0_[8]\,
      Q => \count_16d_srl_r_reg_n_0_[9]\,
      R => DO_CC_reg_0
    );
count_24d_flop_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFBFFF80"
    )
        port map (
      I0 => \count_24d_srl_r_reg_n_0_[22]\,
      I1 => count_16d_srl_r0,
      I2 => \count_16d_srl_r_reg_n_0_[14]\,
      I3 => reset_r,
      I4 => count_24d_flop_r,
      O => count_24d_flop_r_i_1_n_0
    );
count_24d_flop_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => count_24d_flop_r_i_1_n_0,
      Q => count_24d_flop_r,
      R => DO_CC_reg_0
    );
\count_24d_srl_r[0]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => count_16d_srl_r0,
      I1 => \count_16d_srl_r_reg_n_0_[14]\,
      O => count_24d_srl_r0
    );
\count_24d_srl_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => count_24d_flop_r,
      Q => \count_24d_srl_r_reg_n_0_[0]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[9]\,
      Q => \count_24d_srl_r_reg_n_0_[10]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[10]\,
      Q => \count_24d_srl_r_reg_n_0_[11]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[11]\,
      Q => \count_24d_srl_r_reg_n_0_[12]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[12]\,
      Q => \count_24d_srl_r_reg_n_0_[13]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[13]\,
      Q => \count_24d_srl_r_reg_n_0_[14]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[14]\,
      Q => \count_24d_srl_r_reg_n_0_[15]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[16]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[15]\,
      Q => \count_24d_srl_r_reg_n_0_[16]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[17]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[16]\,
      Q => \count_24d_srl_r_reg_n_0_[17]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[18]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[17]\,
      Q => \count_24d_srl_r_reg_n_0_[18]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[19]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[18]\,
      Q => \count_24d_srl_r_reg_n_0_[19]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[0]\,
      Q => \count_24d_srl_r_reg_n_0_[1]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[20]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[19]\,
      Q => \count_24d_srl_r_reg_n_0_[20]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[21]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[20]\,
      Q => \count_24d_srl_r_reg_n_0_[21]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[22]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[21]\,
      Q => \count_24d_srl_r_reg_n_0_[22]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[1]\,
      Q => \count_24d_srl_r_reg_n_0_[2]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[2]\,
      Q => \count_24d_srl_r_reg_n_0_[3]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[3]\,
      Q => \count_24d_srl_r_reg_n_0_[4]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[4]\,
      Q => \count_24d_srl_r_reg_n_0_[5]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[5]\,
      Q => \count_24d_srl_r_reg_n_0_[6]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[6]\,
      Q => \count_24d_srl_r_reg_n_0_[7]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[7]\,
      Q => \count_24d_srl_r_reg_n_0_[8]\,
      R => DO_CC_reg_0
    );
\count_24d_srl_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => count_24d_srl_r0,
      D => \count_24d_srl_r_reg_n_0_[8]\,
      Q => \count_24d_srl_r_reg_n_0_[9]\,
      R => DO_CC_reg_0
    );
\prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5\: unisim.vcomponents.SRL16E
    generic map(
      INIT => X"0000"
    )
        port map (
      A0 => '1',
      A1 => '1',
      A2 => '1',
      A3 => '0',
      CE => '1',
      CLK => user_clk,
      D => cc_idle_count_done_c,
      Q => \prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5_n_0\
    );
\prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"80"
    )
        port map (
      I0 => count_16d_srl_r0,
      I1 => \count_16d_srl_r_reg_n_0_[14]\,
      I2 => \count_24d_srl_r_reg_n_0_[22]\,
      O => cc_idle_count_done_c
    );
\prepare_count_r_reg[8]_standard_cc_module_i_count_13d_srl_r_reg_r_6\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \prepare_count_r_reg[7]_srl8___standard_cc_module_i_count_13d_srl_r_reg_r_5_n_0\,
      Q => \prepare_count_r_reg[8]_standard_cc_module_i_count_13d_srl_r_reg_r_6_n_0\,
      R => '0'
    );
\prepare_count_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => prepare_count_r_reg_gate_n_0,
      Q => p_3_out(5),
      R => DO_CC_reg_0
    );
prepare_count_r_reg_gate: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => \prepare_count_r_reg[8]_standard_cc_module_i_count_13d_srl_r_reg_r_6_n_0\,
      I1 => count_13d_srl_r_reg_r_6_n_0,
      O => prepare_count_r_reg_gate_n_0
    );
reset_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => DO_CC_reg_0,
      Q => reset_r,
      R => '0'
    );
\ufc_message_count_r[0]_i_2\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFFFF75"
    )
        port map (
      I0 => S_AXI_UFC_TX_REQ,
      I1 => \ufc_message_count_r_reg[2]\,
      I2 => S_AXI_NFC_REQ,
      I3 => \^q\,
      I4 => \^warn_cc\,
      O => s_axi_ufc_tx_tvalid
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_SYM_DEC is
  port (
    RX_NEG_Buffer : out STD_LOGIC;
    rx_pad_i : out STD_LOGIC;
    RX_ECP_Buffer_reg_0 : out STD_LOGIC;
    RX_SUF_Buffer_reg_0 : out STD_LOGIC;
    got_v_i : out STD_LOGIC;
    D : out STD_LOGIC_VECTOR ( 0 to 0 );
    \RX_PE_DATA_Buffer_reg[0]_0\ : out STD_LOGIC_VECTOR ( 15 downto 0 );
    left_aligned_r_reg_0 : out STD_LOGIC;
    rx_pe_data_v_i : out STD_LOGIC;
    counter4_r0 : out STD_LOGIC;
    counter3_r0 : out STD_LOGIC;
    M_AXI_RX_SNF : out STD_LOGIC;
    first_v_received_r : out STD_LOGIC;
    \RX_FC_NB_Buffer_reg[1]_0\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    RX_ECP_Buffer_reg_1 : out STD_LOGIC;
    FRAME_ERR_Buffer0 : out STD_LOGIC;
    RX_SCP_Buffer_reg_0 : out STD_LOGIC;
    user_clk : in STD_LOGIC;
    \word_aligned_control_bits_r_reg[1]_0\ : in STD_LOGIC;
    \word_aligned_control_bits_r_reg[0]_0\ : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    left_aligned_r_reg_1 : in STD_LOGIC;
    D_0 : in STD_LOGIC;
    ack_r : in STD_LOGIC;
    \ufc_count_r_reg[0]\ : in STD_LOGIC;
    Q : in STD_LOGIC_VECTOR ( 3 downto 0 );
    \ufc_count_r_reg[1]\ : in STD_LOGIC;
    storage_v_r : in STD_LOGIC;
    in_frame_r : in STD_LOGIC;
    \word_aligned_data_r_reg[8]_0\ : in STD_LOGIC_VECTOR ( 7 downto 0 );
    \word_aligned_data_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 7 downto 0 )
  );
end aurora_8b10b_x1_16b_SYM_DEC;

architecture STRUCTURE of aurora_8b10b_x1_16b_SYM_DEC is
  signal \EXP_IN_inferred__0/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__1/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__14/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__15/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__16/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__17/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__18/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__19/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__2/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__20/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__21/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__22/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__23/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__25/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__29/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__30/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__4/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__6/i__n_0\ : STD_LOGIC;
  signal \EXP_IN_inferred__7/i__n_0\ : STD_LOGIC;
  signal EXP_IN_n_0 : STD_LOGIC;
  signal RX_CC_Buffer_i_1_n_0 : STD_LOGIC;
  signal RX_ECP_Buffer0 : STD_LOGIC;
  signal \^rx_ecp_buffer_reg_0\ : STD_LOGIC;
  signal RX_NEG_Buffer0 : STD_LOGIC;
  signal \^rx_pe_data_buffer_reg[0]_0\ : STD_LOGIC_VECTOR ( 15 downto 0 );
  signal RX_PE_DATA_V_Buffer_i_1_n_0 : STD_LOGIC;
  signal RX_SCP_Buffer0 : STD_LOGIC;
  signal RX_SNF_Buffer : STD_LOGIC;
  signal RX_SNF_Buffer0 : STD_LOGIC;
  signal RX_SPA_Buffer0 : STD_LOGIC;
  signal RX_SUF_Buffer0 : STD_LOGIC;
  signal \^rx_suf_buffer_reg_0\ : STD_LOGIC;
  signal \^first_v_received_r\ : STD_LOGIC;
  signal first_v_received_r_i_1_n_0 : STD_LOGIC;
  signal got_v_c : STD_LOGIC;
  signal p_0_in : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal p_0_in9_in : STD_LOGIC;
  signal p_16_in : STD_LOGIC;
  signal p_19_in : STD_LOGIC;
  signal p_1_in : STD_LOGIC;
  signal p_2_in : STD_LOGIC;
  signal p_4_out : STD_LOGIC_VECTOR ( 3 downto 2 );
  signal prev_beat_sp_r : STD_LOGIC;
  signal prev_beat_spa_r : STD_LOGIC;
  signal prev_beat_v_d_r : STD_LOGIC_VECTOR ( 0 to 0 );
  signal prev_beat_v_r : STD_LOGIC;
  signal rx_cc_r : STD_LOGIC_VECTOR ( 1 to 3 );
  signal \rx_ecp_d_r_reg_n_0_[2]\ : STD_LOGIC;
  signal \rx_ecp_d_r_reg_n_0_[3]\ : STD_LOGIC;
  signal rx_pad_d_r : STD_LOGIC_VECTOR ( 0 to 1 );
  signal \rx_pe_control_r_reg_n_0_[1]\ : STD_LOGIC;
  signal rx_pe_data_r : STD_LOGIC_VECTOR ( 0 to 15 );
  signal \rx_scp_d_r_reg_n_0_[3]\ : STD_LOGIC;
  signal rx_scp_i : STD_LOGIC;
  signal \rx_snf_d_r_reg_n_0_[0]\ : STD_LOGIC;
  signal \rx_snf_d_r_reg_n_0_[1]\ : STD_LOGIC;
  signal rx_sp_c : STD_LOGIC;
  signal rx_sp_d_r : STD_LOGIC_VECTOR ( 0 to 3 );
  signal rx_sp_i : STD_LOGIC;
  signal rx_sp_neg_d_r : STD_LOGIC_VECTOR ( 0 to 1 );
  signal rx_spa_d_r : STD_LOGIC_VECTOR ( 0 to 2 );
  signal rx_spa_i : STD_LOGIC;
  signal rx_spa_neg_d_r : STD_LOGIC_VECTOR ( 0 to 1 );
  signal \rx_spa_neg_d_r[0]_i_1_n_0\ : STD_LOGIC;
  signal \rx_suf_d_r_reg_n_0_[0]\ : STD_LOGIC;
  signal rx_v_d_r : STD_LOGIC_VECTOR ( 0 to 3 );
  signal std_bool10_in : STD_LOGIC;
  signal std_bool11_out : STD_LOGIC;
  signal std_bool12_out : STD_LOGIC;
  signal std_bool13_out : STD_LOGIC;
  signal std_bool27_out : STD_LOGIC;
  signal std_bool3_out : STD_LOGIC;
  signal std_bool4_in : STD_LOGIC;
  signal std_bool7_in : STD_LOGIC;
  signal std_bool9_out : STD_LOGIC;
  signal word_aligned_control_bits_r : STD_LOGIC_VECTOR ( 0 to 1 );
  signal \word_aligned_data_r_reg_n_0_[0]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[12]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[13]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[14]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[15]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[2]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[3]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[4]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[5]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[6]\ : STD_LOGIC;
  signal \word_aligned_data_r_reg_n_0_[7]\ : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of EXP_IN : label is "soft_lutpair12";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__0/i_\ : label is "soft_lutpair16";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__1/i_\ : label is "soft_lutpair19";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__10/i_\ : label is "soft_lutpair12";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__11/i_\ : label is "soft_lutpair17";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__12/i_\ : label is "soft_lutpair11";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__14/i_\ : label is "soft_lutpair14";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__15/i_\ : label is "soft_lutpair17";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__16/i_\ : label is "soft_lutpair20";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__17/i_\ : label is "soft_lutpair14";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__18/i_\ : label is "soft_lutpair21";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__19/i_\ : label is "soft_lutpair22";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__2/i_\ : label is "soft_lutpair18";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__20/i_\ : label is "soft_lutpair22";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__21/i_\ : label is "soft_lutpair23";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__23/i_\ : label is "soft_lutpair23";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__25/i_\ : label is "soft_lutpair15";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__29/i_\ : label is "soft_lutpair15";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__3/i_\ : label is "soft_lutpair20";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__4/i_\ : label is "soft_lutpair21";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__6/i_\ : label is "soft_lutpair13";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__7/i_\ : label is "soft_lutpair16";
  attribute SOFT_HLUTNM of \EXP_IN_inferred__9/i_\ : label is "soft_lutpair13";
  attribute SOFT_HLUTNM of FRAME_ERR_Buffer_i_1 : label is "soft_lutpair10";
  attribute SOFT_HLUTNM of M_AXI_RX_SNF_INST_0 : label is "soft_lutpair26";
  attribute SOFT_HLUTNM of RX_PAD_Buffer_i_1 : label is "soft_lutpair24";
  attribute SOFT_HLUTNM of RX_PE_DATA_V_Buffer_i_1 : label is "soft_lutpair25";
  attribute SOFT_HLUTNM of RX_SNF_Buffer_i_1 : label is "soft_lutpair25";
  attribute SOFT_HLUTNM of RX_SP_Buffer_i_2 : label is "soft_lutpair24";
  attribute SOFT_HLUTNM of first_v_received_r_i_1 : label is "soft_lutpair26";
  attribute SOFT_HLUTNM of \in_frame_r_i_1__0\ : label is "soft_lutpair10";
  attribute SOFT_HLUTNM of \rx_sp_d_r[0]_i_1\ : label is "soft_lutpair18";
  attribute SOFT_HLUTNM of \rx_sp_d_r[1]_i_1\ : label is "soft_lutpair19";
  attribute SOFT_HLUTNM of \rx_spa_neg_d_r[0]_i_1\ : label is "soft_lutpair11";
  attribute SOFT_HLUTNM of \ufc_count_r[2]_i_1\ : label is "soft_lutpair9";
  attribute SOFT_HLUTNM of \ufc_count_r[3]_i_1\ : label is "soft_lutpair9";
begin
  RX_ECP_Buffer_reg_0 <= \^rx_ecp_buffer_reg_0\;
  \RX_PE_DATA_Buffer_reg[0]_0\(15 downto 0) <= \^rx_pe_data_buffer_reg[0]_0\(15 downto 0);
  RX_SUF_Buffer_reg_0 <= \^rx_suf_buffer_reg_0\;
  first_v_received_r <= \^first_v_received_r\;
EXP_IN: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0010"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[13]\,
      I1 => \word_aligned_data_r_reg_n_0_[14]\,
      I2 => \word_aligned_data_r_reg_n_0_[12]\,
      I3 => \word_aligned_data_r_reg_n_0_[15]\,
      O => EXP_IN_n_0
    );
\EXP_IN_inferred__0/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => p_0_in(0),
      I1 => p_0_in(2),
      I2 => p_0_in(3),
      I3 => p_0_in(1),
      O => \EXP_IN_inferred__0/i__n_0\
    );
\EXP_IN_inferred__1/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0010"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[5]\,
      I1 => \word_aligned_data_r_reg_n_0_[6]\,
      I2 => \word_aligned_data_r_reg_n_0_[4]\,
      I3 => \word_aligned_data_r_reg_n_0_[7]\,
      O => \EXP_IN_inferred__1/i__n_0\
    );
\EXP_IN_inferred__10/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1008"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[15]\,
      I1 => \word_aligned_data_r_reg_n_0_[13]\,
      I2 => \word_aligned_data_r_reg_n_0_[14]\,
      I3 => \word_aligned_data_r_reg_n_0_[12]\,
      O => std_bool9_out
    );
\EXP_IN_inferred__11/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => p_0_in(2),
      I1 => p_0_in(3),
      I2 => p_0_in(1),
      I3 => p_0_in(0),
      O => std_bool10_in
    );
\EXP_IN_inferred__12/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0180"
    )
        port map (
      I0 => p_0_in(0),
      I1 => p_0_in(1),
      I2 => p_0_in(3),
      I3 => p_0_in(2),
      O => std_bool12_out
    );
\EXP_IN_inferred__14/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[13]\,
      I1 => \word_aligned_data_r_reg_n_0_[12]\,
      I2 => \word_aligned_data_r_reg_n_0_[14]\,
      I3 => \word_aligned_data_r_reg_n_0_[15]\,
      O => \EXP_IN_inferred__14/i__n_0\
    );
\EXP_IN_inferred__15/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"8000"
    )
        port map (
      I0 => p_0_in(1),
      I1 => p_0_in(0),
      I2 => p_0_in(2),
      I3 => p_0_in(3),
      O => \EXP_IN_inferred__15/i__n_0\
    );
\EXP_IN_inferred__16/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[0]\,
      I1 => \word_aligned_data_r_reg_n_0_[2]\,
      I2 => \word_aligned_data_r_reg_n_0_[1]\,
      I3 => \word_aligned_data_r_reg_n_0_[3]\,
      O => \EXP_IN_inferred__16/i__n_0\
    );
\EXP_IN_inferred__17/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[15]\,
      I1 => \word_aligned_data_r_reg_n_0_[13]\,
      I2 => \word_aligned_data_r_reg_n_0_[12]\,
      I3 => \word_aligned_data_r_reg_n_0_[14]\,
      O => \EXP_IN_inferred__17/i__n_0\
    );
\EXP_IN_inferred__18/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[6]\,
      I1 => \word_aligned_data_r_reg_n_0_[5]\,
      I2 => \word_aligned_data_r_reg_n_0_[4]\,
      I3 => \word_aligned_data_r_reg_n_0_[7]\,
      O => \EXP_IN_inferred__18/i__n_0\
    );
\EXP_IN_inferred__19/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"8000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[2]\,
      I1 => \word_aligned_data_r_reg_n_0_[3]\,
      I2 => \word_aligned_data_r_reg_n_0_[1]\,
      I3 => \word_aligned_data_r_reg_n_0_[0]\,
      O => \EXP_IN_inferred__19/i__n_0\
    );
\EXP_IN_inferred__2/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[3]\,
      I1 => \word_aligned_data_r_reg_n_0_[1]\,
      I2 => \word_aligned_data_r_reg_n_0_[0]\,
      I3 => \word_aligned_data_r_reg_n_0_[2]\,
      O => \EXP_IN_inferred__2/i__n_0\
    );
\EXP_IN_inferred__20/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[2]\,
      I1 => \word_aligned_data_r_reg_n_0_[1]\,
      I2 => \word_aligned_data_r_reg_n_0_[0]\,
      I3 => \word_aligned_data_r_reg_n_0_[3]\,
      O => \EXP_IN_inferred__20/i__n_0\
    );
\EXP_IN_inferred__21/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[1]\,
      I1 => \word_aligned_data_r_reg_n_0_[2]\,
      I2 => \word_aligned_data_r_reg_n_0_[0]\,
      I3 => \word_aligned_data_r_reg_n_0_[3]\,
      O => \EXP_IN_inferred__21/i__n_0\
    );
\EXP_IN_inferred__22/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0010"
    )
        port map (
      I0 => p_0_in(2),
      I1 => p_0_in(3),
      I2 => p_0_in(1),
      I3 => p_0_in(0),
      O => \EXP_IN_inferred__22/i__n_0\
    );
\EXP_IN_inferred__23/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0010"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[1]\,
      I1 => \word_aligned_data_r_reg_n_0_[0]\,
      I2 => \word_aligned_data_r_reg_n_0_[2]\,
      I3 => \word_aligned_data_r_reg_n_0_[3]\,
      O => \EXP_IN_inferred__23/i__n_0\
    );
\EXP_IN_inferred__25/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[13]\,
      I1 => \word_aligned_data_r_reg_n_0_[12]\,
      I2 => \word_aligned_data_r_reg_n_0_[14]\,
      I3 => \word_aligned_data_r_reg_n_0_[15]\,
      O => \EXP_IN_inferred__25/i__n_0\
    );
\EXP_IN_inferred__29/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[12]\,
      I1 => \word_aligned_data_r_reg_n_0_[13]\,
      I2 => \word_aligned_data_r_reg_n_0_[14]\,
      I3 => \word_aligned_data_r_reg_n_0_[15]\,
      O => \EXP_IN_inferred__29/i__n_0\
    );
\EXP_IN_inferred__3/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[1]\,
      I1 => \word_aligned_data_r_reg_n_0_[0]\,
      I2 => \word_aligned_data_r_reg_n_0_[2]\,
      I3 => \word_aligned_data_r_reg_n_0_[3]\,
      O => std_bool4_in
    );
\EXP_IN_inferred__30/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"4000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[4]\,
      I1 => \word_aligned_data_r_reg_n_0_[5]\,
      I2 => \word_aligned_data_r_reg_n_0_[6]\,
      I3 => \word_aligned_data_r_reg_n_0_[7]\,
      O => \EXP_IN_inferred__30/i__n_0\
    );
\EXP_IN_inferred__4/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[6]\,
      I1 => \word_aligned_data_r_reg_n_0_[7]\,
      I2 => \word_aligned_data_r_reg_n_0_[5]\,
      I3 => \word_aligned_data_r_reg_n_0_[4]\,
      O => \EXP_IN_inferred__4/i__n_0\
    );
\EXP_IN_inferred__6/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[14]\,
      I1 => \word_aligned_data_r_reg_n_0_[15]\,
      I2 => \word_aligned_data_r_reg_n_0_[13]\,
      I3 => \word_aligned_data_r_reg_n_0_[12]\,
      O => \EXP_IN_inferred__6/i__n_0\
    );
\EXP_IN_inferred__7/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1000"
    )
        port map (
      I0 => p_0_in(2),
      I1 => p_0_in(1),
      I2 => p_0_in(3),
      I3 => p_0_in(0),
      O => \EXP_IN_inferred__7/i__n_0\
    );
\EXP_IN_inferred__9/i_\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1000"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[12]\,
      I1 => \word_aligned_data_r_reg_n_0_[14]\,
      I2 => \word_aligned_data_r_reg_n_0_[13]\,
      I3 => \word_aligned_data_r_reg_n_0_[15]\,
      O => std_bool7_in
    );
FRAME_ERR_Buffer_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"F2AA"
    )
        port map (
      I0 => \^rx_ecp_buffer_reg_0\,
      I1 => storage_v_r,
      I2 => rx_scp_i,
      I3 => in_frame_r,
      O => FRAME_ERR_Buffer0
    );
GOT_V_Buffer_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => prev_beat_v_r,
      I1 => rx_v_d_r(0),
      I2 => rx_v_d_r(1),
      I3 => rx_v_d_r(3),
      I4 => rx_v_d_r(2),
      I5 => p_0_in9_in,
      O => got_v_c
    );
GOT_V_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => got_v_c,
      Q => got_v_i,
      R => '0'
    );
M_AXI_RX_SNF_INST_0: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => RX_SNF_Buffer,
      I1 => \^first_v_received_r\,
      O => M_AXI_RX_SNF
    );
RX_CC_Buffer_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => p_2_in,
      I1 => \rx_pe_control_r_reg_n_0_[1]\,
      I2 => \rx_ecp_d_r_reg_n_0_[2]\,
      I3 => rx_cc_r(3),
      I4 => rx_cc_r(1),
      I5 => p_16_in,
      O => RX_CC_Buffer_i_1_n_0
    );
RX_CC_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_CC_Buffer_i_1_n_0,
      Q => D(0),
      R => '0'
    );
RX_ECP_Buffer_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => \rx_pe_control_r_reg_n_0_[1]\,
      I1 => p_2_in,
      I2 => p_1_in,
      I3 => p_16_in,
      I4 => \rx_ecp_d_r_reg_n_0_[3]\,
      I5 => \rx_ecp_d_r_reg_n_0_[2]\,
      O => RX_ECP_Buffer0
    );
RX_ECP_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_ECP_Buffer0,
      Q => \^rx_ecp_buffer_reg_0\,
      R => '0'
    );
RX_EOF_N_Buffer_i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^rx_ecp_buffer_reg_0\,
      O => RX_ECP_Buffer_reg_1
    );
\RX_FC_NB_Buffer_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(8),
      Q => \^rx_pe_data_buffer_reg[0]_0\(7),
      R => '0'
    );
\RX_FC_NB_Buffer_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(9),
      Q => \^rx_pe_data_buffer_reg[0]_0\(6),
      R => '0'
    );
\RX_FC_NB_Buffer_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(10),
      Q => \^rx_pe_data_buffer_reg[0]_0\(5),
      R => '0'
    );
\RX_FC_NB_Buffer_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(11),
      Q => \^rx_pe_data_buffer_reg[0]_0\(4),
      R => '0'
    );
RX_NEG_Buffer_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"0000F888"
    )
        port map (
      I0 => rx_spa_neg_d_r(1),
      I1 => rx_spa_neg_d_r(0),
      I2 => rx_sp_neg_d_r(1),
      I3 => rx_sp_neg_d_r(0),
      I4 => \rx_pe_control_r_reg_n_0_[1]\,
      O => RX_NEG_Buffer0
    );
RX_NEG_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_NEG_Buffer0,
      Q => RX_NEG_Buffer,
      R => '0'
    );
RX_PAD_Buffer_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0800"
    )
        port map (
      I0 => rx_pad_d_r(0),
      I1 => rx_pad_d_r(1),
      I2 => p_2_in,
      I3 => \rx_pe_control_r_reg_n_0_[1]\,
      O => std_bool27_out
    );
RX_PAD_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool27_out,
      Q => rx_pad_i,
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(0),
      Q => \^rx_pe_data_buffer_reg[0]_0\(15),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(12),
      Q => \^rx_pe_data_buffer_reg[0]_0\(3),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(13),
      Q => \^rx_pe_data_buffer_reg[0]_0\(2),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(14),
      Q => \^rx_pe_data_buffer_reg[0]_0\(1),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(15),
      Q => \^rx_pe_data_buffer_reg[0]_0\(0),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(1),
      Q => \^rx_pe_data_buffer_reg[0]_0\(14),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(2),
      Q => \^rx_pe_data_buffer_reg[0]_0\(13),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(3),
      Q => \^rx_pe_data_buffer_reg[0]_0\(12),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(4),
      Q => \^rx_pe_data_buffer_reg[0]_0\(11),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(5),
      Q => \^rx_pe_data_buffer_reg[0]_0\(10),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(6),
      Q => \^rx_pe_data_buffer_reg[0]_0\(9),
      R => '0'
    );
\RX_PE_DATA_Buffer_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_pe_data_r(7),
      Q => \^rx_pe_data_buffer_reg[0]_0\(8),
      R => '0'
    );
RX_PE_DATA_V_Buffer_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"01"
    )
        port map (
      I0 => got_v_c,
      I1 => rx_sp_c,
      I2 => p_2_in,
      O => RX_PE_DATA_V_Buffer_i_1_n_0
    );
RX_PE_DATA_V_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_PE_DATA_V_Buffer_i_1_n_0,
      Q => rx_pe_data_v_i,
      R => '0'
    );
RX_SCP_Buffer_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => \rx_pe_control_r_reg_n_0_[1]\,
      I1 => p_2_in,
      I2 => \rx_snf_d_r_reg_n_0_[1]\,
      I3 => p_19_in,
      I4 => \rx_scp_d_r_reg_n_0_[3]\,
      I5 => \rx_ecp_d_r_reg_n_0_[2]\,
      O => RX_SCP_Buffer0
    );
RX_SCP_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_SCP_Buffer0,
      Q => rx_scp_i,
      R => '0'
    );
RX_SNF_Buffer_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"80"
    )
        port map (
      I0 => p_2_in,
      I1 => \rx_snf_d_r_reg_n_0_[0]\,
      I2 => \rx_snf_d_r_reg_n_0_[1]\,
      O => RX_SNF_Buffer0
    );
RX_SNF_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_SNF_Buffer0,
      Q => RX_SNF_Buffer,
      R => '0'
    );
RX_SPA_Buffer_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => prev_beat_spa_r,
      I1 => rx_spa_d_r(0),
      I2 => \rx_snf_d_r_reg_n_0_[1]\,
      I3 => rx_pad_d_r(1),
      I4 => rx_spa_d_r(2),
      I5 => p_0_in9_in,
      O => RX_SPA_Buffer0
    );
RX_SPA_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_SPA_Buffer0,
      Q => rx_spa_i,
      R => '0'
    );
RX_SP_Buffer_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => prev_beat_sp_r,
      I1 => rx_sp_d_r(0),
      I2 => rx_sp_d_r(1),
      I3 => rx_sp_d_r(3),
      I4 => rx_sp_d_r(2),
      I5 => p_0_in9_in,
      O => rx_sp_c
    );
RX_SP_Buffer_i_2: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \rx_pe_control_r_reg_n_0_[1]\,
      I1 => p_2_in,
      O => p_0_in9_in
    );
RX_SP_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_sp_c,
      Q => rx_sp_i,
      R => '0'
    );
RX_SUF_Buffer_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"80"
    )
        port map (
      I0 => p_2_in,
      I1 => \rx_suf_d_r_reg_n_0_[0]\,
      I2 => \rx_snf_d_r_reg_n_0_[1]\,
      O => RX_SUF_Buffer0
    );
RX_SUF_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => RX_SUF_Buffer0,
      Q => \^rx_suf_buffer_reg_0\,
      R => '0'
    );
\counter3_r_reg[2]_srl3_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => rx_spa_i,
      I1 => ack_r,
      O => counter3_r0
    );
\counter4_r_reg[14]_srl15_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => rx_sp_i,
      I1 => D_0,
      O => counter4_r0
    );
first_v_received_r_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => got_v_c,
      I1 => \^first_v_received_r\,
      O => first_v_received_r_i_1_n_0
    );
first_v_received_r_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => first_v_received_r_i_1_n_0,
      Q => \^first_v_received_r\,
      R => SR(0)
    );
\in_frame_r_i_1__0\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"BA"
    )
        port map (
      I0 => rx_scp_i,
      I1 => \^rx_ecp_buffer_reg_0\,
      I2 => in_frame_r,
      O => RX_SCP_Buffer_reg_0
    );
left_aligned_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => left_aligned_r_reg_1,
      Q => left_aligned_r_reg_0,
      R => SR(0)
    );
prev_beat_sp_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"4000000000000000"
    )
        port map (
      I0 => \rx_pe_control_r_reg_n_0_[1]\,
      I1 => p_2_in,
      I2 => rx_sp_d_r(2),
      I3 => rx_sp_d_r(3),
      I4 => \rx_snf_d_r_reg_n_0_[1]\,
      I5 => prev_beat_v_d_r(0),
      O => std_bool13_out
    );
prev_beat_sp_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool13_out,
      Q => prev_beat_sp_r,
      R => '0'
    );
prev_beat_spa_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"4000000000000000"
    )
        port map (
      I0 => \rx_pe_control_r_reg_n_0_[1]\,
      I1 => p_2_in,
      I2 => rx_spa_d_r(2),
      I3 => rx_pad_d_r(1),
      I4 => \rx_snf_d_r_reg_n_0_[1]\,
      I5 => prev_beat_v_d_r(0),
      O => std_bool11_out
    );
prev_beat_spa_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool11_out,
      Q => prev_beat_spa_r,
      R => '0'
    );
\prev_beat_v_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool4_in,
      Q => prev_beat_v_d_r(0),
      R => '0'
    );
prev_beat_v_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"4000000000000000"
    )
        port map (
      I0 => \rx_pe_control_r_reg_n_0_[1]\,
      I1 => p_2_in,
      I2 => rx_v_d_r(2),
      I3 => rx_v_d_r(3),
      I4 => \rx_snf_d_r_reg_n_0_[1]\,
      I5 => prev_beat_v_d_r(0),
      O => std_bool3_out
    );
prev_beat_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool3_out,
      Q => prev_beat_v_r,
      R => '0'
    );
\rx_cc_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__30/i__n_0\,
      Q => rx_cc_r(1),
      R => '0'
    );
\rx_cc_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__29/i__n_0\,
      Q => rx_cc_r(3),
      R => '0'
    );
\rx_ecp_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__19/i__n_0\,
      Q => p_16_in,
      R => '0'
    );
\rx_ecp_d_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__18/i__n_0\,
      Q => p_1_in,
      R => '0'
    );
\rx_ecp_d_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__15/i__n_0\,
      Q => \rx_ecp_d_r_reg_n_0_[2]\,
      R => '0'
    );
\rx_ecp_d_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__17/i__n_0\,
      Q => \rx_ecp_d_r_reg_n_0_[3]\,
      R => '0'
    );
\rx_pad_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__7/i__n_0\,
      Q => rx_pad_d_r(0),
      R => '0'
    );
\rx_pad_d_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__6/i__n_0\,
      Q => rx_pad_d_r(1),
      R => '0'
    );
\rx_pe_control_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => word_aligned_control_bits_r(0),
      Q => p_2_in,
      R => '0'
    );
\rx_pe_control_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => word_aligned_control_bits_r(1),
      Q => \rx_pe_control_r_reg_n_0_[1]\,
      R => '0'
    );
\rx_pe_data_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[0]\,
      Q => rx_pe_data_r(0),
      R => '0'
    );
\rx_pe_data_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => p_0_in(1),
      Q => rx_pe_data_r(10),
      R => '0'
    );
\rx_pe_data_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => p_0_in(0),
      Q => rx_pe_data_r(11),
      R => '0'
    );
\rx_pe_data_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[12]\,
      Q => rx_pe_data_r(12),
      R => '0'
    );
\rx_pe_data_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[13]\,
      Q => rx_pe_data_r(13),
      R => '0'
    );
\rx_pe_data_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[14]\,
      Q => rx_pe_data_r(14),
      R => '0'
    );
\rx_pe_data_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[15]\,
      Q => rx_pe_data_r(15),
      R => '0'
    );
\rx_pe_data_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[1]\,
      Q => rx_pe_data_r(1),
      R => '0'
    );
\rx_pe_data_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[2]\,
      Q => rx_pe_data_r(2),
      R => '0'
    );
\rx_pe_data_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[3]\,
      Q => rx_pe_data_r(3),
      R => '0'
    );
\rx_pe_data_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[4]\,
      Q => rx_pe_data_r(4),
      R => '0'
    );
\rx_pe_data_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[5]\,
      Q => rx_pe_data_r(5),
      R => '0'
    );
\rx_pe_data_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[6]\,
      Q => rx_pe_data_r(6),
      R => '0'
    );
\rx_pe_data_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg_n_0_[7]\,
      Q => rx_pe_data_r(7),
      R => '0'
    );
\rx_pe_data_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => p_0_in(3),
      Q => rx_pe_data_r(8),
      R => '0'
    );
\rx_pe_data_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => p_0_in(2),
      Q => rx_pe_data_r(9),
      R => '0'
    );
\rx_scp_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__16/i__n_0\,
      Q => p_19_in,
      R => '0'
    );
\rx_scp_d_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__14/i__n_0\,
      Q => \rx_scp_d_r_reg_n_0_[3]\,
      R => '0'
    );
\rx_snf_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__20/i__n_0\,
      Q => \rx_snf_d_r_reg_n_0_[0]\,
      R => '0'
    );
\rx_snf_d_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__4/i__n_0\,
      Q => \rx_snf_d_r_reg_n_0_[1]\,
      R => '0'
    );
\rx_sp_d_r[0]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0180"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[3]\,
      I1 => \word_aligned_data_r_reg_n_0_[2]\,
      I2 => \word_aligned_data_r_reg_n_0_[0]\,
      I3 => \word_aligned_data_r_reg_n_0_[1]\,
      O => p_4_out(3)
    );
\rx_sp_d_r[1]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"1008"
    )
        port map (
      I0 => \word_aligned_data_r_reg_n_0_[5]\,
      I1 => \word_aligned_data_r_reg_n_0_[7]\,
      I2 => \word_aligned_data_r_reg_n_0_[6]\,
      I3 => \word_aligned_data_r_reg_n_0_[4]\,
      O => p_4_out(2)
    );
\rx_sp_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => p_4_out(3),
      Q => rx_sp_d_r(0),
      R => '0'
    );
\rx_sp_d_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => p_4_out(2),
      Q => rx_sp_d_r(1),
      R => '0'
    );
\rx_sp_d_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool12_out,
      Q => rx_sp_d_r(2),
      R => '0'
    );
\rx_sp_d_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool9_out,
      Q => rx_sp_d_r(3),
      R => '0'
    );
\rx_sp_neg_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool10_in,
      Q => rx_sp_neg_d_r(0),
      R => '0'
    );
\rx_sp_neg_d_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => std_bool7_in,
      Q => rx_sp_neg_d_r(1),
      R => '0'
    );
\rx_spa_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__23/i__n_0\,
      Q => rx_spa_d_r(0),
      R => '0'
    );
\rx_spa_d_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__22/i__n_0\,
      Q => rx_spa_d_r(2),
      R => '0'
    );
\rx_spa_neg_d_r[0]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"2000"
    )
        port map (
      I0 => p_0_in(2),
      I1 => p_0_in(1),
      I2 => p_0_in(3),
      I3 => p_0_in(0),
      O => \rx_spa_neg_d_r[0]_i_1_n_0\
    );
\rx_spa_neg_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \rx_spa_neg_d_r[0]_i_1_n_0\,
      Q => rx_spa_neg_d_r(0),
      R => '0'
    );
\rx_spa_neg_d_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__25/i__n_0\,
      Q => rx_spa_neg_d_r(1),
      R => '0'
    );
\rx_suf_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__21/i__n_0\,
      Q => \rx_suf_d_r_reg_n_0_[0]\,
      R => '0'
    );
\rx_v_d_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__2/i__n_0\,
      Q => rx_v_d_r(0),
      R => '0'
    );
\rx_v_d_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__1/i__n_0\,
      Q => rx_v_d_r(1),
      R => '0'
    );
\rx_v_d_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \EXP_IN_inferred__0/i__n_0\,
      Q => rx_v_d_r(2),
      R => '0'
    );
\rx_v_d_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => EXP_IN_n_0,
      Q => rx_v_d_r(3),
      R => '0'
    );
\ufc_count_r[0]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"80FF8000800080FF"
    )
        port map (
      I0 => \^rx_pe_data_buffer_reg[0]_0\(6),
      I1 => \^rx_pe_data_buffer_reg[0]_0\(7),
      I2 => \^rx_pe_data_buffer_reg[0]_0\(5),
      I3 => \^rx_suf_buffer_reg_0\,
      I4 => \ufc_count_r_reg[0]\,
      I5 => Q(3),
      O => \RX_FC_NB_Buffer_reg[1]_0\(3)
    );
\ufc_count_r[1]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"09F9F909F9F90909"
    )
        port map (
      I0 => Q(2),
      I1 => \ufc_count_r_reg[1]\,
      I2 => \^rx_suf_buffer_reg_0\,
      I3 => \^rx_pe_data_buffer_reg[0]_0\(5),
      I4 => \^rx_pe_data_buffer_reg[0]_0\(7),
      I5 => \^rx_pe_data_buffer_reg[0]_0\(6),
      O => \RX_FC_NB_Buffer_reg[1]_0\(2)
    );
\ufc_count_r[2]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"6F60606F"
    )
        port map (
      I0 => \^rx_pe_data_buffer_reg[0]_0\(5),
      I1 => \^rx_pe_data_buffer_reg[0]_0\(6),
      I2 => \^rx_suf_buffer_reg_0\,
      I3 => Q(0),
      I4 => Q(1),
      O => \RX_FC_NB_Buffer_reg[1]_0\(1)
    );
\ufc_count_r[3]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"47"
    )
        port map (
      I0 => \^rx_pe_data_buffer_reg[0]_0\(5),
      I1 => \^rx_suf_buffer_reg_0\,
      I2 => Q(0),
      O => \RX_FC_NB_Buffer_reg[1]_0\(0)
    );
\word_aligned_control_bits_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_control_bits_r_reg[0]_0\,
      Q => word_aligned_control_bits_r(0),
      R => '0'
    );
\word_aligned_control_bits_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_control_bits_r_reg[1]_0\,
      Q => word_aligned_control_bits_r(1),
      R => '0'
    );
\word_aligned_data_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(7),
      Q => \word_aligned_data_r_reg_n_0_[0]\,
      R => '0'
    );
\word_aligned_data_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(5),
      Q => p_0_in(1),
      R => '0'
    );
\word_aligned_data_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(4),
      Q => p_0_in(0),
      R => '0'
    );
\word_aligned_data_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(3),
      Q => \word_aligned_data_r_reg_n_0_[12]\,
      R => '0'
    );
\word_aligned_data_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(2),
      Q => \word_aligned_data_r_reg_n_0_[13]\,
      R => '0'
    );
\word_aligned_data_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(1),
      Q => \word_aligned_data_r_reg_n_0_[14]\,
      R => '0'
    );
\word_aligned_data_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(0),
      Q => \word_aligned_data_r_reg_n_0_[15]\,
      R => '0'
    );
\word_aligned_data_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(6),
      Q => \word_aligned_data_r_reg_n_0_[1]\,
      R => '0'
    );
\word_aligned_data_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(5),
      Q => \word_aligned_data_r_reg_n_0_[2]\,
      R => '0'
    );
\word_aligned_data_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(4),
      Q => \word_aligned_data_r_reg_n_0_[3]\,
      R => '0'
    );
\word_aligned_data_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(3),
      Q => \word_aligned_data_r_reg_n_0_[4]\,
      R => '0'
    );
\word_aligned_data_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(2),
      Q => \word_aligned_data_r_reg_n_0_[5]\,
      R => '0'
    );
\word_aligned_data_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(1),
      Q => \word_aligned_data_r_reg_n_0_[6]\,
      R => '0'
    );
\word_aligned_data_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[0]_0\(0),
      Q => \word_aligned_data_r_reg_n_0_[7]\,
      R => '0'
    );
\word_aligned_data_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(7),
      Q => p_0_in(3),
      R => '0'
    );
\word_aligned_data_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \word_aligned_data_r_reg[8]_0\(6),
      Q => p_0_in(2),
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_SYM_GEN is
  port (
    TXCHARISK : out STD_LOGIC_VECTOR ( 1 downto 0 );
    \gen_spa_data_r_reg[1]_0\ : out STD_LOGIC;
    TXDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    gen_spa_data_i : in STD_LOGIC_VECTOR ( 0 to 0 );
    user_clk : in STD_LOGIC;
    tx_pe_data_v_i : in STD_LOGIC;
    gen_k_i : in STD_LOGIC;
    gen_cc_i : in STD_LOGIC;
    gen_suf_i : in STD_LOGIC;
    gen_snf_i : in STD_LOGIC;
    gen_ecp_i : in STD_LOGIC;
    gen_scp_i : in STD_LOGIC;
    gen_pad_i : in STD_LOGIC;
    gen_a_i : in STD_LOGIC;
    ack_r : in STD_LOGIC;
    D : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \gen_v_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \gen_r_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \gen_k_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \tx_pe_data_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 15 downto 0 );
    \fc_nb_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 3 downto 0 )
  );
end aurora_8b10b_x1_16b_SYM_GEN;

architecture STRUCTURE of aurora_8b10b_x1_16b_SYM_GEN is
  signal \TX_CHAR_IS_K_Buffer[0]_i_2_n_0\ : STD_LOGIC;
  signal \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\ : STD_LOGIC;
  signal TX_CHAR_IS_K_Buffer_reg0 : STD_LOGIC;
  signal TX_CHAR_IS_K_Buffer_reg04_out : STD_LOGIC;
  signal \TX_DATA_Buffer[0]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[10]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[10]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[11]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[12]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[12]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[12]_i_3_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[13]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[13]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[13]_i_3_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[13]_i_4_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[13]_i_5_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[14]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[14]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[14]_i_3_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[14]_i_4_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_3_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_4_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_5_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_6_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_7_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_8_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[15]_i_9_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[1]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[2]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[2]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[3]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[4]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[4]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[5]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[5]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[5]_i_3_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[5]_i_4_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[6]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[6]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[6]_i_3_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[7]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[7]_i_3_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[7]_i_4_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[7]_i_5_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[8]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[8]_i_2_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[9]_i_1_n_0\ : STD_LOGIC;
  signal \TX_DATA_Buffer[9]_i_2_n_0\ : STD_LOGIC;
  signal TX_DATA_Buffer_reg0 : STD_LOGIC;
  signal data0 : STD_LOGIC_VECTOR ( 7 downto 0 );
  signal fc_nb_r : STD_LOGIC_VECTOR ( 0 to 3 );
  signal gen_a_r : STD_LOGIC;
  signal gen_cc_r : STD_LOGIC;
  signal gen_ecp_r : STD_LOGIC;
  signal gen_k_fsm_r : STD_LOGIC;
  signal \gen_k_r_reg_n_0_[1]\ : STD_LOGIC;
  signal gen_pad_r : STD_LOGIC;
  signal \gen_r_r_reg_n_0_[1]\ : STD_LOGIC;
  signal gen_scp_r : STD_LOGIC;
  signal gen_snf_r : STD_LOGIC;
  signal \gen_sp_data_r_reg_n_0_[1]\ : STD_LOGIC;
  signal \^gen_spa_data_r_reg[1]_0\ : STD_LOGIC;
  signal gen_suf_r : STD_LOGIC;
  signal p_0_in : STD_LOGIC;
  signal p_0_in1_in : STD_LOGIC;
  signal p_0_in4_in : STD_LOGIC;
  signal p_1_in : STD_LOGIC;
  signal p_2_in : STD_LOGIC;
  signal p_3_in : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[10]\ : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[11]\ : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[12]\ : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[13]\ : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[14]\ : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[15]\ : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[8]\ : STD_LOGIC;
  signal \tx_pe_data_r_reg_n_0_[9]\ : STD_LOGIC;
  signal tx_pe_data_v_r : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \TX_CHAR_IS_K_Buffer[0]_i_2\ : label is "soft_lutpair31";
  attribute SOFT_HLUTNM of \TX_CHAR_IS_K_Buffer[0]_i_3\ : label is "soft_lutpair33";
  attribute SOFT_HLUTNM of \TX_CHAR_IS_K_Buffer[1]_i_1\ : label is "soft_lutpair29";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[12]_i_2\ : label is "soft_lutpair29";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[12]_i_3\ : label is "soft_lutpair32";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[13]_i_2\ : label is "soft_lutpair27";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[13]_i_5\ : label is "soft_lutpair28";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[14]_i_3\ : label is "soft_lutpair30";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[14]_i_4\ : label is "soft_lutpair34";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[15]_i_3\ : label is "soft_lutpair34";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[15]_i_4\ : label is "soft_lutpair32";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[15]_i_6\ : label is "soft_lutpair27";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[15]_i_9\ : label is "soft_lutpair30";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[5]_i_2\ : label is "soft_lutpair33";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[6]_i_3\ : label is "soft_lutpair31";
  attribute SOFT_HLUTNM of \TX_DATA_Buffer[9]_i_2\ : label is "soft_lutpair28";
begin
  \gen_spa_data_r_reg[1]_0\ <= \^gen_spa_data_r_reg[1]_0\;
\TX_CHAR_IS_K_Buffer[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"CCCCCCCCCCCFCCCD"
    )
        port map (
      I0 => tx_pe_data_v_r,
      I1 => gen_cc_r,
      I2 => \TX_CHAR_IS_K_Buffer[0]_i_2_n_0\,
      I3 => \gen_sp_data_r_reg_n_0_[1]\,
      I4 => gen_pad_r,
      I5 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      O => TX_CHAR_IS_K_Buffer_reg0
    );
\TX_CHAR_IS_K_Buffer[0]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => p_3_in,
      I1 => \^gen_spa_data_r_reg[1]_0\,
      O => \TX_CHAR_IS_K_Buffer[0]_i_2_n_0\
    );
\TX_CHAR_IS_K_Buffer[0]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => gen_suf_r,
      I1 => gen_snf_r,
      O => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\
    );
\TX_CHAR_IS_K_Buffer[1]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFF0001"
    )
        port map (
      I0 => p_2_in,
      I1 => p_0_in1_in,
      I2 => p_1_in,
      I3 => tx_pe_data_v_r,
      I4 => gen_cc_r,
      O => TX_CHAR_IS_K_Buffer_reg04_out
    );
\TX_CHAR_IS_K_Buffer_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => TX_CHAR_IS_K_Buffer_reg0,
      Q => TXCHARISK(1),
      R => '0'
    );
\TX_CHAR_IS_K_Buffer_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => TX_CHAR_IS_K_Buffer_reg04_out,
      Q => TXCHARISK(0),
      R => '0'
    );
\TX_DATA_Buffer[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"AAAAAAAAFFAEAEAE"
    )
        port map (
      I0 => gen_scp_r,
      I1 => gen_cc_r,
      I2 => \TX_DATA_Buffer[15]_i_6_n_0\,
      I3 => \TX_DATA_Buffer[5]_i_2_n_0\,
      I4 => \tx_pe_data_r_reg_n_0_[15]\,
      I5 => gen_ecp_r,
      O => \TX_DATA_Buffer[0]_i_1_n_0\
    );
\TX_DATA_Buffer[10]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => gen_scp_r,
      I1 => gen_ecp_r,
      I2 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I3 => gen_k_fsm_r,
      I4 => gen_cc_r,
      I5 => \TX_DATA_Buffer[10]_i_2_n_0\,
      O => \TX_DATA_Buffer[10]_i_1_n_0\
    );
\TX_DATA_Buffer[10]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"CCCCCCCC00AA00FA"
    )
        port map (
      I0 => p_1_in,
      I1 => data0(2),
      I2 => \TX_DATA_Buffer[15]_i_7_n_0\,
      I3 => p_0_in1_in,
      I4 => p_2_in,
      I5 => tx_pe_data_v_r,
      O => \TX_DATA_Buffer[10]_i_2_n_0\
    );
\TX_DATA_Buffer[11]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFF0FFF0FFFFFFFD"
    )
        port map (
      I0 => tx_pe_data_v_r,
      I1 => data0(3),
      I2 => \TX_DATA_Buffer[15]_i_4_n_0\,
      I3 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I4 => gen_k_fsm_r,
      I5 => gen_cc_r,
      O => \TX_DATA_Buffer[11]_i_1_n_0\
    );
\TX_DATA_Buffer[12]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFF888"
    )
        port map (
      I0 => \TX_DATA_Buffer[12]_i_2_n_0\,
      I1 => \TX_DATA_Buffer[15]_i_7_n_0\,
      I2 => tx_pe_data_v_r,
      I3 => data0(4),
      I4 => \TX_DATA_Buffer[12]_i_3_n_0\,
      I5 => \TX_DATA_Buffer[15]_i_3_n_0\,
      O => \TX_DATA_Buffer[12]_i_1_n_0\
    );
\TX_DATA_Buffer[12]_i_2\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0001"
    )
        port map (
      I0 => tx_pe_data_v_r,
      I1 => p_1_in,
      I2 => p_0_in1_in,
      I3 => p_2_in,
      O => \TX_DATA_Buffer[12]_i_2_n_0\
    );
\TX_DATA_Buffer[12]_i_3\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFE"
    )
        port map (
      I0 => gen_scp_r,
      I1 => gen_ecp_r,
      I2 => gen_snf_r,
      I3 => gen_suf_r,
      O => \TX_DATA_Buffer[12]_i_3_n_0\
    );
\TX_DATA_Buffer[13]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFF4F44"
    )
        port map (
      I0 => p_0_in,
      I1 => \TX_DATA_Buffer[13]_i_2_n_0\,
      I2 => gen_scp_r,
      I3 => gen_ecp_r,
      I4 => \TX_DATA_Buffer[13]_i_3_n_0\,
      I5 => \TX_DATA_Buffer[13]_i_4_n_0\,
      O => \TX_DATA_Buffer[13]_i_1_n_0\
    );
\TX_DATA_Buffer[13]_i_2\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00000001"
    )
        port map (
      I0 => gen_scp_r,
      I1 => p_0_in1_in,
      I2 => tx_pe_data_v_r,
      I3 => gen_suf_r,
      I4 => gen_snf_r,
      O => \TX_DATA_Buffer[13]_i_2_n_0\
    );
\TX_DATA_Buffer[13]_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FF08FF08FF080808"
    )
        port map (
      I0 => data0(5),
      I1 => \TX_DATA_Buffer[13]_i_5_n_0\,
      I2 => gen_scp_r,
      I3 => \TX_DATA_Buffer[13]_i_2_n_0\,
      I4 => gen_a_r,
      I5 => p_0_in4_in,
      O => \TX_DATA_Buffer[13]_i_3_n_0\
    );
\TX_DATA_Buffer[13]_i_4\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFF1010FF101010"
    )
        port map (
      I0 => gen_scp_r,
      I1 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I2 => \TX_DATA_Buffer[15]_i_3_n_0\,
      I3 => p_1_in,
      I4 => \TX_DATA_Buffer[13]_i_2_n_0\,
      I5 => p_2_in,
      O => \TX_DATA_Buffer[13]_i_4_n_0\
    );
\TX_DATA_Buffer[13]_i_5\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"02"
    )
        port map (
      I0 => tx_pe_data_v_r,
      I1 => gen_snf_r,
      I2 => gen_suf_r,
      O => \TX_DATA_Buffer[13]_i_5_n_0\
    );
\TX_DATA_Buffer[14]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFAE"
    )
        port map (
      I0 => \TX_DATA_Buffer[14]_i_2_n_0\,
      I1 => gen_cc_r,
      I2 => gen_suf_r,
      I3 => gen_ecp_r,
      I4 => gen_scp_r,
      I5 => gen_snf_r,
      O => \TX_DATA_Buffer[14]_i_1_n_0\
    );
\TX_DATA_Buffer[14]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"CC00AA00CC00FA00"
    )
        port map (
      I0 => p_0_in1_in,
      I1 => data0(6),
      I2 => \TX_DATA_Buffer[14]_i_3_n_0\,
      I3 => \TX_DATA_Buffer[14]_i_4_n_0\,
      I4 => tx_pe_data_v_r,
      I5 => p_1_in,
      O => \TX_DATA_Buffer[14]_i_2_n_0\
    );
\TX_DATA_Buffer[14]_i_3\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFF1"
    )
        port map (
      I0 => p_0_in,
      I1 => p_0_in4_in,
      I2 => p_2_in,
      I3 => gen_a_r,
      O => \TX_DATA_Buffer[14]_i_3_n_0\
    );
\TX_DATA_Buffer[14]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => gen_k_fsm_r,
      I1 => gen_suf_r,
      O => \TX_DATA_Buffer[14]_i_4_n_0\
    );
\TX_DATA_Buffer[15]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => \TX_DATA_Buffer[15]_i_3_n_0\,
      I1 => \TX_DATA_Buffer[15]_i_4_n_0\,
      I2 => \TX_DATA_Buffer[15]_i_5_n_0\,
      I3 => \TX_DATA_Buffer[15]_i_6_n_0\,
      I4 => p_1_in,
      I5 => \TX_DATA_Buffer[15]_i_7_n_0\,
      O => \TX_DATA_Buffer[15]_i_1_n_0\
    );
\TX_DATA_Buffer[15]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"AAAAFFFFAAAAFFFE"
    )
        port map (
      I0 => \TX_DATA_Buffer[15]_i_8_n_0\,
      I1 => gen_cc_r,
      I2 => gen_k_fsm_r,
      I3 => gen_ecp_r,
      I4 => gen_scp_r,
      I5 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      O => \TX_DATA_Buffer[15]_i_2_n_0\
    );
\TX_DATA_Buffer[15]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => gen_k_fsm_r,
      I1 => gen_cc_r,
      O => \TX_DATA_Buffer[15]_i_3_n_0\
    );
\TX_DATA_Buffer[15]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => gen_ecp_r,
      I1 => gen_scp_r,
      O => \TX_DATA_Buffer[15]_i_4_n_0\
    );
\TX_DATA_Buffer[15]_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => p_2_in,
      I1 => p_0_in1_in,
      O => \TX_DATA_Buffer[15]_i_5_n_0\
    );
\TX_DATA_Buffer[15]_i_6\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FE"
    )
        port map (
      I0 => gen_snf_r,
      I1 => gen_suf_r,
      I2 => tx_pe_data_v_r,
      O => \TX_DATA_Buffer[15]_i_6_n_0\
    );
\TX_DATA_Buffer[15]_i_7\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FE"
    )
        port map (
      I0 => p_0_in4_in,
      I1 => gen_a_r,
      I2 => p_0_in,
      O => \TX_DATA_Buffer[15]_i_7_n_0\
    );
\TX_DATA_Buffer[15]_i_8\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0A0A00000A0A000C"
    )
        port map (
      I0 => data0(7),
      I1 => \TX_DATA_Buffer[15]_i_9_n_0\,
      I2 => gen_scp_r,
      I3 => p_0_in1_in,
      I4 => tx_pe_data_v_r,
      I5 => p_1_in,
      O => \TX_DATA_Buffer[15]_i_8_n_0\
    );
\TX_DATA_Buffer[15]_i_9\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FF45"
    )
        port map (
      I0 => gen_a_r,
      I1 => p_0_in4_in,
      I2 => p_0_in,
      I3 => p_2_in,
      O => \TX_DATA_Buffer[15]_i_9_n_0\
    );
\TX_DATA_Buffer[1]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"F0F0F0F0F2F2FFF0"
    )
        port map (
      I0 => \tx_pe_data_r_reg_n_0_[14]\,
      I1 => gen_pad_r,
      I2 => \TX_DATA_Buffer[5]_i_3_n_0\,
      I3 => \gen_sp_data_r_reg_n_0_[1]\,
      I4 => tx_pe_data_v_r,
      I5 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      O => \TX_DATA_Buffer[1]_i_1_n_0\
    );
\TX_DATA_Buffer[2]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"AAAAAFAAAAAAAEAA"
    )
        port map (
      I0 => \TX_DATA_Buffer[2]_i_2_n_0\,
      I1 => gen_pad_r,
      I2 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I3 => tx_pe_data_v_r,
      I4 => gen_scp_r,
      I5 => \tx_pe_data_r_reg_n_0_[13]\,
      O => \TX_DATA_Buffer[2]_i_1_n_0\
    );
\TX_DATA_Buffer[2]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00000000AAAAEEFE"
    )
        port map (
      I0 => gen_ecp_r,
      I1 => gen_cc_r,
      I2 => \TX_DATA_Buffer[6]_i_3_n_0\,
      I3 => \gen_sp_data_r_reg_n_0_[1]\,
      I4 => \TX_DATA_Buffer[15]_i_6_n_0\,
      I5 => gen_scp_r,
      O => \TX_DATA_Buffer[2]_i_2_n_0\
    );
\TX_DATA_Buffer[3]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"F0FFF0F5F0FCF0F5"
    )
        port map (
      I0 => gen_cc_r,
      I1 => \tx_pe_data_r_reg_n_0_[12]\,
      I2 => \TX_DATA_Buffer[15]_i_4_n_0\,
      I3 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I4 => tx_pe_data_v_r,
      I5 => gen_pad_r,
      O => \TX_DATA_Buffer[3]_i_1_n_0\
    );
\TX_DATA_Buffer[4]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFD888"
    )
        port map (
      I0 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I1 => fc_nb_r(3),
      I2 => \tx_pe_data_r_reg_n_0_[11]\,
      I3 => tx_pe_data_v_r,
      I4 => \TX_DATA_Buffer[4]_i_2_n_0\,
      I5 => \TX_DATA_Buffer[7]_i_5_n_0\,
      O => \TX_DATA_Buffer[4]_i_1_n_0\
    );
\TX_DATA_Buffer[4]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"000000000000000E"
    )
        port map (
      I0 => \gen_r_r_reg_n_0_[1]\,
      I1 => \gen_k_r_reg_n_0_[1]\,
      I2 => \TX_DATA_Buffer[15]_i_6_n_0\,
      I3 => \gen_sp_data_r_reg_n_0_[1]\,
      I4 => p_3_in,
      I5 => \^gen_spa_data_r_reg[1]_0\,
      O => \TX_DATA_Buffer[4]_i_2_n_0\
    );
\TX_DATA_Buffer[5]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFF888"
    )
        port map (
      I0 => fc_nb_r(2),
      I1 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I2 => \tx_pe_data_r_reg_n_0_[10]\,
      I3 => \TX_DATA_Buffer[5]_i_2_n_0\,
      I4 => \TX_DATA_Buffer[5]_i_3_n_0\,
      I5 => \TX_DATA_Buffer[5]_i_4_n_0\,
      O => \TX_DATA_Buffer[5]_i_1_n_0\
    );
\TX_DATA_Buffer[5]_i_2\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0010"
    )
        port map (
      I0 => gen_suf_r,
      I1 => gen_snf_r,
      I2 => tx_pe_data_v_r,
      I3 => gen_pad_r,
      O => \TX_DATA_Buffer[5]_i_2_n_0\
    );
\TX_DATA_Buffer[5]_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFF0100"
    )
        port map (
      I0 => gen_snf_r,
      I1 => gen_suf_r,
      I2 => tx_pe_data_v_r,
      I3 => gen_cc_r,
      I4 => gen_scp_r,
      I5 => gen_ecp_r,
      O => \TX_DATA_Buffer[5]_i_3_n_0\
    );
\TX_DATA_Buffer[5]_i_4\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"000F000F000F000B"
    )
        port map (
      I0 => \gen_k_r_reg_n_0_[1]\,
      I1 => \gen_r_r_reg_n_0_[1]\,
      I2 => \TX_DATA_Buffer[15]_i_6_n_0\,
      I3 => \gen_sp_data_r_reg_n_0_[1]\,
      I4 => p_3_in,
      I5 => \^gen_spa_data_r_reg[1]_0\,
      O => \TX_DATA_Buffer[5]_i_4_n_0\
    );
\TX_DATA_Buffer[6]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFBBFFFFFFBA"
    )
        port map (
      I0 => \TX_DATA_Buffer[6]_i_2_n_0\,
      I1 => \TX_DATA_Buffer[15]_i_6_n_0\,
      I2 => gen_cc_r,
      I3 => gen_scp_r,
      I4 => gen_ecp_r,
      I5 => \gen_sp_data_r_reg_n_0_[1]\,
      O => \TX_DATA_Buffer[6]_i_1_n_0\
    );
\TX_DATA_Buffer[6]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFF000040734073"
    )
        port map (
      I0 => gen_pad_r,
      I1 => tx_pe_data_v_r,
      I2 => \tx_pe_data_r_reg_n_0_[9]\,
      I3 => \TX_DATA_Buffer[6]_i_3_n_0\,
      I4 => fc_nb_r(1),
      I5 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      O => \TX_DATA_Buffer[6]_i_2_n_0\
    );
\TX_DATA_Buffer[6]_i_3\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"AAFE"
    )
        port map (
      I0 => \^gen_spa_data_r_reg[1]_0\,
      I1 => \gen_k_r_reg_n_0_[1]\,
      I2 => \gen_r_r_reg_n_0_[1]\,
      I3 => p_3_in,
      O => \TX_DATA_Buffer[6]_i_3_n_0\
    );
\TX_DATA_Buffer[7]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => \TX_DATA_Buffer[7]_i_3_n_0\,
      I1 => \gen_k_r_reg_n_0_[1]\,
      I2 => \gen_r_r_reg_n_0_[1]\,
      I3 => gen_ecp_r,
      I4 => gen_scp_r,
      I5 => gen_cc_r,
      O => TX_DATA_Buffer_reg0
    );
\TX_DATA_Buffer[7]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFB888"
    )
        port map (
      I0 => fc_nb_r(0),
      I1 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I2 => tx_pe_data_v_r,
      I3 => \tx_pe_data_r_reg_n_0_[8]\,
      I4 => \TX_DATA_Buffer[7]_i_4_n_0\,
      I5 => \TX_DATA_Buffer[7]_i_5_n_0\,
      O => \TX_DATA_Buffer[7]_i_2_n_0\
    );
\TX_DATA_Buffer[7]_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => \^gen_spa_data_r_reg[1]_0\,
      I1 => p_3_in,
      I2 => \gen_sp_data_r_reg_n_0_[1]\,
      I3 => gen_snf_r,
      I4 => gen_suf_r,
      I5 => tx_pe_data_v_r,
      O => \TX_DATA_Buffer[7]_i_3_n_0\
    );
\TX_DATA_Buffer[7]_i_4\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000005551"
    )
        port map (
      I0 => \^gen_spa_data_r_reg[1]_0\,
      I1 => \gen_r_r_reg_n_0_[1]\,
      I2 => \gen_k_r_reg_n_0_[1]\,
      I3 => p_3_in,
      I4 => \gen_sp_data_r_reg_n_0_[1]\,
      I5 => \TX_DATA_Buffer[15]_i_6_n_0\,
      O => \TX_DATA_Buffer[7]_i_4_n_0\
    );
\TX_DATA_Buffer[7]_i_5\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FCFCFCFCFEFEFFFC"
    )
        port map (
      I0 => gen_pad_r,
      I1 => gen_ecp_r,
      I2 => gen_scp_r,
      I3 => gen_cc_r,
      I4 => tx_pe_data_v_r,
      I5 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      O => \TX_DATA_Buffer[7]_i_5_n_0\
    );
\TX_DATA_Buffer[8]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FF00FFFFFF00FF02"
    )
        port map (
      I0 => gen_cc_r,
      I1 => gen_snf_r,
      I2 => gen_suf_r,
      I3 => \TX_DATA_Buffer[8]_i_2_n_0\,
      I4 => gen_scp_r,
      I5 => gen_ecp_r,
      O => \TX_DATA_Buffer[8]_i_1_n_0\
    );
\TX_DATA_Buffer[8]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000000400"
    )
        port map (
      I0 => gen_k_fsm_r,
      I1 => data0(0),
      I2 => gen_scp_r,
      I3 => tx_pe_data_v_r,
      I4 => gen_snf_r,
      I5 => gen_suf_r,
      O => \TX_DATA_Buffer[8]_i_2_n_0\
    );
\TX_DATA_Buffer[9]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0002000F00020002"
    )
        port map (
      I0 => \TX_DATA_Buffer[9]_i_2_n_0\,
      I1 => gen_k_fsm_r,
      I2 => gen_scp_r,
      I3 => gen_ecp_r,
      I4 => \TX_CHAR_IS_K_Buffer[0]_i_3_n_0\,
      I5 => gen_cc_r,
      O => \TX_DATA_Buffer[9]_i_1_n_0\
    );
\TX_DATA_Buffer[9]_i_2\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"02030200"
    )
        port map (
      I0 => data0(1),
      I1 => gen_snf_r,
      I2 => gen_suf_r,
      I3 => tx_pe_data_v_r,
      I4 => p_0_in1_in,
      O => \TX_DATA_Buffer[9]_i_2_n_0\
    );
\TX_DATA_Buffer_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[0]_i_1_n_0\,
      Q => TXDATA(8),
      R => '0'
    );
\TX_DATA_Buffer_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[10]_i_1_n_0\,
      Q => TXDATA(2),
      R => '0'
    );
\TX_DATA_Buffer_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[11]_i_1_n_0\,
      Q => TXDATA(3),
      R => '0'
    );
\TX_DATA_Buffer_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[12]_i_1_n_0\,
      Q => TXDATA(4),
      R => '0'
    );
\TX_DATA_Buffer_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[13]_i_1_n_0\,
      Q => TXDATA(5),
      R => '0'
    );
\TX_DATA_Buffer_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[14]_i_1_n_0\,
      Q => TXDATA(6),
      R => '0'
    );
\TX_DATA_Buffer_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[15]_i_2_n_0\,
      Q => TXDATA(7),
      R => '0'
    );
\TX_DATA_Buffer_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[1]_i_1_n_0\,
      Q => TXDATA(9),
      R => '0'
    );
\TX_DATA_Buffer_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[2]_i_1_n_0\,
      Q => TXDATA(10),
      R => '0'
    );
\TX_DATA_Buffer_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[3]_i_1_n_0\,
      Q => TXDATA(11),
      R => '0'
    );
\TX_DATA_Buffer_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[4]_i_1_n_0\,
      Q => TXDATA(12),
      R => '0'
    );
\TX_DATA_Buffer_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[5]_i_1_n_0\,
      Q => TXDATA(13),
      R => '0'
    );
\TX_DATA_Buffer_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[6]_i_1_n_0\,
      Q => TXDATA(14),
      R => '0'
    );
\TX_DATA_Buffer_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => TX_DATA_Buffer_reg0,
      D => \TX_DATA_Buffer[7]_i_2_n_0\,
      Q => TXDATA(15),
      R => '0'
    );
\TX_DATA_Buffer_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[8]_i_1_n_0\,
      Q => TXDATA(0),
      R => '0'
    );
\TX_DATA_Buffer_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \TX_DATA_Buffer[15]_i_1_n_0\,
      D => \TX_DATA_Buffer[9]_i_1_n_0\,
      Q => TXDATA(1),
      R => '0'
    );
\fc_nb_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \fc_nb_r_reg[0]_0\(3),
      Q => fc_nb_r(0),
      R => '0'
    );
\fc_nb_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \fc_nb_r_reg[0]_0\(2),
      Q => fc_nb_r(1),
      R => '0'
    );
\fc_nb_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \fc_nb_r_reg[0]_0\(1),
      Q => fc_nb_r(2),
      R => '0'
    );
\fc_nb_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \fc_nb_r_reg[0]_0\(0),
      Q => fc_nb_r(3),
      R => '0'
    );
gen_a_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_a_i,
      Q => gen_a_r,
      R => '0'
    );
gen_cc_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_cc_i,
      Q => gen_cc_r,
      R => '0'
    );
gen_ecp_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_ecp_i,
      Q => gen_ecp_r,
      R => '0'
    );
gen_k_fsm_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_k_i,
      Q => gen_k_fsm_r,
      R => '0'
    );
\gen_k_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \gen_k_r_reg[0]_0\(1),
      Q => p_0_in4_in,
      R => '0'
    );
\gen_k_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \gen_k_r_reg[0]_0\(0),
      Q => \gen_k_r_reg_n_0_[1]\,
      R => '0'
    );
gen_pad_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_pad_i,
      Q => gen_pad_r,
      R => '0'
    );
\gen_r_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \gen_r_r_reg[0]_0\(1),
      Q => p_0_in,
      R => '0'
    );
\gen_r_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \gen_r_r_reg[0]_0\(0),
      Q => \gen_r_r_reg_n_0_[1]\,
      R => '0'
    );
gen_scp_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_scp_i,
      Q => gen_scp_r,
      R => '0'
    );
gen_snf_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_snf_i,
      Q => gen_snf_r,
      R => '0'
    );
\gen_sp_data_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(1),
      Q => p_0_in1_in,
      R => '0'
    );
\gen_sp_data_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => D(0),
      Q => \gen_sp_data_r_reg_n_0_[1]\,
      R => '0'
    );
\gen_spa_data_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_spa_data_i(0),
      Q => p_1_in,
      R => '0'
    );
\gen_spa_data_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => ack_r,
      Q => \^gen_spa_data_r_reg[1]_0\,
      R => '0'
    );
gen_suf_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gen_suf_i,
      Q => gen_suf_r,
      R => '0'
    );
\gen_v_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \gen_v_r_reg[0]_0\(1),
      Q => p_2_in,
      R => '0'
    );
\gen_v_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \gen_v_r_reg[0]_0\(0),
      Q => p_3_in,
      R => '0'
    );
\tx_pe_data_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(15),
      Q => data0(7),
      R => '0'
    );
\tx_pe_data_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(5),
      Q => \tx_pe_data_r_reg_n_0_[10]\,
      R => '0'
    );
\tx_pe_data_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(4),
      Q => \tx_pe_data_r_reg_n_0_[11]\,
      R => '0'
    );
\tx_pe_data_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(3),
      Q => \tx_pe_data_r_reg_n_0_[12]\,
      R => '0'
    );
\tx_pe_data_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(2),
      Q => \tx_pe_data_r_reg_n_0_[13]\,
      R => '0'
    );
\tx_pe_data_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(1),
      Q => \tx_pe_data_r_reg_n_0_[14]\,
      R => '0'
    );
\tx_pe_data_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(0),
      Q => \tx_pe_data_r_reg_n_0_[15]\,
      R => '0'
    );
\tx_pe_data_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(14),
      Q => data0(6),
      R => '0'
    );
\tx_pe_data_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(13),
      Q => data0(5),
      R => '0'
    );
\tx_pe_data_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(12),
      Q => data0(4),
      R => '0'
    );
\tx_pe_data_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(11),
      Q => data0(3),
      R => '0'
    );
\tx_pe_data_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(10),
      Q => data0(2),
      R => '0'
    );
\tx_pe_data_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(9),
      Q => data0(1),
      R => '0'
    );
\tx_pe_data_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(8),
      Q => data0(0),
      R => '0'
    );
\tx_pe_data_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(7),
      Q => \tx_pe_data_r_reg_n_0_[8]\,
      R => '0'
    );
\tx_pe_data_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \tx_pe_data_r_reg[0]_0\(6),
      Q => \tx_pe_data_r_reg_n_0_[9]\,
      R => '0'
    );
tx_pe_data_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_v_i,
      Q => tx_pe_data_v_r,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_TX_LL_CONTROL is
  port (
    gen_cc_i : out STD_LOGIC;
    do_cc_r_reg_0 : out STD_LOGIC;
    ufc_header_r_reg_0 : out STD_LOGIC;
    do_nfc_r_reg_0 : out STD_LOGIC;
    pdu_ok_c : out STD_LOGIC;
    TX_DST_RDY_N_Buffer_reg_0 : out STD_LOGIC;
    gen_scp_i : out STD_LOGIC;
    gen_ecp_i : out STD_LOGIC;
    gen_snf_i : out STD_LOGIC;
    gen_suf_i : out STD_LOGIC;
    S_AXI_TX_TREADY : out STD_LOGIC;
    \^s_axi_tx_tvalid\ : out STD_LOGIC;
    TX_PE_DATA_V_Buffer0 : out STD_LOGIC;
    new_pkt_r_reg : out STD_LOGIC;
    ufc_idle_r_reg_0 : out STD_LOGIC;
    \FC_NB_Buffer_reg[0]_0\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    user_clk : in STD_LOGIC;
    p_0_in : in STD_LOGIC;
    Q : in STD_LOGIC;
    sof_data_eof_1_r_reg_0 : in STD_LOGIC;
    S_AXI_TX_TVALID : in STD_LOGIC;
    S_AXI_TX_TLAST : in STD_LOGIC;
    WARN_CC : in STD_LOGIC;
    tx_pe_data_v_r : in STD_LOGIC;
    tx_pe_ufc_v_r : in STD_LOGIC;
    previous_cycle_ufc_message_r : in STD_LOGIC;
    S_AXI_NFC_REQ : in STD_LOGIC;
    S_AXI_UFC_TX_REQ : in STD_LOGIC;
    TX_DST_RDY_N_Buffer_reg_1 : in STD_LOGIC_VECTOR ( 0 to 0 );
    in_frame_r_reg : in STD_LOGIC;
    S_AXI_NFC_NB : in STD_LOGIC_VECTOR ( 3 downto 0 );
    S_AXI_UFC_TX_MS : in STD_LOGIC_VECTOR ( 2 downto 0 );
    \ufc_message_count_r_reg[2]_0\ : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_TX_LL_CONTROL;

architecture STRUCTURE of aurora_8b10b_x1_16b_TX_LL_CONTROL is
  signal \FC_NB_Buffer[3]_i_1_n_0\ : STD_LOGIC;
  signal GEN_ECP_Buffer0 : STD_LOGIC;
  signal GEN_SCP_Buffer0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_2_n_0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_3_n_0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_4_n_0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_5_n_0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_6_n_0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_7_n_0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_8_n_0 : STD_LOGIC;
  signal TX_DST_RDY_N_Buffer_i_9_n_0 : STD_LOGIC;
  signal \^tx_dst_rdy_n_buffer_reg_0\ : STD_LOGIC;
  signal data_eof_1_r : STD_LOGIC;
  signal data_eof_2_r : STD_LOGIC;
  signal data_eof_3_r : STD_LOGIC;
  signal data_r : STD_LOGIC;
  signal delay_ms_1_r : STD_LOGIC_VECTOR ( 0 to 2 );
  signal delay_ms_2_r : STD_LOGIC_VECTOR ( 0 to 2 );
  signal \^do_cc_r_reg_0\ : STD_LOGIC;
  signal do_nfc_r : STD_LOGIC;
  signal \^do_nfc_r_reg_0\ : STD_LOGIC;
  signal fc_nb_c : STD_LOGIC_VECTOR ( 0 to 2 );
  signal idle_r : STD_LOGIC;
  signal next_data_c : STD_LOGIC;
  signal next_data_eof_1_c : STD_LOGIC;
  signal next_data_eof_2_c : STD_LOGIC;
  signal next_data_eof_3_c : STD_LOGIC;
  signal next_idle_c : STD_LOGIC;
  signal next_sof_c : STD_LOGIC;
  signal next_sof_data_eof_1_c : STD_LOGIC;
  signal next_sof_data_eof_2_c : STD_LOGIC;
  signal next_sof_data_eof_3_c : STD_LOGIC;
  signal next_ufc_header_c : STD_LOGIC;
  signal next_ufc_idle_c : STD_LOGIC;
  signal next_ufc_message2_c : STD_LOGIC;
  signal next_ufc_message3_c : STD_LOGIC;
  signal next_ufc_message4_c : STD_LOGIC;
  signal next_ufc_message5_c : STD_LOGIC;
  signal next_ufc_message6_c : STD_LOGIC;
  signal next_ufc_message7_c : STD_LOGIC;
  signal next_ufc_message8_c : STD_LOGIC;
  signal \^pdu_ok_c\ : STD_LOGIC;
  signal \^s_axi_tx_tvalid_1\ : STD_LOGIC;
  signal sof_data_eof_1_r : STD_LOGIC;
  signal sof_data_eof_2_r : STD_LOGIC;
  signal sof_data_eof_3_r : STD_LOGIC;
  signal sof_r : STD_LOGIC;
  signal sof_r_i_2_n_0 : STD_LOGIC;
  signal suf_delay_1_r : STD_LOGIC;
  signal suf_delay_2_r : STD_LOGIC;
  signal tx_dst_rdy_n_c : STD_LOGIC;
  signal ufc_header_r_i_2_n_0 : STD_LOGIC;
  signal ufc_header_r_i_3_n_0 : STD_LOGIC;
  signal ufc_header_r_i_4_n_0 : STD_LOGIC;
  signal \^ufc_header_r_reg_0\ : STD_LOGIC;
  signal ufc_idle_r : STD_LOGIC;
  signal ufc_message2_r : STD_LOGIC;
  signal ufc_message3_r : STD_LOGIC;
  signal ufc_message4_r : STD_LOGIC;
  signal ufc_message5_r : STD_LOGIC;
  signal ufc_message6_r : STD_LOGIC;
  signal ufc_message7_r : STD_LOGIC;
  signal ufc_message8_r : STD_LOGIC;
  signal ufc_message_count_r : STD_LOGIC_VECTOR ( 0 to 2 );
  signal \ufc_message_count_r[0]_i_1_n_0\ : STD_LOGIC;
  signal \ufc_message_count_r[1]_i_1_n_0\ : STD_LOGIC;
  signal \ufc_message_count_r[2]_i_1_n_0\ : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \FC_NB_Buffer[0]_i_1\ : label is "soft_lutpair106";
  attribute SOFT_HLUTNM of \FC_NB_Buffer[1]_i_1\ : label is "soft_lutpair105";
  attribute SOFT_HLUTNM of \FC_NB_Buffer[2]_i_1\ : label is "soft_lutpair105";
  attribute SOFT_HLUTNM of \FC_NB_Buffer[3]_i_1\ : label is "soft_lutpair106";
  attribute SOFT_HLUTNM of GEN_SCP_Buffer_i_1 : label is "soft_lutpair100";
  attribute SOFT_HLUTNM of S_AXI_TX_TREADY_INST_0 : label is "soft_lutpair96";
  attribute SOFT_HLUTNM of TX_DST_RDY_N_Buffer_i_3 : label is "soft_lutpair95";
  attribute SOFT_HLUTNM of TX_DST_RDY_N_Buffer_i_5 : label is "soft_lutpair101";
  attribute SOFT_HLUTNM of TX_DST_RDY_N_Buffer_i_8 : label is "soft_lutpair100";
  attribute SOFT_HLUTNM of TX_DST_RDY_N_Buffer_i_9 : label is "soft_lutpair95";
  attribute SOFT_HLUTNM of TX_PE_DATA_V_Buffer_i_1 : label is "soft_lutpair101";
  attribute SOFT_HLUTNM of data_eof_2_r_i_1 : label is "soft_lutpair97";
  attribute SOFT_HLUTNM of data_eof_3_r_i_1 : label is "soft_lutpair97";
  attribute SOFT_HLUTNM of data_r_i_1 : label is "soft_lutpair96";
  attribute BOX_TYPE : string;
  attribute BOX_TYPE of gen_cc_flop_0_i : label is "PRIMITIVE";
  attribute XILINX_LEGACY_PRIM : string;
  attribute XILINX_LEGACY_PRIM of gen_cc_flop_0_i : label is "FDR";
  attribute XILINX_TRANSFORM_PINMAP : string;
  attribute XILINX_TRANSFORM_PINMAP of gen_cc_flop_0_i : label is "VCC:CE";
  attribute SOFT_HLUTNM of sof_data_eof_1_r_i_1 : label is "soft_lutpair94";
  attribute SOFT_HLUTNM of sof_data_eof_2_r_i_1 : label is "soft_lutpair98";
  attribute SOFT_HLUTNM of sof_data_eof_3_r_i_1 : label is "soft_lutpair98";
  attribute SOFT_HLUTNM of sof_r_i_1 : label is "soft_lutpair93";
  attribute SOFT_HLUTNM of sof_r_i_2 : label is "soft_lutpair94";
  attribute SOFT_HLUTNM of storage_pad_r_i_2 : label is "soft_lutpair93";
  attribute SOFT_HLUTNM of storage_ufc_v_r_i_1 : label is "soft_lutpair99";
  attribute SOFT_HLUTNM of ufc_header_r_i_2 : label is "soft_lutpair99";
  attribute SOFT_HLUTNM of ufc_message2_r_i_1 : label is "soft_lutpair102";
  attribute SOFT_HLUTNM of ufc_message3_r_i_1 : label is "soft_lutpair102";
  attribute SOFT_HLUTNM of ufc_message4_r_i_1 : label is "soft_lutpair103";
  attribute SOFT_HLUTNM of ufc_message5_r_i_1 : label is "soft_lutpair103";
  attribute SOFT_HLUTNM of ufc_message6_r_i_1 : label is "soft_lutpair104";
  attribute SOFT_HLUTNM of ufc_message7_r_i_1 : label is "soft_lutpair104";
begin
  TX_DST_RDY_N_Buffer_reg_0 <= \^tx_dst_rdy_n_buffer_reg_0\;
  \^s_axi_tx_tvalid\ <= \^s_axi_tx_tvalid_1\;
  do_cc_r_reg_0 <= \^do_cc_r_reg_0\;
  do_nfc_r_reg_0 <= \^do_nfc_r_reg_0\;
  pdu_ok_c <= \^pdu_ok_c\;
  ufc_header_r_reg_0 <= \^ufc_header_r_reg_0\;
\FC_NB_Buffer[0]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => delay_ms_2_r(0),
      I1 => suf_delay_2_r,
      I2 => S_AXI_NFC_NB(3),
      O => fc_nb_c(0)
    );
\FC_NB_Buffer[1]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => delay_ms_2_r(1),
      I1 => suf_delay_2_r,
      I2 => S_AXI_NFC_NB(2),
      O => fc_nb_c(1)
    );
\FC_NB_Buffer[2]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => delay_ms_2_r(2),
      I1 => suf_delay_2_r,
      I2 => S_AXI_NFC_NB(1),
      O => fc_nb_c(2)
    );
\FC_NB_Buffer[3]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => S_AXI_NFC_NB(0),
      I1 => suf_delay_2_r,
      O => \FC_NB_Buffer[3]_i_1_n_0\
    );
\FC_NB_Buffer_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => fc_nb_c(0),
      Q => \FC_NB_Buffer_reg[0]_0\(3),
      R => '0'
    );
\FC_NB_Buffer_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => fc_nb_c(1),
      Q => \FC_NB_Buffer_reg[0]_0\(2),
      R => '0'
    );
\FC_NB_Buffer_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => fc_nb_c(2),
      Q => \FC_NB_Buffer_reg[0]_0\(1),
      R => '0'
    );
\FC_NB_Buffer_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \FC_NB_Buffer[3]_i_1_n_0\,
      Q => \FC_NB_Buffer_reg[0]_0\(0),
      R => '0'
    );
GEN_ECP_Buffer_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"000E"
    )
        port map (
      I0 => sof_data_eof_3_r,
      I1 => data_eof_3_r,
      I2 => \^do_nfc_r_reg_0\,
      I3 => \^do_cc_r_reg_0\,
      O => GEN_ECP_Buffer0
    );
GEN_ECP_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => GEN_ECP_Buffer0,
      Q => gen_ecp_i,
      R => p_0_in
    );
GEN_SCP_Buffer_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0302"
    )
        port map (
      I0 => sof_r,
      I1 => \^do_cc_r_reg_0\,
      I2 => \^do_nfc_r_reg_0\,
      I3 => sof_data_eof_1_r,
      O => GEN_SCP_Buffer0
    );
GEN_SCP_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => GEN_SCP_Buffer0,
      Q => gen_scp_i,
      R => p_0_in
    );
GEN_SNF_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \^do_nfc_r_reg_0\,
      Q => gen_snf_i,
      R => p_0_in
    );
GEN_SUF_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => suf_delay_2_r,
      Q => gen_suf_i,
      R => p_0_in
    );
S_AXI_TX_TREADY_INST_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^tx_dst_rdy_n_buffer_reg_0\,
      O => S_AXI_TX_TREADY
    );
TX_DST_RDY_N_Buffer_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFEF"
    )
        port map (
      I0 => TX_DST_RDY_N_Buffer_i_2_n_0,
      I1 => TX_DST_RDY_N_Buffer_i_3_n_0,
      I2 => ufc_header_r_i_2_n_0,
      I3 => data_eof_1_r,
      I4 => sof_data_eof_1_r,
      I5 => TX_DST_RDY_N_Buffer_i_4_n_0,
      O => tx_dst_rdy_n_c
    );
TX_DST_RDY_N_Buffer_i_2: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000F22222222"
    )
        port map (
      I0 => sof_r_i_2_n_0,
      I1 => \^ufc_header_r_reg_0\,
      I2 => TX_DST_RDY_N_Buffer_i_5_n_0,
      I3 => WARN_CC,
      I4 => previous_cycle_ufc_message_r,
      I5 => ufc_idle_r,
      O => TX_DST_RDY_N_Buffer_i_2_n_0
    );
TX_DST_RDY_N_Buffer_i_3: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FDFDFDDD"
    )
        port map (
      I0 => TX_DST_RDY_N_Buffer_reg_1(0),
      I1 => Q,
      I2 => previous_cycle_ufc_message_r,
      I3 => data_eof_2_r,
      I4 => sof_data_eof_2_r,
      O => TX_DST_RDY_N_Buffer_i_3_n_0
    );
TX_DST_RDY_N_Buffer_i_4: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFF444F000F444F"
    )
        port map (
      I0 => \^s_axi_tx_tvalid_1\,
      I1 => TX_DST_RDY_N_Buffer_i_6_n_0,
      I2 => TX_DST_RDY_N_Buffer_i_7_n_0,
      I3 => WARN_CC,
      I4 => TX_DST_RDY_N_Buffer_i_8_n_0,
      I5 => TX_DST_RDY_N_Buffer_i_9_n_0,
      O => TX_DST_RDY_N_Buffer_i_4_n_0
    );
TX_DST_RDY_N_Buffer_i_5: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => \^do_nfc_r_reg_0\,
      I1 => S_AXI_NFC_REQ,
      O => TX_DST_RDY_N_Buffer_i_5_n_0
    );
TX_DST_RDY_N_Buffer_i_6: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFF5554"
    )
        port map (
      I0 => sof_data_eof_1_r_reg_0,
      I1 => sof_data_eof_3_r,
      I2 => data_eof_3_r,
      I3 => idle_r,
      I4 => sof_r,
      I5 => data_r,
      O => TX_DST_RDY_N_Buffer_i_6_n_0
    );
TX_DST_RDY_N_Buffer_i_7: unisim.vcomponents.LUT3
    generic map(
      INIT => X"2F"
    )
        port map (
      I0 => S_AXI_NFC_REQ,
      I1 => \^do_nfc_r_reg_0\,
      I2 => S_AXI_UFC_TX_REQ,
      O => TX_DST_RDY_N_Buffer_i_7_n_0
    );
TX_DST_RDY_N_Buffer_i_8: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \^do_cc_r_reg_0\,
      I1 => \^do_nfc_r_reg_0\,
      O => TX_DST_RDY_N_Buffer_i_8_n_0
    );
TX_DST_RDY_N_Buffer_i_9: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => data_eof_2_r,
      I1 => sof_data_eof_2_r,
      O => TX_DST_RDY_N_Buffer_i_9_n_0
    );
TX_DST_RDY_N_Buffer_reg: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_dst_rdy_n_c,
      Q => \^tx_dst_rdy_n_buffer_reg_0\,
      S => p_0_in
    );
TX_PE_DATA_V_Buffer_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FF10"
    )
        port map (
      I0 => \^do_cc_r_reg_0\,
      I1 => \^do_nfc_r_reg_0\,
      I2 => tx_pe_data_v_r,
      I3 => tx_pe_ufc_v_r,
      O => TX_PE_DATA_V_Buffer0
    );
data_eof_1_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"A8FFA8FFA8FFA8A8"
    )
        port map (
      I0 => \^ufc_header_r_reg_0\,
      I1 => data_eof_1_r,
      I2 => sof_data_eof_1_r,
      I3 => \^s_axi_tx_tvalid_1\,
      I4 => data_r,
      I5 => sof_r,
      O => next_data_eof_1_c
    );
data_eof_1_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_data_eof_1_c,
      Q => data_eof_1_r,
      R => p_0_in
    );
data_eof_2_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"F4F4F444"
    )
        port map (
      I0 => \^ufc_header_r_reg_0\,
      I1 => data_eof_1_r,
      I2 => data_eof_2_r,
      I3 => suf_delay_1_r,
      I4 => previous_cycle_ufc_message_r,
      O => next_data_eof_2_c
    );
data_eof_2_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_data_eof_2_c,
      Q => data_eof_2_r,
      R => p_0_in
    );
data_eof_3_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"02"
    )
        port map (
      I0 => data_eof_2_r,
      I1 => previous_cycle_ufc_message_r,
      I2 => suf_delay_1_r,
      O => next_data_eof_3_c
    );
data_eof_3_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_data_eof_3_c,
      Q => data_eof_3_r,
      R => p_0_in
    );
data_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"EE0EEEEE"
    )
        port map (
      I0 => sof_r,
      I1 => data_r,
      I2 => S_AXI_TX_TLAST,
      I3 => \^tx_dst_rdy_n_buffer_reg_0\,
      I4 => S_AXI_TX_TVALID,
      O => next_data_c
    );
data_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_data_c,
      Q => data_r,
      R => p_0_in
    );
\delay_ms_1_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => S_AXI_UFC_TX_MS(2),
      Q => delay_ms_1_r(0),
      R => '0'
    );
\delay_ms_1_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => S_AXI_UFC_TX_MS(1),
      Q => delay_ms_1_r(1),
      R => '0'
    );
\delay_ms_1_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => S_AXI_UFC_TX_MS(0),
      Q => delay_ms_1_r(2),
      R => '0'
    );
\delay_ms_2_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => delay_ms_1_r(0),
      Q => delay_ms_2_r(0),
      R => '0'
    );
\delay_ms_2_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => delay_ms_1_r(1),
      Q => delay_ms_2_r(1),
      R => '0'
    );
\delay_ms_2_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => delay_ms_1_r(2),
      Q => delay_ms_2_r(2),
      R => '0'
    );
do_cc_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => Q,
      Q => \^do_cc_r_reg_0\,
      R => '0'
    );
do_nfc_r_i_2: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000100000"
    )
        port map (
      I0 => WARN_CC,
      I1 => Q,
      I2 => ufc_idle_r,
      I3 => previous_cycle_ufc_message_r,
      I4 => S_AXI_NFC_REQ,
      I5 => \^do_nfc_r_reg_0\,
      O => do_nfc_r
    );
do_nfc_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => do_nfc_r,
      Q => \^do_nfc_r_reg_0\,
      R => p_0_in
    );
gen_cc_flop_0_i: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \^do_cc_r_reg_0\,
      Q => gen_cc_i,
      R => '0'
    );
idle_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"EFEFEFEFEFEFEF00"
    )
        port map (
      I0 => sof_data_eof_1_r_reg_0,
      I1 => \^tx_dst_rdy_n_buffer_reg_0\,
      I2 => S_AXI_TX_TVALID,
      I3 => idle_r,
      I4 => data_eof_3_r,
      I5 => sof_data_eof_3_r,
      O => next_idle_c
    );
idle_r_reg: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_idle_c,
      Q => idle_r,
      S => p_0_in
    );
in_frame_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"F3FF0100"
    )
        port map (
      I0 => sof_data_eof_1_r_reg_0,
      I1 => S_AXI_TX_TLAST,
      I2 => \^tx_dst_rdy_n_buffer_reg_0\,
      I3 => S_AXI_TX_TVALID,
      I4 => in_frame_r_reg,
      O => new_pkt_r_reg
    );
sof_data_eof_1_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"11111110"
    )
        port map (
      I0 => sof_data_eof_1_r_reg_0,
      I1 => \^s_axi_tx_tvalid_1\,
      I2 => idle_r,
      I3 => data_eof_3_r,
      I4 => sof_data_eof_3_r,
      O => next_sof_data_eof_1_c
    );
sof_data_eof_1_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_sof_data_eof_1_c,
      Q => sof_data_eof_1_r,
      R => p_0_in
    );
sof_data_eof_2_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"F4F4F444"
    )
        port map (
      I0 => \^ufc_header_r_reg_0\,
      I1 => sof_data_eof_1_r,
      I2 => sof_data_eof_2_r,
      I3 => suf_delay_1_r,
      I4 => previous_cycle_ufc_message_r,
      O => next_sof_data_eof_2_c
    );
sof_data_eof_2_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_sof_data_eof_2_c,
      Q => sof_data_eof_2_r,
      R => p_0_in
    );
sof_data_eof_3_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"02"
    )
        port map (
      I0 => sof_data_eof_2_r,
      I1 => previous_cycle_ufc_message_r,
      I2 => suf_delay_1_r,
      O => next_sof_data_eof_3_c
    );
sof_data_eof_3_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_sof_data_eof_3_c,
      Q => sof_data_eof_3_r,
      R => p_0_in
    );
sof_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00040000"
    )
        port map (
      I0 => S_AXI_TX_TLAST,
      I1 => S_AXI_TX_TVALID,
      I2 => \^tx_dst_rdy_n_buffer_reg_0\,
      I3 => sof_data_eof_1_r_reg_0,
      I4 => sof_r_i_2_n_0,
      O => next_sof_c
    );
sof_r_i_2: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FE"
    )
        port map (
      I0 => sof_data_eof_3_r,
      I1 => data_eof_3_r,
      I2 => idle_r,
      O => sof_r_i_2_n_0
    );
sof_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \^pdu_ok_c\,
      D => next_sof_c,
      Q => sof_r,
      R => p_0_in
    );
storage_pad_r_i_2: unisim.vcomponents.LUT3
    generic map(
      INIT => X"DF"
    )
        port map (
      I0 => S_AXI_TX_TVALID,
      I1 => \^tx_dst_rdy_n_buffer_reg_0\,
      I2 => S_AXI_TX_TLAST,
      O => \^s_axi_tx_tvalid_1\
    );
storage_ufc_v_r_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => ufc_idle_r,
      I1 => \^ufc_header_r_reg_0\,
      O => ufc_idle_r_reg_0
    );
storage_v_r_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^do_nfc_r_reg_0\,
      I1 => \^do_cc_r_reg_0\,
      O => \^pdu_ok_c\
    );
suf_delay_2_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => suf_delay_1_r,
      Q => suf_delay_2_r,
      R => p_0_in
    );
ufc_header_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0202000200000000"
    )
        port map (
      I0 => ufc_header_r_i_2_n_0,
      I1 => WARN_CC,
      I2 => Q,
      I3 => S_AXI_NFC_REQ,
      I4 => \^do_nfc_r_reg_0\,
      I5 => S_AXI_UFC_TX_REQ,
      O => next_ufc_header_c
    );
ufc_header_r_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"ABFB"
    )
        port map (
      I0 => ufc_idle_r,
      I1 => ufc_header_r_i_3_n_0,
      I2 => ufc_message_count_r(2),
      I3 => ufc_header_r_i_4_n_0,
      O => ufc_header_r_i_2_n_0
    );
ufc_header_r_i_3: unisim.vcomponents.LUT6
    generic map(
      INIT => X"3030505F3F3F505F"
    )
        port map (
      I0 => ufc_message3_r,
      I1 => ufc_message7_r,
      I2 => ufc_message_count_r(1),
      I3 => suf_delay_1_r,
      I4 => ufc_message_count_r(0),
      I5 => ufc_message5_r,
      O => ufc_header_r_i_3_n_0
    );
ufc_header_r_i_4: unisim.vcomponents.LUT6
    generic map(
      INIT => X"3030505F3F3F505F"
    )
        port map (
      I0 => ufc_message4_r,
      I1 => ufc_message8_r,
      I2 => ufc_message_count_r(1),
      I3 => ufc_message2_r,
      I4 => ufc_message_count_r(0),
      I5 => ufc_message6_r,
      O => ufc_header_r_i_4_n_0
    );
ufc_header_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_header_c,
      Q => \^ufc_header_r_reg_0\,
      R => p_0_in
    );
ufc_idle_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"A8A8AAA8AAAAAAAA"
    )
        port map (
      I0 => ufc_header_r_i_2_n_0,
      I1 => WARN_CC,
      I2 => Q,
      I3 => S_AXI_NFC_REQ,
      I4 => \^do_nfc_r_reg_0\,
      I5 => S_AXI_UFC_TX_REQ,
      O => next_ufc_idle_c
    );
ufc_idle_r_reg: unisim.vcomponents.FDSE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_idle_c,
      Q => ufc_idle_r,
      S => p_0_in
    );
ufc_message1_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \^ufc_header_r_reg_0\,
      Q => suf_delay_1_r,
      R => p_0_in
    );
ufc_message2_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"CCC8"
    )
        port map (
      I0 => ufc_message_count_r(2),
      I1 => suf_delay_1_r,
      I2 => ufc_message_count_r(1),
      I3 => ufc_message_count_r(0),
      O => next_ufc_message2_c
    );
ufc_message2_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_message2_c,
      Q => ufc_message2_r,
      R => p_0_in
    );
ufc_message3_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"CCC4"
    )
        port map (
      I0 => ufc_message_count_r(2),
      I1 => ufc_message2_r,
      I2 => ufc_message_count_r(1),
      I3 => ufc_message_count_r(0),
      O => next_ufc_message3_c
    );
ufc_message3_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_message3_c,
      Q => ufc_message3_r,
      R => p_0_in
    );
ufc_message4_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"C8CC"
    )
        port map (
      I0 => ufc_message_count_r(2),
      I1 => ufc_message3_r,
      I2 => ufc_message_count_r(0),
      I3 => ufc_message_count_r(1),
      O => next_ufc_message4_c
    );
ufc_message4_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_message4_c,
      Q => ufc_message4_r,
      R => p_0_in
    );
ufc_message5_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"C4CC"
    )
        port map (
      I0 => ufc_message_count_r(2),
      I1 => ufc_message4_r,
      I2 => ufc_message_count_r(0),
      I3 => ufc_message_count_r(1),
      O => next_ufc_message5_c
    );
ufc_message5_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_message5_c,
      Q => ufc_message5_r,
      R => p_0_in
    );
ufc_message6_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"C8CC"
    )
        port map (
      I0 => ufc_message_count_r(2),
      I1 => ufc_message5_r,
      I2 => ufc_message_count_r(1),
      I3 => ufc_message_count_r(0),
      O => next_ufc_message6_c
    );
ufc_message6_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_message6_c,
      Q => ufc_message6_r,
      R => p_0_in
    );
ufc_message7_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"C4CC"
    )
        port map (
      I0 => ufc_message_count_r(2),
      I1 => ufc_message6_r,
      I2 => ufc_message_count_r(1),
      I3 => ufc_message_count_r(0),
      O => next_ufc_message7_c
    );
ufc_message7_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_message7_c,
      Q => ufc_message7_r,
      R => p_0_in
    );
ufc_message8_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"F700"
    )
        port map (
      I0 => ufc_message_count_r(0),
      I1 => ufc_message_count_r(1),
      I2 => ufc_message_count_r(2),
      I3 => ufc_message7_r,
      O => next_ufc_message8_c
    );
ufc_message8_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => next_ufc_message8_c,
      Q => ufc_message8_r,
      R => p_0_in
    );
\ufc_message_count_r[0]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FB08"
    )
        port map (
      I0 => S_AXI_UFC_TX_MS(2),
      I1 => ufc_header_r_i_2_n_0,
      I2 => \ufc_message_count_r_reg[2]_0\,
      I3 => ufc_message_count_r(0),
      O => \ufc_message_count_r[0]_i_1_n_0\
    );
\ufc_message_count_r[1]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FB08"
    )
        port map (
      I0 => S_AXI_UFC_TX_MS(1),
      I1 => ufc_header_r_i_2_n_0,
      I2 => \ufc_message_count_r_reg[2]_0\,
      I3 => ufc_message_count_r(1),
      O => \ufc_message_count_r[1]_i_1_n_0\
    );
\ufc_message_count_r[2]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FB08"
    )
        port map (
      I0 => S_AXI_UFC_TX_MS(0),
      I1 => ufc_header_r_i_2_n_0,
      I2 => \ufc_message_count_r_reg[2]_0\,
      I3 => ufc_message_count_r(2),
      O => \ufc_message_count_r[2]_i_1_n_0\
    );
\ufc_message_count_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \ufc_message_count_r[0]_i_1_n_0\,
      Q => ufc_message_count_r(0),
      R => '0'
    );
\ufc_message_count_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \ufc_message_count_r[1]_i_1_n_0\,
      Q => ufc_message_count_r(1),
      R => '0'
    );
\ufc_message_count_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \ufc_message_count_r[2]_i_1_n_0\,
      Q => ufc_message_count_r(2),
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_TX_LL_DATAPATH is
  port (
    tx_pe_data_v_r : out STD_LOGIC;
    previous_cycle_ufc_message_r : out STD_LOGIC;
    tx_pe_ufc_v_r : out STD_LOGIC;
    tx_pe_data_v_i : out STD_LOGIC;
    gen_pad_i : out STD_LOGIC;
    in_frame_r_reg_0 : out STD_LOGIC;
    \TX_PE_DATA_Buffer_reg[0]_0\ : out STD_LOGIC_VECTOR ( 15 downto 0 );
    E : in STD_LOGIC_VECTOR ( 0 to 0 );
    user_clk : in STD_LOGIC;
    storage_ufc_v_r_reg_0 : in STD_LOGIC;
    TX_PE_DATA_V_Buffer0 : in STD_LOGIC;
    p_0_in : in STD_LOGIC;
    in_frame_r_reg_1 : in STD_LOGIC;
    storage_pad_r_reg_0 : in STD_LOGIC;
    S_AXI_TX_TVALID : in STD_LOGIC;
    tx_dst_rdy : in STD_LOGIC;
    S_AXI_TX_TKEEP : in STD_LOGIC_VECTOR ( 1 downto 0 );
    storage_pad_r_reg_1 : in STD_LOGIC;
    GEN_PAD_Buffer_reg_0 : in STD_LOGIC;
    D : in STD_LOGIC;
    S_AXI_TX_TDATA : in STD_LOGIC_VECTOR ( 15 downto 0 )
  );
end aurora_8b10b_x1_16b_TX_LL_DATAPATH;

architecture STRUCTURE of aurora_8b10b_x1_16b_TX_LL_DATAPATH is
  signal GEN_PAD_Buffer0 : STD_LOGIC;
  signal gen_pad_r : STD_LOGIC;
  signal in_frame_c : STD_LOGIC;
  signal \^in_frame_r_reg_0\ : STD_LOGIC;
  signal \^previous_cycle_ufc_message_r\ : STD_LOGIC;
  signal storage_pad_r : STD_LOGIC;
  signal storage_pad_r0 : STD_LOGIC;
  signal storage_r : STD_LOGIC_VECTOR ( 0 to 15 );
  signal storage_v_r : STD_LOGIC;
  signal tx_pe_data_r : STD_LOGIC_VECTOR ( 0 to 15 );
  signal \^tx_pe_ufc_v_r\ : STD_LOGIC;
begin
  in_frame_r_reg_0 <= \^in_frame_r_reg_0\;
  previous_cycle_ufc_message_r <= \^previous_cycle_ufc_message_r\;
  tx_pe_ufc_v_r <= \^tx_pe_ufc_v_r\;
GEN_PAD_Buffer_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0004"
    )
        port map (
      I0 => \^tx_pe_ufc_v_r\,
      I1 => gen_pad_r,
      I2 => GEN_PAD_Buffer_reg_0,
      I3 => D,
      O => GEN_PAD_Buffer0
    );
GEN_PAD_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => GEN_PAD_Buffer0,
      Q => gen_pad_i,
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(0),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(15),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(10),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(5),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(11),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(4),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(12),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(3),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(13),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(2),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(14),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(1),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(15),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(0),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(1),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(14),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(2),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(13),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(3),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(12),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(4),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(11),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(5),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(10),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(6),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(9),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(7),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(8),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(8),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(7),
      R => '0'
    );
\TX_PE_DATA_Buffer_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => tx_pe_data_r(9),
      Q => \TX_PE_DATA_Buffer_reg[0]_0\(6),
      R => '0'
    );
TX_PE_DATA_V_Buffer_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => TX_PE_DATA_V_Buffer0,
      Q => tx_pe_data_v_i,
      R => '0'
    );
gen_pad_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_pad_r,
      Q => gen_pad_r,
      R => '0'
    );
in_frame_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => in_frame_r_reg_1,
      Q => \^in_frame_r_reg_0\,
      R => p_0_in
    );
storage_pad_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"000000B0"
    )
        port map (
      I0 => \^in_frame_r_reg_0\,
      I1 => storage_pad_r_reg_0,
      I2 => S_AXI_TX_TKEEP(0),
      I3 => S_AXI_TX_TKEEP(1),
      I4 => storage_pad_r_reg_1,
      O => storage_pad_r0
    );
storage_pad_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_pad_r0,
      Q => storage_pad_r,
      R => '0'
    );
\storage_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(7),
      Q => storage_r(0),
      R => '0'
    );
\storage_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(13),
      Q => storage_r(10),
      R => '0'
    );
\storage_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(12),
      Q => storage_r(11),
      R => '0'
    );
\storage_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(11),
      Q => storage_r(12),
      R => '0'
    );
\storage_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(10),
      Q => storage_r(13),
      R => '0'
    );
\storage_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(9),
      Q => storage_r(14),
      R => '0'
    );
\storage_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(8),
      Q => storage_r(15),
      R => '0'
    );
\storage_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(6),
      Q => storage_r(1),
      R => '0'
    );
\storage_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(5),
      Q => storage_r(2),
      R => '0'
    );
\storage_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(4),
      Q => storage_r(3),
      R => '0'
    );
\storage_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(3),
      Q => storage_r(4),
      R => '0'
    );
\storage_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(2),
      Q => storage_r(5),
      R => '0'
    );
\storage_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(1),
      Q => storage_r(6),
      R => '0'
    );
\storage_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(0),
      Q => storage_r(7),
      R => '0'
    );
\storage_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(15),
      Q => storage_r(8),
      R => '0'
    );
\storage_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => S_AXI_TX_TDATA(14),
      Q => storage_r(9),
      R => '0'
    );
storage_ufc_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => storage_ufc_v_r_reg_0,
      Q => \^previous_cycle_ufc_message_r\,
      R => '0'
    );
storage_v_r_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"00D0"
    )
        port map (
      I0 => storage_pad_r_reg_0,
      I1 => \^in_frame_r_reg_0\,
      I2 => S_AXI_TX_TVALID,
      I3 => tx_dst_rdy,
      O => in_frame_c
    );
storage_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => in_frame_c,
      Q => storage_v_r,
      R => '0'
    );
\tx_pe_data_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(0),
      Q => tx_pe_data_r(0),
      R => '0'
    );
\tx_pe_data_r_reg[10]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(10),
      Q => tx_pe_data_r(10),
      R => '0'
    );
\tx_pe_data_r_reg[11]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(11),
      Q => tx_pe_data_r(11),
      R => '0'
    );
\tx_pe_data_r_reg[12]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(12),
      Q => tx_pe_data_r(12),
      R => '0'
    );
\tx_pe_data_r_reg[13]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(13),
      Q => tx_pe_data_r(13),
      R => '0'
    );
\tx_pe_data_r_reg[14]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(14),
      Q => tx_pe_data_r(14),
      R => '0'
    );
\tx_pe_data_r_reg[15]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(15),
      Q => tx_pe_data_r(15),
      R => '0'
    );
\tx_pe_data_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(1),
      Q => tx_pe_data_r(1),
      R => '0'
    );
\tx_pe_data_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(2),
      Q => tx_pe_data_r(2),
      R => '0'
    );
\tx_pe_data_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(3),
      Q => tx_pe_data_r(3),
      R => '0'
    );
\tx_pe_data_r_reg[4]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(4),
      Q => tx_pe_data_r(4),
      R => '0'
    );
\tx_pe_data_r_reg[5]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(5),
      Q => tx_pe_data_r(5),
      R => '0'
    );
\tx_pe_data_r_reg[6]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(6),
      Q => tx_pe_data_r(6),
      R => '0'
    );
\tx_pe_data_r_reg[7]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(7),
      Q => tx_pe_data_r(7),
      R => '0'
    );
\tx_pe_data_r_reg[8]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(8),
      Q => tx_pe_data_r(8),
      R => '0'
    );
\tx_pe_data_r_reg[9]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_r(9),
      Q => tx_pe_data_r(9),
      R => '0'
    );
tx_pe_data_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => E(0),
      D => storage_v_r,
      Q => tx_pe_data_v_r,
      R => '0'
    );
tx_pe_ufc_v_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => \^previous_cycle_ufc_message_r\,
      Q => \^tx_pe_ufc_v_r\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_UFC_FILTER is
  port (
    Q : out STD_LOGIC_VECTOR ( 3 downto 0 );
    src_rdy_n_c : out STD_LOGIC;
    in_frame_r_reg : out STD_LOGIC;
    E : out STD_LOGIC_VECTOR ( 0 to 0 );
    \ufc_count_r_reg[0]_0\ : out STD_LOGIC;
    ufc_data_v_i : out STD_LOGIC;
    \ufc_count_r_reg[2]_0\ : out STD_LOGIC;
    \ufc_count_r_reg[3]_0\ : out STD_LOGIC;
    rx_suf_i : in STD_LOGIC;
    rx_ecp_i : in STD_LOGIC;
    storage_v_r : in STD_LOGIC;
    rx_pe_data_v_i : in STD_LOGIC;
    in_frame_r : in STD_LOGIC;
    ufc_storage_v_r : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    \ufc_count_r_reg[0]_1\ : in STD_LOGIC_VECTOR ( 3 downto 0 );
    user_clk : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_UFC_FILTER;

architecture STRUCTURE of aurora_8b10b_x1_16b_UFC_FILTER is
  signal \^q\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \^in_frame_r_reg\ : STD_LOGIC;
  signal \ufc_count_r[0]_i_1_n_0\ : STD_LOGIC;
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of UFC_RX_EOF_N_Buffer_inv_i_1 : label is "soft_lutpair89";
  attribute SOFT_HLUTNM of \ufc_count_r[0]_i_3\ : label is "soft_lutpair90";
  attribute SOFT_HLUTNM of \ufc_count_r[1]_i_2\ : label is "soft_lutpair90";
  attribute SOFT_HLUTNM of ufc_storage_v_r_i_1 : label is "soft_lutpair89";
begin
  Q(3 downto 0) <= \^q\(3 downto 0);
  in_frame_r_reg <= \^in_frame_r_reg\;
RX_SRC_RDY_N_Buffer_inv_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B0"
    )
        port map (
      I0 => rx_ecp_i,
      I1 => \^in_frame_r_reg\,
      I2 => storage_v_r,
      O => src_rdy_n_c
    );
RX_SRC_RDY_N_Buffer_inv_i_2: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFF7"
    )
        port map (
      I0 => in_frame_r,
      I1 => rx_pe_data_v_i,
      I2 => \^q\(3),
      I3 => \^q\(1),
      I4 => \^q\(0),
      I5 => \^q\(2),
      O => \^in_frame_r_reg\
    );
UFC_RX_EOF_N_Buffer_inv_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00010000"
    )
        port map (
      I0 => \^q\(3),
      I1 => \^q\(1),
      I2 => \^q\(0),
      I3 => \^q\(2),
      I4 => ufc_storage_v_r,
      O => \ufc_count_r_reg[0]_0\
    );
\storage_r[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0001000000000000"
    )
        port map (
      I0 => \^q\(2),
      I1 => \^q\(0),
      I2 => \^q\(1),
      I3 => \^q\(3),
      I4 => rx_pe_data_v_i,
      I5 => in_frame_r,
      O => E(0)
    );
\ufc_count_r[0]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFFFFFE"
    )
        port map (
      I0 => \^q\(3),
      I1 => \^q\(1),
      I2 => \^q\(0),
      I3 => \^q\(2),
      I4 => rx_suf_i,
      O => \ufc_count_r[0]_i_1_n_0\
    );
\ufc_count_r[0]_i_3\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FE"
    )
        port map (
      I0 => \^q\(1),
      I1 => \^q\(0),
      I2 => \^q\(2),
      O => \ufc_count_r_reg[2]_0\
    );
\ufc_count_r[1]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \^q\(0),
      I1 => \^q\(1),
      O => \ufc_count_r_reg[3]_0\
    );
\ufc_count_r_reg[0]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \ufc_count_r[0]_i_1_n_0\,
      D => \ufc_count_r_reg[0]_1\(3),
      Q => \^q\(3),
      R => SR(0)
    );
\ufc_count_r_reg[1]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \ufc_count_r[0]_i_1_n_0\,
      D => \ufc_count_r_reg[0]_1\(2),
      Q => \^q\(2),
      R => SR(0)
    );
\ufc_count_r_reg[2]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \ufc_count_r[0]_i_1_n_0\,
      D => \ufc_count_r_reg[0]_1\(1),
      Q => \^q\(1),
      R => SR(0)
    );
\ufc_count_r_reg[3]\: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => \ufc_count_r[0]_i_1_n_0\,
      D => \ufc_count_r_reg[0]_1\(0),
      Q => \^q\(0),
      R => SR(0)
    );
ufc_storage_v_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFE"
    )
        port map (
      I0 => \^q\(2),
      I1 => \^q\(0),
      I2 => \^q\(1),
      I3 => \^q\(3),
      O => ufc_data_v_i
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync is
  port (
    AR : out STD_LOGIC_VECTOR ( 0 to 0 );
    HPCNT_RESET : out STD_LOGIC;
    GT_RESET : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    \out\ : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_cdc_sync;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  AR(0) <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
  \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ <= GT_RESET;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
\hotplug_count_synth.count_for_reset_r[0]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      I1 => \out\,
      O => HPCNT_RESET
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_0 is
  port (
    \out\ : out STD_LOGIC;
    RESET : in STD_LOGIC;
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_0 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_0;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_0 is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ <= RESET;
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_1 is
  port (
    \out\ : out STD_LOGIC;
    RESET : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_1 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_1;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_1 is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ <= RESET;
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_10 is
  port (
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_10 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_10;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_10 is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '1',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_12 is
  port (
    \out\ : out STD_LOGIC;
    SR : out STD_LOGIC_VECTOR ( 0 to 0 );
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_12 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_12;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_12 is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '1',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
\mmcm_lock_count[9]_i_1__0\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => SR(0)
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_2 is
  port (
    E : out STD_LOGIC_VECTOR ( 0 to 0 );
    reset_time_out_reg : out STD_LOGIC;
    tx_lock : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    \FSM_sequential_tx_state_reg[0]\ : in STD_LOGIC;
    \FSM_sequential_tx_state_reg[0]_0\ : in STD_LOGIC;
    Q : in STD_LOGIC_VECTOR ( 3 downto 0 );
    reset_time_out_reg_0 : in STD_LOGIC;
    \FSM_sequential_tx_state_reg[0]_1\ : in STD_LOGIC;
    \FSM_sequential_tx_state_reg[0]_2\ : in STD_LOGIC;
    \FSM_sequential_tx_state_reg[0]_3\ : in STD_LOGIC;
    txresetdone_s3 : in STD_LOGIC;
    mmcm_lock_reclocked : in STD_LOGIC;
    reset_time_out : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_2 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_2;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_2 is
  signal \FSM_sequential_tx_state[3]_i_4_n_0\ : STD_LOGIC;
  signal \FSM_sequential_tx_state[3]_i_5_n_0\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  signal reset_time_out_0 : STD_LOGIC;
  signal \reset_time_out_i_3__0_n_0\ : STD_LOGIC;
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ <= tx_lock;
\FSM_sequential_tx_state[3]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FAFAFAFAFFFEFAFA"
    )
        port map (
      I0 => \FSM_sequential_tx_state_reg[0]\,
      I1 => \FSM_sequential_tx_state[3]_i_4_n_0\,
      I2 => \FSM_sequential_tx_state[3]_i_5_n_0\,
      I3 => \FSM_sequential_tx_state_reg[0]_0\,
      I4 => Q(0),
      I5 => Q(3),
      O => E(0)
    );
\FSM_sequential_tx_state[3]_i_4\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"B8CCB800"
    )
        port map (
      I0 => txresetdone_s3,
      I1 => Q(2),
      I2 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      I3 => Q(1),
      I4 => mmcm_lock_reclocked,
      O => \FSM_sequential_tx_state[3]_i_4_n_0\
    );
\FSM_sequential_tx_state[3]_i_5\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0004000400070004"
    )
        port map (
      I0 => \FSM_sequential_tx_state_reg[0]_1\,
      I1 => Q(2),
      I2 => Q(1),
      I3 => \FSM_sequential_tx_state_reg[0]_2\,
      I4 => \FSM_sequential_tx_state_reg[0]_3\,
      I5 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \FSM_sequential_tx_state[3]_i_5_n_0\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
reset_time_out_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => reset_time_out_0,
      I1 => \reset_time_out_i_3__0_n_0\,
      I2 => reset_time_out,
      O => reset_time_out_reg
    );
\reset_time_out_i_2__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00AE00AE00AEF0AE"
    )
        port map (
      I0 => \FSM_sequential_tx_state[3]_i_4_n_0\,
      I1 => reset_time_out_reg_0,
      I2 => Q(0),
      I3 => Q(3),
      I4 => Q(2),
      I5 => Q(1),
      O => reset_time_out_0
    );
\reset_time_out_i_3__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000FF005555F544"
    )
        port map (
      I0 => Q(1),
      I1 => reset_time_out_reg_0,
      I2 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      I3 => Q(0),
      I4 => Q(3),
      I5 => Q(2),
      O => \reset_time_out_i_3__0_n_0\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_3 is
  port (
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_3 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_3;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_3 is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '1',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_5 is
  port (
    \out\ : out STD_LOGIC;
    SR : out STD_LOGIC_VECTOR ( 0 to 0 );
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_5 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_5;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_5 is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '1',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
\mmcm_lock_count[9]_i_1\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => SR(0)
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_cdc_sync_9 is
  port (
    E : out STD_LOGIC_VECTOR ( 0 to 0 );
    \FSM_sequential_rx_state_reg[1]\ : out STD_LOGIC;
    \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg_0\ : out STD_LOGIC;
    tx_lock : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    \FSM_sequential_rx_state_reg[0]\ : in STD_LOGIC;
    \FSM_sequential_rx_state_reg[0]_0\ : in STD_LOGIC_VECTOR ( 0 to 0 );
    \FSM_sequential_rx_state_reg[0]_1\ : in STD_LOGIC;
    Q : in STD_LOGIC_VECTOR ( 3 downto 0 );
    \FSM_sequential_rx_state_reg[0]_2\ : in STD_LOGIC;
    \FSM_sequential_rx_state_reg[0]_3\ : in STD_LOGIC;
    \FSM_sequential_rx_state_reg[0]_4\ : in STD_LOGIC;
    rxresetdone_s3 : in STD_LOGIC;
    reset_time_out_reg : in STD_LOGIC;
    gtrxreset_i : in STD_LOGIC;
    reset_time_out_reg_0 : in STD_LOGIC;
    reset_time_out_reg_1 : in STD_LOGIC;
    adapt_count_reset : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of aurora_8b10b_x1_16b_cdc_sync_9 : entity is "aurora_8b10b_x1_16b_cdc_sync";
end aurora_8b10b_x1_16b_cdc_sync_9;

architecture STRUCTURE of aurora_8b10b_x1_16b_cdc_sync_9 is
  signal \FSM_sequential_rx_state[3]_i_5_n_0\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  signal reset_time_out_i_3_n_0 : STD_LOGIC;
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ <= tx_lock;
\FSM_sequential_rx_state[3]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFAABA"
    )
        port map (
      I0 => \FSM_sequential_rx_state_reg[0]\,
      I1 => \FSM_sequential_rx_state_reg[0]_0\(0),
      I2 => \FSM_sequential_rx_state_reg[0]_1\,
      I3 => Q(3),
      I4 => \FSM_sequential_rx_state[3]_i_5_n_0\,
      I5 => \FSM_sequential_rx_state_reg[0]_2\,
      O => E(0)
    );
\FSM_sequential_rx_state[3]_i_5\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFAAEAAAAAAAEA"
    )
        port map (
      I0 => \FSM_sequential_rx_state_reg[0]_3\,
      I1 => Q(2),
      I2 => \FSM_sequential_rx_state_reg[0]_4\,
      I3 => Q(1),
      I4 => Q(0),
      I5 => reset_time_out_i_3_n_0,
      O => \FSM_sequential_rx_state[3]_i_5_n_0\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
i_0: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => '0',
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\
    );
recclk_mon_count_reset_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFF7F00000030"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      I1 => Q(1),
      I2 => Q(0),
      I3 => Q(2),
      I4 => Q(3),
      I5 => adapt_count_reset,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg_0\
    );
\reset_time_out_i_1__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"EEFEFFFFEEFE0000"
    )
        port map (
      I0 => reset_time_out_reg,
      I1 => reset_time_out_i_3_n_0,
      I2 => gtrxreset_i,
      I3 => Q(1),
      I4 => reset_time_out_reg_0,
      I5 => reset_time_out_reg_1,
      O => \FSM_sequential_rx_state_reg[1]\
    );
reset_time_out_i_3: unisim.vcomponents.LUT5
    generic map(
      INIT => X"000088F0"
    )
        port map (
      I0 => Q(1),
      I1 => rxresetdone_s3,
      I2 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      I3 => Q(2),
      I4 => Q(3),
      O => reset_time_out_i_3_n_0
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2\ is
  port (
    \out\ : out STD_LOGIC;
    gtrxreset_i : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => gtrxreset_i,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_11\ is
  port (
    \out\ : out STD_LOGIC;
    rxfsm_rxresetdone_r : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_11\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_11\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_11\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rxfsm_rxresetdone_r,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_13\ is
  port (
    \out\ : out STD_LOGIC;
    \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg_0\ : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_13\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_13\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_13\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg_0\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_14\ is
  port (
    \out\ : out STD_LOGIC;
    rx_fsm_reset_done_int : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_14\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_14\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_14\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_fsm_reset_done_int,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_15\ is
  port (
    \out\ : out STD_LOGIC;
    \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg_0\ : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_15\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_15\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_15\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg_0\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_16\ is
  port (
    \out\ : out STD_LOGIC;
    link_reset_r : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_16\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_16\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_16\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => link_reset_r,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_17\ is
  port (
    \out\ : out STD_LOGIC;
    tx_lock_comb_r : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_17\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_17\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_17\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => tx_lock_comb_r,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_18\ is
  port (
    O : out STD_LOGIC_VECTOR ( 3 downto 0 );
    \hotplug_count_synth.count_for_reset_r_reg[7]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    \hotplug_count_synth.count_for_reset_r_reg[11]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    \hotplug_count_synth.count_for_reset_r_reg[15]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    \hotplug_count_synth.count_for_reset_r_reg[19]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    \hotplug_count_synth.count_for_reset_r_reg[23]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    \hotplug_count_synth.count_for_reset_r_reg[25]\ : out STD_LOGIC_VECTOR ( 1 downto 0 );
    rx_cc_extend_r2 : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    \hotplug_count_synth.count_for_reset_r_reg\ : in STD_LOGIC_VECTOR ( 25 downto 0 )
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_18\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_18\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_18\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  signal \hotplug_count_synth.count_for_reset_r[0]_i_3_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[0]_i_4_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[0]_i_5_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[0]_i_6_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[0]_i_7_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[12]_i_2_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[12]_i_3_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[12]_i_4_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[12]_i_5_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[16]_i_2_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[16]_i_3_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[16]_i_4_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[16]_i_5_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[20]_i_2_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[20]_i_3_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[20]_i_4_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[20]_i_5_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[24]_i_2_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[24]_i_3_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[4]_i_2_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[4]_i_3_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[4]_i_4_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[4]_i_5_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[8]_i_2_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[8]_i_3_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[8]_i_4_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r[8]_i_5_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_1\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_2\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_3\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_1\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_2\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_3\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_1\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_2\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_3\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_1\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_2\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_3\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[24]_i_1_n_3\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_1\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_2\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_3\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_0\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_1\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_2\ : STD_LOGIC;
  signal \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_3\ : STD_LOGIC;
  signal \NLW_hotplug_count_synth.count_for_reset_r_reg[24]_i_1_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 1 );
  signal \NLW_hotplug_count_synth.count_for_reset_r_reg[24]_i_1_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 2 );
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
  attribute ADDER_THRESHOLD : integer;
  attribute ADDER_THRESHOLD of \hotplug_count_synth.count_for_reset_r_reg[0]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \hotplug_count_synth.count_for_reset_r_reg[12]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \hotplug_count_synth.count_for_reset_r_reg[16]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \hotplug_count_synth.count_for_reset_r_reg[20]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \hotplug_count_synth.count_for_reset_r_reg[24]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \hotplug_count_synth.count_for_reset_r_reg[4]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \hotplug_count_synth.count_for_reset_r_reg[8]_i_1\ : label is 11;
begin
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r2,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
\hotplug_count_synth.count_for_reset_r[0]_i_3\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[0]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r[0]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(3),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[0]_i_4_n_0\
    );
\hotplug_count_synth.count_for_reset_r[0]_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(2),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[0]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r[0]_i_6\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(1),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[0]_i_6_n_0\
    );
\hotplug_count_synth.count_for_reset_r[0]_i_7\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(0),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[0]_i_7_n_0\
    );
\hotplug_count_synth.count_for_reset_r[12]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(15),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[12]_i_2_n_0\
    );
\hotplug_count_synth.count_for_reset_r[12]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(14),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[12]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r[12]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(13),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[12]_i_4_n_0\
    );
\hotplug_count_synth.count_for_reset_r[12]_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(12),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[12]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r[16]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(19),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[16]_i_2_n_0\
    );
\hotplug_count_synth.count_for_reset_r[16]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(18),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[16]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r[16]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(17),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[16]_i_4_n_0\
    );
\hotplug_count_synth.count_for_reset_r[16]_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(16),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[16]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r[20]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(23),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[20]_i_2_n_0\
    );
\hotplug_count_synth.count_for_reset_r[20]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(22),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[20]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r[20]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(21),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[20]_i_4_n_0\
    );
\hotplug_count_synth.count_for_reset_r[20]_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(20),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[20]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r[24]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(25),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[24]_i_2_n_0\
    );
\hotplug_count_synth.count_for_reset_r[24]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(24),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[24]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r[4]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(7),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[4]_i_2_n_0\
    );
\hotplug_count_synth.count_for_reset_r[4]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(6),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[4]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r[4]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(5),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[4]_i_4_n_0\
    );
\hotplug_count_synth.count_for_reset_r[4]_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(4),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[4]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r[8]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(11),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[8]_i_2_n_0\
    );
\hotplug_count_synth.count_for_reset_r[8]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(10),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[8]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r[8]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(9),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[8]_i_4_n_0\
    );
\hotplug_count_synth.count_for_reset_r[8]_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(8),
      I1 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \hotplug_count_synth.count_for_reset_r[8]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r_reg[0]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_0\,
      CO(2) => \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_1\,
      CO(1) => \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_2\,
      CO(0) => \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 1) => B"000",
      DI(0) => \hotplug_count_synth.count_for_reset_r[0]_i_3_n_0\,
      O(3 downto 0) => O(3 downto 0),
      S(3) => \hotplug_count_synth.count_for_reset_r[0]_i_4_n_0\,
      S(2) => \hotplug_count_synth.count_for_reset_r[0]_i_5_n_0\,
      S(1) => \hotplug_count_synth.count_for_reset_r[0]_i_6_n_0\,
      S(0) => \hotplug_count_synth.count_for_reset_r[0]_i_7_n_0\
    );
\hotplug_count_synth.count_for_reset_r_reg[12]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_0\,
      CO(3) => \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_0\,
      CO(2) => \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_1\,
      CO(1) => \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_2\,
      CO(0) => \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 0) => \hotplug_count_synth.count_for_reset_r_reg[15]\(3 downto 0),
      S(3) => \hotplug_count_synth.count_for_reset_r[12]_i_2_n_0\,
      S(2) => \hotplug_count_synth.count_for_reset_r[12]_i_3_n_0\,
      S(1) => \hotplug_count_synth.count_for_reset_r[12]_i_4_n_0\,
      S(0) => \hotplug_count_synth.count_for_reset_r[12]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r_reg[16]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \hotplug_count_synth.count_for_reset_r_reg[12]_i_1_n_0\,
      CO(3) => \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_0\,
      CO(2) => \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_1\,
      CO(1) => \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_2\,
      CO(0) => \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 0) => \hotplug_count_synth.count_for_reset_r_reg[19]\(3 downto 0),
      S(3) => \hotplug_count_synth.count_for_reset_r[16]_i_2_n_0\,
      S(2) => \hotplug_count_synth.count_for_reset_r[16]_i_3_n_0\,
      S(1) => \hotplug_count_synth.count_for_reset_r[16]_i_4_n_0\,
      S(0) => \hotplug_count_synth.count_for_reset_r[16]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r_reg[20]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \hotplug_count_synth.count_for_reset_r_reg[16]_i_1_n_0\,
      CO(3) => \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_0\,
      CO(2) => \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_1\,
      CO(1) => \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_2\,
      CO(0) => \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 0) => \hotplug_count_synth.count_for_reset_r_reg[23]\(3 downto 0),
      S(3) => \hotplug_count_synth.count_for_reset_r[20]_i_2_n_0\,
      S(2) => \hotplug_count_synth.count_for_reset_r[20]_i_3_n_0\,
      S(1) => \hotplug_count_synth.count_for_reset_r[20]_i_4_n_0\,
      S(0) => \hotplug_count_synth.count_for_reset_r[20]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r_reg[24]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \hotplug_count_synth.count_for_reset_r_reg[20]_i_1_n_0\,
      CO(3 downto 1) => \NLW_hotplug_count_synth.count_for_reset_r_reg[24]_i_1_CO_UNCONNECTED\(3 downto 1),
      CO(0) => \hotplug_count_synth.count_for_reset_r_reg[24]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 2) => \NLW_hotplug_count_synth.count_for_reset_r_reg[24]_i_1_O_UNCONNECTED\(3 downto 2),
      O(1 downto 0) => \hotplug_count_synth.count_for_reset_r_reg[25]\(1 downto 0),
      S(3 downto 2) => B"00",
      S(1) => \hotplug_count_synth.count_for_reset_r[24]_i_2_n_0\,
      S(0) => \hotplug_count_synth.count_for_reset_r[24]_i_3_n_0\
    );
\hotplug_count_synth.count_for_reset_r_reg[4]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \hotplug_count_synth.count_for_reset_r_reg[0]_i_1_n_0\,
      CO(3) => \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_0\,
      CO(2) => \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_1\,
      CO(1) => \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_2\,
      CO(0) => \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 0) => \hotplug_count_synth.count_for_reset_r_reg[7]\(3 downto 0),
      S(3) => \hotplug_count_synth.count_for_reset_r[4]_i_2_n_0\,
      S(2) => \hotplug_count_synth.count_for_reset_r[4]_i_3_n_0\,
      S(1) => \hotplug_count_synth.count_for_reset_r[4]_i_4_n_0\,
      S(0) => \hotplug_count_synth.count_for_reset_r[4]_i_5_n_0\
    );
\hotplug_count_synth.count_for_reset_r_reg[8]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \hotplug_count_synth.count_for_reset_r_reg[4]_i_1_n_0\,
      CO(3) => \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_0\,
      CO(2) => \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_1\,
      CO(1) => \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_2\,
      CO(0) => \hotplug_count_synth.count_for_reset_r_reg[8]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 0) => \hotplug_count_synth.count_for_reset_r_reg[11]\(3 downto 0),
      S(3) => \hotplug_count_synth.count_for_reset_r[8]_i_2_n_0\,
      S(2) => \hotplug_count_synth.count_for_reset_r[8]_i_3_n_0\,
      S(1) => \hotplug_count_synth.count_for_reset_r[8]_i_4_n_0\,
      S(0) => \hotplug_count_synth.count_for_reset_r[8]_i_5_n_0\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_4\ is
  port (
    \out\ : out STD_LOGIC;
    txfsm_txresetdone_r : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_4\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_4\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_4\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => txfsm_txresetdone_r,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_6\ is
  port (
    \out\ : out STD_LOGIC;
    run_phase_alignment_int : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_6\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_6\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_6\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => run_phase_alignment_int,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_7\ is
  port (
    \out\ : out STD_LOGIC;
    time_out_wait_bypass : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    init_clk_in : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_7\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_7\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_7\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => time_out_wait_bypass,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity \aurora_8b10b_x1_16b_cdc_sync__parameterized2_8\ is
  port (
    \out\ : out STD_LOGIC;
    \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg_0\ : out STD_LOGIC;
    tx_fsm_reset_done_int : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC
  );
  attribute ORIG_REF_NAME : string;
  attribute ORIG_REF_NAME of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_8\ : entity is "aurora_8b10b_x1_16b_cdc_sync";
end \aurora_8b10b_x1_16b_cdc_sync__parameterized2_8\;

architecture STRUCTURE of \aurora_8b10b_x1_16b_cdc_sync__parameterized2_8\ is
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : STD_LOGIC;
  attribute RTL_KEEP : string;
  attribute RTL_KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\ : signal is "true";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\ : STD_LOGIC;
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : STD_LOGIC;
  attribute async_reg : string;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "true";
  attribute shift_extract : string;
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\ : signal is "no";
  signal \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : STD_LOGIC;
  attribute async_reg of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "true";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\ : signal is "no";
  attribute KEEP : string;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "yes";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\ : label is "no";
  attribute ASYNC_REG_boolean : boolean;
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\ : label is "no";
  attribute ASYNC_REG_boolean of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is std.standard.true;
  attribute KEEP of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "yes";
  attribute shift_extract of \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\ : label is "no";
begin
  \out\ <= \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\;
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => tx_fsm_reset_done_int,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from_inst\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_d1_cdc_from\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.p_level_in_int\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d1_aurora_8b10b_x1_16b_cdc_to\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d2\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d4\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      R => '0'
    );
\GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d5\,
      Q => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d6\,
      R => '0'
    );
gt_txresetdone_r_i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3\,
      O => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg_0\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_gt is
  port (
    tx_lock : out STD_LOGIC;
    DRPRDY_OUT : out STD_LOGIC;
    TXN : out STD_LOGIC;
    TXP : out STD_LOGIC;
    rx_realign_i : out STD_LOGIC;
    gtxe2_i_0 : out STD_LOGIC;
    TX_OUT_CLK : out STD_LOGIC;
    gtxe2_i_1 : out STD_LOGIC;
    DRPDO_OUT : out STD_LOGIC_VECTOR ( 15 downto 0 );
    gtxe2_i_2 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    gtxe2_i_3 : out STD_LOGIC;
    gtxe2_i_4 : out STD_LOGIC;
    gtxe2_i_5 : out STD_LOGIC;
    gtxe2_i_6 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    hard_err_flop_r0 : out STD_LOGIC;
    gtxe2_i_7 : out STD_LOGIC_VECTOR ( 7 downto 0 );
    gtxe2_i_8 : out STD_LOGIC_VECTOR ( 7 downto 0 );
    gtxe2_i_9 : out STD_LOGIC;
    ack_flag : out STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    drpclk_in : in STD_LOGIC;
    DRPEN_IN : in STD_LOGIC;
    DRPWE_IN : in STD_LOGIC;
    gt_refclk1 : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    gt_tx_reset_i : in STD_LOGIC;
    RXN : in STD_LOGIC;
    RXP : in STD_LOGIC;
    gt_qpllclk_quad1_in : in STD_LOGIC;
    gt_qpllrefclk_quad1_in : in STD_LOGIC;
    gt_rxdfelfhold_i : in STD_LOGIC;
    ena_comma_align_i : in STD_LOGIC;
    rx_polarity_i : in STD_LOGIC;
    gt_rxuserrdy_i : in STD_LOGIC;
    sync_clk : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    POWER_DOWN : in STD_LOGIC;
    gt_txuserrdy_i : in STD_LOGIC;
    DRPDI_IN : in STD_LOGIC_VECTOR ( 15 downto 0 );
    LOOPBACK : in STD_LOGIC_VECTOR ( 2 downto 0 );
    TXDATA : in STD_LOGIC_VECTOR ( 15 downto 0 );
    TXCHARISK : in STD_LOGIC_VECTOR ( 1 downto 0 );
    DRPADDR_IN : in STD_LOGIC_VECTOR ( 8 downto 0 );
    flag2_reg_0 : in STD_LOGIC;
    left_aligned_r_reg : in STD_LOGIC;
    tx_reset_i : in STD_LOGIC;
    hard_err_flop_r_reg : in STD_LOGIC;
    left_aligned_r_reg_0 : in STD_LOGIC;
    cpll_reset_i : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_gt;

architecture STRUCTURE of aurora_8b10b_x1_16b_gt is
  signal CPLLPD : STD_LOGIC;
  signal CPLLRESET : STD_LOGIC;
  signal D : STD_LOGIC;
  signal \^ack_flag\ : STD_LOGIC;
  signal ack_flag_i_1_n_0 : STD_LOGIC;
  signal ack_sync1 : STD_LOGIC;
  signal ack_sync2 : STD_LOGIC;
  signal ack_sync3 : STD_LOGIC;
  signal ack_sync4 : STD_LOGIC;
  signal ack_sync5 : STD_LOGIC;
  signal ack_sync6 : STD_LOGIC;
  signal \cpllpd_wait_reg[31]_srl32_n_1\ : STD_LOGIC;
  signal \cpllpd_wait_reg[63]_srl32_n_1\ : STD_LOGIC;
  signal \cpllpd_wait_reg[94]_srl31_n_0\ : STD_LOGIC;
  signal cpllreset_ovrd_i : STD_LOGIC;
  signal \cpllreset_wait_reg[126]_srl31_n_0\ : STD_LOGIC;
  signal \cpllreset_wait_reg[31]_srl32_n_1\ : STD_LOGIC;
  signal \cpllreset_wait_reg[63]_srl32_n_1\ : STD_LOGIC;
  signal \cpllreset_wait_reg[95]_srl32_n_1\ : STD_LOGIC;
  signal data_sync1 : STD_LOGIC;
  signal data_sync2 : STD_LOGIC;
  signal data_sync3 : STD_LOGIC;
  signal data_sync4 : STD_LOGIC;
  signal data_sync5 : STD_LOGIC;
  signal data_sync6 : STD_LOGIC;
  signal flag2 : STD_LOGIC;
  signal flag_i_1_n_0 : STD_LOGIC;
  signal gt0_pllrefclklost_i : STD_LOGIC;
  signal \^gtxe2_i_2\ : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal gtxe2_i_n_0 : STD_LOGIC;
  signal gtxe2_i_n_11 : STD_LOGIC;
  signal gtxe2_i_n_16 : STD_LOGIC;
  signal gtxe2_i_n_170 : STD_LOGIC;
  signal gtxe2_i_n_171 : STD_LOGIC;
  signal gtxe2_i_n_172 : STD_LOGIC;
  signal gtxe2_i_n_173 : STD_LOGIC;
  signal gtxe2_i_n_174 : STD_LOGIC;
  signal gtxe2_i_n_175 : STD_LOGIC;
  signal gtxe2_i_n_176 : STD_LOGIC;
  signal gtxe2_i_n_177 : STD_LOGIC;
  signal gtxe2_i_n_178 : STD_LOGIC;
  signal gtxe2_i_n_179 : STD_LOGIC;
  signal gtxe2_i_n_180 : STD_LOGIC;
  signal gtxe2_i_n_181 : STD_LOGIC;
  signal gtxe2_i_n_182 : STD_LOGIC;
  signal gtxe2_i_n_183 : STD_LOGIC;
  signal gtxe2_i_n_184 : STD_LOGIC;
  signal gtxe2_i_n_23 : STD_LOGIC;
  signal gtxe2_i_n_27 : STD_LOGIC;
  signal gtxe2_i_n_38 : STD_LOGIC;
  signal gtxe2_i_n_39 : STD_LOGIC;
  signal gtxe2_i_n_4 : STD_LOGIC;
  signal gtxe2_i_n_78 : STD_LOGIC;
  signal gtxe2_i_n_79 : STD_LOGIC;
  signal gtxe2_i_n_81 : STD_LOGIC;
  signal gtxe2_i_n_83 : STD_LOGIC;
  signal gtxe2_i_n_84 : STD_LOGIC;
  signal gtxe2_i_n_9 : STD_LOGIC;
  signal rx_buf_err_i : STD_LOGIC;
  signal rx_char_is_k_i : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal rx_data_i : STD_LOGIC_VECTOR ( 15 downto 0 );
  signal rx_disp_err_i : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal rx_not_in_table_i : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal \^rx_realign_i\ : STD_LOGIC;
  signal tx_buf_err_i : STD_LOGIC;
  signal \NLW_cpllpd_wait_reg[31]_srl32_Q_UNCONNECTED\ : STD_LOGIC;
  signal \NLW_cpllpd_wait_reg[63]_srl32_Q_UNCONNECTED\ : STD_LOGIC;
  signal \NLW_cpllpd_wait_reg[94]_srl31_Q31_UNCONNECTED\ : STD_LOGIC;
  signal \NLW_cpllreset_wait_reg[126]_srl31_Q31_UNCONNECTED\ : STD_LOGIC;
  signal \NLW_cpllreset_wait_reg[31]_srl32_Q_UNCONNECTED\ : STD_LOGIC;
  signal \NLW_cpllreset_wait_reg[63]_srl32_Q_UNCONNECTED\ : STD_LOGIC;
  signal \NLW_cpllreset_wait_reg[95]_srl32_Q_UNCONNECTED\ : STD_LOGIC;
  signal NLW_gtxe2_i_GTREFCLKMONITOR_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_PHYSTATUS_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXCHANBONDSEQ_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXCHANISALIGNED_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXCHANREALIGN_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXCOMINITDET_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXCOMSASDET_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXCOMWAKEDET_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXDATAVALID_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXDLYSRESETDONE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXELECIDLE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXHEADERVALID_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXOUTCLKFABRIC_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXOUTCLKPCS_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXPHALIGNDONE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXQPISENN_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXQPISENP_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXRATEDONE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXSTARTOFSEQ_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_RXVALID_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXCOMFINISH_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXDLYSRESETDONE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXGEARBOXREADY_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXPHALIGNDONE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXPHINITDONE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXQPISENN_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXQPISENP_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_TXRATEDONE_UNCONNECTED : STD_LOGIC;
  signal NLW_gtxe2_i_PCSRSVDOUT_UNCONNECTED : STD_LOGIC_VECTOR ( 15 downto 0 );
  signal NLW_gtxe2_i_RXCHARISCOMMA_UNCONNECTED : STD_LOGIC_VECTOR ( 7 downto 2 );
  signal NLW_gtxe2_i_RXCHARISK_UNCONNECTED : STD_LOGIC_VECTOR ( 7 downto 2 );
  signal NLW_gtxe2_i_RXCHBONDO_UNCONNECTED : STD_LOGIC_VECTOR ( 4 downto 0 );
  signal NLW_gtxe2_i_RXDATA_UNCONNECTED : STD_LOGIC_VECTOR ( 63 downto 16 );
  signal NLW_gtxe2_i_RXDISPERR_UNCONNECTED : STD_LOGIC_VECTOR ( 7 downto 2 );
  signal NLW_gtxe2_i_RXHEADER_UNCONNECTED : STD_LOGIC_VECTOR ( 2 downto 0 );
  signal NLW_gtxe2_i_RXNOTINTABLE_UNCONNECTED : STD_LOGIC_VECTOR ( 7 downto 2 );
  signal NLW_gtxe2_i_RXPHMONITOR_UNCONNECTED : STD_LOGIC_VECTOR ( 4 downto 0 );
  signal NLW_gtxe2_i_RXPHSLIPMONITOR_UNCONNECTED : STD_LOGIC_VECTOR ( 4 downto 0 );
  signal NLW_gtxe2_i_RXSTATUS_UNCONNECTED : STD_LOGIC_VECTOR ( 2 downto 0 );
  signal NLW_gtxe2_i_TSTOUT_UNCONNECTED : STD_LOGIC_VECTOR ( 9 downto 0 );
  attribute ASYNC_REG : boolean;
  attribute ASYNC_REG of ack_sync_reg1 : label is std.standard.true;
  attribute BOX_TYPE : string;
  attribute BOX_TYPE of ack_sync_reg1 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT : string;
  attribute SHREG_EXTRACT of ack_sync_reg1 : label is "no";
  attribute XILINX_LEGACY_PRIM : string;
  attribute XILINX_LEGACY_PRIM of ack_sync_reg1 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP : string;
  attribute XILINX_TRANSFORM_PINMAP of ack_sync_reg1 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of ack_sync_reg2 : label is std.standard.true;
  attribute BOX_TYPE of ack_sync_reg2 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of ack_sync_reg2 : label is "no";
  attribute XILINX_LEGACY_PRIM of ack_sync_reg2 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of ack_sync_reg2 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of ack_sync_reg3 : label is std.standard.true;
  attribute BOX_TYPE of ack_sync_reg3 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of ack_sync_reg3 : label is "no";
  attribute XILINX_LEGACY_PRIM of ack_sync_reg3 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of ack_sync_reg3 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of ack_sync_reg4 : label is std.standard.true;
  attribute BOX_TYPE of ack_sync_reg4 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of ack_sync_reg4 : label is "no";
  attribute XILINX_LEGACY_PRIM of ack_sync_reg4 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of ack_sync_reg4 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of ack_sync_reg5 : label is std.standard.true;
  attribute BOX_TYPE of ack_sync_reg5 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of ack_sync_reg5 : label is "no";
  attribute XILINX_LEGACY_PRIM of ack_sync_reg5 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of ack_sync_reg5 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of ack_sync_reg6 : label is std.standard.true;
  attribute BOX_TYPE of ack_sync_reg6 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of ack_sync_reg6 : label is "no";
  attribute XILINX_LEGACY_PRIM of ack_sync_reg6 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of ack_sync_reg6 : label is "VCC:CE GND:R";
  attribute srl_bus_name : string;
  attribute srl_bus_name of \cpllpd_wait_reg[31]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllpd_wait_reg ";
  attribute srl_name : string;
  attribute srl_name of \cpllpd_wait_reg[31]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllpd_wait_reg[31]_srl32 ";
  attribute srl_bus_name of \cpllpd_wait_reg[63]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllpd_wait_reg ";
  attribute srl_name of \cpllpd_wait_reg[63]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllpd_wait_reg[63]_srl32 ";
  attribute srl_bus_name of \cpllpd_wait_reg[94]_srl31\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllpd_wait_reg ";
  attribute srl_name of \cpllpd_wait_reg[94]_srl31\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllpd_wait_reg[94]_srl31 ";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of \cpllpd_wait_reg[95]\ : label is "no";
  attribute srl_bus_name of \cpllreset_wait_reg[126]_srl31\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg ";
  attribute srl_name of \cpllreset_wait_reg[126]_srl31\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg[126]_srl31 ";
  attribute equivalent_register_removal of \cpllreset_wait_reg[127]\ : label is "no";
  attribute srl_bus_name of \cpllreset_wait_reg[31]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg ";
  attribute srl_name of \cpllreset_wait_reg[31]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg[31]_srl32 ";
  attribute srl_bus_name of \cpllreset_wait_reg[63]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg ";
  attribute srl_name of \cpllreset_wait_reg[63]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg[63]_srl32 ";
  attribute srl_bus_name of \cpllreset_wait_reg[95]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg ";
  attribute srl_name of \cpllreset_wait_reg[95]_srl32\ : label is "U0/\gt_wrapper_i/aurora_8b10b_x1_16b_multi_gt_i/gt0_aurora_8b10b_x1_16b_i/cpllreset_wait_reg[95]_srl32 ";
  attribute ASYNC_REG of data_sync_reg1 : label is std.standard.true;
  attribute BOX_TYPE of data_sync_reg1 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of data_sync_reg1 : label is "no";
  attribute XILINX_LEGACY_PRIM of data_sync_reg1 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of data_sync_reg1 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of data_sync_reg2 : label is std.standard.true;
  attribute BOX_TYPE of data_sync_reg2 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of data_sync_reg2 : label is "no";
  attribute XILINX_LEGACY_PRIM of data_sync_reg2 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of data_sync_reg2 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of data_sync_reg3 : label is std.standard.true;
  attribute BOX_TYPE of data_sync_reg3 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of data_sync_reg3 : label is "no";
  attribute XILINX_LEGACY_PRIM of data_sync_reg3 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of data_sync_reg3 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of data_sync_reg4 : label is std.standard.true;
  attribute BOX_TYPE of data_sync_reg4 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of data_sync_reg4 : label is "no";
  attribute XILINX_LEGACY_PRIM of data_sync_reg4 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of data_sync_reg4 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of data_sync_reg5 : label is std.standard.true;
  attribute BOX_TYPE of data_sync_reg5 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of data_sync_reg5 : label is "no";
  attribute XILINX_LEGACY_PRIM of data_sync_reg5 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of data_sync_reg5 : label is "VCC:CE GND:R";
  attribute ASYNC_REG of data_sync_reg6 : label is std.standard.true;
  attribute BOX_TYPE of data_sync_reg6 : label is "PRIMITIVE";
  attribute SHREG_EXTRACT of data_sync_reg6 : label is "no";
  attribute XILINX_LEGACY_PRIM of data_sync_reg6 : label is "FD";
  attribute XILINX_TRANSFORM_PINMAP of data_sync_reg6 : label is "VCC:CE GND:R";
  attribute BOX_TYPE of gtxe2_i : label is "PRIMITIVE";
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of reset_count_r_i_2 : label is "soft_lutpair39";
  attribute SOFT_HLUTNM of \soft_err_r[1]_i_1\ : label is "soft_lutpair39";
  attribute SOFT_HLUTNM of \word_aligned_control_bits_r[0]_i_1\ : label is "soft_lutpair40";
  attribute SOFT_HLUTNM of \word_aligned_control_bits_r[1]_i_1\ : label is "soft_lutpair40";
  attribute SOFT_HLUTNM of \word_aligned_data_r[0]_i_1\ : label is "soft_lutpair41";
  attribute SOFT_HLUTNM of \word_aligned_data_r[10]_i_1\ : label is "soft_lutpair43";
  attribute SOFT_HLUTNM of \word_aligned_data_r[11]_i_1\ : label is "soft_lutpair44";
  attribute SOFT_HLUTNM of \word_aligned_data_r[12]_i_1\ : label is "soft_lutpair45";
  attribute SOFT_HLUTNM of \word_aligned_data_r[13]_i_1\ : label is "soft_lutpair46";
  attribute SOFT_HLUTNM of \word_aligned_data_r[14]_i_1\ : label is "soft_lutpair47";
  attribute SOFT_HLUTNM of \word_aligned_data_r[15]_i_1\ : label is "soft_lutpair48";
  attribute SOFT_HLUTNM of \word_aligned_data_r[1]_i_1\ : label is "soft_lutpair42";
  attribute SOFT_HLUTNM of \word_aligned_data_r[2]_i_1\ : label is "soft_lutpair43";
  attribute SOFT_HLUTNM of \word_aligned_data_r[3]_i_1\ : label is "soft_lutpair44";
  attribute SOFT_HLUTNM of \word_aligned_data_r[4]_i_1\ : label is "soft_lutpair45";
  attribute SOFT_HLUTNM of \word_aligned_data_r[5]_i_1\ : label is "soft_lutpair46";
  attribute SOFT_HLUTNM of \word_aligned_data_r[6]_i_1\ : label is "soft_lutpair47";
  attribute SOFT_HLUTNM of \word_aligned_data_r[7]_i_1\ : label is "soft_lutpair48";
  attribute SOFT_HLUTNM of \word_aligned_data_r[8]_i_1\ : label is "soft_lutpair41";
  attribute SOFT_HLUTNM of \word_aligned_data_r[9]_i_1\ : label is "soft_lutpair42";
begin
  ack_flag <= \^ack_flag\;
  gtxe2_i_2(1 downto 0) <= \^gtxe2_i_2\(1 downto 0);
  rx_realign_i <= \^rx_realign_i\;
ack_flag_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FF90"
    )
        port map (
      I0 => ack_sync6,
      I1 => ack_sync5,
      I2 => \^ack_flag\,
      I3 => flag2,
      O => ack_flag_i_1_n_0
    );
ack_flag_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => ack_flag_i_1_n_0,
      Q => \^ack_flag\,
      R => '0'
    );
ack_sync_reg1: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => data_sync6,
      Q => ack_sync1,
      R => '0'
    );
ack_sync_reg2: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => ack_sync1,
      Q => ack_sync2,
      R => '0'
    );
ack_sync_reg3: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => ack_sync2,
      Q => ack_sync3,
      R => '0'
    );
ack_sync_reg4: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => ack_sync3,
      Q => ack_sync4,
      R => '0'
    );
ack_sync_reg5: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => ack_sync4,
      Q => ack_sync5,
      R => '0'
    );
ack_sync_reg6: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => ack_sync5,
      Q => ack_sync6,
      R => '0'
    );
\cpll_reset_i__0\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"F6"
    )
        port map (
      I0 => data_sync6,
      I1 => data_sync5,
      I2 => cpllreset_ovrd_i,
      O => CPLLRESET
    );
\cpllpd_wait_reg[31]_srl32\: unisim.vcomponents.SRLC32E
    generic map(
      INIT => X"FFFFFFFF"
    )
        port map (
      A(4 downto 0) => B"11111",
      CE => '1',
      CLK => gt_refclk1,
      D => '0',
      Q => \NLW_cpllpd_wait_reg[31]_srl32_Q_UNCONNECTED\,
      Q31 => \cpllpd_wait_reg[31]_srl32_n_1\
    );
\cpllpd_wait_reg[63]_srl32\: unisim.vcomponents.SRLC32E
    generic map(
      INIT => X"FFFFFFFF"
    )
        port map (
      A(4 downto 0) => B"11111",
      CE => '1',
      CLK => gt_refclk1,
      D => \cpllpd_wait_reg[31]_srl32_n_1\,
      Q => \NLW_cpllpd_wait_reg[63]_srl32_Q_UNCONNECTED\,
      Q31 => \cpllpd_wait_reg[63]_srl32_n_1\
    );
\cpllpd_wait_reg[94]_srl31\: unisim.vcomponents.SRLC32E
    generic map(
      INIT => X"7FFFFFFF"
    )
        port map (
      A(4 downto 0) => B"11110",
      CE => '1',
      CLK => gt_refclk1,
      D => \cpllpd_wait_reg[63]_srl32_n_1\,
      Q => \cpllpd_wait_reg[94]_srl31_n_0\,
      Q31 => \NLW_cpllpd_wait_reg[94]_srl31_Q31_UNCONNECTED\
    );
\cpllpd_wait_reg[95]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '1'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => \cpllpd_wait_reg[94]_srl31_n_0\,
      Q => CPLLPD,
      R => '0'
    );
\cpllreset_wait_reg[126]_srl31\: unisim.vcomponents.SRLC32E
    generic map(
      INIT => X"00000000"
    )
        port map (
      A(4 downto 0) => B"11110",
      CE => '1',
      CLK => gt_refclk1,
      D => \cpllreset_wait_reg[95]_srl32_n_1\,
      Q => \cpllreset_wait_reg[126]_srl31_n_0\,
      Q31 => \NLW_cpllreset_wait_reg[126]_srl31_Q31_UNCONNECTED\
    );
\cpllreset_wait_reg[127]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => \cpllreset_wait_reg[126]_srl31_n_0\,
      Q => cpllreset_ovrd_i,
      R => '0'
    );
\cpllreset_wait_reg[31]_srl32\: unisim.vcomponents.SRLC32E
    generic map(
      INIT => X"000000FF"
    )
        port map (
      A(4 downto 0) => B"11111",
      CE => '1',
      CLK => gt_refclk1,
      D => '0',
      Q => \NLW_cpllreset_wait_reg[31]_srl32_Q_UNCONNECTED\,
      Q31 => \cpllreset_wait_reg[31]_srl32_n_1\
    );
\cpllreset_wait_reg[63]_srl32\: unisim.vcomponents.SRLC32E
    generic map(
      INIT => X"00000000"
    )
        port map (
      A(4 downto 0) => B"11111",
      CE => '1',
      CLK => gt_refclk1,
      D => \cpllreset_wait_reg[31]_srl32_n_1\,
      Q => \NLW_cpllreset_wait_reg[63]_srl32_Q_UNCONNECTED\,
      Q31 => \cpllreset_wait_reg[63]_srl32_n_1\
    );
\cpllreset_wait_reg[95]_srl32\: unisim.vcomponents.SRLC32E
    generic map(
      INIT => X"00000000"
    )
        port map (
      A(4 downto 0) => B"11111",
      CE => '1',
      CLK => gt_refclk1,
      D => \cpllreset_wait_reg[63]_srl32_n_1\,
      Q => \NLW_cpllreset_wait_reg[95]_srl32_Q_UNCONNECTED\,
      Q31 => \cpllreset_wait_reg[95]_srl32_n_1\
    );
data_sync_reg1: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => D,
      Q => data_sync1,
      R => '0'
    );
data_sync_reg2: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => data_sync1,
      Q => data_sync2,
      R => '0'
    );
data_sync_reg3: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => data_sync2,
      Q => data_sync3,
      R => '0'
    );
data_sync_reg4: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => data_sync3,
      Q => data_sync4,
      R => '0'
    );
data_sync_reg5: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => data_sync4,
      Q => data_sync5,
      R => '0'
    );
data_sync_reg6: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => gt_refclk1,
      CE => '1',
      D => data_sync5,
      Q => data_sync6,
      R => '0'
    );
flag2_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => flag2_reg_0,
      Q => flag2,
      R => '0'
    );
flag_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B4"
    )
        port map (
      I0 => \^ack_flag\,
      I1 => cpll_reset_i,
      I2 => D,
      O => flag_i_1_n_0
    );
flag_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => flag_i_1_n_0,
      Q => D,
      R => '0'
    );
gtxe2_i: unisim.vcomponents.GTXE2_CHANNEL
    generic map(
      ALIGN_COMMA_DOUBLE => "FALSE",
      ALIGN_COMMA_ENABLE => B"1111111111",
      ALIGN_COMMA_WORD => 2,
      ALIGN_MCOMMA_DET => "TRUE",
      ALIGN_MCOMMA_VALUE => B"1010000011",
      ALIGN_PCOMMA_DET => "TRUE",
      ALIGN_PCOMMA_VALUE => B"0101111100",
      CBCC_DATA_SOURCE_SEL => "DECODED",
      CHAN_BOND_KEEP_ALIGN => "FALSE",
      CHAN_BOND_MAX_SKEW => 7,
      CHAN_BOND_SEQ_1_1 => B"0101111100",
      CHAN_BOND_SEQ_1_2 => B"0000000000",
      CHAN_BOND_SEQ_1_3 => B"0000000000",
      CHAN_BOND_SEQ_1_4 => B"0000000000",
      CHAN_BOND_SEQ_1_ENABLE => B"0001",
      CHAN_BOND_SEQ_2_1 => B"0000000000",
      CHAN_BOND_SEQ_2_2 => B"0000000000",
      CHAN_BOND_SEQ_2_3 => B"0000000000",
      CHAN_BOND_SEQ_2_4 => B"0000000000",
      CHAN_BOND_SEQ_2_ENABLE => B"0000",
      CHAN_BOND_SEQ_2_USE => "FALSE",
      CHAN_BOND_SEQ_LEN => 1,
      CLK_CORRECT_USE => "TRUE",
      CLK_COR_KEEP_IDLE => "FALSE",
      CLK_COR_MAX_LAT => 17,
      CLK_COR_MIN_LAT => 12,
      CLK_COR_PRECEDENCE => "TRUE",
      CLK_COR_REPEAT_WAIT => 0,
      CLK_COR_SEQ_1_1 => B"0111110111",
      CLK_COR_SEQ_1_2 => B"0111110111",
      CLK_COR_SEQ_1_3 => B"0100000000",
      CLK_COR_SEQ_1_4 => B"0100000000",
      CLK_COR_SEQ_1_ENABLE => B"1111",
      CLK_COR_SEQ_2_1 => B"0100000000",
      CLK_COR_SEQ_2_2 => B"0100000000",
      CLK_COR_SEQ_2_3 => B"0100000000",
      CLK_COR_SEQ_2_4 => B"0100000000",
      CLK_COR_SEQ_2_ENABLE => B"1111",
      CLK_COR_SEQ_2_USE => "FALSE",
      CLK_COR_SEQ_LEN => 2,
      CPLL_CFG => X"BC07DC",
      CPLL_FBDIV => 4,
      CPLL_FBDIV_45 => 5,
      CPLL_INIT_CFG => X"00001E",
      CPLL_LOCK_CFG => X"01E8",
      CPLL_REFCLK_DIV => 1,
      DEC_MCOMMA_DETECT => "TRUE",
      DEC_PCOMMA_DETECT => "TRUE",
      DEC_VALID_COMMA_ONLY => "FALSE",
      DMONITOR_CFG => X"000A00",
      ES_CONTROL => B"000000",
      ES_ERRDET_EN => "FALSE",
      ES_EYE_SCAN_EN => "TRUE",
      ES_HORZ_OFFSET => X"000",
      ES_PMA_CFG => B"0000000000",
      ES_PRESCALE => B"00000",
      ES_QUALIFIER => X"00000000000000000000",
      ES_QUAL_MASK => X"00000000000000000000",
      ES_SDATA_MASK => X"00000000000000000000",
      ES_VERT_OFFSET => B"000000000",
      FTS_DESKEW_SEQ_ENABLE => B"1111",
      FTS_LANE_DESKEW_CFG => B"1111",
      FTS_LANE_DESKEW_EN => "FALSE",
      GEARBOX_MODE => B"000",
      IS_CPLLLOCKDETCLK_INVERTED => '0',
      IS_DRPCLK_INVERTED => '0',
      IS_GTGREFCLK_INVERTED => '0',
      IS_RXUSRCLK2_INVERTED => '0',
      IS_RXUSRCLK_INVERTED => '0',
      IS_TXPHDLYTSTCLK_INVERTED => '0',
      IS_TXUSRCLK2_INVERTED => '0',
      IS_TXUSRCLK_INVERTED => '0',
      OUTREFCLK_SEL_INV => B"11",
      PCS_PCIE_EN => "FALSE",
      PCS_RSVD_ATTR => X"000000000000",
      PD_TRANS_TIME_FROM_P2 => X"03C",
      PD_TRANS_TIME_NONE_P2 => X"19",
      PD_TRANS_TIME_TO_P2 => X"64",
      PMA_RSV => X"00018480",
      PMA_RSV2 => X"2050",
      PMA_RSV3 => B"00",
      PMA_RSV4 => X"00000000",
      RXBUFRESET_TIME => B"00001",
      RXBUF_ADDR_MODE => "FULL",
      RXBUF_EIDLE_HI_CNT => B"1000",
      RXBUF_EIDLE_LO_CNT => B"0000",
      RXBUF_EN => "TRUE",
      RXBUF_RESET_ON_CB_CHANGE => "TRUE",
      RXBUF_RESET_ON_COMMAALIGN => "FALSE",
      RXBUF_RESET_ON_EIDLE => "FALSE",
      RXBUF_RESET_ON_RATE_CHANGE => "TRUE",
      RXBUF_THRESH_OVFLW => 61,
      RXBUF_THRESH_OVRD => "FALSE",
      RXBUF_THRESH_UNDFLW => 4,
      RXCDRFREQRESET_TIME => B"00001",
      RXCDRPHRESET_TIME => B"00001",
      RXCDR_CFG => X"03000023FF40200020",
      RXCDR_FR_RESET_ON_EIDLE => '0',
      RXCDR_HOLD_DURING_EIDLE => '0',
      RXCDR_LOCK_CFG => B"010101",
      RXCDR_PH_RESET_ON_EIDLE => '0',
      RXDFELPMRESET_TIME => B"0001111",
      RXDLY_CFG => X"001F",
      RXDLY_LCFG => X"030",
      RXDLY_TAP_CFG => X"0000",
      RXGEARBOX_EN => "FALSE",
      RXISCANRESET_TIME => B"00001",
      RXLPM_HF_CFG => B"00000011110000",
      RXLPM_LF_CFG => B"00000011110000",
      RXOOB_CFG => B"0000110",
      RXOUT_DIV => 2,
      RXPCSRESET_TIME => B"00001",
      RXPHDLY_CFG => X"084020",
      RXPH_CFG => X"000000",
      RXPH_MONITOR_SEL => B"00000",
      RXPMARESET_TIME => B"00011",
      RXPRBS_ERR_LOOPBACK => '0',
      RXSLIDE_AUTO_WAIT => 7,
      RXSLIDE_MODE => "OFF",
      RX_BIAS_CFG => B"000000000100",
      RX_BUFFER_CFG => B"000000",
      RX_CLK25_DIV => 7,
      RX_CLKMUX_PD => '1',
      RX_CM_SEL => B"11",
      RX_CM_TRIM => B"010",
      RX_DATA_WIDTH => 20,
      RX_DDI_SEL => B"000000",
      RX_DEBUG_CFG => B"000000000000",
      RX_DEFER_RESET_BUF_EN => "TRUE",
      RX_DFE_GAIN_CFG => X"020FEA",
      RX_DFE_H2_CFG => B"000000000000",
      RX_DFE_H3_CFG => B"000001000000",
      RX_DFE_H4_CFG => B"00011110000",
      RX_DFE_H5_CFG => B"00011100000",
      RX_DFE_KL_CFG => B"0000011111110",
      RX_DFE_KL_CFG2 => X"3010D90C",
      RX_DFE_LPM_CFG => X"0954",
      RX_DFE_LPM_HOLD_DURING_EIDLE => '0',
      RX_DFE_UT_CFG => B"10001111000000000",
      RX_DFE_VP_CFG => B"00011111100000011",
      RX_DFE_XYD_CFG => B"0000000000000",
      RX_DISPERR_SEQ_MATCH => "TRUE",
      RX_INT_DATAWIDTH => 0,
      RX_OS_CFG => B"0000010000000",
      RX_SIG_VALID_DLY => 10,
      RX_XCLK_SEL => "RXREC",
      SAS_MAX_COM => 64,
      SAS_MIN_COM => 36,
      SATA_BURST_SEQ_LEN => B"0101",
      SATA_BURST_VAL => B"100",
      SATA_CPLL_CFG => "VCO_3000MHZ",
      SATA_EIDLE_VAL => B"100",
      SATA_MAX_BURST => 8,
      SATA_MAX_INIT => 21,
      SATA_MAX_WAKE => 7,
      SATA_MIN_BURST => 4,
      SATA_MIN_INIT => 12,
      SATA_MIN_WAKE => 4,
      SHOW_REALIGN_COMMA => "TRUE",
      SIM_CPLLREFCLK_SEL => B"001",
      SIM_RECEIVER_DETECT_PASS => "TRUE",
      SIM_RESET_SPEEDUP => "TRUE",
      SIM_TX_EIDLE_DRIVE_LEVEL => "X",
      SIM_VERSION => "4.0",
      TERM_RCAL_CFG => B"10000",
      TERM_RCAL_OVRD => '0',
      TRANS_TIME_RATE => X"0E",
      TST_RSV => X"00000000",
      TXBUF_EN => "TRUE",
      TXBUF_RESET_ON_RATE_CHANGE => "TRUE",
      TXDLY_CFG => X"001F",
      TXDLY_LCFG => X"030",
      TXDLY_TAP_CFG => X"0000",
      TXGEARBOX_EN => "FALSE",
      TXOUT_DIV => 2,
      TXPCSRESET_TIME => B"00001",
      TXPHDLY_CFG => X"084020",
      TXPH_CFG => X"0780",
      TXPH_MONITOR_SEL => B"00000",
      TXPMARESET_TIME => B"00001",
      TX_CLK25_DIV => 7,
      TX_CLKMUX_PD => '1',
      TX_DATA_WIDTH => 20,
      TX_DEEMPH0 => B"00000",
      TX_DEEMPH1 => B"00000",
      TX_DRIVE_MODE => "DIRECT",
      TX_EIDLE_ASSERT_DELAY => B"110",
      TX_EIDLE_DEASSERT_DELAY => B"100",
      TX_INT_DATAWIDTH => 0,
      TX_LOOPBACK_DRIVE_HIZ => "FALSE",
      TX_MAINCURSOR_SEL => '0',
      TX_MARGIN_FULL_0 => B"1001110",
      TX_MARGIN_FULL_1 => B"1001001",
      TX_MARGIN_FULL_2 => B"1000101",
      TX_MARGIN_FULL_3 => B"1000010",
      TX_MARGIN_FULL_4 => B"1000000",
      TX_MARGIN_LOW_0 => B"1000110",
      TX_MARGIN_LOW_1 => B"1000100",
      TX_MARGIN_LOW_2 => B"1000010",
      TX_MARGIN_LOW_3 => B"1000000",
      TX_MARGIN_LOW_4 => B"1000000",
      TX_PREDRIVER_MODE => '0',
      TX_QPI_STATUS_EN => '0',
      TX_RXDETECT_CFG => X"1832",
      TX_RXDETECT_REF => B"100",
      TX_XCLK_SEL => "TXOUT",
      UCODEER_CLR => '0'
    )
        port map (
      CFGRESET => '0',
      CLKRSVD(3 downto 0) => B"0000",
      CPLLFBCLKLOST => gtxe2_i_n_0,
      CPLLLOCK => tx_lock,
      CPLLLOCKDETCLK => init_clk_in,
      CPLLLOCKEN => '1',
      CPLLPD => CPLLPD,
      CPLLREFCLKLOST => gt0_pllrefclklost_i,
      CPLLREFCLKSEL(2 downto 0) => B"001",
      CPLLRESET => CPLLRESET,
      DMONITOROUT(7) => gtxe2_i_n_177,
      DMONITOROUT(6) => gtxe2_i_n_178,
      DMONITOROUT(5) => gtxe2_i_n_179,
      DMONITOROUT(4) => gtxe2_i_n_180,
      DMONITOROUT(3) => gtxe2_i_n_181,
      DMONITOROUT(2) => gtxe2_i_n_182,
      DMONITOROUT(1) => gtxe2_i_n_183,
      DMONITOROUT(0) => gtxe2_i_n_184,
      DRPADDR(8 downto 0) => DRPADDR_IN(8 downto 0),
      DRPCLK => drpclk_in,
      DRPDI(15 downto 0) => DRPDI_IN(15 downto 0),
      DRPDO(15 downto 0) => DRPDO_OUT(15 downto 0),
      DRPEN => DRPEN_IN,
      DRPRDY => DRPRDY_OUT,
      DRPWE => DRPWE_IN,
      EYESCANDATAERROR => gtxe2_i_n_4,
      EYESCANMODE => '0',
      EYESCANRESET => '0',
      EYESCANTRIGGER => '0',
      GTGREFCLK => '0',
      GTNORTHREFCLK0 => '0',
      GTNORTHREFCLK1 => '0',
      GTREFCLK0 => gt_refclk1,
      GTREFCLK1 => '0',
      GTREFCLKMONITOR => NLW_gtxe2_i_GTREFCLKMONITOR_UNCONNECTED,
      GTRESETSEL => '0',
      GTRSVD(15 downto 0) => B"0000000000000000",
      GTRXRESET => SR(0),
      GTSOUTHREFCLK0 => '0',
      GTSOUTHREFCLK1 => '0',
      GTTXRESET => gt_tx_reset_i,
      GTXRXN => RXN,
      GTXRXP => RXP,
      GTXTXN => TXN,
      GTXTXP => TXP,
      LOOPBACK(2 downto 0) => LOOPBACK(2 downto 0),
      PCSRSVDIN(15 downto 0) => B"0000000000000000",
      PCSRSVDIN2(4 downto 0) => B"00000",
      PCSRSVDOUT(15 downto 0) => NLW_gtxe2_i_PCSRSVDOUT_UNCONNECTED(15 downto 0),
      PHYSTATUS => NLW_gtxe2_i_PHYSTATUS_UNCONNECTED,
      PMARSVDIN(4 downto 0) => B"00000",
      PMARSVDIN2(4 downto 0) => B"00000",
      QPLLCLK => gt_qpllclk_quad1_in,
      QPLLREFCLK => gt_qpllrefclk_quad1_in,
      RESETOVRD => '0',
      RX8B10BEN => '1',
      RXBUFRESET => '0',
      RXBUFSTATUS(2) => rx_buf_err_i,
      RXBUFSTATUS(1) => gtxe2_i_n_83,
      RXBUFSTATUS(0) => gtxe2_i_n_84,
      RXBYTEISALIGNED => gtxe2_i_n_9,
      RXBYTEREALIGN => \^rx_realign_i\,
      RXCDRFREQRESET => '0',
      RXCDRHOLD => '0',
      RXCDRLOCK => gtxe2_i_n_11,
      RXCDROVRDEN => '0',
      RXCDRRESET => '0',
      RXCDRRESETRSV => '0',
      RXCHANBONDSEQ => NLW_gtxe2_i_RXCHANBONDSEQ_UNCONNECTED,
      RXCHANISALIGNED => NLW_gtxe2_i_RXCHANISALIGNED_UNCONNECTED,
      RXCHANREALIGN => NLW_gtxe2_i_RXCHANREALIGN_UNCONNECTED,
      RXCHARISCOMMA(7 downto 2) => NLW_gtxe2_i_RXCHARISCOMMA_UNCONNECTED(7 downto 2),
      RXCHARISCOMMA(1 downto 0) => \^gtxe2_i_2\(1 downto 0),
      RXCHARISK(7 downto 2) => NLW_gtxe2_i_RXCHARISK_UNCONNECTED(7 downto 2),
      RXCHARISK(1 downto 0) => rx_char_is_k_i(1 downto 0),
      RXCHBONDEN => '0',
      RXCHBONDI(4 downto 0) => B"00000",
      RXCHBONDLEVEL(2 downto 0) => B"000",
      RXCHBONDMASTER => '0',
      RXCHBONDO(4 downto 0) => NLW_gtxe2_i_RXCHBONDO_UNCONNECTED(4 downto 0),
      RXCHBONDSLAVE => '0',
      RXCLKCORCNT(1) => gtxe2_i_n_78,
      RXCLKCORCNT(0) => gtxe2_i_n_79,
      RXCOMINITDET => NLW_gtxe2_i_RXCOMINITDET_UNCONNECTED,
      RXCOMMADET => gtxe2_i_n_16,
      RXCOMMADETEN => '1',
      RXCOMSASDET => NLW_gtxe2_i_RXCOMSASDET_UNCONNECTED,
      RXCOMWAKEDET => NLW_gtxe2_i_RXCOMWAKEDET_UNCONNECTED,
      RXDATA(63 downto 16) => NLW_gtxe2_i_RXDATA_UNCONNECTED(63 downto 16),
      RXDATA(15 downto 0) => rx_data_i(15 downto 0),
      RXDATAVALID => NLW_gtxe2_i_RXDATAVALID_UNCONNECTED,
      RXDDIEN => '0',
      RXDFEAGCHOLD => gt_rxdfelfhold_i,
      RXDFEAGCOVRDEN => '0',
      RXDFECM1EN => '0',
      RXDFELFHOLD => gt_rxdfelfhold_i,
      RXDFELFOVRDEN => '1',
      RXDFELPMRESET => '0',
      RXDFETAP2HOLD => '0',
      RXDFETAP2OVRDEN => '0',
      RXDFETAP3HOLD => '0',
      RXDFETAP3OVRDEN => '0',
      RXDFETAP4HOLD => '0',
      RXDFETAP4OVRDEN => '0',
      RXDFETAP5HOLD => '0',
      RXDFETAP5OVRDEN => '0',
      RXDFEUTHOLD => '0',
      RXDFEUTOVRDEN => '0',
      RXDFEVPHOLD => '0',
      RXDFEVPOVRDEN => '0',
      RXDFEVSEN => '0',
      RXDFEXYDEN => '1',
      RXDFEXYDHOLD => '0',
      RXDFEXYDOVRDEN => '0',
      RXDISPERR(7 downto 2) => NLW_gtxe2_i_RXDISPERR_UNCONNECTED(7 downto 2),
      RXDISPERR(1 downto 0) => rx_disp_err_i(1 downto 0),
      RXDLYBYPASS => '1',
      RXDLYEN => '0',
      RXDLYOVRDEN => '0',
      RXDLYSRESET => '0',
      RXDLYSRESETDONE => NLW_gtxe2_i_RXDLYSRESETDONE_UNCONNECTED,
      RXELECIDLE => NLW_gtxe2_i_RXELECIDLE_UNCONNECTED,
      RXELECIDLEMODE(1 downto 0) => B"11",
      RXGEARBOXSLIP => '0',
      RXHEADER(2 downto 0) => NLW_gtxe2_i_RXHEADER_UNCONNECTED(2 downto 0),
      RXHEADERVALID => NLW_gtxe2_i_RXHEADERVALID_UNCONNECTED,
      RXLPMEN => '0',
      RXLPMHFHOLD => '0',
      RXLPMHFOVRDEN => '0',
      RXLPMLFHOLD => '0',
      RXLPMLFKLOVRDEN => '0',
      RXMCOMMAALIGNEN => ena_comma_align_i,
      RXMONITOROUT(6) => gtxe2_i_n_170,
      RXMONITOROUT(5) => gtxe2_i_n_171,
      RXMONITOROUT(4) => gtxe2_i_n_172,
      RXMONITOROUT(3) => gtxe2_i_n_173,
      RXMONITOROUT(2) => gtxe2_i_n_174,
      RXMONITOROUT(1) => gtxe2_i_n_175,
      RXMONITOROUT(0) => gtxe2_i_n_176,
      RXMONITORSEL(1 downto 0) => B"00",
      RXNOTINTABLE(7 downto 2) => NLW_gtxe2_i_RXNOTINTABLE_UNCONNECTED(7 downto 2),
      RXNOTINTABLE(1 downto 0) => rx_not_in_table_i(1 downto 0),
      RXOOBRESET => '0',
      RXOSHOLD => '0',
      RXOSOVRDEN => '0',
      RXOUTCLK => gtxe2_i_n_23,
      RXOUTCLKFABRIC => NLW_gtxe2_i_RXOUTCLKFABRIC_UNCONNECTED,
      RXOUTCLKPCS => NLW_gtxe2_i_RXOUTCLKPCS_UNCONNECTED,
      RXOUTCLKSEL(2 downto 0) => B"010",
      RXPCOMMAALIGNEN => ena_comma_align_i,
      RXPCSRESET => '0',
      RXPD(1) => POWER_DOWN,
      RXPD(0) => POWER_DOWN,
      RXPHALIGN => '0',
      RXPHALIGNDONE => NLW_gtxe2_i_RXPHALIGNDONE_UNCONNECTED,
      RXPHALIGNEN => '0',
      RXPHDLYPD => '0',
      RXPHDLYRESET => '0',
      RXPHMONITOR(4 downto 0) => NLW_gtxe2_i_RXPHMONITOR_UNCONNECTED(4 downto 0),
      RXPHOVRDEN => '0',
      RXPHSLIPMONITOR(4 downto 0) => NLW_gtxe2_i_RXPHSLIPMONITOR_UNCONNECTED(4 downto 0),
      RXPMARESET => '0',
      RXPOLARITY => rx_polarity_i,
      RXPRBSCNTRESET => '0',
      RXPRBSERR => gtxe2_i_n_27,
      RXPRBSSEL(2 downto 0) => B"000",
      RXQPIEN => '0',
      RXQPISENN => NLW_gtxe2_i_RXQPISENN_UNCONNECTED,
      RXQPISENP => NLW_gtxe2_i_RXQPISENP_UNCONNECTED,
      RXRATE(2 downto 0) => B"000",
      RXRATEDONE => NLW_gtxe2_i_RXRATEDONE_UNCONNECTED,
      RXRESETDONE => gtxe2_i_0,
      RXSLIDE => '0',
      RXSTARTOFSEQ => NLW_gtxe2_i_RXSTARTOFSEQ_UNCONNECTED,
      RXSTATUS(2 downto 0) => NLW_gtxe2_i_RXSTATUS_UNCONNECTED(2 downto 0),
      RXSYSCLKSEL(1 downto 0) => B"00",
      RXUSERRDY => gt_rxuserrdy_i,
      RXUSRCLK => sync_clk,
      RXUSRCLK2 => user_clk,
      RXVALID => NLW_gtxe2_i_RXVALID_UNCONNECTED,
      SETERRSTATUS => '0',
      TSTIN(19 downto 0) => B"11111111111111111111",
      TSTOUT(9 downto 0) => NLW_gtxe2_i_TSTOUT_UNCONNECTED(9 downto 0),
      TX8B10BBYPASS(7 downto 0) => B"00000000",
      TX8B10BEN => '1',
      TXBUFDIFFCTRL(2 downto 0) => B"100",
      TXBUFSTATUS(1) => tx_buf_err_i,
      TXBUFSTATUS(0) => gtxe2_i_n_81,
      TXCHARDISPMODE(7 downto 0) => B"00000000",
      TXCHARDISPVAL(7 downto 0) => B"00000000",
      TXCHARISK(7 downto 2) => B"000000",
      TXCHARISK(1 downto 0) => TXCHARISK(1 downto 0),
      TXCOMFINISH => NLW_gtxe2_i_TXCOMFINISH_UNCONNECTED,
      TXCOMINIT => '0',
      TXCOMSAS => '0',
      TXCOMWAKE => '0',
      TXDATA(63 downto 16) => B"000000000000000000000000000000000000000000000000",
      TXDATA(15 downto 0) => TXDATA(15 downto 0),
      TXDEEMPH => '0',
      TXDETECTRX => '0',
      TXDIFFCTRL(3 downto 0) => B"1000",
      TXDIFFPD => '0',
      TXDLYBYPASS => '1',
      TXDLYEN => '0',
      TXDLYHOLD => '0',
      TXDLYOVRDEN => '0',
      TXDLYSRESET => '0',
      TXDLYSRESETDONE => NLW_gtxe2_i_TXDLYSRESETDONE_UNCONNECTED,
      TXDLYUPDOWN => '0',
      TXELECIDLE => POWER_DOWN,
      TXGEARBOXREADY => NLW_gtxe2_i_TXGEARBOXREADY_UNCONNECTED,
      TXHEADER(2 downto 0) => B"000",
      TXINHIBIT => '0',
      TXMAINCURSOR(6 downto 0) => B"0000000",
      TXMARGIN(2 downto 0) => B"000",
      TXOUTCLK => TX_OUT_CLK,
      TXOUTCLKFABRIC => gtxe2_i_n_38,
      TXOUTCLKPCS => gtxe2_i_n_39,
      TXOUTCLKSEL(2 downto 0) => B"010",
      TXPCSRESET => '0',
      TXPD(1) => POWER_DOWN,
      TXPD(0) => POWER_DOWN,
      TXPDELECIDLEMODE => '0',
      TXPHALIGN => '0',
      TXPHALIGNDONE => NLW_gtxe2_i_TXPHALIGNDONE_UNCONNECTED,
      TXPHALIGNEN => '0',
      TXPHDLYPD => '0',
      TXPHDLYRESET => '0',
      TXPHDLYTSTCLK => '0',
      TXPHINIT => '0',
      TXPHINITDONE => NLW_gtxe2_i_TXPHINITDONE_UNCONNECTED,
      TXPHOVRDEN => '0',
      TXPISOPD => '0',
      TXPMARESET => '0',
      TXPOLARITY => '0',
      TXPOSTCURSOR(4 downto 0) => B"00000",
      TXPOSTCURSORINV => '0',
      TXPRBSFORCEERR => '0',
      TXPRBSSEL(2 downto 0) => B"000",
      TXPRECURSOR(4 downto 0) => B"00000",
      TXPRECURSORINV => '0',
      TXQPIBIASEN => '0',
      TXQPISENN => NLW_gtxe2_i_TXQPISENN_UNCONNECTED,
      TXQPISENP => NLW_gtxe2_i_TXQPISENP_UNCONNECTED,
      TXQPISTRONGPDOWN => '0',
      TXQPIWEAKPUP => '0',
      TXRATE(2 downto 0) => B"000",
      TXRATEDONE => NLW_gtxe2_i_TXRATEDONE_UNCONNECTED,
      TXRESETDONE => gtxe2_i_1,
      TXSEQUENCE(6 downto 0) => B"0000000",
      TXSTARTSEQ => '0',
      TXSWING => '0',
      TXSYSCLKSEL(1 downto 0) => B"00",
      TXUSERRDY => gt_txuserrdy_i,
      TXUSRCLK => sync_clk,
      TXUSRCLK2 => user_clk
    );
hard_err_flop_r_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFE"
    )
        port map (
      I0 => hard_err_flop_r_reg,
      I1 => rx_buf_err_i,
      I2 => \^rx_realign_i\,
      I3 => tx_buf_err_i,
      O => hard_err_flop_r0
    );
left_aligned_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFBFFBFF00800800"
    )
        port map (
      I0 => \^gtxe2_i_2\(0),
      I1 => left_aligned_r_reg_0,
      I2 => \^gtxe2_i_2\(1),
      I3 => rx_char_is_k_i(0),
      I4 => rx_char_is_k_i(1),
      I5 => left_aligned_r_reg,
      O => gtxe2_i_9
    );
reset_count_r_i_2: unisim.vcomponents.LUT5
    generic map(
      INIT => X"0F0F0F0E"
    )
        port map (
      I0 => rx_disp_err_i(1),
      I1 => rx_not_in_table_i(1),
      I2 => tx_reset_i,
      I3 => rx_disp_err_i(0),
      I4 => rx_not_in_table_i(0),
      O => gtxe2_i_5
    );
\soft_err_r[0]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => rx_disp_err_i(0),
      I1 => rx_not_in_table_i(0),
      O => gtxe2_i_6(1)
    );
\soft_err_r[1]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => rx_disp_err_i(1),
      I1 => rx_not_in_table_i(1),
      O => gtxe2_i_6(0)
    );
\word_aligned_control_bits_r[0]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_char_is_k_i(0),
      I1 => left_aligned_r_reg,
      I2 => rx_char_is_k_i(1),
      O => gtxe2_i_4
    );
\word_aligned_control_bits_r[1]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_char_is_k_i(1),
      I1 => left_aligned_r_reg,
      I2 => rx_char_is_k_i(0),
      O => gtxe2_i_3
    );
\word_aligned_data_r[0]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(7),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(15),
      O => gtxe2_i_8(7)
    );
\word_aligned_data_r[10]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(13),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(5),
      O => gtxe2_i_7(5)
    );
\word_aligned_data_r[11]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(12),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(4),
      O => gtxe2_i_7(4)
    );
\word_aligned_data_r[12]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(11),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(3),
      O => gtxe2_i_7(3)
    );
\word_aligned_data_r[13]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(10),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(2),
      O => gtxe2_i_7(2)
    );
\word_aligned_data_r[14]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(9),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(1),
      O => gtxe2_i_7(1)
    );
\word_aligned_data_r[15]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(8),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(0),
      O => gtxe2_i_7(0)
    );
\word_aligned_data_r[1]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(6),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(14),
      O => gtxe2_i_8(6)
    );
\word_aligned_data_r[2]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(5),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(13),
      O => gtxe2_i_8(5)
    );
\word_aligned_data_r[3]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(4),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(12),
      O => gtxe2_i_8(4)
    );
\word_aligned_data_r[4]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(3),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(11),
      O => gtxe2_i_8(3)
    );
\word_aligned_data_r[5]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(2),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(10),
      O => gtxe2_i_8(2)
    );
\word_aligned_data_r[6]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(1),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(9),
      O => gtxe2_i_8(1)
    );
\word_aligned_data_r[7]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(0),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(8),
      O => gtxe2_i_8(0)
    );
\word_aligned_data_r[8]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(15),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(7),
      O => gtxe2_i_7(7)
    );
\word_aligned_data_r[9]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"B8"
    )
        port map (
      I0 => rx_data_i(14),
      I1 => left_aligned_r_reg,
      I2 => rx_data_i(6),
      O => gtxe2_i_7(6)
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_GLOBAL_LOGIC is
  port (
    SR : out STD_LOGIC_VECTOR ( 0 to 0 );
    gen_v_flop_0_i : out STD_LOGIC_VECTOR ( 1 downto 0 );
    gen_a_i : out STD_LOGIC;
    gen_k_flop_0_i : out STD_LOGIC_VECTOR ( 1 downto 0 );
    gen_r_flop_0_i : out STD_LOGIC_VECTOR ( 1 downto 0 );
    CHANNEL_UP : out STD_LOGIC;
    gtrxreset_i : out STD_LOGIC;
    HARD_ERR : out STD_LOGIC;
    SOFT_ERR : out STD_LOGIC;
    START_RX_Buffer_reg_inv : out STD_LOGIC_VECTOR ( 0 to 0 );
    begin_r0 : out STD_LOGIC;
    p_0_in : out STD_LOGIC;
    user_clk : in STD_LOGIC;
    lfsr_last_flop_i : in STD_LOGIC;
    got_v_i : in STD_LOGIC;
    hard_err_i : in STD_LOGIC;
    LANE_UP : in STD_LOGIC;
    soft_err_flop_r0 : in STD_LOGIC;
    hard_err_reset_i : in STD_LOGIC;
    POWER_DOWN : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_GLOBAL_LOGIC;

architecture STRUCTURE of aurora_8b10b_x1_16b_GLOBAL_LOGIC is
  signal D1_out : STD_LOGIC;
  signal did_ver_i : STD_LOGIC;
  signal gen_ver_i : STD_LOGIC;
  signal reset_channel_i : STD_LOGIC;
  signal txver_count_r0 : STD_LOGIC;
  signal wait_for_lane_up_r0 : STD_LOGIC;
begin
channel_err_detect_i: entity work.aurora_8b10b_x1_16b_CHANNEL_ERR_DETECT
     port map (
      HARD_ERR => HARD_ERR,
      LANE_UP => LANE_UP,
      POWER_DOWN => POWER_DOWN,
      SOFT_ERR => SOFT_ERR,
      hard_err_i => hard_err_i,
      reset_channel_i => reset_channel_i,
      soft_err_flop_r0 => soft_err_flop_r0,
      user_clk => user_clk,
      verify_r_reg => lfsr_last_flop_i,
      wait_for_lane_up_r0 => wait_for_lane_up_r0
    );
channel_init_sm_i: entity work.aurora_8b10b_x1_16b_CHANNEL_INIT_SM
     port map (
      CHANNEL_UP => CHANNEL_UP,
      D1_out => D1_out,
      SR(0) => SR(0),
      START_RX_Buffer_reg_inv_0(0) => START_RX_Buffer_reg_inv(0),
      START_RX_Buffer_reg_inv_1 => lfsr_last_flop_i,
      begin_r0 => begin_r0,
      did_ver_i => did_ver_i,
      gen_ver_i => gen_ver_i,
      got_v_i => got_v_i,
      gtrxreset_i => gtrxreset_i,
      hard_err_reset_i => hard_err_reset_i,
      p_0_in => p_0_in,
      reset_channel_i => reset_channel_i,
      txver_count_r0 => txver_count_r0,
      user_clk => user_clk,
      wait_for_lane_up_r0 => wait_for_lane_up_r0
    );
idle_and_ver_gen_i: entity work.aurora_8b10b_x1_16b_IDLE_AND_VER_GEN
     port map (
      D1_out => D1_out,
      did_ver_i => did_ver_i,
      gen_a_i => gen_a_i,
      gen_k_flop_0_i_0(1 downto 0) => gen_k_flop_0_i(1 downto 0),
      gen_r_flop_0_i_0(1 downto 0) => gen_r_flop_0_i(1 downto 0),
      gen_v_flop_0_i_0(1 downto 0) => gen_v_flop_0_i(1 downto 0),
      gen_ver_i => gen_ver_i,
      lfsr_last_flop_i_0 => lfsr_last_flop_i,
      txver_count_r0 => txver_count_r0,
      user_clk => user_clk
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_HOTPLUG is
  port (
    LINK_RESET_OUT : out STD_LOGIC;
    user_clk : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    HPCNT_RESET : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    D : in STD_LOGIC_VECTOR ( 0 to 0 )
  );
end aurora_8b10b_x1_16b_HOTPLUG;

architecture STRUCTURE of aurora_8b10b_x1_16b_HOTPLUG is
  signal \hotplug_count_synth.count_for_reset_r_reg\ : STD_LOGIC_VECTOR ( 25 downto 0 );
  signal link_reset_0 : STD_LOGIC;
  signal link_reset_r : STD_LOGIC;
  signal link_reset_r_i_2_n_0 : STD_LOGIC;
  signal link_reset_r_i_3_n_0 : STD_LOGIC;
  signal link_reset_r_i_4_n_0 : STD_LOGIC;
  signal link_reset_r_i_5_n_0 : STD_LOGIC;
  signal link_reset_r_i_6_n_0 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_0 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_1 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_10 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_11 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_12 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_13 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_14 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_15 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_16 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_17 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_18 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_19 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_2 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_20 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_21 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_22 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_23 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_24 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_25 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_3 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_4 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_5 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_6 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_7 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_8 : STD_LOGIC;
  signal rx_cc_cdc_sync_n_9 : STD_LOGIC;
  signal rx_cc_extend_r : STD_LOGIC_VECTOR ( 7 downto 0 );
  signal rx_cc_extend_r2 : STD_LOGIC;
  signal rx_cc_extend_r2_i_1_n_0 : STD_LOGIC;
  signal rx_cc_extend_r2_i_2_n_0 : STD_LOGIC;
begin
\hotplug_count_synth.count_for_reset_r_reg[0]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_3,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(0)
    );
\hotplug_count_synth.count_for_reset_r_reg[10]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_9,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(10)
    );
\hotplug_count_synth.count_for_reset_r_reg[11]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_8,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(11)
    );
\hotplug_count_synth.count_for_reset_r_reg[12]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_15,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(12)
    );
\hotplug_count_synth.count_for_reset_r_reg[13]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_14,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(13)
    );
\hotplug_count_synth.count_for_reset_r_reg[14]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_13,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(14)
    );
\hotplug_count_synth.count_for_reset_r_reg[15]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_12,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(15)
    );
\hotplug_count_synth.count_for_reset_r_reg[16]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_19,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(16)
    );
\hotplug_count_synth.count_for_reset_r_reg[17]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_18,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(17)
    );
\hotplug_count_synth.count_for_reset_r_reg[18]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_17,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(18)
    );
\hotplug_count_synth.count_for_reset_r_reg[19]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_16,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(19)
    );
\hotplug_count_synth.count_for_reset_r_reg[1]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_2,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(1)
    );
\hotplug_count_synth.count_for_reset_r_reg[20]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_23,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(20)
    );
\hotplug_count_synth.count_for_reset_r_reg[21]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_22,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(21)
    );
\hotplug_count_synth.count_for_reset_r_reg[22]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_21,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(22)
    );
\hotplug_count_synth.count_for_reset_r_reg[23]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_20,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(23)
    );
\hotplug_count_synth.count_for_reset_r_reg[24]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_25,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(24)
    );
\hotplug_count_synth.count_for_reset_r_reg[25]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_24,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(25)
    );
\hotplug_count_synth.count_for_reset_r_reg[2]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_1,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(2)
    );
\hotplug_count_synth.count_for_reset_r_reg[3]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_0,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(3)
    );
\hotplug_count_synth.count_for_reset_r_reg[4]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_7,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(4)
    );
\hotplug_count_synth.count_for_reset_r_reg[5]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_6,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(5)
    );
\hotplug_count_synth.count_for_reset_r_reg[6]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_5,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(6)
    );
\hotplug_count_synth.count_for_reset_r_reg[7]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_4,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(7)
    );
\hotplug_count_synth.count_for_reset_r_reg[8]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_11,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(8)
    );
\hotplug_count_synth.count_for_reset_r_reg[9]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => HPCNT_RESET,
      D => rx_cc_cdc_sync_n_10,
      Q => \hotplug_count_synth.count_for_reset_r_reg\(9)
    );
\hotplug_enable.LINK_RESET_OUT_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => link_reset_r,
      Q => LINK_RESET_OUT,
      R => '0'
    );
link_reset_r_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"80000000"
    )
        port map (
      I0 => link_reset_r_i_2_n_0,
      I1 => link_reset_r_i_3_n_0,
      I2 => link_reset_r_i_4_n_0,
      I3 => link_reset_r_i_5_n_0,
      I4 => link_reset_r_i_6_n_0,
      O => link_reset_0
    );
link_reset_r_i_2: unisim.vcomponents.LUT3
    generic map(
      INIT => X"80"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(7),
      I1 => \hotplug_count_synth.count_for_reset_r_reg\(6),
      I2 => \hotplug_count_synth.count_for_reset_r_reg\(5),
      O => link_reset_r_i_2_n_0
    );
link_reset_r_i_3: unisim.vcomponents.LUT5
    generic map(
      INIT => X"78F8F8F8"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(2),
      I1 => \hotplug_count_synth.count_for_reset_r_reg\(3),
      I2 => \hotplug_count_synth.count_for_reset_r_reg\(4),
      I3 => \hotplug_count_synth.count_for_reset_r_reg\(1),
      I4 => \hotplug_count_synth.count_for_reset_r_reg\(0),
      O => link_reset_r_i_3_n_0
    );
link_reset_r_i_4: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(16),
      I1 => \hotplug_count_synth.count_for_reset_r_reg\(17),
      I2 => \hotplug_count_synth.count_for_reset_r_reg\(14),
      I3 => \hotplug_count_synth.count_for_reset_r_reg\(15),
      I4 => \hotplug_count_synth.count_for_reset_r_reg\(19),
      I5 => \hotplug_count_synth.count_for_reset_r_reg\(18),
      O => link_reset_r_i_4_n_0
    );
link_reset_r_i_5: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(10),
      I1 => \hotplug_count_synth.count_for_reset_r_reg\(11),
      I2 => \hotplug_count_synth.count_for_reset_r_reg\(8),
      I3 => \hotplug_count_synth.count_for_reset_r_reg\(9),
      I4 => \hotplug_count_synth.count_for_reset_r_reg\(13),
      I5 => \hotplug_count_synth.count_for_reset_r_reg\(12),
      O => link_reset_r_i_5_n_0
    );
link_reset_r_i_6: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => \hotplug_count_synth.count_for_reset_r_reg\(22),
      I1 => \hotplug_count_synth.count_for_reset_r_reg\(23),
      I2 => \hotplug_count_synth.count_for_reset_r_reg\(20),
      I3 => \hotplug_count_synth.count_for_reset_r_reg\(21),
      I4 => \hotplug_count_synth.count_for_reset_r_reg\(25),
      I5 => \hotplug_count_synth.count_for_reset_r_reg\(24),
      O => link_reset_r_i_6_n_0
    );
link_reset_r_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => link_reset_0,
      Q => link_reset_r,
      R => '0'
    );
rx_cc_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_18\
     port map (
      O(3) => rx_cc_cdc_sync_n_0,
      O(2) => rx_cc_cdc_sync_n_1,
      O(1) => rx_cc_cdc_sync_n_2,
      O(0) => rx_cc_cdc_sync_n_3,
      \hotplug_count_synth.count_for_reset_r_reg\(25 downto 0) => \hotplug_count_synth.count_for_reset_r_reg\(25 downto 0),
      \hotplug_count_synth.count_for_reset_r_reg[11]\(3) => rx_cc_cdc_sync_n_8,
      \hotplug_count_synth.count_for_reset_r_reg[11]\(2) => rx_cc_cdc_sync_n_9,
      \hotplug_count_synth.count_for_reset_r_reg[11]\(1) => rx_cc_cdc_sync_n_10,
      \hotplug_count_synth.count_for_reset_r_reg[11]\(0) => rx_cc_cdc_sync_n_11,
      \hotplug_count_synth.count_for_reset_r_reg[15]\(3) => rx_cc_cdc_sync_n_12,
      \hotplug_count_synth.count_for_reset_r_reg[15]\(2) => rx_cc_cdc_sync_n_13,
      \hotplug_count_synth.count_for_reset_r_reg[15]\(1) => rx_cc_cdc_sync_n_14,
      \hotplug_count_synth.count_for_reset_r_reg[15]\(0) => rx_cc_cdc_sync_n_15,
      \hotplug_count_synth.count_for_reset_r_reg[19]\(3) => rx_cc_cdc_sync_n_16,
      \hotplug_count_synth.count_for_reset_r_reg[19]\(2) => rx_cc_cdc_sync_n_17,
      \hotplug_count_synth.count_for_reset_r_reg[19]\(1) => rx_cc_cdc_sync_n_18,
      \hotplug_count_synth.count_for_reset_r_reg[19]\(0) => rx_cc_cdc_sync_n_19,
      \hotplug_count_synth.count_for_reset_r_reg[23]\(3) => rx_cc_cdc_sync_n_20,
      \hotplug_count_synth.count_for_reset_r_reg[23]\(2) => rx_cc_cdc_sync_n_21,
      \hotplug_count_synth.count_for_reset_r_reg[23]\(1) => rx_cc_cdc_sync_n_22,
      \hotplug_count_synth.count_for_reset_r_reg[23]\(0) => rx_cc_cdc_sync_n_23,
      \hotplug_count_synth.count_for_reset_r_reg[25]\(1) => rx_cc_cdc_sync_n_24,
      \hotplug_count_synth.count_for_reset_r_reg[25]\(0) => rx_cc_cdc_sync_n_25,
      \hotplug_count_synth.count_for_reset_r_reg[7]\(3) => rx_cc_cdc_sync_n_4,
      \hotplug_count_synth.count_for_reset_r_reg[7]\(2) => rx_cc_cdc_sync_n_5,
      \hotplug_count_synth.count_for_reset_r_reg[7]\(1) => rx_cc_cdc_sync_n_6,
      \hotplug_count_synth.count_for_reset_r_reg[7]\(0) => rx_cc_cdc_sync_n_7,
      init_clk_in => init_clk_in,
      rx_cc_extend_r2 => rx_cc_extend_r2,
      user_clk => user_clk
    );
rx_cc_extend_r2_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFFFFFE"
    )
        port map (
      I0 => rx_cc_extend_r(2),
      I1 => rx_cc_extend_r(3),
      I2 => rx_cc_extend_r(0),
      I3 => rx_cc_extend_r(1),
      I4 => rx_cc_extend_r2_i_2_n_0,
      O => rx_cc_extend_r2_i_1_n_0
    );
rx_cc_extend_r2_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFE"
    )
        port map (
      I0 => rx_cc_extend_r(5),
      I1 => rx_cc_extend_r(4),
      I2 => rx_cc_extend_r(7),
      I3 => rx_cc_extend_r(6),
      O => rx_cc_extend_r2_i_2_n_0
    );
rx_cc_extend_r2_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r2_i_1_n_0,
      Q => rx_cc_extend_r2,
      R => '0'
    );
\rx_cc_extend_r_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r(1),
      Q => rx_cc_extend_r(0),
      R => SR(0)
    );
\rx_cc_extend_r_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r(2),
      Q => rx_cc_extend_r(1),
      R => SR(0)
    );
\rx_cc_extend_r_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r(3),
      Q => rx_cc_extend_r(2),
      R => SR(0)
    );
\rx_cc_extend_r_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r(4),
      Q => rx_cc_extend_r(3),
      R => SR(0)
    );
\rx_cc_extend_r_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r(5),
      Q => rx_cc_extend_r(4),
      R => SR(0)
    );
\rx_cc_extend_r_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r(6),
      Q => rx_cc_extend_r(5),
      R => SR(0)
    );
\rx_cc_extend_r_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => rx_cc_extend_r(7),
      Q => rx_cc_extend_r(6),
      R => SR(0)
    );
\rx_cc_extend_r_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => D(0),
      Q => rx_cc_extend_r(7),
      R => SR(0)
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_RESET_LOGIC is
  port (
    SYSTEM_RESET_reg_0 : out STD_LOGIC;
    new_pkt_r : out STD_LOGIC;
    \out\ : in STD_LOGIC;
    link_reset_r : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    tx_lock : in STD_LOGIC;
    gt_rxresetdone_r2_reg_0 : in STD_LOGIC;
    gt_txresetdone_r2_reg_0 : in STD_LOGIC;
    CHANNEL_UP : in STD_LOGIC;
    S_AXI_TX_TLAST : in STD_LOGIC;
    S_AXI_TX_TVALID : in STD_LOGIC;
    tx_dst_rdy : in STD_LOGIC;
    new_pkt_r_reg : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_RESET_LOGIC;

architecture STRUCTURE of aurora_8b10b_x1_16b_RESET_LOGIC is
  signal SYSTEM_RESET0_n_0 : STD_LOGIC;
  signal \^system_reset_reg_0\ : STD_LOGIC;
  signal gt_rxresetdone_r : STD_LOGIC;
  signal gt_rxresetdone_r2 : STD_LOGIC;
  signal gt_rxresetdone_r3 : STD_LOGIC;
  signal gt_txresetdone_r : STD_LOGIC;
  signal gt_txresetdone_r2 : STD_LOGIC;
  signal gt_txresetdone_r3 : STD_LOGIC;
  signal scndry_out : STD_LOGIC;
  signal tx_lock_comb_r : STD_LOGIC;
  signal tx_lock_sync : STD_LOGIC;
begin
  SYSTEM_RESET_reg_0 <= \^system_reset_reg_0\;
SYSTEM_RESET0: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFBFFFFF"
    )
        port map (
      I0 => \out\,
      I1 => gt_txresetdone_r3,
      I2 => gt_rxresetdone_r3,
      I3 => scndry_out,
      I4 => tx_lock_sync,
      O => SYSTEM_RESET0_n_0
    );
SYSTEM_RESET_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => SYSTEM_RESET0_n_0,
      Q => \^system_reset_reg_0\,
      R => '0'
    );
gt_rxresetdone_r2_reg: unisim.vcomponents.FDCE
     port map (
      C => user_clk,
      CE => '1',
      CLR => gt_rxresetdone_r2_reg_0,
      D => gt_rxresetdone_r,
      Q => gt_rxresetdone_r2
    );
gt_rxresetdone_r3_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gt_rxresetdone_r2,
      Q => gt_rxresetdone_r3,
      R => '0'
    );
gt_rxresetdone_r_reg: unisim.vcomponents.FDCE
     port map (
      C => user_clk,
      CE => '1',
      CLR => gt_rxresetdone_r2_reg_0,
      D => '1',
      Q => gt_rxresetdone_r
    );
gt_txresetdone_r2_reg: unisim.vcomponents.FDCE
     port map (
      C => user_clk,
      CE => '1',
      CLR => gt_txresetdone_r2_reg_0,
      D => gt_txresetdone_r,
      Q => gt_txresetdone_r2
    );
gt_txresetdone_r3_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gt_txresetdone_r2,
      Q => gt_txresetdone_r3,
      R => '0'
    );
gt_txresetdone_r_reg: unisim.vcomponents.FDCE
     port map (
      C => user_clk,
      CE => '1',
      CLR => gt_txresetdone_r2_reg_0,
      D => '1',
      Q => gt_txresetdone_r
    );
link_reset_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_16\
     port map (
      init_clk_in => init_clk_in,
      link_reset_r => link_reset_r,
      \out\ => scndry_out,
      user_clk => user_clk
    );
new_pkt_r_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"4444044400000400"
    )
        port map (
      I0 => \^system_reset_reg_0\,
      I1 => CHANNEL_UP,
      I2 => S_AXI_TX_TLAST,
      I3 => S_AXI_TX_TVALID,
      I4 => tx_dst_rdy,
      I5 => new_pkt_r_reg,
      O => new_pkt_r
    );
tx_lock_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_17\
     port map (
      init_clk_in => init_clk_in,
      \out\ => tx_lock_sync,
      tx_lock_comb_r => tx_lock_comb_r,
      user_clk => user_clk
    );
tx_lock_comb_r_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => tx_lock,
      Q => tx_lock_comb_r,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_RX_LL is
  port (
    FRAME_ERR : out STD_LOGIC;
    M_AXI_UFC_RX_TLAST : out STD_LOGIC;
    in_frame_r : out STD_LOGIC;
    M_AXI_RX_TVALID : out STD_LOGIC;
    M_AXI_UFC_RX_TVALID : out STD_LOGIC;
    Q : out STD_LOGIC_VECTOR ( 0 to 0 );
    \ufc_count_r_reg[0]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    storage_v_r : out STD_LOGIC;
    \ufc_count_r_reg[2]\ : out STD_LOGIC;
    \ufc_count_r_reg[3]\ : out STD_LOGIC;
    M_AXI_RX_TDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    M_AXI_UFC_RX_TDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    M_AXI_RX_TKEEP : out STD_LOGIC_VECTOR ( 0 to 0 );
    M_AXI_RX_TLAST : out STD_LOGIC;
    M_AXI_RX_SNF : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    rx_pad_i : in STD_LOGIC;
    RX_EOF_N_Buffer_reg : in STD_LOGIC;
    FRAME_ERR_Buffer0 : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    D : in STD_LOGIC_VECTOR ( 15 downto 0 );
    in_frame_r_reg : in STD_LOGIC;
    tx_dst_rdy : in STD_LOGIC;
    D_0 : in STD_LOGIC;
    rx_suf_i : in STD_LOGIC;
    rx_ecp_i : in STD_LOGIC;
    rx_pe_data_v_i : in STD_LOGIC;
    \ufc_count_r_reg[0]_0\ : in STD_LOGIC_VECTOR ( 3 downto 0 )
  );
end aurora_8b10b_x1_16b_RX_LL;

architecture STRUCTURE of aurora_8b10b_x1_16b_RX_LL is
  signal \^in_frame_r\ : STD_LOGIC;
  signal load_nfc_r : STD_LOGIC;
  signal nfc_module_i_n_3 : STD_LOGIC;
  signal nfc_module_i_n_4 : STD_LOGIC;
  signal nfc_module_i_n_5 : STD_LOGIC;
  signal nfc_module_i_n_6 : STD_LOGIC;
  signal nfc_module_i_n_7 : STD_LOGIC;
  signal p_0_in : STD_LOGIC_VECTOR ( 8 downto 1 );
  signal rx_ll_ufc_datapath_i_n_10 : STD_LOGIC;
  signal rx_ll_ufc_datapath_i_n_11 : STD_LOGIC;
  signal rx_ll_ufc_datapath_i_n_12 : STD_LOGIC;
  signal rx_ll_ufc_datapath_i_n_13 : STD_LOGIC;
  signal rx_ll_ufc_datapath_i_n_5 : STD_LOGIC;
  signal rx_ll_ufc_datapath_i_n_9 : STD_LOGIC;
  signal src_rdy_n_c : STD_LOGIC;
  signal storage_ce_c : STD_LOGIC;
  signal \^storage_v_r\ : STD_LOGIC;
  signal ufc_data_v_i : STD_LOGIC;
  signal ufc_filter_i_n_5 : STD_LOGIC;
  signal ufc_filter_i_n_7 : STD_LOGIC;
  signal ufc_storage_data_r : STD_LOGIC_VECTOR ( 8 to 9 );
  signal ufc_storage_v_r : STD_LOGIC;
  signal xoff_r : STD_LOGIC;
begin
  in_frame_r <= \^in_frame_r\;
  storage_v_r <= \^storage_v_r\;
nfc_module_i: entity work.aurora_8b10b_x1_16b_RX_LL_NFC
     port map (
      D(2) => p_0_in(8),
      D(1 downto 0) => p_0_in(2 downto 1),
      D_0 => D_0,
      M_AXI_RX_SNF => M_AXI_RX_SNF,
      Q(3) => Q(0),
      Q(2) => nfc_module_i_n_3,
      Q(1) => nfc_module_i_n_4,
      Q(0) => nfc_module_i_n_5,
      SR(0) => SR(0),
      load_nfc_r => load_nfc_r,
      \nfc_counter_r_reg[0]_0\ => nfc_module_i_n_6,
      \nfc_counter_r_reg[1]_0\ => rx_ll_ufc_datapath_i_n_5,
      \nfc_counter_r_reg[2]_0\ => rx_ll_ufc_datapath_i_n_9,
      \nfc_counter_r_reg[3]_0\ => rx_ll_ufc_datapath_i_n_10,
      \nfc_counter_r_reg[4]_0\ => rx_ll_ufc_datapath_i_n_12,
      \nfc_counter_r_reg[5]_0\ => rx_ll_ufc_datapath_i_n_11,
      \nfc_counter_r_reg[8]_0\ => nfc_module_i_n_7,
      tx_dst_rdy => tx_dst_rdy,
      ufc_storage_data_r(1) => ufc_storage_data_r(8),
      ufc_storage_data_r(0) => ufc_storage_data_r(9),
      user_clk => user_clk,
      xoff_r => xoff_r,
      xoff_r_reg_0 => rx_ll_ufc_datapath_i_n_13
    );
rx_ll_pdu_datapath_i: entity work.aurora_8b10b_x1_16b_RX_LL_PDU_DATAPATH
     port map (
      D(15 downto 0) => D(15 downto 0),
      E(0) => storage_ce_c,
      FRAME_ERR => FRAME_ERR,
      FRAME_ERR_Buffer0 => FRAME_ERR_Buffer0,
      M_AXI_RX_TDATA(15 downto 0) => M_AXI_RX_TDATA(15 downto 0),
      M_AXI_RX_TKEEP(0) => M_AXI_RX_TKEEP(0),
      M_AXI_RX_TLAST => M_AXI_RX_TLAST,
      M_AXI_RX_TVALID => M_AXI_RX_TVALID,
      RX_EOF_N_Buffer_reg_0 => RX_EOF_N_Buffer_reg,
      SR(0) => SR(0),
      in_frame_r => \^in_frame_r\,
      in_frame_r_reg_0 => in_frame_r_reg,
      rx_ecp_i => rx_ecp_i,
      rx_pad_i => rx_pad_i,
      src_rdy_n_c => src_rdy_n_c,
      storage_v_r => \^storage_v_r\,
      storage_v_r_reg_0 => ufc_filter_i_n_5,
      user_clk => user_clk
    );
rx_ll_ufc_datapath_i: entity work.aurora_8b10b_x1_16b_RX_LL_UFC_DATAPATH
     port map (
      D(15 downto 0) => D(15 downto 0),
      M_AXI_UFC_RX_TDATA(15 downto 0) => M_AXI_UFC_RX_TDATA(15 downto 0),
      M_AXI_UFC_RX_TLAST => M_AXI_UFC_RX_TLAST,
      M_AXI_UFC_RX_TVALID => M_AXI_UFC_RX_TVALID,
      Q(2) => nfc_module_i_n_3,
      Q(1) => nfc_module_i_n_4,
      Q(0) => nfc_module_i_n_5,
      SR(0) => SR(0),
      UFC_RX_EOF_N_Buffer_reg_inv_0 => ufc_filter_i_n_7,
      load_nfc_r => load_nfc_r,
      \nfc_counter_r_reg[0]\ => nfc_module_i_n_6,
      \nfc_counter_r_reg[6]\ => nfc_module_i_n_7,
      ufc_data_v_i => ufc_data_v_i,
      \ufc_storage_data_r_reg[10]_0\ => rx_ll_ufc_datapath_i_n_5,
      \ufc_storage_data_r_reg[10]_1\ => rx_ll_ufc_datapath_i_n_10,
      \ufc_storage_data_r_reg[10]_2\ => rx_ll_ufc_datapath_i_n_13,
      \ufc_storage_data_r_reg[11]_0\ => rx_ll_ufc_datapath_i_n_12,
      \ufc_storage_data_r_reg[8]_0\(1) => ufc_storage_data_r(8),
      \ufc_storage_data_r_reg[8]_0\(0) => ufc_storage_data_r(9),
      \ufc_storage_data_r_reg[9]_0\(2) => p_0_in(8),
      \ufc_storage_data_r_reg[9]_0\(1 downto 0) => p_0_in(2 downto 1),
      \ufc_storage_data_r_reg[9]_1\ => rx_ll_ufc_datapath_i_n_9,
      \ufc_storage_data_r_reg[9]_2\ => rx_ll_ufc_datapath_i_n_11,
      ufc_storage_v_r => ufc_storage_v_r,
      user_clk => user_clk,
      xoff_r => xoff_r
    );
ufc_filter_i: entity work.aurora_8b10b_x1_16b_UFC_FILTER
     port map (
      E(0) => storage_ce_c,
      Q(3 downto 0) => \ufc_count_r_reg[0]\(3 downto 0),
      SR(0) => SR(0),
      in_frame_r => \^in_frame_r\,
      in_frame_r_reg => ufc_filter_i_n_5,
      rx_ecp_i => rx_ecp_i,
      rx_pe_data_v_i => rx_pe_data_v_i,
      rx_suf_i => rx_suf_i,
      src_rdy_n_c => src_rdy_n_c,
      storage_v_r => \^storage_v_r\,
      \ufc_count_r_reg[0]_0\ => ufc_filter_i_n_7,
      \ufc_count_r_reg[0]_1\(3 downto 0) => \ufc_count_r_reg[0]_0\(3 downto 0),
      \ufc_count_r_reg[2]_0\ => \ufc_count_r_reg[2]\,
      \ufc_count_r_reg[3]_0\ => \ufc_count_r_reg[3]\,
      ufc_data_v_i => ufc_data_v_i,
      ufc_storage_v_r => ufc_storage_v_r,
      user_clk => user_clk
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_TX_LL is
  port (
    gen_cc_i : out STD_LOGIC;
    D : out STD_LOGIC;
    tx_pe_data_v_i : out STD_LOGIC;
    gen_pad_i : out STD_LOGIC;
    ufc_header_r_reg : out STD_LOGIC;
    do_nfc_r_reg : out STD_LOGIC;
    tx_dst_rdy : out STD_LOGIC;
    gen_scp_i : out STD_LOGIC;
    gen_ecp_i : out STD_LOGIC;
    gen_snf_i : out STD_LOGIC;
    gen_suf_i : out STD_LOGIC;
    S_AXI_TX_TREADY : out STD_LOGIC;
    \TX_PE_DATA_Buffer_reg[0]\ : out STD_LOGIC_VECTOR ( 15 downto 0 );
    \FC_NB_Buffer_reg[0]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    user_clk : in STD_LOGIC;
    p_0_in : in STD_LOGIC;
    Q : in STD_LOGIC;
    storage_pad_r_reg : in STD_LOGIC;
    S_AXI_TX_TVALID : in STD_LOGIC;
    S_AXI_TX_TLAST : in STD_LOGIC;
    WARN_CC : in STD_LOGIC;
    S_AXI_TX_TKEEP : in STD_LOGIC_VECTOR ( 1 downto 0 );
    S_AXI_NFC_REQ : in STD_LOGIC;
    S_AXI_UFC_TX_REQ : in STD_LOGIC;
    TX_DST_RDY_N_Buffer_reg : in STD_LOGIC_VECTOR ( 0 to 0 );
    S_AXI_NFC_NB : in STD_LOGIC_VECTOR ( 3 downto 0 );
    S_AXI_TX_TDATA : in STD_LOGIC_VECTOR ( 15 downto 0 );
    S_AXI_UFC_TX_MS : in STD_LOGIC_VECTOR ( 2 downto 0 );
    \ufc_message_count_r_reg[2]\ : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_TX_LL;

architecture STRUCTURE of aurora_8b10b_x1_16b_TX_LL is
  signal \^d\ : STD_LOGIC;
  signal TX_PE_DATA_V_Buffer0 : STD_LOGIC;
  signal \^do_nfc_r_reg\ : STD_LOGIC;
  signal pdu_ok_c : STD_LOGIC;
  signal previous_cycle_ufc_message_r : STD_LOGIC;
  signal \^tx_dst_rdy\ : STD_LOGIC;
  signal tx_ll_control_i_n_11 : STD_LOGIC;
  signal tx_ll_control_i_n_13 : STD_LOGIC;
  signal tx_ll_control_i_n_14 : STD_LOGIC;
  signal tx_ll_datapath_i_n_5 : STD_LOGIC;
  signal tx_pe_data_v_r : STD_LOGIC;
  signal tx_pe_ufc_v_r : STD_LOGIC;
begin
  D <= \^d\;
  do_nfc_r_reg <= \^do_nfc_r_reg\;
  tx_dst_rdy <= \^tx_dst_rdy\;
tx_ll_control_i: entity work.aurora_8b10b_x1_16b_TX_LL_CONTROL
     port map (
      \FC_NB_Buffer_reg[0]_0\(3 downto 0) => \FC_NB_Buffer_reg[0]\(3 downto 0),
      Q => Q,
      S_AXI_NFC_NB(3 downto 0) => S_AXI_NFC_NB(3 downto 0),
      S_AXI_NFC_REQ => S_AXI_NFC_REQ,
      S_AXI_TX_TLAST => S_AXI_TX_TLAST,
      S_AXI_TX_TREADY => S_AXI_TX_TREADY,
      S_AXI_TX_TVALID => S_AXI_TX_TVALID,
      S_AXI_UFC_TX_MS(2 downto 0) => S_AXI_UFC_TX_MS(2 downto 0),
      S_AXI_UFC_TX_REQ => S_AXI_UFC_TX_REQ,
      TX_DST_RDY_N_Buffer_reg_0 => \^tx_dst_rdy\,
      TX_DST_RDY_N_Buffer_reg_1(0) => TX_DST_RDY_N_Buffer_reg(0),
      TX_PE_DATA_V_Buffer0 => TX_PE_DATA_V_Buffer0,
      WARN_CC => WARN_CC,
      do_cc_r_reg_0 => \^d\,
      do_nfc_r_reg_0 => \^do_nfc_r_reg\,
      gen_cc_i => gen_cc_i,
      gen_ecp_i => gen_ecp_i,
      gen_scp_i => gen_scp_i,
      gen_snf_i => gen_snf_i,
      gen_suf_i => gen_suf_i,
      in_frame_r_reg => tx_ll_datapath_i_n_5,
      new_pkt_r_reg => tx_ll_control_i_n_13,
      p_0_in => p_0_in,
      pdu_ok_c => pdu_ok_c,
      previous_cycle_ufc_message_r => previous_cycle_ufc_message_r,
      \^s_axi_tx_tvalid\ => tx_ll_control_i_n_11,
      sof_data_eof_1_r_reg_0 => storage_pad_r_reg,
      tx_pe_data_v_r => tx_pe_data_v_r,
      tx_pe_ufc_v_r => tx_pe_ufc_v_r,
      ufc_header_r_reg_0 => ufc_header_r_reg,
      ufc_idle_r_reg_0 => tx_ll_control_i_n_14,
      \ufc_message_count_r_reg[2]_0\ => \ufc_message_count_r_reg[2]\,
      user_clk => user_clk
    );
tx_ll_datapath_i: entity work.aurora_8b10b_x1_16b_TX_LL_DATAPATH
     port map (
      D => \^d\,
      E(0) => pdu_ok_c,
      GEN_PAD_Buffer_reg_0 => \^do_nfc_r_reg\,
      S_AXI_TX_TDATA(15 downto 0) => S_AXI_TX_TDATA(15 downto 0),
      S_AXI_TX_TKEEP(1 downto 0) => S_AXI_TX_TKEEP(1 downto 0),
      S_AXI_TX_TVALID => S_AXI_TX_TVALID,
      \TX_PE_DATA_Buffer_reg[0]_0\(15 downto 0) => \TX_PE_DATA_Buffer_reg[0]\(15 downto 0),
      TX_PE_DATA_V_Buffer0 => TX_PE_DATA_V_Buffer0,
      gen_pad_i => gen_pad_i,
      in_frame_r_reg_0 => tx_ll_datapath_i_n_5,
      in_frame_r_reg_1 => tx_ll_control_i_n_13,
      p_0_in => p_0_in,
      previous_cycle_ufc_message_r => previous_cycle_ufc_message_r,
      storage_pad_r_reg_0 => storage_pad_r_reg,
      storage_pad_r_reg_1 => tx_ll_control_i_n_11,
      storage_ufc_v_r_reg_0 => tx_ll_control_i_n_14,
      tx_dst_rdy => \^tx_dst_rdy\,
      tx_pe_data_v_i => tx_pe_data_v_i,
      tx_pe_data_v_r => tx_pe_data_v_r,
      tx_pe_ufc_v_r => tx_pe_ufc_v_r,
      user_clk => user_clk
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_multi_gt is
  port (
    tx_lock : out STD_LOGIC;
    DRPRDY_OUT : out STD_LOGIC;
    TXN : out STD_LOGIC;
    TXP : out STD_LOGIC;
    rx_realign_i : out STD_LOGIC;
    gtxe2_i : out STD_LOGIC;
    TX_OUT_CLK : out STD_LOGIC;
    gtxe2_i_0 : out STD_LOGIC;
    DRPDO_OUT : out STD_LOGIC_VECTOR ( 15 downto 0 );
    gtxe2_i_1 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    gtxe2_i_2 : out STD_LOGIC;
    gtxe2_i_3 : out STD_LOGIC;
    gtxe2_i_4 : out STD_LOGIC;
    gtxe2_i_5 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    hard_err_flop_r0 : out STD_LOGIC;
    gtxe2_i_6 : out STD_LOGIC_VECTOR ( 7 downto 0 );
    gtxe2_i_7 : out STD_LOGIC_VECTOR ( 7 downto 0 );
    gtxe2_i_8 : out STD_LOGIC;
    ack_flag : out STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    drpclk_in : in STD_LOGIC;
    DRPEN_IN : in STD_LOGIC;
    DRPWE_IN : in STD_LOGIC;
    gt_refclk1 : in STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    gt_tx_reset_i : in STD_LOGIC;
    RXN : in STD_LOGIC;
    RXP : in STD_LOGIC;
    gt_qpllclk_quad1_in : in STD_LOGIC;
    gt_qpllrefclk_quad1_in : in STD_LOGIC;
    gt_rxdfelfhold_i : in STD_LOGIC;
    ena_comma_align_i : in STD_LOGIC;
    rx_polarity_i : in STD_LOGIC;
    gt_rxuserrdy_i : in STD_LOGIC;
    sync_clk : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    POWER_DOWN : in STD_LOGIC;
    gt_txuserrdy_i : in STD_LOGIC;
    DRPDI_IN : in STD_LOGIC_VECTOR ( 15 downto 0 );
    LOOPBACK : in STD_LOGIC_VECTOR ( 2 downto 0 );
    TXDATA : in STD_LOGIC_VECTOR ( 15 downto 0 );
    TXCHARISK : in STD_LOGIC_VECTOR ( 1 downto 0 );
    DRPADDR_IN : in STD_LOGIC_VECTOR ( 8 downto 0 );
    flag2_reg : in STD_LOGIC;
    left_aligned_r_reg : in STD_LOGIC;
    tx_reset_i : in STD_LOGIC;
    hard_err_flop_r_reg : in STD_LOGIC;
    left_aligned_r_reg_0 : in STD_LOGIC;
    cpll_reset_i : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_multi_gt;

architecture STRUCTURE of aurora_8b10b_x1_16b_multi_gt is
begin
gt0_aurora_8b10b_x1_16b_i: entity work.aurora_8b10b_x1_16b_gt
     port map (
      DRPADDR_IN(8 downto 0) => DRPADDR_IN(8 downto 0),
      DRPDI_IN(15 downto 0) => DRPDI_IN(15 downto 0),
      DRPDO_OUT(15 downto 0) => DRPDO_OUT(15 downto 0),
      DRPEN_IN => DRPEN_IN,
      DRPRDY_OUT => DRPRDY_OUT,
      DRPWE_IN => DRPWE_IN,
      LOOPBACK(2 downto 0) => LOOPBACK(2 downto 0),
      POWER_DOWN => POWER_DOWN,
      RXN => RXN,
      RXP => RXP,
      SR(0) => SR(0),
      TXCHARISK(1 downto 0) => TXCHARISK(1 downto 0),
      TXDATA(15 downto 0) => TXDATA(15 downto 0),
      TXN => TXN,
      TXP => TXP,
      TX_OUT_CLK => TX_OUT_CLK,
      ack_flag => ack_flag,
      cpll_reset_i => cpll_reset_i,
      drpclk_in => drpclk_in,
      ena_comma_align_i => ena_comma_align_i,
      flag2_reg_0 => flag2_reg,
      gt_qpllclk_quad1_in => gt_qpllclk_quad1_in,
      gt_qpllrefclk_quad1_in => gt_qpllrefclk_quad1_in,
      gt_refclk1 => gt_refclk1,
      gt_rxdfelfhold_i => gt_rxdfelfhold_i,
      gt_rxuserrdy_i => gt_rxuserrdy_i,
      gt_tx_reset_i => gt_tx_reset_i,
      gt_txuserrdy_i => gt_txuserrdy_i,
      gtxe2_i_0 => gtxe2_i,
      gtxe2_i_1 => gtxe2_i_0,
      gtxe2_i_2(1 downto 0) => gtxe2_i_1(1 downto 0),
      gtxe2_i_3 => gtxe2_i_2,
      gtxe2_i_4 => gtxe2_i_3,
      gtxe2_i_5 => gtxe2_i_4,
      gtxe2_i_6(1 downto 0) => gtxe2_i_5(1 downto 0),
      gtxe2_i_7(7 downto 0) => gtxe2_i_6(7 downto 0),
      gtxe2_i_8(7 downto 0) => gtxe2_i_7(7 downto 0),
      gtxe2_i_9 => gtxe2_i_8,
      hard_err_flop_r0 => hard_err_flop_r0,
      hard_err_flop_r_reg => hard_err_flop_r_reg,
      init_clk_in => init_clk_in,
      left_aligned_r_reg => left_aligned_r_reg,
      left_aligned_r_reg_0 => left_aligned_r_reg_0,
      rx_polarity_i => rx_polarity_i,
      rx_realign_i => rx_realign_i,
      sync_clk => sync_clk,
      tx_lock => tx_lock,
      tx_reset_i => tx_reset_i,
      user_clk => user_clk
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_rx_startup_fsm is
  port (
    gtrxreset_i_0 : out STD_LOGIC;
    gt_rxuserrdy_i : out STD_LOGIC;
    gt_rxdfelfhold_i : out STD_LOGIC;
    tx_lock : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    rxfsm_rxresetdone_r : in STD_LOGIC;
    AR : in STD_LOGIC_VECTOR ( 0 to 0 );
    \FSM_sequential_rx_state_reg[0]_0\ : in STD_LOGIC;
    gt_txuserrdy_i : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_rx_startup_fsm;

architecture STRUCTURE of aurora_8b10b_x1_16b_rx_startup_fsm is
  signal \FSM_sequential_rx_state[0]_i_2_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[0]_i_3_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[1]_i_2_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[2]_i_2_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_10_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_11_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_3_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_4_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_6_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_7_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_8_n_0\ : STD_LOGIC;
  signal \FSM_sequential_rx_state[3]_i_9_n_0\ : STD_LOGIC;
  signal RXDFEAGCHOLD_i_1_n_0 : STD_LOGIC;
  signal RXUSERRDY_i_1_n_0 : STD_LOGIC;
  signal adapt_count : STD_LOGIC;
  signal adapt_count_reset : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count[0]_i_3_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count[0]_i_4_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count[0]_i_5_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count[0]_i_6_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg\ : STD_LOGIC_VECTOR ( 20 downto 0 );
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_1\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_2\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_3\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_4\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_5\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_6\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[0]_i_2_n_7\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_1\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_2\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_3\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_4\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_5\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_6\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[12]_i_1_n_7\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_1\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_2\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_3\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_4\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_5\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_6\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[16]_i_1_n_7\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[20]_i_1_n_7\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_1\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_2\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_3\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_4\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_5\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_6\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[4]_i_1_n_7\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_1\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_2\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_3\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_4\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_5\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_6\ : STD_LOGIC;
  signal \adapt_wait_hw.adapt_count_reg[8]_i_1_n_7\ : STD_LOGIC;
  signal \adapt_wait_hw.time_out_adapt_i_1_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.time_out_adapt_i_2_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.time_out_adapt_i_3_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.time_out_adapt_i_4_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.time_out_adapt_i_5_n_0\ : STD_LOGIC;
  signal \adapt_wait_hw.time_out_adapt_reg_n_0\ : STD_LOGIC;
  signal check_tlock_max_i_1_n_0 : STD_LOGIC;
  signal check_tlock_max_reg_n_0 : STD_LOGIC;
  signal \^gt_rxdfelfhold_i\ : STD_LOGIC;
  signal \^gt_rxuserrdy_i\ : STD_LOGIC;
  signal gtrxreset_i : STD_LOGIC;
  signal \^gtrxreset_i_0\ : STD_LOGIC;
  signal gtrxreset_i_i_1_n_0 : STD_LOGIC;
  signal \init_wait_count[0]_i_1__0_n_0\ : STD_LOGIC;
  signal \init_wait_count[5]_i_1__0_n_0\ : STD_LOGIC;
  signal init_wait_count_reg : STD_LOGIC_VECTOR ( 5 downto 0 );
  signal \init_wait_done_i_1__0_n_0\ : STD_LOGIC;
  signal \init_wait_done_i_2__0_n_0\ : STD_LOGIC;
  signal init_wait_done_reg_n_0 : STD_LOGIC;
  signal \mmcm_lock_count[9]_i_2__0_n_0\ : STD_LOGIC;
  signal \mmcm_lock_count[9]_i_4__0_n_0\ : STD_LOGIC;
  signal mmcm_lock_count_reg : STD_LOGIC_VECTOR ( 9 downto 0 );
  signal mmcm_lock_i : STD_LOGIC;
  signal mmcm_lock_reclocked : STD_LOGIC;
  signal mmcm_lock_reclocked_i_1_n_0 : STD_LOGIC;
  signal \mmcm_lock_reclocked_i_2__0_n_0\ : STD_LOGIC;
  signal \p_0_in__1\ : STD_LOGIC_VECTOR ( 5 downto 1 );
  signal \p_0_in__2\ : STD_LOGIC_VECTOR ( 9 downto 0 );
  signal reset_time_out_i_2_n_0 : STD_LOGIC;
  signal reset_time_out_i_5_n_0 : STD_LOGIC;
  signal reset_time_out_reg_n_0 : STD_LOGIC;
  signal \run_phase_alignment_int_i_1__0_n_0\ : STD_LOGIC;
  signal run_phase_alignment_int_reg_n_0 : STD_LOGIC;
  signal run_phase_alignment_int_s3_reg_n_0 : STD_LOGIC;
  signal rx_fsm_reset_done_int : STD_LOGIC;
  signal rx_fsm_reset_done_int_0 : STD_LOGIC;
  signal rx_fsm_reset_done_int_i_1_n_0 : STD_LOGIC;
  signal rx_fsm_reset_done_int_i_3_n_0 : STD_LOGIC;
  signal rx_fsm_reset_done_int_i_4_n_0 : STD_LOGIC;
  signal rx_fsm_reset_done_int_i_5_n_0 : STD_LOGIC;
  signal rx_fsm_reset_done_int_i_6_n_0 : STD_LOGIC;
  signal rx_fsm_reset_done_int_s3 : STD_LOGIC;
  signal rx_state : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \rx_state__0\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal rxresetdone_s2 : STD_LOGIC;
  signal rxresetdone_s3 : STD_LOGIC;
  signal scndry_out : STD_LOGIC;
  signal sync_CPLLLOCK_cdc_sync_n_0 : STD_LOGIC;
  signal sync_CPLLLOCK_cdc_sync_n_1 : STD_LOGIC;
  signal sync_CPLLLOCK_cdc_sync_n_2 : STD_LOGIC;
  signal sync_mmcm_lock_reclocked_cdc_sync_n_1 : STD_LOGIC;
  signal sync_rx_fsm_reset_done_int_cdc_sync_n_0 : STD_LOGIC;
  signal time_out_100us_i_1_n_0 : STD_LOGIC;
  signal time_out_100us_i_2_n_0 : STD_LOGIC;
  signal time_out_100us_i_3_n_0 : STD_LOGIC;
  signal time_out_100us_reg_n_0 : STD_LOGIC;
  signal time_out_1us_i_1_n_0 : STD_LOGIC;
  signal time_out_1us_i_2_n_0 : STD_LOGIC;
  signal time_out_1us_i_3_n_0 : STD_LOGIC;
  signal time_out_1us_i_4_n_0 : STD_LOGIC;
  signal time_out_1us_reg_n_0 : STD_LOGIC;
  signal time_out_2ms_i_1_n_0 : STD_LOGIC;
  signal time_out_2ms_i_2_n_0 : STD_LOGIC;
  signal \time_out_2ms_i_3__0_n_0\ : STD_LOGIC;
  signal time_out_2ms_reg_n_0 : STD_LOGIC;
  signal time_out_counter : STD_LOGIC;
  signal \time_out_counter[0]_i_3__0_n_0\ : STD_LOGIC;
  signal \time_out_counter[0]_i_4__0_n_0\ : STD_LOGIC;
  signal time_out_counter_reg : STD_LOGIC_VECTOR ( 18 downto 0 );
  signal \time_out_counter_reg[0]_i_2__0_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2__0_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2__0_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2__0_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2__0_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2__0_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2__0_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2__0_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1__0_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1__0_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1__0_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1__0_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1__0_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1__0_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1__0_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1__0_n_7\ : STD_LOGIC;
  signal time_out_wait_bypass_i_1_n_0 : STD_LOGIC;
  signal \time_out_wait_bypass_i_2__0_n_0\ : STD_LOGIC;
  signal \time_out_wait_bypass_i_3__0_n_0\ : STD_LOGIC;
  signal \time_out_wait_bypass_i_4__0_n_0\ : STD_LOGIC;
  signal time_out_wait_bypass_reg_n_0 : STD_LOGIC;
  signal time_out_wait_bypass_s2 : STD_LOGIC;
  signal time_out_wait_bypass_s3 : STD_LOGIC;
  signal time_tlock_max : STD_LOGIC;
  signal time_tlock_max1 : STD_LOGIC;
  signal \time_tlock_max1_carry__0_i_1_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_i_2_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_i_3_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_i_4_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_i_5_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_i_6_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_n_1\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_n_2\ : STD_LOGIC;
  signal \time_tlock_max1_carry__0_n_3\ : STD_LOGIC;
  signal \time_tlock_max1_carry__1_i_1_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__1_i_2_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__1_i_3_n_0\ : STD_LOGIC;
  signal \time_tlock_max1_carry__1_n_3\ : STD_LOGIC;
  signal time_tlock_max1_carry_i_1_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_i_2_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_i_3_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_i_4_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_i_5_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_i_6_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_i_7_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_n_0 : STD_LOGIC;
  signal time_tlock_max1_carry_n_1 : STD_LOGIC;
  signal time_tlock_max1_carry_n_2 : STD_LOGIC;
  signal time_tlock_max1_carry_n_3 : STD_LOGIC;
  signal time_tlock_max_i_1_n_0 : STD_LOGIC;
  signal \wait_bypass_count[0]_i_1__0_n_0\ : STD_LOGIC;
  signal \wait_bypass_count[0]_i_2__0_n_0\ : STD_LOGIC;
  signal \wait_bypass_count[0]_i_4__0_n_0\ : STD_LOGIC;
  signal wait_bypass_count_reg : STD_LOGIC_VECTOR ( 12 downto 0 );
  signal \wait_bypass_count_reg[0]_i_3__0_n_0\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3__0_n_1\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3__0_n_2\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3__0_n_3\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3__0_n_4\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3__0_n_5\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3__0_n_6\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3__0_n_7\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1__0_n_7\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_0\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_1\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_2\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_3\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_4\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_5\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_6\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1__0_n_7\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_0\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_1\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_2\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_3\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_4\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_5\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_6\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1__0_n_7\ : STD_LOGIC;
  signal \wait_time_cnt0__0\ : STD_LOGIC_VECTOR ( 6 downto 0 );
  signal \wait_time_cnt[6]_i_1_n_0\ : STD_LOGIC;
  signal \wait_time_cnt[6]_i_2__0_n_0\ : STD_LOGIC;
  signal \wait_time_cnt[6]_i_4__0_n_0\ : STD_LOGIC;
  signal wait_time_cnt_reg : STD_LOGIC_VECTOR ( 6 downto 0 );
  signal \NLW_adapt_wait_hw.adapt_count_reg[20]_i_1_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \NLW_adapt_wait_hw.adapt_count_reg[20]_i_1_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 1 );
  signal \NLW_time_out_counter_reg[16]_i_1__0_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 2 );
  signal \NLW_time_out_counter_reg[16]_i_1__0_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 to 3 );
  signal NLW_time_tlock_max1_carry_O_UNCONNECTED : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \NLW_time_tlock_max1_carry__0_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \NLW_time_tlock_max1_carry__1_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 2 );
  signal \NLW_time_tlock_max1_carry__1_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \NLW_wait_bypass_count_reg[12]_i_1__0_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \NLW_wait_bypass_count_reg[12]_i_1__0_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 1 );
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \FSM_sequential_rx_state[0]_i_1\ : label is "soft_lutpair52";
  attribute SOFT_HLUTNM of \FSM_sequential_rx_state[0]_i_3\ : label is "soft_lutpair58";
  attribute SOFT_HLUTNM of \FSM_sequential_rx_state[2]_i_2\ : label is "soft_lutpair60";
  attribute SOFT_HLUTNM of \FSM_sequential_rx_state[3]_i_11\ : label is "soft_lutpair51";
  attribute SOFT_HLUTNM of \FSM_sequential_rx_state[3]_i_4\ : label is "soft_lutpair49";
  attribute SOFT_HLUTNM of \FSM_sequential_rx_state[3]_i_7\ : label is "soft_lutpair58";
  attribute SOFT_HLUTNM of \FSM_sequential_rx_state[3]_i_9\ : label is "soft_lutpair49";
  attribute FSM_ENCODED_STATES : string;
  attribute FSM_ENCODED_STATES of \FSM_sequential_rx_state_reg[0]\ : label is "release_pll_reset:0011,verify_recclk_stable:0100,wait_for_pll_lock:0010,fsm_done:1010,assert_all_resets:0001,init:0000,wait_reset_done:0111,monitor_data_valid:1001,wait_for_rxusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute FSM_ENCODED_STATES of \FSM_sequential_rx_state_reg[1]\ : label is "release_pll_reset:0011,verify_recclk_stable:0100,wait_for_pll_lock:0010,fsm_done:1010,assert_all_resets:0001,init:0000,wait_reset_done:0111,monitor_data_valid:1001,wait_for_rxusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute FSM_ENCODED_STATES of \FSM_sequential_rx_state_reg[2]\ : label is "release_pll_reset:0011,verify_recclk_stable:0100,wait_for_pll_lock:0010,fsm_done:1010,assert_all_resets:0001,init:0000,wait_reset_done:0111,monitor_data_valid:1001,wait_for_rxusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute FSM_ENCODED_STATES of \FSM_sequential_rx_state_reg[3]\ : label is "release_pll_reset:0011,verify_recclk_stable:0100,wait_for_pll_lock:0010,fsm_done:1010,assert_all_resets:0001,init:0000,wait_reset_done:0111,monitor_data_valid:1001,wait_for_rxusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute ADDER_THRESHOLD : integer;
  attribute ADDER_THRESHOLD of \adapt_wait_hw.adapt_count_reg[0]_i_2\ : label is 11;
  attribute ADDER_THRESHOLD of \adapt_wait_hw.adapt_count_reg[12]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \adapt_wait_hw.adapt_count_reg[16]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \adapt_wait_hw.adapt_count_reg[20]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \adapt_wait_hw.adapt_count_reg[4]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \adapt_wait_hw.adapt_count_reg[8]_i_1\ : label is 11;
  attribute SOFT_HLUTNM of gtrxreset_i_i_1 : label is "soft_lutpair57";
  attribute SOFT_HLUTNM of \init_wait_count[1]_i_1__0\ : label is "soft_lutpair61";
  attribute SOFT_HLUTNM of \init_wait_count[2]_i_1__0\ : label is "soft_lutpair61";
  attribute SOFT_HLUTNM of \init_wait_count[3]_i_1__0\ : label is "soft_lutpair53";
  attribute SOFT_HLUTNM of \init_wait_count[4]_i_1__0\ : label is "soft_lutpair53";
  attribute SOFT_HLUTNM of \mmcm_lock_count[1]_i_1__0\ : label is "soft_lutpair62";
  attribute SOFT_HLUTNM of \mmcm_lock_count[2]_i_1__0\ : label is "soft_lutpair62";
  attribute SOFT_HLUTNM of \mmcm_lock_count[3]_i_1__0\ : label is "soft_lutpair55";
  attribute SOFT_HLUTNM of \mmcm_lock_count[4]_i_1__0\ : label is "soft_lutpair55";
  attribute SOFT_HLUTNM of \mmcm_lock_count[7]_i_1__0\ : label is "soft_lutpair59";
  attribute SOFT_HLUTNM of \mmcm_lock_count[8]_i_1__0\ : label is "soft_lutpair59";
  attribute SOFT_HLUTNM of \mmcm_lock_count[9]_i_3__0\ : label is "soft_lutpair50";
  attribute SOFT_HLUTNM of \mmcm_lock_reclocked_i_2__0\ : label is "soft_lutpair50";
  attribute SOFT_HLUTNM of reset_time_out_i_4 : label is "soft_lutpair57";
  attribute SOFT_HLUTNM of reset_time_out_i_5 : label is "soft_lutpair51";
  attribute SOFT_HLUTNM of \run_phase_alignment_int_i_1__0\ : label is "soft_lutpair56";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of run_phase_alignment_int_s3_reg : label is "no";
  attribute SOFT_HLUTNM of rx_fsm_reset_done_int_i_5 : label is "soft_lutpair52";
  attribute SOFT_HLUTNM of rx_fsm_reset_done_int_i_6 : label is "soft_lutpair56";
  attribute equivalent_register_removal of rx_fsm_reset_done_int_s3_reg : label is "no";
  attribute equivalent_register_removal of rxresetdone_s3_reg : label is "no";
  attribute SOFT_HLUTNM of time_out_100us_i_2 : label is "soft_lutpair63";
  attribute SOFT_HLUTNM of \time_out_counter[0]_i_3__0\ : label is "soft_lutpair63";
  attribute ADDER_THRESHOLD of \time_out_counter_reg[0]_i_2__0\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[12]_i_1__0\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[16]_i_1__0\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[4]_i_1__0\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[8]_i_1__0\ : label is 11;
  attribute equivalent_register_removal of time_out_wait_bypass_s3_reg : label is "no";
  attribute COMPARATOR_THRESHOLD : integer;
  attribute COMPARATOR_THRESHOLD of time_tlock_max1_carry : label is 11;
  attribute COMPARATOR_THRESHOLD of \time_tlock_max1_carry__0\ : label is 11;
  attribute COMPARATOR_THRESHOLD of \time_tlock_max1_carry__1\ : label is 11;
  attribute SOFT_HLUTNM of time_tlock_max_i_1 : label is "soft_lutpair60";
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[0]_i_3__0\ : label is 11;
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[12]_i_1__0\ : label is 11;
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[4]_i_1__0\ : label is 11;
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[8]_i_1__0\ : label is 11;
  attribute SOFT_HLUTNM of \wait_time_cnt[0]_i_1__0\ : label is "soft_lutpair64";
  attribute SOFT_HLUTNM of \wait_time_cnt[1]_i_1__0\ : label is "soft_lutpair64";
  attribute SOFT_HLUTNM of \wait_time_cnt[3]_i_1__0\ : label is "soft_lutpair54";
  attribute SOFT_HLUTNM of \wait_time_cnt[4]_i_1__0\ : label is "soft_lutpair54";
begin
  gt_rxdfelfhold_i <= \^gt_rxdfelfhold_i\;
  gt_rxuserrdy_i <= \^gt_rxuserrdy_i\;
  gtrxreset_i_0 <= \^gtrxreset_i_0\;
\FSM_sequential_rx_state[0]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFEFEFEF"
    )
        port map (
      I0 => \FSM_sequential_rx_state[0]_i_2_n_0\,
      I1 => \FSM_sequential_rx_state[0]_i_3_n_0\,
      I2 => rx_state(0),
      I3 => rx_state(1),
      I4 => rx_state(3),
      O => \rx_state__0\(0)
    );
\FSM_sequential_rx_state[0]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"2222AAAA00300000"
    )
        port map (
      I0 => time_out_2ms_reg_n_0,
      I1 => reset_time_out_reg_n_0,
      I2 => time_tlock_max,
      I3 => rx_state(3),
      I4 => rx_state(2),
      I5 => rx_state(1),
      O => \FSM_sequential_rx_state[0]_i_2_n_0\
    );
\FSM_sequential_rx_state[0]_i_3\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0200"
    )
        port map (
      I0 => rx_state(3),
      I1 => reset_time_out_reg_n_0,
      I2 => \^gt_rxuserrdy_i\,
      I3 => time_out_100us_reg_n_0,
      O => \FSM_sequential_rx_state[0]_i_3_n_0\
    );
\FSM_sequential_rx_state[1]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFF01300330"
    )
        port map (
      I0 => rx_state(2),
      I1 => rx_state(3),
      I2 => rx_state(1),
      I3 => rx_state(0),
      I4 => time_tlock_max,
      I5 => \FSM_sequential_rx_state[1]_i_2_n_0\,
      O => \rx_state__0\(1)
    );
\FSM_sequential_rx_state[1]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"3030203020202020"
    )
        port map (
      I0 => reset_time_out_reg_n_0,
      I1 => rx_state(1),
      I2 => rx_state(0),
      I3 => time_out_100us_reg_n_0,
      I4 => \^gt_rxuserrdy_i\,
      I5 => rx_state(3),
      O => \FSM_sequential_rx_state[1]_i_2_n_0\
    );
\FSM_sequential_rx_state[2]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"010C0C0C01000C0C"
    )
        port map (
      I0 => time_out_2ms_reg_n_0,
      I1 => rx_state(2),
      I2 => rx_state(3),
      I3 => rx_state(1),
      I4 => rx_state(0),
      I5 => \FSM_sequential_rx_state[2]_i_2_n_0\,
      O => \rx_state__0\(2)
    );
\FSM_sequential_rx_state[2]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => reset_time_out_reg_n_0,
      I1 => time_tlock_max,
      O => \FSM_sequential_rx_state[2]_i_2_n_0\
    );
\FSM_sequential_rx_state[3]_i_10\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"000000004400C400"
    )
        port map (
      I0 => rx_state(2),
      I1 => rx_state(0),
      I2 => rx_state(1),
      I3 => time_out_2ms_reg_n_0,
      I4 => reset_time_out_reg_n_0,
      I5 => rx_state(3),
      O => \FSM_sequential_rx_state[3]_i_10_n_0\
    );
\FSM_sequential_rx_state[3]_i_11\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0010"
    )
        port map (
      I0 => rx_state(3),
      I1 => rx_state(2),
      I2 => rx_state(0),
      I3 => rx_state(1),
      O => \FSM_sequential_rx_state[3]_i_11_n_0\
    );
\FSM_sequential_rx_state[3]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFF0F0F8FBF0F0"
    )
        port map (
      I0 => \FSM_sequential_rx_state[3]_i_7_n_0\,
      I1 => rx_state(0),
      I2 => \FSM_sequential_rx_state[3]_i_8_n_0\,
      I3 => time_out_wait_bypass_s3,
      I4 => rx_state(3),
      I5 => rx_state(1),
      O => \rx_state__0\(3)
    );
\FSM_sequential_rx_state[3]_i_3\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0004"
    )
        port map (
      I0 => rx_state(2),
      I1 => init_wait_done_reg_n_0,
      I2 => rx_state(1),
      I3 => rx_state(0),
      O => \FSM_sequential_rx_state[3]_i_3_n_0\
    );
\FSM_sequential_rx_state[3]_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => rx_state(1),
      I1 => rx_state(0),
      O => \FSM_sequential_rx_state[3]_i_4_n_0\
    );
\FSM_sequential_rx_state[3]_i_6\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FEFEFEFEFFFEFEFE"
    )
        port map (
      I0 => \FSM_sequential_rx_state[3]_i_10_n_0\,
      I1 => \FSM_sequential_rx_state[0]_i_3_n_0\,
      I2 => \FSM_sequential_rx_state[3]_i_11_n_0\,
      I3 => \wait_time_cnt[6]_i_1_n_0\,
      I4 => time_tlock_max,
      I5 => reset_time_out_reg_n_0,
      O => \FSM_sequential_rx_state[3]_i_6_n_0\
    );
\FSM_sequential_rx_state[3]_i_7\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FD"
    )
        port map (
      I0 => time_out_100us_reg_n_0,
      I1 => \^gt_rxuserrdy_i\,
      I2 => reset_time_out_reg_n_0,
      O => \FSM_sequential_rx_state[3]_i_7_n_0\
    );
\FSM_sequential_rx_state[3]_i_8\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"8A000000"
    )
        port map (
      I0 => rx_state(2),
      I1 => reset_time_out_reg_n_0,
      I2 => time_out_2ms_reg_n_0,
      I3 => rx_state(1),
      I4 => rx_state(0),
      O => \FSM_sequential_rx_state[3]_i_8_n_0\
    );
\FSM_sequential_rx_state[3]_i_9\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"55AF00C0"
    )
        port map (
      I0 => \^gt_rxuserrdy_i\,
      I1 => mmcm_lock_reclocked,
      I2 => rx_state(0),
      I3 => rx_state(1),
      I4 => rx_state(3),
      O => \FSM_sequential_rx_state[3]_i_9_n_0\
    );
\FSM_sequential_rx_state_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \rx_state__0\(0),
      Q => rx_state(0),
      R => AR(0)
    );
\FSM_sequential_rx_state_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \rx_state__0\(1),
      Q => rx_state(1),
      R => AR(0)
    );
\FSM_sequential_rx_state_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \rx_state__0\(2),
      Q => rx_state(2),
      R => AR(0)
    );
\FSM_sequential_rx_state_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \rx_state__0\(3),
      Q => rx_state(3),
      R => AR(0)
    );
RXDFEAGCHOLD_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFF00080000"
    )
        port map (
      I0 => \adapt_wait_hw.time_out_adapt_reg_n_0\,
      I1 => rx_state(1),
      I2 => rx_state(0),
      I3 => rx_state(2),
      I4 => rx_state(3),
      I5 => \^gt_rxdfelfhold_i\,
      O => RXDFEAGCHOLD_i_1_n_0
    );
RXDFEAGCHOLD_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => RXDFEAGCHOLD_i_1_n_0,
      Q => \^gt_rxdfelfhold_i\,
      R => AR(0)
    );
RXUSERRDY_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFCF00008000"
    )
        port map (
      I0 => gt_txuserrdy_i,
      I1 => rx_state(1),
      I2 => rx_state(0),
      I3 => rx_state(2),
      I4 => rx_state(3),
      I5 => \^gt_rxuserrdy_i\,
      O => RXUSERRDY_i_1_n_0
    );
RXUSERRDY_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => RXUSERRDY_i_1_n_0,
      Q => \^gt_rxuserrdy_i\,
      R => AR(0)
    );
\adapt_wait_hw.adapt_count[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFEF"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count[0]_i_3_n_0\,
      I1 => \adapt_wait_hw.adapt_count_reg\(0),
      I2 => \adapt_wait_hw.adapt_count_reg\(2),
      I3 => \adapt_wait_hw.adapt_count_reg\(1),
      I4 => \adapt_wait_hw.adapt_count[0]_i_4_n_0\,
      I5 => \adapt_wait_hw.adapt_count[0]_i_5_n_0\,
      O => adapt_count
    );
\adapt_wait_hw.adapt_count[0]_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFF7FFFFFFFFF"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(7),
      I1 => \adapt_wait_hw.adapt_count_reg\(8),
      I2 => \adapt_wait_hw.adapt_count_reg\(5),
      I3 => \adapt_wait_hw.adapt_count_reg\(6),
      I4 => \adapt_wait_hw.adapt_count_reg\(3),
      I5 => \adapt_wait_hw.adapt_count_reg\(4),
      O => \adapt_wait_hw.adapt_count[0]_i_3_n_0\
    );
\adapt_wait_hw.adapt_count[0]_i_4\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFDFFFFFFFFF"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(20),
      I1 => \adapt_wait_hw.adapt_count_reg\(19),
      I2 => \adapt_wait_hw.adapt_count_reg\(17),
      I3 => \adapt_wait_hw.adapt_count_reg\(18),
      I4 => \adapt_wait_hw.adapt_count_reg\(16),
      I5 => \adapt_wait_hw.adapt_count_reg\(15),
      O => \adapt_wait_hw.adapt_count[0]_i_4_n_0\
    );
\adapt_wait_hw.adapt_count[0]_i_5\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFDF"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(14),
      I1 => \adapt_wait_hw.adapt_count_reg\(13),
      I2 => \adapt_wait_hw.adapt_count_reg\(12),
      I3 => \adapt_wait_hw.adapt_count_reg\(11),
      I4 => \adapt_wait_hw.adapt_count_reg\(10),
      I5 => \adapt_wait_hw.adapt_count_reg\(9),
      O => \adapt_wait_hw.adapt_count[0]_i_5_n_0\
    );
\adapt_wait_hw.adapt_count[0]_i_6\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(0),
      O => \adapt_wait_hw.adapt_count[0]_i_6_n_0\
    );
\adapt_wait_hw.adapt_count_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_7\,
      Q => \adapt_wait_hw.adapt_count_reg\(0),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[0]_i_2\: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_0\,
      CO(2) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_1\,
      CO(1) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_2\,
      CO(0) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0001",
      O(3) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_4\,
      O(2) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_5\,
      O(1) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_6\,
      O(0) => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_7\,
      S(3 downto 1) => \adapt_wait_hw.adapt_count_reg\(3 downto 1),
      S(0) => \adapt_wait_hw.adapt_count[0]_i_6_n_0\
    );
\adapt_wait_hw.adapt_count_reg[10]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_5\,
      Q => \adapt_wait_hw.adapt_count_reg\(10),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[11]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_4\,
      Q => \adapt_wait_hw.adapt_count_reg\(11),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[12]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_7\,
      Q => \adapt_wait_hw.adapt_count_reg\(12),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[12]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_0\,
      CO(3) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_0\,
      CO(2) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_1\,
      CO(1) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_2\,
      CO(0) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_4\,
      O(2) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_5\,
      O(1) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_6\,
      O(0) => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_7\,
      S(3 downto 0) => \adapt_wait_hw.adapt_count_reg\(15 downto 12)
    );
\adapt_wait_hw.adapt_count_reg[13]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_6\,
      Q => \adapt_wait_hw.adapt_count_reg\(13),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[14]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_5\,
      Q => \adapt_wait_hw.adapt_count_reg\(14),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[15]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_4\,
      Q => \adapt_wait_hw.adapt_count_reg\(15),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[16]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_7\,
      Q => \adapt_wait_hw.adapt_count_reg\(16),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[16]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \adapt_wait_hw.adapt_count_reg[12]_i_1_n_0\,
      CO(3) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_0\,
      CO(2) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_1\,
      CO(1) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_2\,
      CO(0) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_4\,
      O(2) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_5\,
      O(1) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_6\,
      O(0) => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_7\,
      S(3 downto 0) => \adapt_wait_hw.adapt_count_reg\(19 downto 16)
    );
\adapt_wait_hw.adapt_count_reg[17]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_6\,
      Q => \adapt_wait_hw.adapt_count_reg\(17),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[18]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_5\,
      Q => \adapt_wait_hw.adapt_count_reg\(18),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[19]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_4\,
      Q => \adapt_wait_hw.adapt_count_reg\(19),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_6\,
      Q => \adapt_wait_hw.adapt_count_reg\(1),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[20]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[20]_i_1_n_7\,
      Q => \adapt_wait_hw.adapt_count_reg\(20),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[20]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \adapt_wait_hw.adapt_count_reg[16]_i_1_n_0\,
      CO(3 downto 0) => \NLW_adapt_wait_hw.adapt_count_reg[20]_i_1_CO_UNCONNECTED\(3 downto 0),
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 1) => \NLW_adapt_wait_hw.adapt_count_reg[20]_i_1_O_UNCONNECTED\(3 downto 1),
      O(0) => \adapt_wait_hw.adapt_count_reg[20]_i_1_n_7\,
      S(3 downto 1) => B"000",
      S(0) => \adapt_wait_hw.adapt_count_reg\(20)
    );
\adapt_wait_hw.adapt_count_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_5\,
      Q => \adapt_wait_hw.adapt_count_reg\(2),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_4\,
      Q => \adapt_wait_hw.adapt_count_reg\(3),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_7\,
      Q => \adapt_wait_hw.adapt_count_reg\(4),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[4]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \adapt_wait_hw.adapt_count_reg[0]_i_2_n_0\,
      CO(3) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_0\,
      CO(2) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_1\,
      CO(1) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_2\,
      CO(0) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_4\,
      O(2) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_5\,
      O(1) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_6\,
      O(0) => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_7\,
      S(3 downto 0) => \adapt_wait_hw.adapt_count_reg\(7 downto 4)
    );
\adapt_wait_hw.adapt_count_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_6\,
      Q => \adapt_wait_hw.adapt_count_reg\(5),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_5\,
      Q => \adapt_wait_hw.adapt_count_reg\(6),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_4\,
      Q => \adapt_wait_hw.adapt_count_reg\(7),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_7\,
      Q => \adapt_wait_hw.adapt_count_reg\(8),
      R => adapt_count_reset
    );
\adapt_wait_hw.adapt_count_reg[8]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \adapt_wait_hw.adapt_count_reg[4]_i_1_n_0\,
      CO(3) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_0\,
      CO(2) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_1\,
      CO(1) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_2\,
      CO(0) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_4\,
      O(2) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_5\,
      O(1) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_6\,
      O(0) => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_7\,
      S(3 downto 0) => \adapt_wait_hw.adapt_count_reg\(11 downto 8)
    );
\adapt_wait_hw.adapt_count_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => adapt_count,
      D => \adapt_wait_hw.adapt_count_reg[8]_i_1_n_6\,
      Q => \adapt_wait_hw.adapt_count_reg\(9),
      R => adapt_count_reset
    );
\adapt_wait_hw.time_out_adapt_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00000000EAAAAAAA"
    )
        port map (
      I0 => \adapt_wait_hw.time_out_adapt_reg_n_0\,
      I1 => \adapt_wait_hw.time_out_adapt_i_2_n_0\,
      I2 => \adapt_wait_hw.time_out_adapt_i_3_n_0\,
      I3 => \adapt_wait_hw.time_out_adapt_i_4_n_0\,
      I4 => \adapt_wait_hw.time_out_adapt_i_5_n_0\,
      I5 => adapt_count_reset,
      O => \adapt_wait_hw.time_out_adapt_i_1_n_0\
    );
\adapt_wait_hw.time_out_adapt_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000200000000"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(12),
      I1 => \adapt_wait_hw.adapt_count_reg\(11),
      I2 => \adapt_wait_hw.adapt_count_reg\(9),
      I3 => \adapt_wait_hw.adapt_count_reg\(10),
      I4 => \adapt_wait_hw.adapt_count_reg\(13),
      I5 => \adapt_wait_hw.adapt_count_reg\(14),
      O => \adapt_wait_hw.time_out_adapt_i_2_n_0\
    );
\adapt_wait_hw.time_out_adapt_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0020000000000000"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(5),
      I1 => \adapt_wait_hw.adapt_count_reg\(6),
      I2 => \adapt_wait_hw.adapt_count_reg\(4),
      I3 => \adapt_wait_hw.adapt_count_reg\(3),
      I4 => \adapt_wait_hw.adapt_count_reg\(8),
      I5 => \adapt_wait_hw.adapt_count_reg\(7),
      O => \adapt_wait_hw.time_out_adapt_i_3_n_0\
    );
\adapt_wait_hw.time_out_adapt_i_4\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000002000000000"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(17),
      I1 => \adapt_wait_hw.adapt_count_reg\(18),
      I2 => \adapt_wait_hw.adapt_count_reg\(15),
      I3 => \adapt_wait_hw.adapt_count_reg\(16),
      I4 => \adapt_wait_hw.adapt_count_reg\(19),
      I5 => \adapt_wait_hw.adapt_count_reg\(20),
      O => \adapt_wait_hw.time_out_adapt_i_4_n_0\
    );
\adapt_wait_hw.time_out_adapt_i_5\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"04"
    )
        port map (
      I0 => \adapt_wait_hw.adapt_count_reg\(1),
      I1 => \adapt_wait_hw.adapt_count_reg\(2),
      I2 => \adapt_wait_hw.adapt_count_reg\(0),
      O => \adapt_wait_hw.time_out_adapt_i_5_n_0\
    );
\adapt_wait_hw.time_out_adapt_reg\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \adapt_wait_hw.time_out_adapt_i_1_n_0\,
      Q => \adapt_wait_hw.time_out_adapt_reg_n_0\,
      R => '0'
    );
check_tlock_max_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFB0008"
    )
        port map (
      I0 => rx_state(2),
      I1 => rx_state(0),
      I2 => rx_state(1),
      I3 => rx_state(3),
      I4 => check_tlock_max_reg_n_0,
      O => check_tlock_max_i_1_n_0
    );
check_tlock_max_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => check_tlock_max_i_1_n_0,
      Q => check_tlock_max_reg_n_0,
      R => AR(0)
    );
gtrxreset_i_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFEF0004"
    )
        port map (
      I0 => rx_state(1),
      I1 => rx_state(0),
      I2 => rx_state(2),
      I3 => rx_state(3),
      I4 => \^gtrxreset_i_0\,
      O => gtrxreset_i_i_1_n_0
    );
gtrxreset_i_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => gtrxreset_i_i_1_n_0,
      Q => \^gtrxreset_i_0\,
      R => AR(0)
    );
\init_wait_count[0]_i_1__0\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => init_wait_count_reg(0),
      O => \init_wait_count[0]_i_1__0_n_0\
    );
\init_wait_count[1]_i_1__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"6"
    )
        port map (
      I0 => init_wait_count_reg(0),
      I1 => init_wait_count_reg(1),
      O => \p_0_in__1\(1)
    );
\init_wait_count[2]_i_1__0\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"78"
    )
        port map (
      I0 => init_wait_count_reg(1),
      I1 => init_wait_count_reg(0),
      I2 => init_wait_count_reg(2),
      O => \p_0_in__1\(2)
    );
\init_wait_count[3]_i_1__0\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7F80"
    )
        port map (
      I0 => init_wait_count_reg(2),
      I1 => init_wait_count_reg(0),
      I2 => init_wait_count_reg(1),
      I3 => init_wait_count_reg(3),
      O => \p_0_in__1\(3)
    );
\init_wait_count[4]_i_1__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"7FFF8000"
    )
        port map (
      I0 => init_wait_count_reg(3),
      I1 => init_wait_count_reg(1),
      I2 => init_wait_count_reg(0),
      I3 => init_wait_count_reg(2),
      I4 => init_wait_count_reg(4),
      O => \p_0_in__1\(4)
    );
\init_wait_count[5]_i_1__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFF7FFF"
    )
        port map (
      I0 => init_wait_count_reg(4),
      I1 => init_wait_count_reg(5),
      I2 => init_wait_count_reg(2),
      I3 => init_wait_count_reg(3),
      I4 => init_wait_count_reg(1),
      I5 => init_wait_count_reg(0),
      O => \init_wait_count[5]_i_1__0_n_0\
    );
\init_wait_count[5]_i_2__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFF80000000"
    )
        port map (
      I0 => init_wait_count_reg(4),
      I1 => init_wait_count_reg(2),
      I2 => init_wait_count_reg(0),
      I3 => init_wait_count_reg(1),
      I4 => init_wait_count_reg(3),
      I5 => init_wait_count_reg(5),
      O => \p_0_in__1\(5)
    );
\init_wait_count_reg[0]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1__0_n_0\,
      CLR => AR(0),
      D => \init_wait_count[0]_i_1__0_n_0\,
      Q => init_wait_count_reg(0)
    );
\init_wait_count_reg[1]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1__0_n_0\,
      CLR => AR(0),
      D => \p_0_in__1\(1),
      Q => init_wait_count_reg(1)
    );
\init_wait_count_reg[2]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1__0_n_0\,
      CLR => AR(0),
      D => \p_0_in__1\(2),
      Q => init_wait_count_reg(2)
    );
\init_wait_count_reg[3]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1__0_n_0\,
      CLR => AR(0),
      D => \p_0_in__1\(3),
      Q => init_wait_count_reg(3)
    );
\init_wait_count_reg[4]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1__0_n_0\,
      CLR => AR(0),
      D => \p_0_in__1\(4),
      Q => init_wait_count_reg(4)
    );
\init_wait_count_reg[5]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1__0_n_0\,
      CLR => AR(0),
      D => \p_0_in__1\(5),
      Q => init_wait_count_reg(5)
    );
\init_wait_done_i_1__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFF02000000"
    )
        port map (
      I0 => \init_wait_done_i_2__0_n_0\,
      I1 => init_wait_count_reg(1),
      I2 => init_wait_count_reg(0),
      I3 => init_wait_count_reg(3),
      I4 => init_wait_count_reg(2),
      I5 => init_wait_done_reg_n_0,
      O => \init_wait_done_i_1__0_n_0\
    );
\init_wait_done_i_2__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => init_wait_count_reg(4),
      I1 => init_wait_count_reg(5),
      O => \init_wait_done_i_2__0_n_0\
    );
init_wait_done_reg: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => AR(0),
      D => \init_wait_done_i_1__0_n_0\,
      Q => init_wait_done_reg_n_0
    );
\mmcm_lock_count[0]_i_1__0\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => mmcm_lock_count_reg(0),
      O => \p_0_in__2\(0)
    );
\mmcm_lock_count[1]_i_1__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"6"
    )
        port map (
      I0 => mmcm_lock_count_reg(0),
      I1 => mmcm_lock_count_reg(1),
      O => \p_0_in__2\(1)
    );
\mmcm_lock_count[2]_i_1__0\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"78"
    )
        port map (
      I0 => mmcm_lock_count_reg(1),
      I1 => mmcm_lock_count_reg(0),
      I2 => mmcm_lock_count_reg(2),
      O => \p_0_in__2\(2)
    );
\mmcm_lock_count[3]_i_1__0\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7F80"
    )
        port map (
      I0 => mmcm_lock_count_reg(2),
      I1 => mmcm_lock_count_reg(0),
      I2 => mmcm_lock_count_reg(1),
      I3 => mmcm_lock_count_reg(3),
      O => \p_0_in__2\(3)
    );
\mmcm_lock_count[4]_i_1__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"7FFF8000"
    )
        port map (
      I0 => mmcm_lock_count_reg(3),
      I1 => mmcm_lock_count_reg(1),
      I2 => mmcm_lock_count_reg(0),
      I3 => mmcm_lock_count_reg(2),
      I4 => mmcm_lock_count_reg(4),
      O => \p_0_in__2\(4)
    );
\mmcm_lock_count[5]_i_1__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFF80000000"
    )
        port map (
      I0 => mmcm_lock_count_reg(4),
      I1 => mmcm_lock_count_reg(2),
      I2 => mmcm_lock_count_reg(0),
      I3 => mmcm_lock_count_reg(1),
      I4 => mmcm_lock_count_reg(3),
      I5 => mmcm_lock_count_reg(5),
      O => \p_0_in__2\(5)
    );
\mmcm_lock_count[6]_i_1__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"9"
    )
        port map (
      I0 => \mmcm_lock_count[9]_i_4__0_n_0\,
      I1 => mmcm_lock_count_reg(6),
      O => \p_0_in__2\(6)
    );
\mmcm_lock_count[7]_i_1__0\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"D2"
    )
        port map (
      I0 => mmcm_lock_count_reg(6),
      I1 => \mmcm_lock_count[9]_i_4__0_n_0\,
      I2 => mmcm_lock_count_reg(7),
      O => \p_0_in__2\(7)
    );
\mmcm_lock_count[8]_i_1__0\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"DF20"
    )
        port map (
      I0 => mmcm_lock_count_reg(7),
      I1 => \mmcm_lock_count[9]_i_4__0_n_0\,
      I2 => mmcm_lock_count_reg(6),
      I3 => mmcm_lock_count_reg(8),
      O => \p_0_in__2\(8)
    );
\mmcm_lock_count[9]_i_2__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"DFFFFFFF"
    )
        port map (
      I0 => mmcm_lock_count_reg(7),
      I1 => \mmcm_lock_count[9]_i_4__0_n_0\,
      I2 => mmcm_lock_count_reg(6),
      I3 => mmcm_lock_count_reg(8),
      I4 => mmcm_lock_count_reg(9),
      O => \mmcm_lock_count[9]_i_2__0_n_0\
    );
\mmcm_lock_count[9]_i_3__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"F7FF0800"
    )
        port map (
      I0 => mmcm_lock_count_reg(8),
      I1 => mmcm_lock_count_reg(6),
      I2 => \mmcm_lock_count[9]_i_4__0_n_0\,
      I3 => mmcm_lock_count_reg(7),
      I4 => mmcm_lock_count_reg(9),
      O => \p_0_in__2\(9)
    );
\mmcm_lock_count[9]_i_4__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFFFFFFFFFF"
    )
        port map (
      I0 => mmcm_lock_count_reg(4),
      I1 => mmcm_lock_count_reg(2),
      I2 => mmcm_lock_count_reg(0),
      I3 => mmcm_lock_count_reg(1),
      I4 => mmcm_lock_count_reg(3),
      I5 => mmcm_lock_count_reg(5),
      O => \mmcm_lock_count[9]_i_4__0_n_0\
    );
\mmcm_lock_count_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(0),
      Q => mmcm_lock_count_reg(0),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(1),
      Q => mmcm_lock_count_reg(1),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(2),
      Q => mmcm_lock_count_reg(2),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(3),
      Q => mmcm_lock_count_reg(3),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(4),
      Q => mmcm_lock_count_reg(4),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(5),
      Q => mmcm_lock_count_reg(5),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(6),
      Q => mmcm_lock_count_reg(6),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(7),
      Q => mmcm_lock_count_reg(7),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(8),
      Q => mmcm_lock_count_reg(8),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2__0_n_0\,
      D => \p_0_in__2\(9),
      Q => mmcm_lock_count_reg(9),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
mmcm_lock_reclocked_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"E0"
    )
        port map (
      I0 => mmcm_lock_reclocked,
      I1 => \mmcm_lock_reclocked_i_2__0_n_0\,
      I2 => mmcm_lock_i,
      O => mmcm_lock_reclocked_i_1_n_0
    );
\mmcm_lock_reclocked_i_2__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00800000"
    )
        port map (
      I0 => mmcm_lock_count_reg(9),
      I1 => mmcm_lock_count_reg(8),
      I2 => mmcm_lock_count_reg(6),
      I3 => \mmcm_lock_count[9]_i_4__0_n_0\,
      I4 => mmcm_lock_count_reg(7),
      O => \mmcm_lock_reclocked_i_2__0_n_0\
    );
mmcm_lock_reclocked_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => mmcm_lock_reclocked_i_1_n_0,
      Q => mmcm_lock_reclocked,
      R => '0'
    );
recclk_mon_count_reset_reg: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => sync_CPLLLOCK_cdc_sync_n_2,
      Q => adapt_count_reset,
      S => AR(0)
    );
reset_time_out_i_2: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0F0E0C0EC3CEC0CE"
    )
        port map (
      I0 => \FSM_sequential_rx_state_reg[0]_0\,
      I1 => rx_state(3),
      I2 => rx_state(1),
      I3 => rx_state(0),
      I4 => mmcm_lock_reclocked,
      I5 => \^gt_rxuserrdy_i\,
      O => reset_time_out_i_2_n_0
    );
reset_time_out_i_4: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => rx_state(2),
      I1 => rx_state(3),
      O => gtrxreset_i
    );
reset_time_out_i_5: unisim.vcomponents.LUT5
    generic map(
      INIT => X"34347674"
    )
        port map (
      I0 => rx_state(2),
      I1 => rx_state(3),
      I2 => rx_state(0),
      I3 => \FSM_sequential_rx_state_reg[0]_0\,
      I4 => rx_state(1),
      O => reset_time_out_i_5_n_0
    );
reset_time_out_reg: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => sync_CPLLLOCK_cdc_sync_n_1,
      Q => reset_time_out_reg_n_0,
      S => AR(0)
    );
\run_phase_alignment_int_i_1__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFB0100"
    )
        port map (
      I0 => rx_state(1),
      I1 => rx_state(0),
      I2 => rx_state(2),
      I3 => rx_state(3),
      I4 => run_phase_alignment_int_reg_n_0,
      O => \run_phase_alignment_int_i_1__0_n_0\
    );
run_phase_alignment_int_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => \run_phase_alignment_int_i_1__0_n_0\,
      Q => run_phase_alignment_int_reg_n_0,
      R => AR(0)
    );
run_phase_alignment_int_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => scndry_out,
      Q => run_phase_alignment_int_s3_reg_n_0,
      R => '0'
    );
rx_fsm_reset_done_int_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"ABA8"
    )
        port map (
      I0 => rx_fsm_reset_done_int_0,
      I1 => rx_fsm_reset_done_int_i_3_n_0,
      I2 => rx_fsm_reset_done_int_i_4_n_0,
      I3 => rx_fsm_reset_done_int,
      O => rx_fsm_reset_done_int_i_1_n_0
    );
rx_fsm_reset_done_int_i_2: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00040000"
    )
        port map (
      I0 => rx_state(0),
      I1 => time_out_1us_reg_n_0,
      I2 => rx_state(2),
      I3 => reset_time_out_reg_n_0,
      I4 => \^gt_rxuserrdy_i\,
      O => rx_fsm_reset_done_int_0
    );
rx_fsm_reset_done_int_i_3: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0400040004040400"
    )
        port map (
      I0 => rx_fsm_reset_done_int_i_5_n_0,
      I1 => rx_state(3),
      I2 => rx_state(2),
      I3 => \^gt_rxuserrdy_i\,
      I4 => time_out_100us_reg_n_0,
      I5 => reset_time_out_reg_n_0,
      O => rx_fsm_reset_done_int_i_3_n_0
    );
rx_fsm_reset_done_int_i_4: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0020002020200020"
    )
        port map (
      I0 => rx_state(1),
      I1 => rx_state(0),
      I2 => rx_fsm_reset_done_int_i_6_n_0,
      I3 => \^gt_rxuserrdy_i\,
      I4 => time_out_1us_reg_n_0,
      I5 => reset_time_out_reg_n_0,
      O => rx_fsm_reset_done_int_i_4_n_0
    );
rx_fsm_reset_done_int_i_5: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => rx_state(1),
      I1 => rx_state(0),
      O => rx_fsm_reset_done_int_i_5_n_0
    );
rx_fsm_reset_done_int_i_6: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => rx_state(3),
      I1 => rx_state(2),
      O => rx_fsm_reset_done_int_i_6_n_0
    );
rx_fsm_reset_done_int_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_fsm_reset_done_int_i_1_n_0,
      Q => rx_fsm_reset_done_int,
      R => AR(0)
    );
rx_fsm_reset_done_int_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => sync_rx_fsm_reset_done_int_cdc_sync_n_0,
      Q => rx_fsm_reset_done_int_s3,
      R => '0'
    );
rxresetdone_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rxresetdone_s2,
      Q => rxresetdone_s3,
      R => '0'
    );
sync_CPLLLOCK_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_9
     port map (
      E(0) => sync_CPLLLOCK_cdc_sync_n_0,
      \FSM_sequential_rx_state_reg[0]\ => \FSM_sequential_rx_state[3]_i_3_n_0\,
      \FSM_sequential_rx_state_reg[0]_0\(0) => \wait_time_cnt[6]_i_2__0_n_0\,
      \FSM_sequential_rx_state_reg[0]_1\ => \FSM_sequential_rx_state[3]_i_4_n_0\,
      \FSM_sequential_rx_state_reg[0]_2\ => \FSM_sequential_rx_state[3]_i_6_n_0\,
      \FSM_sequential_rx_state_reg[0]_3\ => \FSM_sequential_rx_state[3]_i_9_n_0\,
      \FSM_sequential_rx_state_reg[0]_4\ => \FSM_sequential_rx_state_reg[0]_0\,
      \FSM_sequential_rx_state_reg[1]\ => sync_CPLLLOCK_cdc_sync_n_1,
      \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg_0\ => sync_CPLLLOCK_cdc_sync_n_2,
      Q(3 downto 0) => rx_state(3 downto 0),
      adapt_count_reset => adapt_count_reset,
      gtrxreset_i => gtrxreset_i,
      init_clk_in => init_clk_in,
      reset_time_out_reg => reset_time_out_i_2_n_0,
      reset_time_out_reg_0 => reset_time_out_i_5_n_0,
      reset_time_out_reg_1 => reset_time_out_reg_n_0,
      rxresetdone_s3 => rxresetdone_s3,
      tx_lock => tx_lock
    );
sync_QPLLLOCK_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_10
     port map (
      init_clk_in => init_clk_in
    );
sync_RXRESETDONE_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_11\
     port map (
      init_clk_in => init_clk_in,
      \out\ => rxresetdone_s2,
      rxfsm_rxresetdone_r => rxfsm_rxresetdone_r,
      user_clk => user_clk
    );
sync_mmcm_lock_reclocked_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_12
     port map (
      SR(0) => sync_mmcm_lock_reclocked_cdc_sync_n_1,
      init_clk_in => init_clk_in,
      \out\ => mmcm_lock_i
    );
sync_run_phase_alignment_int_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_13\
     port map (
      \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg_0\ => run_phase_alignment_int_reg_n_0,
      init_clk_in => init_clk_in,
      \out\ => scndry_out,
      user_clk => user_clk
    );
sync_rx_fsm_reset_done_int_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_14\
     port map (
      init_clk_in => init_clk_in,
      \out\ => sync_rx_fsm_reset_done_int_cdc_sync_n_0,
      rx_fsm_reset_done_int => rx_fsm_reset_done_int,
      user_clk => user_clk
    );
sync_time_out_wait_bypass_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_15\
     port map (
      \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.INPUT_FLOP.p_level_in_d1_cdc_from_reg_0\ => time_out_wait_bypass_reg_n_0,
      init_clk_in => init_clk_in,
      \out\ => time_out_wait_bypass_s2,
      user_clk => user_clk
    );
time_out_100us_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFF00010000"
    )
        port map (
      I0 => time_out_2ms_i_2_n_0,
      I1 => time_out_counter_reg(6),
      I2 => time_out_counter_reg(7),
      I3 => time_out_100us_i_2_n_0,
      I4 => time_out_100us_i_3_n_0,
      I5 => time_out_100us_reg_n_0,
      O => time_out_100us_i_1_n_0
    );
time_out_100us_i_2: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => time_out_counter_reg(14),
      I1 => time_out_counter_reg(15),
      O => time_out_100us_i_2_n_0
    );
time_out_100us_i_3: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000002000000000"
    )
        port map (
      I0 => time_out_counter_reg(10),
      I1 => time_out_counter_reg(12),
      I2 => time_out_counter_reg(4),
      I3 => time_out_counter_reg(5),
      I4 => time_out_counter_reg(18),
      I5 => time_out_counter_reg(13),
      O => time_out_100us_i_3_n_0
    );
time_out_100us_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_out_100us_i_1_n_0,
      Q => time_out_100us_reg_n_0,
      R => reset_time_out_reg_n_0
    );
time_out_1us_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFF00000400"
    )
        port map (
      I0 => time_out_100us_i_2_n_0,
      I1 => time_out_counter_reg(2),
      I2 => time_out_1us_i_2_n_0,
      I3 => time_out_1us_i_3_n_0,
      I4 => time_out_1us_i_4_n_0,
      I5 => time_out_1us_reg_n_0,
      O => time_out_1us_i_1_n_0
    );
time_out_1us_i_2: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFFFFFE"
    )
        port map (
      I0 => time_out_counter_reg(11),
      I1 => time_out_counter_reg(16),
      I2 => time_out_counter_reg(17),
      I3 => time_out_counter_reg(1),
      I4 => time_out_counter_reg(0),
      O => time_out_1us_i_2_n_0
    );
time_out_1us_i_3: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000000001"
    )
        port map (
      I0 => time_out_counter_reg(8),
      I1 => time_out_counter_reg(9),
      I2 => time_out_counter_reg(3),
      I3 => time_out_counter_reg(7),
      I4 => time_out_counter_reg(18),
      I5 => time_out_counter_reg(12),
      O => time_out_1us_i_3_n_0
    );
time_out_1us_i_4: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FEFFFFFF"
    )
        port map (
      I0 => time_out_counter_reg(4),
      I1 => time_out_counter_reg(10),
      I2 => time_out_counter_reg(13),
      I3 => time_out_counter_reg(6),
      I4 => time_out_counter_reg(5),
      O => time_out_1us_i_4_n_0
    );
time_out_1us_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_out_1us_i_1_n_0,
      Q => time_out_1us_reg_n_0,
      R => reset_time_out_reg_n_0
    );
time_out_2ms_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"F4"
    )
        port map (
      I0 => time_out_2ms_i_2_n_0,
      I1 => \time_out_2ms_i_3__0_n_0\,
      I2 => time_out_2ms_reg_n_0,
      O => time_out_2ms_i_1_n_0
    );
time_out_2ms_i_2: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFFEFFF"
    )
        port map (
      I0 => time_out_counter_reg(2),
      I1 => time_out_counter_reg(3),
      I2 => time_out_counter_reg(8),
      I3 => time_out_counter_reg(9),
      I4 => time_out_1us_i_2_n_0,
      O => time_out_2ms_i_2_n_0
    );
\time_out_2ms_i_3__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000008000000"
    )
        port map (
      I0 => time_out_counter_reg(15),
      I1 => time_out_counter_reg(18),
      I2 => time_out_counter_reg(14),
      I3 => time_out_counter_reg(12),
      I4 => time_out_counter_reg(7),
      I5 => time_out_1us_i_4_n_0,
      O => \time_out_2ms_i_3__0_n_0\
    );
time_out_2ms_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_out_2ms_i_1_n_0,
      Q => time_out_2ms_reg_n_0,
      R => reset_time_out_reg_n_0
    );
\time_out_counter[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFF7FFFF"
    )
        port map (
      I0 => \time_out_counter[0]_i_3__0_n_0\,
      I1 => time_out_counter_reg(7),
      I2 => time_out_1us_i_4_n_0,
      I3 => time_out_counter_reg(14),
      I4 => time_out_counter_reg(12),
      I5 => time_out_2ms_i_2_n_0,
      O => time_out_counter
    );
\time_out_counter[0]_i_3__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => time_out_counter_reg(15),
      I1 => time_out_counter_reg(18),
      O => \time_out_counter[0]_i_3__0_n_0\
    );
\time_out_counter[0]_i_4__0\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(0),
      O => \time_out_counter[0]_i_4__0_n_0\
    );
\time_out_counter_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2__0_n_7\,
      Q => time_out_counter_reg(0),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[0]_i_2__0\: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => \time_out_counter_reg[0]_i_2__0_n_0\,
      CO(2) => \time_out_counter_reg[0]_i_2__0_n_1\,
      CO(1) => \time_out_counter_reg[0]_i_2__0_n_2\,
      CO(0) => \time_out_counter_reg[0]_i_2__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0001",
      O(3) => \time_out_counter_reg[0]_i_2__0_n_4\,
      O(2) => \time_out_counter_reg[0]_i_2__0_n_5\,
      O(1) => \time_out_counter_reg[0]_i_2__0_n_6\,
      O(0) => \time_out_counter_reg[0]_i_2__0_n_7\,
      S(3 downto 1) => time_out_counter_reg(3 downto 1),
      S(0) => \time_out_counter[0]_i_4__0_n_0\
    );
\time_out_counter_reg[10]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1__0_n_5\,
      Q => time_out_counter_reg(10),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[11]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1__0_n_4\,
      Q => time_out_counter_reg(11),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[12]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1__0_n_7\,
      Q => time_out_counter_reg(12),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[12]_i_1__0\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[8]_i_1__0_n_0\,
      CO(3) => \time_out_counter_reg[12]_i_1__0_n_0\,
      CO(2) => \time_out_counter_reg[12]_i_1__0_n_1\,
      CO(1) => \time_out_counter_reg[12]_i_1__0_n_2\,
      CO(0) => \time_out_counter_reg[12]_i_1__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \time_out_counter_reg[12]_i_1__0_n_4\,
      O(2) => \time_out_counter_reg[12]_i_1__0_n_5\,
      O(1) => \time_out_counter_reg[12]_i_1__0_n_6\,
      O(0) => \time_out_counter_reg[12]_i_1__0_n_7\,
      S(3 downto 0) => time_out_counter_reg(15 downto 12)
    );
\time_out_counter_reg[13]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1__0_n_6\,
      Q => time_out_counter_reg(13),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[14]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1__0_n_5\,
      Q => time_out_counter_reg(14),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[15]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1__0_n_4\,
      Q => time_out_counter_reg(15),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[16]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[16]_i_1__0_n_7\,
      Q => time_out_counter_reg(16),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[16]_i_1__0\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[12]_i_1__0_n_0\,
      CO(3 downto 2) => \NLW_time_out_counter_reg[16]_i_1__0_CO_UNCONNECTED\(3 downto 2),
      CO(1) => \time_out_counter_reg[16]_i_1__0_n_2\,
      CO(0) => \time_out_counter_reg[16]_i_1__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \NLW_time_out_counter_reg[16]_i_1__0_O_UNCONNECTED\(3),
      O(2) => \time_out_counter_reg[16]_i_1__0_n_5\,
      O(1) => \time_out_counter_reg[16]_i_1__0_n_6\,
      O(0) => \time_out_counter_reg[16]_i_1__0_n_7\,
      S(3) => '0',
      S(2 downto 0) => time_out_counter_reg(18 downto 16)
    );
\time_out_counter_reg[17]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[16]_i_1__0_n_6\,
      Q => time_out_counter_reg(17),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[18]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[16]_i_1__0_n_5\,
      Q => time_out_counter_reg(18),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2__0_n_6\,
      Q => time_out_counter_reg(1),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2__0_n_5\,
      Q => time_out_counter_reg(2),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2__0_n_4\,
      Q => time_out_counter_reg(3),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1__0_n_7\,
      Q => time_out_counter_reg(4),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[4]_i_1__0\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[0]_i_2__0_n_0\,
      CO(3) => \time_out_counter_reg[4]_i_1__0_n_0\,
      CO(2) => \time_out_counter_reg[4]_i_1__0_n_1\,
      CO(1) => \time_out_counter_reg[4]_i_1__0_n_2\,
      CO(0) => \time_out_counter_reg[4]_i_1__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \time_out_counter_reg[4]_i_1__0_n_4\,
      O(2) => \time_out_counter_reg[4]_i_1__0_n_5\,
      O(1) => \time_out_counter_reg[4]_i_1__0_n_6\,
      O(0) => \time_out_counter_reg[4]_i_1__0_n_7\,
      S(3 downto 0) => time_out_counter_reg(7 downto 4)
    );
\time_out_counter_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1__0_n_6\,
      Q => time_out_counter_reg(5),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1__0_n_5\,
      Q => time_out_counter_reg(6),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1__0_n_4\,
      Q => time_out_counter_reg(7),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1__0_n_7\,
      Q => time_out_counter_reg(8),
      R => reset_time_out_reg_n_0
    );
\time_out_counter_reg[8]_i_1__0\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[4]_i_1__0_n_0\,
      CO(3) => \time_out_counter_reg[8]_i_1__0_n_0\,
      CO(2) => \time_out_counter_reg[8]_i_1__0_n_1\,
      CO(1) => \time_out_counter_reg[8]_i_1__0_n_2\,
      CO(0) => \time_out_counter_reg[8]_i_1__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \time_out_counter_reg[8]_i_1__0_n_4\,
      O(2) => \time_out_counter_reg[8]_i_1__0_n_5\,
      O(1) => \time_out_counter_reg[8]_i_1__0_n_6\,
      O(0) => \time_out_counter_reg[8]_i_1__0_n_7\,
      S(3 downto 0) => time_out_counter_reg(11 downto 8)
    );
\time_out_counter_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1__0_n_6\,
      Q => time_out_counter_reg(9),
      R => reset_time_out_reg_n_0
    );
time_out_wait_bypass_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"AB00"
    )
        port map (
      I0 => time_out_wait_bypass_reg_n_0,
      I1 => \time_out_wait_bypass_i_2__0_n_0\,
      I2 => rx_fsm_reset_done_int_s3,
      I3 => run_phase_alignment_int_s3_reg_n_0,
      O => time_out_wait_bypass_i_1_n_0
    );
\time_out_wait_bypass_i_2__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => \time_out_wait_bypass_i_3__0_n_0\,
      I1 => wait_bypass_count_reg(4),
      I2 => wait_bypass_count_reg(3),
      I3 => wait_bypass_count_reg(6),
      I4 => wait_bypass_count_reg(5),
      I5 => \time_out_wait_bypass_i_4__0_n_0\,
      O => \time_out_wait_bypass_i_2__0_n_0\
    );
\time_out_wait_bypass_i_3__0\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FF7F"
    )
        port map (
      I0 => wait_bypass_count_reg(8),
      I1 => wait_bypass_count_reg(7),
      I2 => wait_bypass_count_reg(9),
      I3 => wait_bypass_count_reg(10),
      O => \time_out_wait_bypass_i_3__0_n_0\
    );
\time_out_wait_bypass_i_4__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"DFFFFFFF"
    )
        port map (
      I0 => wait_bypass_count_reg(0),
      I1 => wait_bypass_count_reg(11),
      I2 => wait_bypass_count_reg(12),
      I3 => wait_bypass_count_reg(2),
      I4 => wait_bypass_count_reg(1),
      O => \time_out_wait_bypass_i_4__0_n_0\
    );
time_out_wait_bypass_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => time_out_wait_bypass_i_1_n_0,
      Q => time_out_wait_bypass_reg_n_0,
      R => '0'
    );
time_out_wait_bypass_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_out_wait_bypass_s2,
      Q => time_out_wait_bypass_s3,
      R => '0'
    );
time_tlock_max1_carry: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => time_tlock_max1_carry_n_0,
      CO(2) => time_tlock_max1_carry_n_1,
      CO(1) => time_tlock_max1_carry_n_2,
      CO(0) => time_tlock_max1_carry_n_3,
      CYINIT => '0',
      DI(3) => time_tlock_max1_carry_i_1_n_0,
      DI(2) => time_out_counter_reg(5),
      DI(1) => time_tlock_max1_carry_i_2_n_0,
      DI(0) => time_tlock_max1_carry_i_3_n_0,
      O(3 downto 0) => NLW_time_tlock_max1_carry_O_UNCONNECTED(3 downto 0),
      S(3) => time_tlock_max1_carry_i_4_n_0,
      S(2) => time_tlock_max1_carry_i_5_n_0,
      S(1) => time_tlock_max1_carry_i_6_n_0,
      S(0) => time_tlock_max1_carry_i_7_n_0
    );
\time_tlock_max1_carry__0\: unisim.vcomponents.CARRY4
     port map (
      CI => time_tlock_max1_carry_n_0,
      CO(3) => \time_tlock_max1_carry__0_n_0\,
      CO(2) => \time_tlock_max1_carry__0_n_1\,
      CO(1) => \time_tlock_max1_carry__0_n_2\,
      CO(0) => \time_tlock_max1_carry__0_n_3\,
      CYINIT => '0',
      DI(3) => \time_tlock_max1_carry__0_i_1_n_0\,
      DI(2) => \time_tlock_max1_carry__0_i_2_n_0\,
      DI(1) => time_out_counter_reg(11),
      DI(0) => '0',
      O(3 downto 0) => \NLW_time_tlock_max1_carry__0_O_UNCONNECTED\(3 downto 0),
      S(3) => \time_tlock_max1_carry__0_i_3_n_0\,
      S(2) => \time_tlock_max1_carry__0_i_4_n_0\,
      S(1) => \time_tlock_max1_carry__0_i_5_n_0\,
      S(0) => \time_tlock_max1_carry__0_i_6_n_0\
    );
\time_tlock_max1_carry__0_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => time_out_counter_reg(14),
      I1 => time_out_counter_reg(15),
      O => \time_tlock_max1_carry__0_i_1_n_0\
    );
\time_tlock_max1_carry__0_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => time_out_counter_reg(12),
      I1 => time_out_counter_reg(13),
      O => \time_tlock_max1_carry__0_i_2_n_0\
    );
\time_tlock_max1_carry__0_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(15),
      I1 => time_out_counter_reg(14),
      O => \time_tlock_max1_carry__0_i_3_n_0\
    );
\time_tlock_max1_carry__0_i_4\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => time_out_counter_reg(13),
      I1 => time_out_counter_reg(12),
      O => \time_tlock_max1_carry__0_i_4_n_0\
    );
\time_tlock_max1_carry__0_i_5\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => time_out_counter_reg(10),
      I1 => time_out_counter_reg(11),
      O => \time_tlock_max1_carry__0_i_5_n_0\
    );
\time_tlock_max1_carry__0_i_6\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => time_out_counter_reg(9),
      I1 => time_out_counter_reg(8),
      O => \time_tlock_max1_carry__0_i_6_n_0\
    );
\time_tlock_max1_carry__1\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_tlock_max1_carry__0_n_0\,
      CO(3 downto 2) => \NLW_time_tlock_max1_carry__1_CO_UNCONNECTED\(3 downto 2),
      CO(1) => time_tlock_max1,
      CO(0) => \time_tlock_max1_carry__1_n_3\,
      CYINIT => '0',
      DI(3 downto 2) => B"00",
      DI(1) => time_out_counter_reg(18),
      DI(0) => \time_tlock_max1_carry__1_i_1_n_0\,
      O(3 downto 0) => \NLW_time_tlock_max1_carry__1_O_UNCONNECTED\(3 downto 0),
      S(3 downto 2) => B"00",
      S(1) => \time_tlock_max1_carry__1_i_2_n_0\,
      S(0) => \time_tlock_max1_carry__1_i_3_n_0\
    );
\time_tlock_max1_carry__1_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => time_out_counter_reg(16),
      I1 => time_out_counter_reg(17),
      O => \time_tlock_max1_carry__1_i_1_n_0\
    );
\time_tlock_max1_carry__1_i_2\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(18),
      O => \time_tlock_max1_carry__1_i_2_n_0\
    );
\time_tlock_max1_carry__1_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(17),
      I1 => time_out_counter_reg(16),
      O => \time_tlock_max1_carry__1_i_3_n_0\
    );
time_tlock_max1_carry_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => time_out_counter_reg(6),
      I1 => time_out_counter_reg(7),
      O => time_tlock_max1_carry_i_1_n_0
    );
time_tlock_max1_carry_i_2: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => time_out_counter_reg(2),
      I1 => time_out_counter_reg(3),
      O => time_tlock_max1_carry_i_2_n_0
    );
time_tlock_max1_carry_i_3: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => time_out_counter_reg(0),
      I1 => time_out_counter_reg(1),
      O => time_tlock_max1_carry_i_3_n_0
    );
time_tlock_max1_carry_i_4: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(7),
      I1 => time_out_counter_reg(6),
      O => time_tlock_max1_carry_i_4_n_0
    );
time_tlock_max1_carry_i_5: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => time_out_counter_reg(4),
      I1 => time_out_counter_reg(5),
      O => time_tlock_max1_carry_i_5_n_0
    );
time_tlock_max1_carry_i_6: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(3),
      I1 => time_out_counter_reg(2),
      O => time_tlock_max1_carry_i_6_n_0
    );
time_tlock_max1_carry_i_7: unisim.vcomponents.LUT2
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(1),
      I1 => time_out_counter_reg(0),
      O => time_tlock_max1_carry_i_7_n_0
    );
time_tlock_max_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"F8"
    )
        port map (
      I0 => check_tlock_max_reg_n_0,
      I1 => time_tlock_max1,
      I2 => time_tlock_max,
      O => time_tlock_max_i_1_n_0
    );
time_tlock_max_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_tlock_max_i_1_n_0,
      Q => time_tlock_max,
      R => reset_time_out_reg_n_0
    );
\wait_bypass_count[0]_i_1__0\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => run_phase_alignment_int_s3_reg_n_0,
      O => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count[0]_i_2__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \time_out_wait_bypass_i_2__0_n_0\,
      I1 => rx_fsm_reset_done_int_s3,
      O => \wait_bypass_count[0]_i_2__0_n_0\
    );
\wait_bypass_count[0]_i_4__0\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => wait_bypass_count_reg(0),
      O => \wait_bypass_count[0]_i_4__0_n_0\
    );
\wait_bypass_count_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[0]_i_3__0_n_7\,
      Q => wait_bypass_count_reg(0),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[0]_i_3__0\: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => \wait_bypass_count_reg[0]_i_3__0_n_0\,
      CO(2) => \wait_bypass_count_reg[0]_i_3__0_n_1\,
      CO(1) => \wait_bypass_count_reg[0]_i_3__0_n_2\,
      CO(0) => \wait_bypass_count_reg[0]_i_3__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0001",
      O(3) => \wait_bypass_count_reg[0]_i_3__0_n_4\,
      O(2) => \wait_bypass_count_reg[0]_i_3__0_n_5\,
      O(1) => \wait_bypass_count_reg[0]_i_3__0_n_6\,
      O(0) => \wait_bypass_count_reg[0]_i_3__0_n_7\,
      S(3 downto 1) => wait_bypass_count_reg(3 downto 1),
      S(0) => \wait_bypass_count[0]_i_4__0_n_0\
    );
\wait_bypass_count_reg[10]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[8]_i_1__0_n_5\,
      Q => wait_bypass_count_reg(10),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[11]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[8]_i_1__0_n_4\,
      Q => wait_bypass_count_reg(11),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[12]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[12]_i_1__0_n_7\,
      Q => wait_bypass_count_reg(12),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[12]_i_1__0\: unisim.vcomponents.CARRY4
     port map (
      CI => \wait_bypass_count_reg[8]_i_1__0_n_0\,
      CO(3 downto 0) => \NLW_wait_bypass_count_reg[12]_i_1__0_CO_UNCONNECTED\(3 downto 0),
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 1) => \NLW_wait_bypass_count_reg[12]_i_1__0_O_UNCONNECTED\(3 downto 1),
      O(0) => \wait_bypass_count_reg[12]_i_1__0_n_7\,
      S(3 downto 1) => B"000",
      S(0) => wait_bypass_count_reg(12)
    );
\wait_bypass_count_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[0]_i_3__0_n_6\,
      Q => wait_bypass_count_reg(1),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[0]_i_3__0_n_5\,
      Q => wait_bypass_count_reg(2),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[0]_i_3__0_n_4\,
      Q => wait_bypass_count_reg(3),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[4]_i_1__0_n_7\,
      Q => wait_bypass_count_reg(4),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[4]_i_1__0\: unisim.vcomponents.CARRY4
     port map (
      CI => \wait_bypass_count_reg[0]_i_3__0_n_0\,
      CO(3) => \wait_bypass_count_reg[4]_i_1__0_n_0\,
      CO(2) => \wait_bypass_count_reg[4]_i_1__0_n_1\,
      CO(1) => \wait_bypass_count_reg[4]_i_1__0_n_2\,
      CO(0) => \wait_bypass_count_reg[4]_i_1__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \wait_bypass_count_reg[4]_i_1__0_n_4\,
      O(2) => \wait_bypass_count_reg[4]_i_1__0_n_5\,
      O(1) => \wait_bypass_count_reg[4]_i_1__0_n_6\,
      O(0) => \wait_bypass_count_reg[4]_i_1__0_n_7\,
      S(3 downto 0) => wait_bypass_count_reg(7 downto 4)
    );
\wait_bypass_count_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[4]_i_1__0_n_6\,
      Q => wait_bypass_count_reg(5),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[4]_i_1__0_n_5\,
      Q => wait_bypass_count_reg(6),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[4]_i_1__0_n_4\,
      Q => wait_bypass_count_reg(7),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[8]_i_1__0_n_7\,
      Q => wait_bypass_count_reg(8),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_bypass_count_reg[8]_i_1__0\: unisim.vcomponents.CARRY4
     port map (
      CI => \wait_bypass_count_reg[4]_i_1__0_n_0\,
      CO(3) => \wait_bypass_count_reg[8]_i_1__0_n_0\,
      CO(2) => \wait_bypass_count_reg[8]_i_1__0_n_1\,
      CO(1) => \wait_bypass_count_reg[8]_i_1__0_n_2\,
      CO(0) => \wait_bypass_count_reg[8]_i_1__0_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \wait_bypass_count_reg[8]_i_1__0_n_4\,
      O(2) => \wait_bypass_count_reg[8]_i_1__0_n_5\,
      O(1) => \wait_bypass_count_reg[8]_i_1__0_n_6\,
      O(0) => \wait_bypass_count_reg[8]_i_1__0_n_7\,
      S(3 downto 0) => wait_bypass_count_reg(11 downto 8)
    );
\wait_bypass_count_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2__0_n_0\,
      D => \wait_bypass_count_reg[8]_i_1__0_n_6\,
      Q => wait_bypass_count_reg(9),
      R => \wait_bypass_count[0]_i_1__0_n_0\
    );
\wait_time_cnt[0]_i_1__0\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => wait_time_cnt_reg(0),
      O => \wait_time_cnt0__0\(0)
    );
\wait_time_cnt[1]_i_1__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"9"
    )
        port map (
      I0 => wait_time_cnt_reg(1),
      I1 => wait_time_cnt_reg(0),
      O => \wait_time_cnt0__0\(1)
    );
\wait_time_cnt[2]_i_1__0\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"A9"
    )
        port map (
      I0 => wait_time_cnt_reg(2),
      I1 => wait_time_cnt_reg(0),
      I2 => wait_time_cnt_reg(1),
      O => \wait_time_cnt0__0\(2)
    );
\wait_time_cnt[3]_i_1__0\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"AAA9"
    )
        port map (
      I0 => wait_time_cnt_reg(3),
      I1 => wait_time_cnt_reg(1),
      I2 => wait_time_cnt_reg(0),
      I3 => wait_time_cnt_reg(2),
      O => \wait_time_cnt0__0\(3)
    );
\wait_time_cnt[4]_i_1__0\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"AAAAAAA9"
    )
        port map (
      I0 => wait_time_cnt_reg(4),
      I1 => wait_time_cnt_reg(2),
      I2 => wait_time_cnt_reg(0),
      I3 => wait_time_cnt_reg(1),
      I4 => wait_time_cnt_reg(3),
      O => \wait_time_cnt0__0\(4)
    );
\wait_time_cnt[5]_i_1__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"AAAAAAAAAAAAAAA9"
    )
        port map (
      I0 => wait_time_cnt_reg(5),
      I1 => wait_time_cnt_reg(3),
      I2 => wait_time_cnt_reg(1),
      I3 => wait_time_cnt_reg(0),
      I4 => wait_time_cnt_reg(2),
      I5 => wait_time_cnt_reg(4),
      O => \wait_time_cnt0__0\(5)
    );
\wait_time_cnt[6]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"02"
    )
        port map (
      I0 => rx_state(0),
      I1 => rx_state(1),
      I2 => rx_state(3),
      O => \wait_time_cnt[6]_i_1_n_0\
    );
\wait_time_cnt[6]_i_2__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \wait_time_cnt[6]_i_4__0_n_0\,
      I1 => wait_time_cnt_reg(6),
      O => \wait_time_cnt[6]_i_2__0_n_0\
    );
\wait_time_cnt[6]_i_3__0\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"9"
    )
        port map (
      I0 => wait_time_cnt_reg(6),
      I1 => \wait_time_cnt[6]_i_4__0_n_0\,
      O => \wait_time_cnt0__0\(6)
    );
\wait_time_cnt[6]_i_4__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => wait_time_cnt_reg(4),
      I1 => wait_time_cnt_reg(2),
      I2 => wait_time_cnt_reg(0),
      I3 => wait_time_cnt_reg(1),
      I4 => wait_time_cnt_reg(3),
      I5 => wait_time_cnt_reg(5),
      O => \wait_time_cnt[6]_i_4__0_n_0\
    );
\wait_time_cnt_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \wait_time_cnt[6]_i_2__0_n_0\,
      D => \wait_time_cnt0__0\(0),
      Q => wait_time_cnt_reg(0),
      R => \wait_time_cnt[6]_i_1_n_0\
    );
\wait_time_cnt_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \wait_time_cnt[6]_i_2__0_n_0\,
      D => \wait_time_cnt0__0\(1),
      Q => wait_time_cnt_reg(1),
      R => \wait_time_cnt[6]_i_1_n_0\
    );
\wait_time_cnt_reg[2]\: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \wait_time_cnt[6]_i_2__0_n_0\,
      D => \wait_time_cnt0__0\(2),
      Q => wait_time_cnt_reg(2),
      S => \wait_time_cnt[6]_i_1_n_0\
    );
\wait_time_cnt_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \wait_time_cnt[6]_i_2__0_n_0\,
      D => \wait_time_cnt0__0\(3),
      Q => wait_time_cnt_reg(3),
      R => \wait_time_cnt[6]_i_1_n_0\
    );
\wait_time_cnt_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \wait_time_cnt[6]_i_2__0_n_0\,
      D => \wait_time_cnt0__0\(4),
      Q => wait_time_cnt_reg(4),
      R => \wait_time_cnt[6]_i_1_n_0\
    );
\wait_time_cnt_reg[5]\: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \wait_time_cnt[6]_i_2__0_n_0\,
      D => \wait_time_cnt0__0\(5),
      Q => wait_time_cnt_reg(5),
      S => \wait_time_cnt[6]_i_1_n_0\
    );
\wait_time_cnt_reg[6]\: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \wait_time_cnt[6]_i_2__0_n_0\,
      D => \wait_time_cnt0__0\(6),
      Q => wait_time_cnt_reg(6),
      S => \wait_time_cnt[6]_i_1_n_0\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_tx_startup_fsm is
  port (
    \out\ : out STD_LOGIC;
    gt_tx_reset_i : out STD_LOGIC;
    cpll_reset_i : out STD_LOGIC;
    gt_txuserrdy_i : out STD_LOGIC;
    CPLL_RESET_reg_0 : out STD_LOGIC;
    \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : out STD_LOGIC;
    tx_lock : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    txfsm_txresetdone_r : in STD_LOGIC;
    AR : in STD_LOGIC_VECTOR ( 0 to 0 );
    ack_flag : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_tx_startup_fsm;

architecture STRUCTURE of aurora_8b10b_x1_16b_tx_startup_fsm is
  signal CPLL_RESET_i_1_n_0 : STD_LOGIC;
  signal \FSM_sequential_tx_state[2]_i_2_n_0\ : STD_LOGIC;
  signal \FSM_sequential_tx_state[3]_i_10_n_0\ : STD_LOGIC;
  signal \FSM_sequential_tx_state[3]_i_3_n_0\ : STD_LOGIC;
  signal \FSM_sequential_tx_state[3]_i_6_n_0\ : STD_LOGIC;
  signal \FSM_sequential_tx_state[3]_i_7_n_0\ : STD_LOGIC;
  signal \FSM_sequential_tx_state[3]_i_8_n_0\ : STD_LOGIC;
  signal \FSM_sequential_tx_state[3]_i_9_n_0\ : STD_LOGIC;
  signal TXUSERRDY_i_1_n_0 : STD_LOGIC;
  signal clear : STD_LOGIC;
  signal \^cpll_reset_i\ : STD_LOGIC;
  signal \^gt_tx_reset_i\ : STD_LOGIC;
  signal \^gt_txuserrdy_i\ : STD_LOGIC;
  signal gttxreset_i_i_1_n_0 : STD_LOGIC;
  signal \init_wait_count[0]_i_1_n_0\ : STD_LOGIC;
  signal \init_wait_count[5]_i_1_n_0\ : STD_LOGIC;
  signal init_wait_count_reg : STD_LOGIC_VECTOR ( 5 downto 0 );
  signal init_wait_done_i_1_n_0 : STD_LOGIC;
  signal init_wait_done_i_2_n_0 : STD_LOGIC;
  signal init_wait_done_reg_n_0 : STD_LOGIC;
  signal \mmcm_lock_count[9]_i_2_n_0\ : STD_LOGIC;
  signal \mmcm_lock_count[9]_i_4_n_0\ : STD_LOGIC;
  signal mmcm_lock_count_reg : STD_LOGIC_VECTOR ( 9 downto 0 );
  signal mmcm_lock_i : STD_LOGIC;
  signal mmcm_lock_reclocked : STD_LOGIC;
  signal mmcm_lock_reclocked_i_1_n_0 : STD_LOGIC;
  signal \^out\ : STD_LOGIC;
  signal p_0_in : STD_LOGIC_VECTOR ( 5 downto 1 );
  signal p_0_in_1 : STD_LOGIC;
  signal \p_0_in__0\ : STD_LOGIC_VECTOR ( 9 downto 0 );
  signal pll_reset_asserted_i_1_n_0 : STD_LOGIC;
  signal pll_reset_asserted_reg_n_0 : STD_LOGIC;
  signal reset_time_out : STD_LOGIC;
  signal run_phase_alignment_int : STD_LOGIC;
  signal run_phase_alignment_int_i_1_n_0 : STD_LOGIC;
  signal run_phase_alignment_int_s3 : STD_LOGIC;
  signal scndry_out : STD_LOGIC;
  signal sel : STD_LOGIC;
  signal sync_CPLLLOCK_cdc_sync_n_0 : STD_LOGIC;
  signal sync_CPLLLOCK_cdc_sync_n_1 : STD_LOGIC;
  signal sync_mmcm_lock_reclocked_cdc_sync_n_1 : STD_LOGIC;
  signal time_out_2ms_i_1_n_0 : STD_LOGIC;
  signal \time_out_2ms_i_2__0_n_0\ : STD_LOGIC;
  signal time_out_2ms_i_3_n_0 : STD_LOGIC;
  signal time_out_2ms_i_4_n_0 : STD_LOGIC;
  signal time_out_2ms_i_5_n_0 : STD_LOGIC;
  signal time_out_2ms_reg_n_0 : STD_LOGIC;
  signal time_out_500us_i_1_n_0 : STD_LOGIC;
  signal time_out_500us_i_2_n_0 : STD_LOGIC;
  signal time_out_500us_reg_n_0 : STD_LOGIC;
  signal time_out_counter : STD_LOGIC;
  signal \time_out_counter[0]_i_3_n_0\ : STD_LOGIC;
  signal \time_out_counter[0]_i_4_n_0\ : STD_LOGIC;
  signal time_out_counter_reg : STD_LOGIC_VECTOR ( 17 downto 0 );
  signal \time_out_counter_reg[0]_i_2_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[0]_i_2_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[12]_i_1_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[16]_i_1_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[4]_i_1_n_7\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_0\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_1\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_2\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_3\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_4\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_5\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_6\ : STD_LOGIC;
  signal \time_out_counter_reg[8]_i_1_n_7\ : STD_LOGIC;
  signal time_out_wait_bypass : STD_LOGIC;
  signal time_out_wait_bypass_i_1_n_0 : STD_LOGIC;
  signal time_out_wait_bypass_i_2_n_0 : STD_LOGIC;
  signal time_out_wait_bypass_i_3_n_0 : STD_LOGIC;
  signal time_out_wait_bypass_i_4_n_0 : STD_LOGIC;
  signal time_out_wait_bypass_i_5_n_0 : STD_LOGIC;
  signal time_out_wait_bypass_i_6_n_0 : STD_LOGIC;
  signal time_out_wait_bypass_s2 : STD_LOGIC;
  signal time_out_wait_bypass_s3 : STD_LOGIC;
  signal time_tlock_max_i_1_n_0 : STD_LOGIC;
  signal time_tlock_max_i_2_n_0 : STD_LOGIC;
  signal time_tlock_max_i_3_n_0 : STD_LOGIC;
  signal time_tlock_max_i_4_n_0 : STD_LOGIC;
  signal time_tlock_max_reg_n_0 : STD_LOGIC;
  signal tx_fsm_reset_done_int : STD_LOGIC;
  signal tx_fsm_reset_done_int_i_1_n_0 : STD_LOGIC;
  signal tx_fsm_reset_done_int_s3 : STD_LOGIC;
  signal tx_state : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \tx_state__0\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal txresetdone_s2 : STD_LOGIC;
  signal txresetdone_s3 : STD_LOGIC;
  signal \wait_bypass_count[0]_i_2_n_0\ : STD_LOGIC;
  signal \wait_bypass_count[0]_i_4_n_0\ : STD_LOGIC;
  signal wait_bypass_count_reg : STD_LOGIC_VECTOR ( 15 downto 0 );
  signal \wait_bypass_count_reg[0]_i_3_n_0\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3_n_1\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3_n_2\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3_n_3\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3_n_4\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3_n_5\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3_n_6\ : STD_LOGIC;
  signal \wait_bypass_count_reg[0]_i_3_n_7\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1_n_1\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1_n_2\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1_n_3\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1_n_4\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1_n_5\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1_n_6\ : STD_LOGIC;
  signal \wait_bypass_count_reg[12]_i_1_n_7\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_0\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_1\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_2\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_3\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_4\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_5\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_6\ : STD_LOGIC;
  signal \wait_bypass_count_reg[4]_i_1_n_7\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_0\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_1\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_2\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_3\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_4\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_5\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_6\ : STD_LOGIC;
  signal \wait_bypass_count_reg[8]_i_1_n_7\ : STD_LOGIC;
  signal wait_time_cnt0 : STD_LOGIC_VECTOR ( 6 downto 0 );
  signal \wait_time_cnt[6]_i_1__0_n_0\ : STD_LOGIC;
  signal \wait_time_cnt[6]_i_4_n_0\ : STD_LOGIC;
  signal wait_time_cnt_reg : STD_LOGIC_VECTOR ( 6 downto 0 );
  signal \NLW_time_out_counter_reg[16]_i_1_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 1 );
  signal \NLW_time_out_counter_reg[16]_i_1_O_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 downto 2 );
  signal \NLW_wait_bypass_count_reg[12]_i_1_CO_UNCONNECTED\ : STD_LOGIC_VECTOR ( 3 to 3 );
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \FSM_sequential_tx_state[1]_i_1\ : label is "soft_lutpair68";
  attribute SOFT_HLUTNM of \FSM_sequential_tx_state[2]_i_2\ : label is "soft_lutpair75";
  attribute SOFT_HLUTNM of \FSM_sequential_tx_state[3]_i_10\ : label is "soft_lutpair68";
  attribute SOFT_HLUTNM of \FSM_sequential_tx_state[3]_i_6\ : label is "soft_lutpair65";
  attribute SOFT_HLUTNM of \FSM_sequential_tx_state[3]_i_7\ : label is "soft_lutpair72";
  attribute SOFT_HLUTNM of \FSM_sequential_tx_state[3]_i_8\ : label is "soft_lutpair65";
  attribute SOFT_HLUTNM of \FSM_sequential_tx_state[3]_i_9\ : label is "soft_lutpair73";
  attribute FSM_ENCODED_STATES : string;
  attribute FSM_ENCODED_STATES of \FSM_sequential_tx_state_reg[0]\ : label is "wait_for_txoutclk:0100,release_pll_reset:0011,wait_for_pll_lock:0010,assert_all_resets:0001,init:0000,wait_reset_done:0111,reset_fsm_done:1001,wait_for_txusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute FSM_ENCODED_STATES of \FSM_sequential_tx_state_reg[1]\ : label is "wait_for_txoutclk:0100,release_pll_reset:0011,wait_for_pll_lock:0010,assert_all_resets:0001,init:0000,wait_reset_done:0111,reset_fsm_done:1001,wait_for_txusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute FSM_ENCODED_STATES of \FSM_sequential_tx_state_reg[2]\ : label is "wait_for_txoutclk:0100,release_pll_reset:0011,wait_for_pll_lock:0010,assert_all_resets:0001,init:0000,wait_reset_done:0111,reset_fsm_done:1001,wait_for_txusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute FSM_ENCODED_STATES of \FSM_sequential_tx_state_reg[3]\ : label is "wait_for_txoutclk:0100,release_pll_reset:0011,wait_for_pll_lock:0010,assert_all_resets:0001,init:0000,wait_reset_done:0111,reset_fsm_done:1001,wait_for_txusrclk:0110,do_phase_alignment:1000,release_mmcm_reset:0101";
  attribute SOFT_HLUTNM of \init_wait_count[1]_i_1\ : label is "soft_lutpair76";
  attribute SOFT_HLUTNM of \init_wait_count[2]_i_1\ : label is "soft_lutpair76";
  attribute SOFT_HLUTNM of \init_wait_count[3]_i_1\ : label is "soft_lutpair69";
  attribute SOFT_HLUTNM of \init_wait_count[4]_i_1\ : label is "soft_lutpair69";
  attribute SOFT_HLUTNM of \mmcm_lock_count[1]_i_1\ : label is "soft_lutpair77";
  attribute SOFT_HLUTNM of \mmcm_lock_count[2]_i_1\ : label is "soft_lutpair77";
  attribute SOFT_HLUTNM of \mmcm_lock_count[3]_i_1\ : label is "soft_lutpair71";
  attribute SOFT_HLUTNM of \mmcm_lock_count[4]_i_1\ : label is "soft_lutpair71";
  attribute SOFT_HLUTNM of \mmcm_lock_count[7]_i_1\ : label is "soft_lutpair74";
  attribute SOFT_HLUTNM of \mmcm_lock_count[8]_i_1\ : label is "soft_lutpair74";
  attribute SOFT_HLUTNM of \mmcm_lock_count[9]_i_3\ : label is "soft_lutpair66";
  attribute SOFT_HLUTNM of mmcm_lock_reclocked_i_1 : label is "soft_lutpair75";
  attribute SOFT_HLUTNM of mmcm_lock_reclocked_i_2 : label is "soft_lutpair66";
  attribute SOFT_HLUTNM of run_phase_alignment_int_i_1 : label is "soft_lutpair72";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of run_phase_alignment_int_s3_reg : label is "no";
  attribute SOFT_HLUTNM of time_out_2ms_i_1 : label is "soft_lutpair73";
  attribute SOFT_HLUTNM of time_out_2ms_i_5 : label is "soft_lutpair67";
  attribute ADDER_THRESHOLD : integer;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[0]_i_2\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[12]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[16]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[4]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \time_out_counter_reg[8]_i_1\ : label is 11;
  attribute equivalent_register_removal of time_out_wait_bypass_s3_reg : label is "no";
  attribute SOFT_HLUTNM of time_tlock_max_i_2 : label is "soft_lutpair67";
  attribute equivalent_register_removal of tx_fsm_reset_done_int_s3_reg : label is "no";
  attribute equivalent_register_removal of txresetdone_s3_reg : label is "no";
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[0]_i_3\ : label is 11;
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[12]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[4]_i_1\ : label is 11;
  attribute ADDER_THRESHOLD of \wait_bypass_count_reg[8]_i_1\ : label is 11;
  attribute SOFT_HLUTNM of \wait_time_cnt[0]_i_1\ : label is "soft_lutpair78";
  attribute SOFT_HLUTNM of \wait_time_cnt[1]_i_1\ : label is "soft_lutpair78";
  attribute SOFT_HLUTNM of \wait_time_cnt[3]_i_1\ : label is "soft_lutpair70";
  attribute SOFT_HLUTNM of \wait_time_cnt[4]_i_1\ : label is "soft_lutpair70";
begin
  cpll_reset_i <= \^cpll_reset_i\;
  gt_tx_reset_i <= \^gt_tx_reset_i\;
  gt_txuserrdy_i <= \^gt_txuserrdy_i\;
  \out\ <= \^out\;
CPLL_RESET_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFDFF00000100"
    )
        port map (
      I0 => pll_reset_asserted_reg_n_0,
      I1 => tx_state(2),
      I2 => tx_state(1),
      I3 => tx_state(0),
      I4 => tx_state(3),
      I5 => \^cpll_reset_i\,
      O => CPLL_RESET_i_1_n_0
    );
CPLL_RESET_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => CPLL_RESET_i_1_n_0,
      Q => \^cpll_reset_i\,
      R => AR(0)
    );
\FSM_sequential_tx_state[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"EFEFEFEFEFFFEFEF"
    )
        port map (
      I0 => \FSM_sequential_tx_state[3]_i_6_n_0\,
      I1 => tx_state(3),
      I2 => tx_state(0),
      I3 => \FSM_sequential_tx_state[2]_i_2_n_0\,
      I4 => tx_state(2),
      I5 => tx_state(1),
      O => \tx_state__0\(0)
    );
\FSM_sequential_tx_state[1]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"000F00D0"
    )
        port map (
      I0 => tx_state(2),
      I1 => \FSM_sequential_tx_state[2]_i_2_n_0\,
      I2 => tx_state(0),
      I3 => tx_state(3),
      I4 => tx_state(1),
      O => \tx_state__0\(1)
    );
\FSM_sequential_tx_state[2]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"000000000838CCCC"
    )
        port map (
      I0 => \FSM_sequential_tx_state[2]_i_2_n_0\,
      I1 => tx_state(2),
      I2 => tx_state(1),
      I3 => time_out_2ms_reg_n_0,
      I4 => tx_state(0),
      I5 => tx_state(3),
      O => \tx_state__0\(2)
    );
\FSM_sequential_tx_state[2]_i_2\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FD"
    )
        port map (
      I0 => time_tlock_max_reg_n_0,
      I1 => reset_time_out,
      I2 => mmcm_lock_reclocked,
      O => \FSM_sequential_tx_state[2]_i_2_n_0\
    );
\FSM_sequential_tx_state[3]_i_10\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => tx_state(3),
      I1 => tx_state(0),
      O => \FSM_sequential_tx_state[3]_i_10_n_0\
    );
\FSM_sequential_tx_state[3]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"5555555500F30000"
    )
        port map (
      I0 => time_out_wait_bypass_s3,
      I1 => time_out_500us_reg_n_0,
      I2 => reset_time_out,
      I3 => \FSM_sequential_tx_state[3]_i_7_n_0\,
      I4 => tx_state(0),
      I5 => tx_state(3),
      O => \tx_state__0\(3)
    );
\FSM_sequential_tx_state[3]_i_3\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000001100FF00F0"
    )
        port map (
      I0 => wait_time_cnt_reg(6),
      I1 => \wait_time_cnt[6]_i_4_n_0\,
      I2 => init_wait_done_reg_n_0,
      I3 => tx_state(0),
      I4 => tx_state(3),
      I5 => \FSM_sequential_tx_state[3]_i_8_n_0\,
      O => \FSM_sequential_tx_state[3]_i_3_n_0\
    );
\FSM_sequential_tx_state[3]_i_6\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"2020F000"
    )
        port map (
      I0 => time_out_500us_reg_n_0,
      I1 => reset_time_out,
      I2 => tx_state(1),
      I3 => time_out_2ms_reg_n_0,
      I4 => tx_state(2),
      O => \FSM_sequential_tx_state[3]_i_6_n_0\
    );
\FSM_sequential_tx_state[3]_i_7\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"7"
    )
        port map (
      I0 => tx_state(1),
      I1 => tx_state(2),
      O => \FSM_sequential_tx_state[3]_i_7_n_0\
    );
\FSM_sequential_tx_state[3]_i_8\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => tx_state(1),
      I1 => tx_state(2),
      O => \FSM_sequential_tx_state[3]_i_8_n_0\
    );
\FSM_sequential_tx_state[3]_i_9\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"B"
    )
        port map (
      I0 => reset_time_out,
      I1 => time_tlock_max_reg_n_0,
      O => \FSM_sequential_tx_state[3]_i_9_n_0\
    );
\FSM_sequential_tx_state_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \tx_state__0\(0),
      Q => tx_state(0),
      R => AR(0)
    );
\FSM_sequential_tx_state_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \tx_state__0\(1),
      Q => tx_state(1),
      R => AR(0)
    );
\FSM_sequential_tx_state_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \tx_state__0\(2),
      Q => tx_state(2),
      R => AR(0)
    );
\FSM_sequential_tx_state_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sync_CPLLLOCK_cdc_sync_n_0,
      D => \tx_state__0\(3),
      Q => tx_state(3),
      R => AR(0)
    );
TXUSERRDY_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFB4000"
    )
        port map (
      I0 => tx_state(3),
      I1 => tx_state(0),
      I2 => tx_state(1),
      I3 => tx_state(2),
      I4 => \^gt_txuserrdy_i\,
      O => TXUSERRDY_i_1_n_0
    );
TXUSERRDY_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => TXUSERRDY_i_1_n_0,
      Q => \^gt_txuserrdy_i\,
      R => AR(0)
    );
flag2_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => \^cpll_reset_i\,
      I1 => ack_flag,
      O => CPLL_RESET_reg_0
    );
gttxreset_i_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FEFF0004"
    )
        port map (
      I0 => tx_state(3),
      I1 => tx_state(0),
      I2 => tx_state(1),
      I3 => tx_state(2),
      I4 => \^gt_tx_reset_i\,
      O => gttxreset_i_i_1_n_0
    );
gttxreset_i_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => gttxreset_i_i_1_n_0,
      Q => \^gt_tx_reset_i\,
      R => AR(0)
    );
\init_wait_count[0]_i_1\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => init_wait_count_reg(0),
      O => \init_wait_count[0]_i_1_n_0\
    );
\init_wait_count[1]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"6"
    )
        port map (
      I0 => init_wait_count_reg(0),
      I1 => init_wait_count_reg(1),
      O => p_0_in(1)
    );
\init_wait_count[2]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"78"
    )
        port map (
      I0 => init_wait_count_reg(1),
      I1 => init_wait_count_reg(0),
      I2 => init_wait_count_reg(2),
      O => p_0_in(2)
    );
\init_wait_count[3]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7F80"
    )
        port map (
      I0 => init_wait_count_reg(2),
      I1 => init_wait_count_reg(0),
      I2 => init_wait_count_reg(1),
      I3 => init_wait_count_reg(3),
      O => p_0_in(3)
    );
\init_wait_count[4]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"7FFF8000"
    )
        port map (
      I0 => init_wait_count_reg(3),
      I1 => init_wait_count_reg(1),
      I2 => init_wait_count_reg(0),
      I3 => init_wait_count_reg(2),
      I4 => init_wait_count_reg(4),
      O => p_0_in(4)
    );
\init_wait_count[5]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFF7FFF"
    )
        port map (
      I0 => init_wait_count_reg(4),
      I1 => init_wait_count_reg(5),
      I2 => init_wait_count_reg(2),
      I3 => init_wait_count_reg(3),
      I4 => init_wait_count_reg(1),
      I5 => init_wait_count_reg(0),
      O => \init_wait_count[5]_i_1_n_0\
    );
\init_wait_count[5]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFF80000000"
    )
        port map (
      I0 => init_wait_count_reg(4),
      I1 => init_wait_count_reg(2),
      I2 => init_wait_count_reg(0),
      I3 => init_wait_count_reg(1),
      I4 => init_wait_count_reg(3),
      I5 => init_wait_count_reg(5),
      O => p_0_in(5)
    );
\init_wait_count_reg[0]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1_n_0\,
      CLR => AR(0),
      D => \init_wait_count[0]_i_1_n_0\,
      Q => init_wait_count_reg(0)
    );
\init_wait_count_reg[1]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1_n_0\,
      CLR => AR(0),
      D => p_0_in(1),
      Q => init_wait_count_reg(1)
    );
\init_wait_count_reg[2]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1_n_0\,
      CLR => AR(0),
      D => p_0_in(2),
      Q => init_wait_count_reg(2)
    );
\init_wait_count_reg[3]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1_n_0\,
      CLR => AR(0),
      D => p_0_in(3),
      Q => init_wait_count_reg(3)
    );
\init_wait_count_reg[4]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1_n_0\,
      CLR => AR(0),
      D => p_0_in(4),
      Q => init_wait_count_reg(4)
    );
\init_wait_count_reg[5]\: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \init_wait_count[5]_i_1_n_0\,
      CLR => AR(0),
      D => p_0_in(5),
      Q => init_wait_count_reg(5)
    );
init_wait_done_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFF02000000"
    )
        port map (
      I0 => init_wait_done_i_2_n_0,
      I1 => init_wait_count_reg(1),
      I2 => init_wait_count_reg(0),
      I3 => init_wait_count_reg(3),
      I4 => init_wait_count_reg(2),
      I5 => init_wait_done_reg_n_0,
      O => init_wait_done_i_1_n_0
    );
init_wait_done_i_2: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => init_wait_count_reg(4),
      I1 => init_wait_count_reg(5),
      O => init_wait_done_i_2_n_0
    );
init_wait_done_reg: unisim.vcomponents.FDCE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      CLR => AR(0),
      D => init_wait_done_i_1_n_0,
      Q => init_wait_done_reg_n_0
    );
\mmcm_lock_count[0]_i_1\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => mmcm_lock_count_reg(0),
      O => \p_0_in__0\(0)
    );
\mmcm_lock_count[1]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"6"
    )
        port map (
      I0 => mmcm_lock_count_reg(0),
      I1 => mmcm_lock_count_reg(1),
      O => \p_0_in__0\(1)
    );
\mmcm_lock_count[2]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"78"
    )
        port map (
      I0 => mmcm_lock_count_reg(1),
      I1 => mmcm_lock_count_reg(0),
      I2 => mmcm_lock_count_reg(2),
      O => \p_0_in__0\(2)
    );
\mmcm_lock_count[3]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7F80"
    )
        port map (
      I0 => mmcm_lock_count_reg(2),
      I1 => mmcm_lock_count_reg(0),
      I2 => mmcm_lock_count_reg(1),
      I3 => mmcm_lock_count_reg(3),
      O => \p_0_in__0\(3)
    );
\mmcm_lock_count[4]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"7FFF8000"
    )
        port map (
      I0 => mmcm_lock_count_reg(3),
      I1 => mmcm_lock_count_reg(1),
      I2 => mmcm_lock_count_reg(0),
      I3 => mmcm_lock_count_reg(2),
      I4 => mmcm_lock_count_reg(4),
      O => \p_0_in__0\(4)
    );
\mmcm_lock_count[5]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFF80000000"
    )
        port map (
      I0 => mmcm_lock_count_reg(4),
      I1 => mmcm_lock_count_reg(2),
      I2 => mmcm_lock_count_reg(0),
      I3 => mmcm_lock_count_reg(1),
      I4 => mmcm_lock_count_reg(3),
      I5 => mmcm_lock_count_reg(5),
      O => \p_0_in__0\(5)
    );
\mmcm_lock_count[6]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"9"
    )
        port map (
      I0 => \mmcm_lock_count[9]_i_4_n_0\,
      I1 => mmcm_lock_count_reg(6),
      O => \p_0_in__0\(6)
    );
\mmcm_lock_count[7]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"D2"
    )
        port map (
      I0 => mmcm_lock_count_reg(6),
      I1 => \mmcm_lock_count[9]_i_4_n_0\,
      I2 => mmcm_lock_count_reg(7),
      O => \p_0_in__0\(7)
    );
\mmcm_lock_count[8]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"DF20"
    )
        port map (
      I0 => mmcm_lock_count_reg(7),
      I1 => \mmcm_lock_count[9]_i_4_n_0\,
      I2 => mmcm_lock_count_reg(6),
      I3 => mmcm_lock_count_reg(8),
      O => \p_0_in__0\(8)
    );
\mmcm_lock_count[9]_i_2\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"DFFFFFFF"
    )
        port map (
      I0 => mmcm_lock_count_reg(7),
      I1 => \mmcm_lock_count[9]_i_4_n_0\,
      I2 => mmcm_lock_count_reg(6),
      I3 => mmcm_lock_count_reg(8),
      I4 => mmcm_lock_count_reg(9),
      O => \mmcm_lock_count[9]_i_2_n_0\
    );
\mmcm_lock_count[9]_i_3\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"F7FF0800"
    )
        port map (
      I0 => mmcm_lock_count_reg(8),
      I1 => mmcm_lock_count_reg(6),
      I2 => \mmcm_lock_count[9]_i_4_n_0\,
      I3 => mmcm_lock_count_reg(7),
      I4 => mmcm_lock_count_reg(9),
      O => \p_0_in__0\(9)
    );
\mmcm_lock_count[9]_i_4\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFFFFFFFFFF"
    )
        port map (
      I0 => mmcm_lock_count_reg(4),
      I1 => mmcm_lock_count_reg(2),
      I2 => mmcm_lock_count_reg(0),
      I3 => mmcm_lock_count_reg(1),
      I4 => mmcm_lock_count_reg(3),
      I5 => mmcm_lock_count_reg(5),
      O => \mmcm_lock_count[9]_i_4_n_0\
    );
\mmcm_lock_count_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(0),
      Q => mmcm_lock_count_reg(0),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(1),
      Q => mmcm_lock_count_reg(1),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(2),
      Q => mmcm_lock_count_reg(2),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(3),
      Q => mmcm_lock_count_reg(3),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(4),
      Q => mmcm_lock_count_reg(4),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(5),
      Q => mmcm_lock_count_reg(5),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(6),
      Q => mmcm_lock_count_reg(6),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(7),
      Q => mmcm_lock_count_reg(7),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(8),
      Q => mmcm_lock_count_reg(8),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
\mmcm_lock_count_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => \mmcm_lock_count[9]_i_2_n_0\,
      D => \p_0_in__0\(9),
      Q => mmcm_lock_count_reg(9),
      R => sync_mmcm_lock_reclocked_cdc_sync_n_1
    );
mmcm_lock_reclocked_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"E0"
    )
        port map (
      I0 => mmcm_lock_reclocked,
      I1 => p_0_in_1,
      I2 => mmcm_lock_i,
      O => mmcm_lock_reclocked_i_1_n_0
    );
mmcm_lock_reclocked_i_2: unisim.vcomponents.LUT5
    generic map(
      INIT => X"00800000"
    )
        port map (
      I0 => mmcm_lock_count_reg(9),
      I1 => mmcm_lock_count_reg(8),
      I2 => mmcm_lock_count_reg(6),
      I3 => \mmcm_lock_count[9]_i_4_n_0\,
      I4 => mmcm_lock_count_reg(7),
      O => p_0_in_1
    );
mmcm_lock_reclocked_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => mmcm_lock_reclocked_i_1_n_0,
      Q => mmcm_lock_reclocked,
      R => '0'
    );
pll_reset_asserted_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"EF00FF10"
    )
        port map (
      I0 => tx_state(2),
      I1 => tx_state(3),
      I2 => tx_state(0),
      I3 => pll_reset_asserted_reg_n_0,
      I4 => tx_state(1),
      O => pll_reset_asserted_i_1_n_0
    );
pll_reset_asserted_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => pll_reset_asserted_i_1_n_0,
      Q => pll_reset_asserted_reg_n_0,
      R => AR(0)
    );
reset_time_out_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => sync_CPLLLOCK_cdc_sync_n_1,
      Q => reset_time_out,
      R => AR(0)
    );
run_phase_alignment_int_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFB0002"
    )
        port map (
      I0 => tx_state(3),
      I1 => tx_state(0),
      I2 => tx_state(1),
      I3 => tx_state(2),
      I4 => run_phase_alignment_int,
      O => run_phase_alignment_int_i_1_n_0
    );
run_phase_alignment_int_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => run_phase_alignment_int_i_1_n_0,
      Q => run_phase_alignment_int,
      R => AR(0)
    );
run_phase_alignment_int_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => scndry_out,
      Q => run_phase_alignment_int_s3,
      R => '0'
    );
sync_CPLLLOCK_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_2
     port map (
      E(0) => sync_CPLLLOCK_cdc_sync_n_0,
      \FSM_sequential_tx_state_reg[0]\ => \FSM_sequential_tx_state[3]_i_3_n_0\,
      \FSM_sequential_tx_state_reg[0]_0\ => \FSM_sequential_tx_state[3]_i_6_n_0\,
      \FSM_sequential_tx_state_reg[0]_1\ => \FSM_sequential_tx_state[3]_i_9_n_0\,
      \FSM_sequential_tx_state_reg[0]_2\ => \FSM_sequential_tx_state[3]_i_10_n_0\,
      \FSM_sequential_tx_state_reg[0]_3\ => pll_reset_asserted_reg_n_0,
      Q(3 downto 0) => tx_state(3 downto 0),
      init_clk_in => init_clk_in,
      mmcm_lock_reclocked => mmcm_lock_reclocked,
      reset_time_out => reset_time_out,
      reset_time_out_reg => sync_CPLLLOCK_cdc_sync_n_1,
      reset_time_out_reg_0 => init_wait_done_reg_n_0,
      tx_lock => tx_lock,
      txresetdone_s3 => txresetdone_s3
    );
sync_QPLLLOCK_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_3
     port map (
      init_clk_in => init_clk_in
    );
sync_TXRESETDONE_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_4\
     port map (
      init_clk_in => init_clk_in,
      \out\ => txresetdone_s2,
      txfsm_txresetdone_r => txfsm_txresetdone_r,
      user_clk => user_clk
    );
sync_mmcm_lock_reclocked_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_5
     port map (
      SR(0) => sync_mmcm_lock_reclocked_cdc_sync_n_1,
      init_clk_in => init_clk_in,
      \out\ => mmcm_lock_i
    );
sync_run_phase_alignment_int_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_6\
     port map (
      init_clk_in => init_clk_in,
      \out\ => scndry_out,
      run_phase_alignment_int => run_phase_alignment_int,
      user_clk => user_clk
    );
sync_time_out_wait_bypass_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_7\
     port map (
      init_clk_in => init_clk_in,
      \out\ => time_out_wait_bypass_s2,
      time_out_wait_bypass => time_out_wait_bypass,
      user_clk => user_clk
    );
sync_tx_fsm_reset_done_int_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2_8\
     port map (
      \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg_0\ => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\,
      init_clk_in => init_clk_in,
      \out\ => \^out\,
      tx_fsm_reset_done_int => tx_fsm_reset_done_int,
      user_clk => user_clk
    );
time_out_2ms_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"00AE"
    )
        port map (
      I0 => time_out_2ms_reg_n_0,
      I1 => \time_out_2ms_i_2__0_n_0\,
      I2 => time_out_2ms_i_3_n_0,
      I3 => reset_time_out,
      O => time_out_2ms_i_1_n_0
    );
\time_out_2ms_i_2__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000000800"
    )
        port map (
      I0 => time_out_counter_reg(16),
      I1 => time_out_counter_reg(17),
      I2 => time_out_counter_reg(9),
      I3 => time_out_counter_reg(11),
      I4 => time_out_counter_reg(4),
      I5 => time_tlock_max_i_3_n_0,
      O => \time_out_2ms_i_2__0_n_0\
    );
time_out_2ms_i_3: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFD"
    )
        port map (
      I0 => time_out_counter_reg(6),
      I1 => time_out_counter_reg(13),
      I2 => time_out_2ms_i_4_n_0,
      I3 => time_out_2ms_i_5_n_0,
      O => time_out_2ms_i_3_n_0
    );
time_out_2ms_i_4: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFEF"
    )
        port map (
      I0 => time_out_counter_reg(7),
      I1 => time_out_counter_reg(5),
      I2 => time_out_counter_reg(8),
      I3 => time_out_counter_reg(12),
      O => time_out_2ms_i_4_n_0
    );
time_out_2ms_i_5: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFE"
    )
        port map (
      I0 => time_out_counter_reg(1),
      I1 => time_out_counter_reg(0),
      I2 => time_out_counter_reg(3),
      I3 => time_out_counter_reg(2),
      O => time_out_2ms_i_5_n_0
    );
time_out_2ms_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_out_2ms_i_1_n_0,
      Q => time_out_2ms_reg_n_0,
      R => '0'
    );
time_out_500us_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00000000AAAAEAAA"
    )
        port map (
      I0 => time_out_500us_reg_n_0,
      I1 => time_out_500us_i_2_n_0,
      I2 => time_out_counter_reg(4),
      I3 => time_out_counter_reg(9),
      I4 => time_out_2ms_i_3_n_0,
      I5 => reset_time_out,
      O => time_out_500us_i_1_n_0
    );
time_out_500us_i_2: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000000008"
    )
        port map (
      I0 => time_out_counter_reg(14),
      I1 => time_out_counter_reg(15),
      I2 => time_out_counter_reg(10),
      I3 => time_out_counter_reg(11),
      I4 => time_out_counter_reg(17),
      I5 => time_out_counter_reg(16),
      O => time_out_500us_i_2_n_0
    );
time_out_500us_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_out_500us_i_1_n_0,
      Q => time_out_500us_reg_n_0,
      R => '0'
    );
\time_out_counter[0]_i_1__0\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFBFFFF"
    )
        port map (
      I0 => time_out_2ms_i_3_n_0,
      I1 => time_out_counter_reg(11),
      I2 => time_tlock_max_i_3_n_0,
      I3 => time_out_counter_reg(9),
      I4 => \time_out_counter[0]_i_3_n_0\,
      I5 => time_out_counter_reg(4),
      O => time_out_counter
    );
\time_out_counter[0]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"8"
    )
        port map (
      I0 => time_out_counter_reg(16),
      I1 => time_out_counter_reg(17),
      O => \time_out_counter[0]_i_3_n_0\
    );
\time_out_counter[0]_i_4\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => time_out_counter_reg(0),
      O => \time_out_counter[0]_i_4_n_0\
    );
\time_out_counter_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2_n_7\,
      Q => time_out_counter_reg(0),
      R => reset_time_out
    );
\time_out_counter_reg[0]_i_2\: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => \time_out_counter_reg[0]_i_2_n_0\,
      CO(2) => \time_out_counter_reg[0]_i_2_n_1\,
      CO(1) => \time_out_counter_reg[0]_i_2_n_2\,
      CO(0) => \time_out_counter_reg[0]_i_2_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0001",
      O(3) => \time_out_counter_reg[0]_i_2_n_4\,
      O(2) => \time_out_counter_reg[0]_i_2_n_5\,
      O(1) => \time_out_counter_reg[0]_i_2_n_6\,
      O(0) => \time_out_counter_reg[0]_i_2_n_7\,
      S(3 downto 1) => time_out_counter_reg(3 downto 1),
      S(0) => \time_out_counter[0]_i_4_n_0\
    );
\time_out_counter_reg[10]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1_n_5\,
      Q => time_out_counter_reg(10),
      R => reset_time_out
    );
\time_out_counter_reg[11]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1_n_4\,
      Q => time_out_counter_reg(11),
      R => reset_time_out
    );
\time_out_counter_reg[12]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1_n_7\,
      Q => time_out_counter_reg(12),
      R => reset_time_out
    );
\time_out_counter_reg[12]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[8]_i_1_n_0\,
      CO(3) => \time_out_counter_reg[12]_i_1_n_0\,
      CO(2) => \time_out_counter_reg[12]_i_1_n_1\,
      CO(1) => \time_out_counter_reg[12]_i_1_n_2\,
      CO(0) => \time_out_counter_reg[12]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \time_out_counter_reg[12]_i_1_n_4\,
      O(2) => \time_out_counter_reg[12]_i_1_n_5\,
      O(1) => \time_out_counter_reg[12]_i_1_n_6\,
      O(0) => \time_out_counter_reg[12]_i_1_n_7\,
      S(3 downto 0) => time_out_counter_reg(15 downto 12)
    );
\time_out_counter_reg[13]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1_n_6\,
      Q => time_out_counter_reg(13),
      R => reset_time_out
    );
\time_out_counter_reg[14]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1_n_5\,
      Q => time_out_counter_reg(14),
      R => reset_time_out
    );
\time_out_counter_reg[15]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[12]_i_1_n_4\,
      Q => time_out_counter_reg(15),
      R => reset_time_out
    );
\time_out_counter_reg[16]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[16]_i_1_n_7\,
      Q => time_out_counter_reg(16),
      R => reset_time_out
    );
\time_out_counter_reg[16]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[12]_i_1_n_0\,
      CO(3 downto 1) => \NLW_time_out_counter_reg[16]_i_1_CO_UNCONNECTED\(3 downto 1),
      CO(0) => \time_out_counter_reg[16]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3 downto 2) => \NLW_time_out_counter_reg[16]_i_1_O_UNCONNECTED\(3 downto 2),
      O(1) => \time_out_counter_reg[16]_i_1_n_6\,
      O(0) => \time_out_counter_reg[16]_i_1_n_7\,
      S(3 downto 2) => B"00",
      S(1 downto 0) => time_out_counter_reg(17 downto 16)
    );
\time_out_counter_reg[17]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[16]_i_1_n_6\,
      Q => time_out_counter_reg(17),
      R => reset_time_out
    );
\time_out_counter_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2_n_6\,
      Q => time_out_counter_reg(1),
      R => reset_time_out
    );
\time_out_counter_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2_n_5\,
      Q => time_out_counter_reg(2),
      R => reset_time_out
    );
\time_out_counter_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[0]_i_2_n_4\,
      Q => time_out_counter_reg(3),
      R => reset_time_out
    );
\time_out_counter_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1_n_7\,
      Q => time_out_counter_reg(4),
      R => reset_time_out
    );
\time_out_counter_reg[4]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[0]_i_2_n_0\,
      CO(3) => \time_out_counter_reg[4]_i_1_n_0\,
      CO(2) => \time_out_counter_reg[4]_i_1_n_1\,
      CO(1) => \time_out_counter_reg[4]_i_1_n_2\,
      CO(0) => \time_out_counter_reg[4]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \time_out_counter_reg[4]_i_1_n_4\,
      O(2) => \time_out_counter_reg[4]_i_1_n_5\,
      O(1) => \time_out_counter_reg[4]_i_1_n_6\,
      O(0) => \time_out_counter_reg[4]_i_1_n_7\,
      S(3 downto 0) => time_out_counter_reg(7 downto 4)
    );
\time_out_counter_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1_n_6\,
      Q => time_out_counter_reg(5),
      R => reset_time_out
    );
\time_out_counter_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1_n_5\,
      Q => time_out_counter_reg(6),
      R => reset_time_out
    );
\time_out_counter_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[4]_i_1_n_4\,
      Q => time_out_counter_reg(7),
      R => reset_time_out
    );
\time_out_counter_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1_n_7\,
      Q => time_out_counter_reg(8),
      R => reset_time_out
    );
\time_out_counter_reg[8]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \time_out_counter_reg[4]_i_1_n_0\,
      CO(3) => \time_out_counter_reg[8]_i_1_n_0\,
      CO(2) => \time_out_counter_reg[8]_i_1_n_1\,
      CO(1) => \time_out_counter_reg[8]_i_1_n_2\,
      CO(0) => \time_out_counter_reg[8]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \time_out_counter_reg[8]_i_1_n_4\,
      O(2) => \time_out_counter_reg[8]_i_1_n_5\,
      O(1) => \time_out_counter_reg[8]_i_1_n_6\,
      O(0) => \time_out_counter_reg[8]_i_1_n_7\,
      S(3 downto 0) => time_out_counter_reg(11 downto 8)
    );
\time_out_counter_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => time_out_counter,
      D => \time_out_counter_reg[8]_i_1_n_6\,
      Q => time_out_counter_reg(9),
      R => reset_time_out
    );
time_out_wait_bypass_i_1: unisim.vcomponents.LUT4
    generic map(
      INIT => X"AB00"
    )
        port map (
      I0 => time_out_wait_bypass,
      I1 => time_out_wait_bypass_i_2_n_0,
      I2 => tx_fsm_reset_done_int_s3,
      I3 => run_phase_alignment_int_s3,
      O => time_out_wait_bypass_i_1_n_0
    );
time_out_wait_bypass_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFE"
    )
        port map (
      I0 => time_out_wait_bypass_i_3_n_0,
      I1 => time_out_wait_bypass_i_4_n_0,
      I2 => time_out_wait_bypass_i_5_n_0,
      I3 => time_out_wait_bypass_i_6_n_0,
      O => time_out_wait_bypass_i_2_n_0
    );
time_out_wait_bypass_i_3: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7FFF"
    )
        port map (
      I0 => wait_bypass_count_reg(5),
      I1 => wait_bypass_count_reg(4),
      I2 => wait_bypass_count_reg(7),
      I3 => wait_bypass_count_reg(6),
      O => time_out_wait_bypass_i_3_n_0
    );
time_out_wait_bypass_i_4: unisim.vcomponents.LUT4
    generic map(
      INIT => X"7FFF"
    )
        port map (
      I0 => wait_bypass_count_reg(1),
      I1 => wait_bypass_count_reg(0),
      I2 => wait_bypass_count_reg(3),
      I3 => wait_bypass_count_reg(2),
      O => time_out_wait_bypass_i_4_n_0
    );
time_out_wait_bypass_i_5: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FF7F"
    )
        port map (
      I0 => wait_bypass_count_reg(13),
      I1 => wait_bypass_count_reg(12),
      I2 => wait_bypass_count_reg(15),
      I3 => wait_bypass_count_reg(14),
      O => time_out_wait_bypass_i_5_n_0
    );
time_out_wait_bypass_i_6: unisim.vcomponents.LUT4
    generic map(
      INIT => X"FFFD"
    )
        port map (
      I0 => wait_bypass_count_reg(9),
      I1 => wait_bypass_count_reg(8),
      I2 => wait_bypass_count_reg(11),
      I3 => wait_bypass_count_reg(10),
      O => time_out_wait_bypass_i_6_n_0
    );
time_out_wait_bypass_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => time_out_wait_bypass_i_1_n_0,
      Q => time_out_wait_bypass,
      R => '0'
    );
time_out_wait_bypass_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_out_wait_bypass_s2,
      Q => time_out_wait_bypass_s3,
      R => '0'
    );
time_tlock_max_i_1: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00000000AABAAAAA"
    )
        port map (
      I0 => time_tlock_max_reg_n_0,
      I1 => time_tlock_max_i_2_n_0,
      I2 => time_out_counter_reg(4),
      I3 => time_tlock_max_i_3_n_0,
      I4 => time_tlock_max_i_4_n_0,
      I5 => reset_time_out,
      O => time_tlock_max_i_1_n_0
    );
time_tlock_max_i_2: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFFFFFE"
    )
        port map (
      I0 => time_out_counter_reg(2),
      I1 => time_out_counter_reg(3),
      I2 => time_out_counter_reg(0),
      I3 => time_out_counter_reg(1),
      I4 => time_out_2ms_i_4_n_0,
      O => time_tlock_max_i_2_n_0
    );
time_tlock_max_i_3: unisim.vcomponents.LUT3
    generic map(
      INIT => X"EF"
    )
        port map (
      I0 => time_out_counter_reg(15),
      I1 => time_out_counter_reg(14),
      I2 => time_out_counter_reg(10),
      O => time_tlock_max_i_3_n_0
    );
time_tlock_max_i_4: unisim.vcomponents.LUT6
    generic map(
      INIT => X"0000000000000020"
    )
        port map (
      I0 => time_out_counter_reg(13),
      I1 => time_out_counter_reg(11),
      I2 => time_out_counter_reg(9),
      I3 => time_out_counter_reg(6),
      I4 => time_out_counter_reg(17),
      I5 => time_out_counter_reg(16),
      O => time_tlock_max_i_4_n_0
    );
time_tlock_max_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => time_tlock_max_i_1_n_0,
      Q => time_tlock_max_reg_n_0,
      R => '0'
    );
tx_fsm_reset_done_int_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFF0008"
    )
        port map (
      I0 => tx_state(0),
      I1 => tx_state(3),
      I2 => tx_state(2),
      I3 => tx_state(1),
      I4 => tx_fsm_reset_done_int,
      O => tx_fsm_reset_done_int_i_1_n_0
    );
tx_fsm_reset_done_int_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => tx_fsm_reset_done_int_i_1_n_0,
      Q => tx_fsm_reset_done_int,
      R => AR(0)
    );
tx_fsm_reset_done_int_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => '1',
      D => \^out\,
      Q => tx_fsm_reset_done_int_s3,
      R => '0'
    );
txresetdone_s3_reg: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => txresetdone_s2,
      Q => txresetdone_s3,
      R => '0'
    );
\wait_bypass_count[0]_i_1\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => run_phase_alignment_int_s3,
      O => clear
    );
\wait_bypass_count[0]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => time_out_wait_bypass_i_2_n_0,
      I1 => tx_fsm_reset_done_int_s3,
      O => \wait_bypass_count[0]_i_2_n_0\
    );
\wait_bypass_count[0]_i_4\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => wait_bypass_count_reg(0),
      O => \wait_bypass_count[0]_i_4_n_0\
    );
\wait_bypass_count_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[0]_i_3_n_7\,
      Q => wait_bypass_count_reg(0),
      R => clear
    );
\wait_bypass_count_reg[0]_i_3\: unisim.vcomponents.CARRY4
     port map (
      CI => '0',
      CO(3) => \wait_bypass_count_reg[0]_i_3_n_0\,
      CO(2) => \wait_bypass_count_reg[0]_i_3_n_1\,
      CO(1) => \wait_bypass_count_reg[0]_i_3_n_2\,
      CO(0) => \wait_bypass_count_reg[0]_i_3_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0001",
      O(3) => \wait_bypass_count_reg[0]_i_3_n_4\,
      O(2) => \wait_bypass_count_reg[0]_i_3_n_5\,
      O(1) => \wait_bypass_count_reg[0]_i_3_n_6\,
      O(0) => \wait_bypass_count_reg[0]_i_3_n_7\,
      S(3 downto 1) => wait_bypass_count_reg(3 downto 1),
      S(0) => \wait_bypass_count[0]_i_4_n_0\
    );
\wait_bypass_count_reg[10]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[8]_i_1_n_5\,
      Q => wait_bypass_count_reg(10),
      R => clear
    );
\wait_bypass_count_reg[11]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[8]_i_1_n_4\,
      Q => wait_bypass_count_reg(11),
      R => clear
    );
\wait_bypass_count_reg[12]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[12]_i_1_n_7\,
      Q => wait_bypass_count_reg(12),
      R => clear
    );
\wait_bypass_count_reg[12]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \wait_bypass_count_reg[8]_i_1_n_0\,
      CO(3) => \NLW_wait_bypass_count_reg[12]_i_1_CO_UNCONNECTED\(3),
      CO(2) => \wait_bypass_count_reg[12]_i_1_n_1\,
      CO(1) => \wait_bypass_count_reg[12]_i_1_n_2\,
      CO(0) => \wait_bypass_count_reg[12]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \wait_bypass_count_reg[12]_i_1_n_4\,
      O(2) => \wait_bypass_count_reg[12]_i_1_n_5\,
      O(1) => \wait_bypass_count_reg[12]_i_1_n_6\,
      O(0) => \wait_bypass_count_reg[12]_i_1_n_7\,
      S(3 downto 0) => wait_bypass_count_reg(15 downto 12)
    );
\wait_bypass_count_reg[13]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[12]_i_1_n_6\,
      Q => wait_bypass_count_reg(13),
      R => clear
    );
\wait_bypass_count_reg[14]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[12]_i_1_n_5\,
      Q => wait_bypass_count_reg(14),
      R => clear
    );
\wait_bypass_count_reg[15]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[12]_i_1_n_4\,
      Q => wait_bypass_count_reg(15),
      R => clear
    );
\wait_bypass_count_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[0]_i_3_n_6\,
      Q => wait_bypass_count_reg(1),
      R => clear
    );
\wait_bypass_count_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[0]_i_3_n_5\,
      Q => wait_bypass_count_reg(2),
      R => clear
    );
\wait_bypass_count_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[0]_i_3_n_4\,
      Q => wait_bypass_count_reg(3),
      R => clear
    );
\wait_bypass_count_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[4]_i_1_n_7\,
      Q => wait_bypass_count_reg(4),
      R => clear
    );
\wait_bypass_count_reg[4]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \wait_bypass_count_reg[0]_i_3_n_0\,
      CO(3) => \wait_bypass_count_reg[4]_i_1_n_0\,
      CO(2) => \wait_bypass_count_reg[4]_i_1_n_1\,
      CO(1) => \wait_bypass_count_reg[4]_i_1_n_2\,
      CO(0) => \wait_bypass_count_reg[4]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \wait_bypass_count_reg[4]_i_1_n_4\,
      O(2) => \wait_bypass_count_reg[4]_i_1_n_5\,
      O(1) => \wait_bypass_count_reg[4]_i_1_n_6\,
      O(0) => \wait_bypass_count_reg[4]_i_1_n_7\,
      S(3 downto 0) => wait_bypass_count_reg(7 downto 4)
    );
\wait_bypass_count_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[4]_i_1_n_6\,
      Q => wait_bypass_count_reg(5),
      R => clear
    );
\wait_bypass_count_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[4]_i_1_n_5\,
      Q => wait_bypass_count_reg(6),
      R => clear
    );
\wait_bypass_count_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[4]_i_1_n_4\,
      Q => wait_bypass_count_reg(7),
      R => clear
    );
\wait_bypass_count_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[8]_i_1_n_7\,
      Q => wait_bypass_count_reg(8),
      R => clear
    );
\wait_bypass_count_reg[8]_i_1\: unisim.vcomponents.CARRY4
     port map (
      CI => \wait_bypass_count_reg[4]_i_1_n_0\,
      CO(3) => \wait_bypass_count_reg[8]_i_1_n_0\,
      CO(2) => \wait_bypass_count_reg[8]_i_1_n_1\,
      CO(1) => \wait_bypass_count_reg[8]_i_1_n_2\,
      CO(0) => \wait_bypass_count_reg[8]_i_1_n_3\,
      CYINIT => '0',
      DI(3 downto 0) => B"0000",
      O(3) => \wait_bypass_count_reg[8]_i_1_n_4\,
      O(2) => \wait_bypass_count_reg[8]_i_1_n_5\,
      O(1) => \wait_bypass_count_reg[8]_i_1_n_6\,
      O(0) => \wait_bypass_count_reg[8]_i_1_n_7\,
      S(3 downto 0) => wait_bypass_count_reg(11 downto 8)
    );
\wait_bypass_count_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => user_clk,
      CE => \wait_bypass_count[0]_i_2_n_0\,
      D => \wait_bypass_count_reg[8]_i_1_n_6\,
      Q => wait_bypass_count_reg(9),
      R => clear
    );
\wait_time_cnt[0]_i_1\: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => wait_time_cnt_reg(0),
      O => wait_time_cnt0(0)
    );
\wait_time_cnt[1]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"9"
    )
        port map (
      I0 => wait_time_cnt_reg(1),
      I1 => wait_time_cnt_reg(0),
      O => wait_time_cnt0(1)
    );
\wait_time_cnt[2]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"A9"
    )
        port map (
      I0 => wait_time_cnt_reg(2),
      I1 => wait_time_cnt_reg(0),
      I2 => wait_time_cnt_reg(1),
      O => wait_time_cnt0(2)
    );
\wait_time_cnt[3]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"AAA9"
    )
        port map (
      I0 => wait_time_cnt_reg(3),
      I1 => wait_time_cnt_reg(1),
      I2 => wait_time_cnt_reg(0),
      I3 => wait_time_cnt_reg(2),
      O => wait_time_cnt0(3)
    );
\wait_time_cnt[4]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"AAAAAAA9"
    )
        port map (
      I0 => wait_time_cnt_reg(4),
      I1 => wait_time_cnt_reg(2),
      I2 => wait_time_cnt_reg(0),
      I3 => wait_time_cnt_reg(1),
      I4 => wait_time_cnt_reg(3),
      O => wait_time_cnt0(4)
    );
\wait_time_cnt[5]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"AAAAAAAAAAAAAAA9"
    )
        port map (
      I0 => wait_time_cnt_reg(5),
      I1 => wait_time_cnt_reg(3),
      I2 => wait_time_cnt_reg(1),
      I3 => wait_time_cnt_reg(0),
      I4 => wait_time_cnt_reg(2),
      I5 => wait_time_cnt_reg(4),
      O => wait_time_cnt0(5)
    );
\wait_time_cnt[6]_i_1__0\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0070"
    )
        port map (
      I0 => tx_state(2),
      I1 => tx_state(1),
      I2 => tx_state(0),
      I3 => tx_state(3),
      O => \wait_time_cnt[6]_i_1__0_n_0\
    );
\wait_time_cnt[6]_i_2\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"E"
    )
        port map (
      I0 => \wait_time_cnt[6]_i_4_n_0\,
      I1 => wait_time_cnt_reg(6),
      O => sel
    );
\wait_time_cnt[6]_i_3\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"9"
    )
        port map (
      I0 => wait_time_cnt_reg(6),
      I1 => \wait_time_cnt[6]_i_4_n_0\,
      O => wait_time_cnt0(6)
    );
\wait_time_cnt[6]_i_4\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFFFFFFFFFFFE"
    )
        port map (
      I0 => wait_time_cnt_reg(4),
      I1 => wait_time_cnt_reg(2),
      I2 => wait_time_cnt_reg(0),
      I3 => wait_time_cnt_reg(1),
      I4 => wait_time_cnt_reg(3),
      I5 => wait_time_cnt_reg(5),
      O => \wait_time_cnt[6]_i_4_n_0\
    );
\wait_time_cnt_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sel,
      D => wait_time_cnt0(0),
      Q => wait_time_cnt_reg(0),
      R => \wait_time_cnt[6]_i_1__0_n_0\
    );
\wait_time_cnt_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sel,
      D => wait_time_cnt0(1),
      Q => wait_time_cnt_reg(1),
      R => \wait_time_cnt[6]_i_1__0_n_0\
    );
\wait_time_cnt_reg[2]\: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sel,
      D => wait_time_cnt0(2),
      Q => wait_time_cnt_reg(2),
      S => \wait_time_cnt[6]_i_1__0_n_0\
    );
\wait_time_cnt_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sel,
      D => wait_time_cnt0(3),
      Q => wait_time_cnt_reg(3),
      R => \wait_time_cnt[6]_i_1__0_n_0\
    );
\wait_time_cnt_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sel,
      D => wait_time_cnt0(4),
      Q => wait_time_cnt_reg(4),
      R => \wait_time_cnt[6]_i_1__0_n_0\
    );
\wait_time_cnt_reg[5]\: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sel,
      D => wait_time_cnt0(5),
      Q => wait_time_cnt_reg(5),
      S => \wait_time_cnt[6]_i_1__0_n_0\
    );
\wait_time_cnt_reg[6]\: unisim.vcomponents.FDSE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => sel,
      D => wait_time_cnt0(6),
      Q => wait_time_cnt_reg(6),
      S => \wait_time_cnt[6]_i_1__0_n_0\
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_AURORA_LANE is
  port (
    LANE_UP : out STD_LOGIC;
    ena_comma_align_i : out STD_LOGIC;
    tx_reset_i : out STD_LOGIC;
    TXCHARISK : out STD_LOGIC_VECTOR ( 1 downto 0 );
    rx_pad_i : out STD_LOGIC;
    rx_ecp_i : out STD_LOGIC;
    rx_suf_i : out STD_LOGIC;
    got_v_i : out STD_LOGIC;
    hard_err_reset_i : out STD_LOGIC;
    hard_err_i : out STD_LOGIC;
    LINK_RESET_OUT : out STD_LOGIC;
    D : out STD_LOGIC_VECTOR ( 15 downto 0 );
    rx_polarity_i : out STD_LOGIC;
    left_aligned_r_reg : out STD_LOGIC;
    rx_pe_data_v_i : out STD_LOGIC;
    M_AXI_RX_SNF : out STD_LOGIC;
    \RX_FC_NB_Buffer_reg[1]\ : out STD_LOGIC_VECTOR ( 3 downto 0 );
    RX_ECP_Buffer_reg : out STD_LOGIC;
    first_v_received_r_reg : out STD_LOGIC;
    FRAME_ERR_Buffer0 : out STD_LOGIC;
    RX_SCP_Buffer_reg : out STD_LOGIC;
    TXDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    bucket_full_r_reg : out STD_LOGIC;
    soft_err_flop_r0 : out STD_LOGIC;
    SR : in STD_LOGIC_VECTOR ( 0 to 0 );
    user_clk : in STD_LOGIC;
    begin_r0 : in STD_LOGIC;
    tx_pe_data_v_i : in STD_LOGIC;
    gen_cc_i : in STD_LOGIC;
    gen_suf_i : in STD_LOGIC;
    gen_snf_i : in STD_LOGIC;
    gen_ecp_i : in STD_LOGIC;
    gen_scp_i : in STD_LOGIC;
    gen_pad_i : in STD_LOGIC;
    gen_a_i : in STD_LOGIC;
    \word_aligned_control_bits_r_reg[1]\ : in STD_LOGIC;
    \word_aligned_control_bits_r_reg[0]\ : in STD_LOGIC;
    hard_err_flop_r0 : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    HPCNT_RESET : in STD_LOGIC;
    left_aligned_r_reg_0 : in STD_LOGIC;
    reset_count_r_reg : in STD_LOGIC;
    \ufc_count_r_reg[0]\ : in STD_LOGIC;
    Q : in STD_LOGIC_VECTOR ( 3 downto 0 );
    \ufc_count_r_reg[1]\ : in STD_LOGIC;
    rx_realign_i : in STD_LOGIC;
    \RX_CHAR_IS_COMMA_R_reg[1]\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    storage_v_r : in STD_LOGIC;
    in_frame_r : in STD_LOGIC;
    \soft_err_r_reg[0]\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \gen_v_r_reg[0]\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \gen_r_r_reg[0]\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \gen_k_r_reg[0]\ : in STD_LOGIC_VECTOR ( 1 downto 0 );
    \tx_pe_data_r_reg[0]\ : in STD_LOGIC_VECTOR ( 15 downto 0 );
    \fc_nb_r_reg[0]\ : in STD_LOGIC_VECTOR ( 3 downto 0 );
    \word_aligned_data_r_reg[8]\ : in STD_LOGIC_VECTOR ( 7 downto 0 );
    \word_aligned_data_r_reg[0]\ : in STD_LOGIC_VECTOR ( 7 downto 0 )
  );
end aurora_8b10b_x1_16b_AURORA_LANE;

architecture STRUCTURE of aurora_8b10b_x1_16b_AURORA_LANE is
  signal D_0 : STD_LOGIC;
  signal RX_CC_Buffer : STD_LOGIC;
  signal RX_NEG_Buffer : STD_LOGIC;
  signal ack_r : STD_LOGIC;
  signal counter3_r0 : STD_LOGIC;
  signal counter4_r0 : STD_LOGIC;
  signal enable_err_detect_i : STD_LOGIC;
  signal first_v_received_r : STD_LOGIC;
  signal gen_k_i : STD_LOGIC;
  signal gen_sp_data_i : STD_LOGIC_VECTOR ( 0 to 0 );
  signal gen_spa_data_i : STD_LOGIC_VECTOR ( 0 to 0 );
  signal lane_init_sm_i_n_12 : STD_LOGIC;
  signal send_sp_c : STD_LOGIC;
  signal sym_gen_i_n_2 : STD_LOGIC;
begin
aurora_8b10b_x1_16b_hotplug_i: entity work.aurora_8b10b_x1_16b_HOTPLUG
     port map (
      D(0) => RX_CC_Buffer,
      HPCNT_RESET => HPCNT_RESET,
      LINK_RESET_OUT => LINK_RESET_OUT,
      SR(0) => SR(0),
      init_clk_in => init_clk_in,
      user_clk => user_clk
    );
err_detect_i: entity work.aurora_8b10b_x1_16b_ERR_DETECT
     port map (
      SR => lane_init_sm_i_n_12,
      bucket_full_r_reg_0 => bucket_full_r_reg,
      enable_err_detect_i => enable_err_detect_i,
      hard_err_flop_r0 => hard_err_flop_r0,
      hard_err_i => hard_err_i,
      hard_err_reset_i => hard_err_reset_i,
      soft_err_flop_r0 => soft_err_flop_r0,
      \soft_err_r_reg[0]_0\(1 downto 0) => \soft_err_r_reg[0]\(1 downto 0),
      user_clk => user_clk
    );
lane_init_sm_i: entity work.aurora_8b10b_x1_16b_LANE_INIT_SM
     port map (
      D(1) => gen_sp_data_i(0),
      D(0) => send_sp_c,
      D_0 => D_0,
      ENABLE_ERR_DETECT_Buffer_reg_0 => lane_init_sm_i_n_12,
      LANE_UP => LANE_UP,
      \RX_CHAR_IS_COMMA_R_reg[1]_0\(1 downto 0) => \RX_CHAR_IS_COMMA_R_reg[1]\(1 downto 0),
      RX_NEG_Buffer => RX_NEG_Buffer,
      SR(0) => SR(0),
      ack_r => ack_r,
      align_r_reg_0 => ena_comma_align_i,
      begin_r0 => begin_r0,
      \counter2_r_reg[15]_0\ => sym_gen_i_n_2,
      counter3_r0 => counter3_r0,
      counter4_r0 => counter4_r0,
      enable_err_detect_i => enable_err_detect_i,
      first_v_received_r => first_v_received_r,
      first_v_received_r_reg => first_v_received_r_reg,
      gen_k_i => gen_k_i,
      gen_spa_data_i(0) => gen_spa_data_i(0),
      reset_count_r_reg_0 => reset_count_r_reg,
      rst_r_reg_0 => tx_reset_i,
      rx_polarity_i => rx_polarity_i,
      rx_realign_i => rx_realign_i,
      user_clk => user_clk
    );
sym_dec_i: entity work.aurora_8b10b_x1_16b_SYM_DEC
     port map (
      D(0) => RX_CC_Buffer,
      D_0 => D_0,
      FRAME_ERR_Buffer0 => FRAME_ERR_Buffer0,
      M_AXI_RX_SNF => M_AXI_RX_SNF,
      Q(3 downto 0) => Q(3 downto 0),
      RX_ECP_Buffer_reg_0 => rx_ecp_i,
      RX_ECP_Buffer_reg_1 => RX_ECP_Buffer_reg,
      \RX_FC_NB_Buffer_reg[1]_0\(3 downto 0) => \RX_FC_NB_Buffer_reg[1]\(3 downto 0),
      RX_NEG_Buffer => RX_NEG_Buffer,
      \RX_PE_DATA_Buffer_reg[0]_0\(15 downto 0) => D(15 downto 0),
      RX_SCP_Buffer_reg_0 => RX_SCP_Buffer_reg,
      RX_SUF_Buffer_reg_0 => rx_suf_i,
      SR(0) => SR(0),
      ack_r => ack_r,
      counter3_r0 => counter3_r0,
      counter4_r0 => counter4_r0,
      first_v_received_r => first_v_received_r,
      got_v_i => got_v_i,
      in_frame_r => in_frame_r,
      left_aligned_r_reg_0 => left_aligned_r_reg,
      left_aligned_r_reg_1 => left_aligned_r_reg_0,
      rx_pad_i => rx_pad_i,
      rx_pe_data_v_i => rx_pe_data_v_i,
      storage_v_r => storage_v_r,
      \ufc_count_r_reg[0]\ => \ufc_count_r_reg[0]\,
      \ufc_count_r_reg[1]\ => \ufc_count_r_reg[1]\,
      user_clk => user_clk,
      \word_aligned_control_bits_r_reg[0]_0\ => \word_aligned_control_bits_r_reg[0]\,
      \word_aligned_control_bits_r_reg[1]_0\ => \word_aligned_control_bits_r_reg[1]\,
      \word_aligned_data_r_reg[0]_0\(7 downto 0) => \word_aligned_data_r_reg[0]\(7 downto 0),
      \word_aligned_data_r_reg[8]_0\(7 downto 0) => \word_aligned_data_r_reg[8]\(7 downto 0)
    );
sym_gen_i: entity work.aurora_8b10b_x1_16b_SYM_GEN
     port map (
      D(1) => gen_sp_data_i(0),
      D(0) => send_sp_c,
      TXCHARISK(1 downto 0) => TXCHARISK(1 downto 0),
      TXDATA(15 downto 0) => TXDATA(15 downto 0),
      ack_r => ack_r,
      \fc_nb_r_reg[0]_0\(3 downto 0) => \fc_nb_r_reg[0]\(3 downto 0),
      gen_a_i => gen_a_i,
      gen_cc_i => gen_cc_i,
      gen_ecp_i => gen_ecp_i,
      gen_k_i => gen_k_i,
      \gen_k_r_reg[0]_0\(1 downto 0) => \gen_k_r_reg[0]\(1 downto 0),
      gen_pad_i => gen_pad_i,
      \gen_r_r_reg[0]_0\(1 downto 0) => \gen_r_r_reg[0]\(1 downto 0),
      gen_scp_i => gen_scp_i,
      gen_snf_i => gen_snf_i,
      gen_spa_data_i(0) => gen_spa_data_i(0),
      \gen_spa_data_r_reg[1]_0\ => sym_gen_i_n_2,
      gen_suf_i => gen_suf_i,
      \gen_v_r_reg[0]_0\(1 downto 0) => \gen_v_r_reg[0]\(1 downto 0),
      \tx_pe_data_r_reg[0]_0\(15 downto 0) => \tx_pe_data_r_reg[0]\(15 downto 0),
      tx_pe_data_v_i => tx_pe_data_v_i,
      user_clk => user_clk
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_GT_WRAPPER is
  port (
    TX_RESETDONE_OUT : out STD_LOGIC;
    tx_lock : out STD_LOGIC;
    DRPRDY_OUT : out STD_LOGIC;
    TXN : out STD_LOGIC;
    TXP : out STD_LOGIC;
    rx_realign_i : out STD_LOGIC;
    TX_OUT_CLK : out STD_LOGIC;
    DRPDO_OUT : out STD_LOGIC_VECTOR ( 15 downto 0 );
    gtxe2_i : out STD_LOGIC_VECTOR ( 1 downto 0 );
    RX_RESETDONE_OUT : out STD_LOGIC;
    link_reset_r : out STD_LOGIC;
    gtxe2_i_0 : out STD_LOGIC;
    gtxe2_i_1 : out STD_LOGIC;
    gtxe2_i_2 : out STD_LOGIC;
    gtxe2_i_3 : out STD_LOGIC_VECTOR ( 1 downto 0 );
    hard_err_flop_r0 : out STD_LOGIC;
    gtxe2_i_4 : out STD_LOGIC_VECTOR ( 7 downto 0 );
    gtxe2_i_5 : out STD_LOGIC_VECTOR ( 7 downto 0 );
    gtxe2_i_6 : out STD_LOGIC;
    rxfsm_rxresetdone_r3_reg_0 : out STD_LOGIC;
    \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ : out STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    drpclk_in : in STD_LOGIC;
    DRPEN_IN : in STD_LOGIC;
    DRPWE_IN : in STD_LOGIC;
    gt_refclk1 : in STD_LOGIC;
    RXN : in STD_LOGIC;
    RXP : in STD_LOGIC;
    gt_qpllclk_quad1_in : in STD_LOGIC;
    gt_qpllrefclk_quad1_in : in STD_LOGIC;
    ena_comma_align_i : in STD_LOGIC;
    rx_polarity_i : in STD_LOGIC;
    sync_clk : in STD_LOGIC;
    user_clk : in STD_LOGIC;
    POWER_DOWN : in STD_LOGIC;
    DRPDI_IN : in STD_LOGIC_VECTOR ( 15 downto 0 );
    LOOPBACK : in STD_LOGIC_VECTOR ( 2 downto 0 );
    TXDATA : in STD_LOGIC_VECTOR ( 15 downto 0 );
    TXCHARISK : in STD_LOGIC_VECTOR ( 1 downto 0 );
    DRPADDR_IN : in STD_LOGIC_VECTOR ( 8 downto 0 );
    gtrxreset_i : in STD_LOGIC;
    LINK_RESET_OUT : in STD_LOGIC;
    AR : in STD_LOGIC_VECTOR ( 0 to 0 );
    left_aligned_r_reg : in STD_LOGIC;
    tx_reset_i : in STD_LOGIC;
    hard_err_flop_r_reg : in STD_LOGIC;
    left_aligned_r_reg_0 : in STD_LOGIC
  );
end aurora_8b10b_x1_16b_GT_WRAPPER;

architecture STRUCTURE of aurora_8b10b_x1_16b_GT_WRAPPER is
  signal \^rx_resetdone_out\ : STD_LOGIC;
  signal aurora_8b10b_x1_16b_multi_gt_i_n_5 : STD_LOGIC;
  signal aurora_8b10b_x1_16b_multi_gt_i_n_7 : STD_LOGIC;
  signal cpll_reset_i : STD_LOGIC;
  signal \gt0_aurora_8b10b_x1_16b_i/ack_flag\ : STD_LOGIC;
  signal gt0_rxresetdone_r3_reg_srl3_n_0 : STD_LOGIC;
  signal gt0_txresetdone_r3_reg_srl3_n_0 : STD_LOGIC;
  signal gt_rx_reset_i : STD_LOGIC;
  signal gt_rxdfelfhold_i : STD_LOGIC;
  signal gt_rxuserrdy_i : STD_LOGIC;
  signal gt_tx_reset_i : STD_LOGIC;
  signal gt_txresetfsm_i_n_4 : STD_LOGIC;
  signal gt_txuserrdy_i : STD_LOGIC;
  signal gtrxreset_i_0 : STD_LOGIC;
  signal gtrxreset_pulse : STD_LOGIC;
  signal gtrxreset_pulse_i_1_n_0 : STD_LOGIC;
  signal gtrxreset_r1 : STD_LOGIC;
  signal gtrxreset_r2 : STD_LOGIC;
  signal gtrxreset_r3 : STD_LOGIC;
  signal gtrxreset_sync : STD_LOGIC;
  signal \^link_reset_r\ : STD_LOGIC;
  signal link_reset_r2 : STD_LOGIC;
  signal rx_cdrlock_counter : STD_LOGIC_VECTOR ( 10 downto 0 );
  signal \rx_cdrlock_counter[0]_i_2_n_0\ : STD_LOGIC;
  signal \rx_cdrlock_counter[10]_i_2_n_0\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[0]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[10]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[1]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[2]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[3]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[4]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[5]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[6]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[7]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[8]\ : STD_LOGIC;
  signal \rx_cdrlock_counter_reg_n_0_[9]\ : STD_LOGIC;
  signal rx_cdrlocked_i_1_n_0 : STD_LOGIC;
  signal rx_cdrlocked_i_2_n_0 : STD_LOGIC;
  signal rx_cdrlocked_reg_n_0 : STD_LOGIC;
  signal rxfsm_rxresetdone_r : STD_LOGIC;
  signal rxfsm_rxresetdone_r2 : STD_LOGIC;
  signal rxfsm_soft_reset_r : STD_LOGIC;
  signal rxfsm_soft_reset_r_i_1_n_0 : STD_LOGIC;
  signal \^tx_lock\ : STD_LOGIC;
  signal txfsm_txresetdone_r : STD_LOGIC;
  attribute srl_name : string;
  attribute srl_name of gt0_rxresetdone_r3_reg_srl3 : label is "U0/\gt_wrapper_i/gt0_rxresetdone_r3_reg_srl3 ";
  attribute srl_name of gt0_txresetdone_r3_reg_srl3 : label is "U0/\gt_wrapper_i/gt0_txresetdone_r3_reg_srl3 ";
  attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of gtrxreset_r1_reg : label is "no";
  attribute SOFT_HLUTNM : string;
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[1]_i_1\ : label is "soft_lutpair82";
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[2]_i_1\ : label is "soft_lutpair79";
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[3]_i_1\ : label is "soft_lutpair81";
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[4]_i_1\ : label is "soft_lutpair81";
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[6]_i_1\ : label is "soft_lutpair83";
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[7]_i_1\ : label is "soft_lutpair83";
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[8]_i_1\ : label is "soft_lutpair80";
  attribute SOFT_HLUTNM of \rx_cdrlock_counter[9]_i_1\ : label is "soft_lutpair80";
  attribute SOFT_HLUTNM of rx_cdrlocked_i_1 : label is "soft_lutpair79";
  attribute SOFT_HLUTNM of rx_cdrlocked_i_2 : label is "soft_lutpair82";
  attribute equivalent_register_removal of rxfsm_rxresetdone_r2_reg : label is "no";
begin
  RX_RESETDONE_OUT <= \^rx_resetdone_out\;
  link_reset_r <= \^link_reset_r\;
  tx_lock <= \^tx_lock\;
aurora_8b10b_x1_16b_multi_gt_i: entity work.aurora_8b10b_x1_16b_multi_gt
     port map (
      DRPADDR_IN(8 downto 0) => DRPADDR_IN(8 downto 0),
      DRPDI_IN(15 downto 0) => DRPDI_IN(15 downto 0),
      DRPDO_OUT(15 downto 0) => DRPDO_OUT(15 downto 0),
      DRPEN_IN => DRPEN_IN,
      DRPRDY_OUT => DRPRDY_OUT,
      DRPWE_IN => DRPWE_IN,
      LOOPBACK(2 downto 0) => LOOPBACK(2 downto 0),
      POWER_DOWN => POWER_DOWN,
      RXN => RXN,
      RXP => RXP,
      SR(0) => gt_rx_reset_i,
      TXCHARISK(1 downto 0) => TXCHARISK(1 downto 0),
      TXDATA(15 downto 0) => TXDATA(15 downto 0),
      TXN => TXN,
      TXP => TXP,
      TX_OUT_CLK => TX_OUT_CLK,
      ack_flag => \gt0_aurora_8b10b_x1_16b_i/ack_flag\,
      cpll_reset_i => cpll_reset_i,
      drpclk_in => drpclk_in,
      ena_comma_align_i => ena_comma_align_i,
      flag2_reg => gt_txresetfsm_i_n_4,
      gt_qpllclk_quad1_in => gt_qpllclk_quad1_in,
      gt_qpllrefclk_quad1_in => gt_qpllrefclk_quad1_in,
      gt_refclk1 => gt_refclk1,
      gt_rxdfelfhold_i => gt_rxdfelfhold_i,
      gt_rxuserrdy_i => gt_rxuserrdy_i,
      gt_tx_reset_i => gt_tx_reset_i,
      gt_txuserrdy_i => gt_txuserrdy_i,
      gtxe2_i => aurora_8b10b_x1_16b_multi_gt_i_n_5,
      gtxe2_i_0 => aurora_8b10b_x1_16b_multi_gt_i_n_7,
      gtxe2_i_1(1 downto 0) => gtxe2_i(1 downto 0),
      gtxe2_i_2 => gtxe2_i_0,
      gtxe2_i_3 => gtxe2_i_1,
      gtxe2_i_4 => gtxe2_i_2,
      gtxe2_i_5(1 downto 0) => gtxe2_i_3(1 downto 0),
      gtxe2_i_6(7 downto 0) => gtxe2_i_4(7 downto 0),
      gtxe2_i_7(7 downto 0) => gtxe2_i_5(7 downto 0),
      gtxe2_i_8 => gtxe2_i_6,
      hard_err_flop_r0 => hard_err_flop_r0,
      hard_err_flop_r_reg => hard_err_flop_r_reg,
      init_clk_in => init_clk_in,
      left_aligned_r_reg => left_aligned_r_reg,
      left_aligned_r_reg_0 => left_aligned_r_reg_0,
      rx_polarity_i => rx_polarity_i,
      rx_realign_i => rx_realign_i,
      sync_clk => sync_clk,
      tx_lock => \^tx_lock\,
      tx_reset_i => tx_reset_i,
      user_clk => user_clk
    );
gt0_rxresetdone_r3_reg_srl3: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '0',
      A3 => '0',
      CE => '1',
      CLK => user_clk,
      D => aurora_8b10b_x1_16b_multi_gt_i_n_5,
      Q => gt0_rxresetdone_r3_reg_srl3_n_0
    );
gt0_txresetdone_r3_reg_srl3: unisim.vcomponents.SRL16E
     port map (
      A0 => '0',
      A1 => '1',
      A2 => '0',
      A3 => '0',
      CE => '1',
      CLK => user_clk,
      D => aurora_8b10b_x1_16b_multi_gt_i_n_7,
      Q => gt0_txresetdone_r3_reg_srl3_n_0
    );
gt_rx_reset_i_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => gtrxreset_i_0,
      Q => gt_rx_reset_i,
      R => '0'
    );
gt_rxresetdone_r_i_1: unisim.vcomponents.LUT1
    generic map(
      INIT => X"1"
    )
        port map (
      I0 => \^rx_resetdone_out\,
      O => rxfsm_rxresetdone_r3_reg_0
    );
gt_rxresetfsm_i: entity work.aurora_8b10b_x1_16b_rx_startup_fsm
     port map (
      AR(0) => rxfsm_soft_reset_r,
      \FSM_sequential_rx_state_reg[0]_0\ => rx_cdrlocked_reg_n_0,
      gt_rxdfelfhold_i => gt_rxdfelfhold_i,
      gt_rxuserrdy_i => gt_rxuserrdy_i,
      gt_txuserrdy_i => gt_txuserrdy_i,
      gtrxreset_i_0 => gtrxreset_i_0,
      init_clk_in => init_clk_in,
      rxfsm_rxresetdone_r => rxfsm_rxresetdone_r,
      tx_lock => \^tx_lock\,
      user_clk => user_clk
    );
gt_txresetfsm_i: entity work.aurora_8b10b_x1_16b_tx_startup_fsm
     port map (
      AR(0) => AR(0),
      CPLL_RESET_reg_0 => gt_txresetfsm_i_n_4,
      \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ => \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\,
      ack_flag => \gt0_aurora_8b10b_x1_16b_i/ack_flag\,
      cpll_reset_i => cpll_reset_i,
      gt_tx_reset_i => gt_tx_reset_i,
      gt_txuserrdy_i => gt_txuserrdy_i,
      init_clk_in => init_clk_in,
      \out\ => TX_RESETDONE_OUT,
      tx_lock => \^tx_lock\,
      txfsm_txresetdone_r => txfsm_txresetdone_r,
      user_clk => user_clk
    );
gtrxreset_cdc_sync: entity work.\aurora_8b10b_x1_16b_cdc_sync__parameterized2\
     port map (
      gtrxreset_i => gtrxreset_i,
      init_clk_in => init_clk_in,
      \out\ => gtrxreset_sync,
      user_clk => user_clk
    );
gtrxreset_pulse_i_1: unisim.vcomponents.LUT2
    generic map(
      INIT => X"2"
    )
        port map (
      I0 => gtrxreset_r2,
      I1 => gtrxreset_r3,
      O => gtrxreset_pulse_i_1_n_0
    );
gtrxreset_pulse_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => gtrxreset_pulse_i_1_n_0,
      Q => gtrxreset_pulse,
      R => '0'
    );
gtrxreset_r1_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => gtrxreset_sync,
      Q => gtrxreset_r1,
      R => '0'
    );
gtrxreset_r2_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => gtrxreset_r1,
      Q => gtrxreset_r2,
      R => '0'
    );
gtrxreset_r3_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => gtrxreset_r2,
      Q => gtrxreset_r3,
      R => '0'
    );
link_reset_r2_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => \^link_reset_r\,
      Q => link_reset_r2,
      R => '0'
    );
link_reset_r_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => LINK_RESET_OUT,
      Q => \^link_reset_r\,
      R => '0'
    );
\rx_cdrlock_counter[0]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"00000000FFFFFFBF"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[3]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[9]\,
      I3 => \rx_cdrlock_counter[0]_i_2_n_0\,
      I4 => \rx_cdrlock_counter_reg_n_0_[2]\,
      I5 => \rx_cdrlock_counter_reg_n_0_[0]\,
      O => rx_cdrlock_counter(0)
    );
\rx_cdrlock_counter[0]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"FFFFFEFFFFFFFFFF"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[5]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[4]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[6]\,
      I3 => \rx_cdrlock_counter_reg_n_0_[7]\,
      I4 => \rx_cdrlock_counter_reg_n_0_[8]\,
      I5 => \rx_cdrlock_counter_reg_n_0_[10]\,
      O => \rx_cdrlock_counter[0]_i_2_n_0\
    );
\rx_cdrlock_counter[10]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"6AAAAAAAAAAAAAAA"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[10]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[8]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[6]\,
      I3 => \rx_cdrlock_counter[10]_i_2_n_0\,
      I4 => \rx_cdrlock_counter_reg_n_0_[7]\,
      I5 => \rx_cdrlock_counter_reg_n_0_[9]\,
      O => rx_cdrlock_counter(10)
    );
\rx_cdrlock_counter[10]_i_2\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"8000000000000000"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[5]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[4]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[2]\,
      I3 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I4 => \rx_cdrlock_counter_reg_n_0_[0]\,
      I5 => \rx_cdrlock_counter_reg_n_0_[3]\,
      O => \rx_cdrlock_counter[10]_i_2_n_0\
    );
\rx_cdrlock_counter[1]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"6"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[0]\,
      O => rx_cdrlock_counter(1)
    );
\rx_cdrlock_counter[2]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"78"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[0]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[2]\,
      O => rx_cdrlock_counter(2)
    );
\rx_cdrlock_counter[3]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"6AAA"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[3]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[0]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I3 => \rx_cdrlock_counter_reg_n_0_[2]\,
      O => rx_cdrlock_counter(3)
    );
\rx_cdrlock_counter[4]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"6AAAAAAA"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[4]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[2]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I3 => \rx_cdrlock_counter_reg_n_0_[0]\,
      I4 => \rx_cdrlock_counter_reg_n_0_[3]\,
      O => rx_cdrlock_counter(4)
    );
\rx_cdrlock_counter[5]_i_1\: unisim.vcomponents.LUT6
    generic map(
      INIT => X"7FFFFFFF80000000"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[3]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[0]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I3 => \rx_cdrlock_counter_reg_n_0_[2]\,
      I4 => \rx_cdrlock_counter_reg_n_0_[4]\,
      I5 => \rx_cdrlock_counter_reg_n_0_[5]\,
      O => rx_cdrlock_counter(5)
    );
\rx_cdrlock_counter[6]_i_1\: unisim.vcomponents.LUT2
    generic map(
      INIT => X"6"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[6]\,
      I1 => \rx_cdrlock_counter[10]_i_2_n_0\,
      O => rx_cdrlock_counter(6)
    );
\rx_cdrlock_counter[7]_i_1\: unisim.vcomponents.LUT3
    generic map(
      INIT => X"6A"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[7]\,
      I1 => \rx_cdrlock_counter[10]_i_2_n_0\,
      I2 => \rx_cdrlock_counter_reg_n_0_[6]\,
      O => rx_cdrlock_counter(7)
    );
\rx_cdrlock_counter[8]_i_1\: unisim.vcomponents.LUT4
    generic map(
      INIT => X"6AAA"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[8]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[6]\,
      I2 => \rx_cdrlock_counter[10]_i_2_n_0\,
      I3 => \rx_cdrlock_counter_reg_n_0_[7]\,
      O => rx_cdrlock_counter(8)
    );
\rx_cdrlock_counter[9]_i_1\: unisim.vcomponents.LUT5
    generic map(
      INIT => X"6AAAAAAA"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[9]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[7]\,
      I2 => \rx_cdrlock_counter[10]_i_2_n_0\,
      I3 => \rx_cdrlock_counter_reg_n_0_[6]\,
      I4 => \rx_cdrlock_counter_reg_n_0_[8]\,
      O => rx_cdrlock_counter(9)
    );
\rx_cdrlock_counter_reg[0]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(0),
      Q => \rx_cdrlock_counter_reg_n_0_[0]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[10]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(10),
      Q => \rx_cdrlock_counter_reg_n_0_[10]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[1]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(1),
      Q => \rx_cdrlock_counter_reg_n_0_[1]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[2]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(2),
      Q => \rx_cdrlock_counter_reg_n_0_[2]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[3]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(3),
      Q => \rx_cdrlock_counter_reg_n_0_[3]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[4]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(4),
      Q => \rx_cdrlock_counter_reg_n_0_[4]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[5]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(5),
      Q => \rx_cdrlock_counter_reg_n_0_[5]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[6]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(6),
      Q => \rx_cdrlock_counter_reg_n_0_[6]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[7]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(7),
      Q => \rx_cdrlock_counter_reg_n_0_[7]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[8]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(8),
      Q => \rx_cdrlock_counter_reg_n_0_[8]\,
      R => gt_rx_reset_i
    );
\rx_cdrlock_counter_reg[9]\: unisim.vcomponents.FDRE
    generic map(
      INIT => '0'
    )
        port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlock_counter(9),
      Q => \rx_cdrlock_counter_reg_n_0_[9]\,
      R => gt_rx_reset_i
    );
rx_cdrlocked_i_1: unisim.vcomponents.LUT5
    generic map(
      INIT => X"FFFF1500"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[2]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[0]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I3 => rx_cdrlocked_i_2_n_0,
      I4 => rx_cdrlocked_reg_n_0,
      O => rx_cdrlocked_i_1_n_0
    );
rx_cdrlocked_i_2: unisim.vcomponents.LUT4
    generic map(
      INIT => X"0040"
    )
        port map (
      I0 => \rx_cdrlock_counter_reg_n_0_[3]\,
      I1 => \rx_cdrlock_counter_reg_n_0_[1]\,
      I2 => \rx_cdrlock_counter_reg_n_0_[9]\,
      I3 => \rx_cdrlock_counter[0]_i_2_n_0\,
      O => rx_cdrlocked_i_2_n_0
    );
rx_cdrlocked_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => rx_cdrlocked_i_1_n_0,
      Q => rx_cdrlocked_reg_n_0,
      R => gt_rx_reset_i
    );
rxfsm_rxresetdone_r2_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rxfsm_rxresetdone_r,
      Q => rxfsm_rxresetdone_r2,
      R => '0'
    );
rxfsm_rxresetdone_r3_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => rxfsm_rxresetdone_r2,
      Q => \^rx_resetdone_out\,
      R => '0'
    );
rxfsm_rxresetdone_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gt0_rxresetdone_r3_reg_srl3_n_0,
      Q => rxfsm_rxresetdone_r,
      R => '0'
    );
rxfsm_soft_reset_r_i_1: unisim.vcomponents.LUT3
    generic map(
      INIT => X"FE"
    )
        port map (
      I0 => AR(0),
      I1 => gtrxreset_pulse,
      I2 => link_reset_r2,
      O => rxfsm_soft_reset_r_i_1_n_0
    );
rxfsm_soft_reset_r_reg: unisim.vcomponents.FDRE
     port map (
      C => init_clk_in,
      CE => '1',
      D => rxfsm_soft_reset_r_i_1_n_0,
      Q => rxfsm_soft_reset_r,
      R => '0'
    );
txfsm_txresetdone_r_reg: unisim.vcomponents.FDRE
     port map (
      C => user_clk,
      CE => '1',
      D => gt0_txresetdone_r3_reg_srl3_n_0,
      Q => txfsm_txresetdone_r,
      R => '0'
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b_core is
  port (
    S_AXI_TX_TDATA : in STD_LOGIC_VECTOR ( 15 downto 0 );
    S_AXI_TX_TKEEP : in STD_LOGIC_VECTOR ( 1 downto 0 );
    S_AXI_TX_TVALID : in STD_LOGIC;
    S_AXI_TX_TREADY : out STD_LOGIC;
    S_AXI_TX_TLAST : in STD_LOGIC;
    M_AXI_RX_TDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    M_AXI_RX_TKEEP : out STD_LOGIC_VECTOR ( 1 downto 0 );
    M_AXI_RX_TVALID : out STD_LOGIC;
    M_AXI_RX_TLAST : out STD_LOGIC;
    S_AXI_NFC_REQ : in STD_LOGIC;
    S_AXI_NFC_NB : in STD_LOGIC_VECTOR ( 3 downto 0 );
    S_AXI_NFC_ACK : out STD_LOGIC;
    M_AXI_RX_SNF : out STD_LOGIC;
    M_AXI_RX_FC_NB : out STD_LOGIC_VECTOR ( 3 downto 0 );
    S_AXI_UFC_TX_REQ : in STD_LOGIC;
    S_AXI_UFC_TX_MS : in STD_LOGIC_VECTOR ( 2 downto 0 );
    S_AXI_UFC_TX_ACK : out STD_LOGIC;
    M_AXI_UFC_RX_TDATA : out STD_LOGIC_VECTOR ( 15 downto 0 );
    M_AXI_UFC_RX_TKEEP : out STD_LOGIC_VECTOR ( 1 downto 0 );
    M_AXI_UFC_RX_TVALID : out STD_LOGIC;
    M_AXI_UFC_RX_TLAST : out STD_LOGIC;
    RXP : in STD_LOGIC;
    RXN : in STD_LOGIC;
    TXP : out STD_LOGIC;
    TXN : out STD_LOGIC;
    gt_refclk1 : in STD_LOGIC;
    HARD_ERR : out STD_LOGIC;
    SOFT_ERR : out STD_LOGIC;
    FRAME_ERR : out STD_LOGIC;
    CHANNEL_UP : out STD_LOGIC;
    LANE_UP : out STD_LOGIC;
    user_clk : in STD_LOGIC;
    sync_clk : in STD_LOGIC;
    RESET : in STD_LOGIC;
    POWER_DOWN : in STD_LOGIC;
    LOOPBACK : in STD_LOGIC_VECTOR ( 2 downto 0 );
    GT_RESET : in STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    PLL_NOT_LOCKED : in STD_LOGIC;
    TX_RESETDONE_OUT : out STD_LOGIC;
    RX_RESETDONE_OUT : out STD_LOGIC;
    LINK_RESET_OUT : out STD_LOGIC;
    drpclk_in : in STD_LOGIC;
    DRPADDR_IN : in STD_LOGIC_VECTOR ( 8 downto 0 );
    DRPDI_IN : in STD_LOGIC_VECTOR ( 15 downto 0 );
    DRPDO_OUT : out STD_LOGIC_VECTOR ( 15 downto 0 );
    DRPEN_IN : in STD_LOGIC;
    DRPRDY_OUT : out STD_LOGIC;
    DRPWE_IN : in STD_LOGIC;
    TX_OUT_CLK : out STD_LOGIC;
    gt0_qplllock_in : in STD_LOGIC;
    gt0_qpllrefclklost_in : in STD_LOGIC;
    gt0_qpllreset_out : out STD_LOGIC;
    gt_qpllclk_quad1_in : in STD_LOGIC;
    gt_qpllrefclk_quad1_in : in STD_LOGIC;
    sys_reset_out : out STD_LOGIC;
    tx_lock : out STD_LOGIC
  );
  attribute CC_FREQ_FACTOR : integer;
  attribute CC_FREQ_FACTOR of aurora_8b10b_x1_16b_core : entity is 24;
  attribute EXAMPLE_SIMULATION : integer;
  attribute EXAMPLE_SIMULATION of aurora_8b10b_x1_16b_core : entity is 0;
  attribute SIM_GTRESET_SPEEDUP : string;
  attribute SIM_GTRESET_SPEEDUP of aurora_8b10b_x1_16b_core : entity is "TRUE";
end aurora_8b10b_x1_16b_core;

architecture STRUCTURE of aurora_8b10b_x1_16b_core is
  signal \<const0>\ : STD_LOGIC;
  signal \^channel_up\ : STD_LOGIC;
  signal DO_CC_I : STD_LOGIC;
  signal HPCNT_RESET : STD_LOGIC;
  signal \^lane_up\ : STD_LOGIC;
  signal \^link_reset_out\ : STD_LOGIC;
  signal \^m_axi_rx_fc_nb\ : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal \^m_axi_rx_snf\ : STD_LOGIC;
  signal \^m_axi_rx_tkeep\ : STD_LOGIC_VECTOR ( 1 to 1 );
  signal \^s_axi_nfc_ack\ : STD_LOGIC;
  signal TXCHARISK_IN : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal TXDATA_IN : STD_LOGIC_VECTOR ( 15 downto 0 );
  signal WARN_CC : STD_LOGIC;
  signal aurora_lane_0_i_n_29 : STD_LOGIC;
  signal aurora_lane_0_i_n_36 : STD_LOGIC;
  signal aurora_lane_0_i_n_37 : STD_LOGIC;
  signal aurora_lane_0_i_n_39 : STD_LOGIC;
  signal axi_to_ll_pdu_i_n_0 : STD_LOGIC;
  signal clear : STD_LOGIC;
  signal ena_comma_align_i : STD_LOGIC;
  signal \err_detect_i/bucket_full_r\ : STD_LOGIC;
  signal \err_detect_i/hard_err_flop_r0\ : STD_LOGIC;
  signal \err_detect_i/p_2_out\ : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal fc_nb_i : STD_LOGIC_VECTOR ( 0 to 3 );
  signal gen_a_i : STD_LOGIC;
  signal gen_cc_i : STD_LOGIC;
  signal gen_ecp_i : STD_LOGIC;
  signal gen_k_i : STD_LOGIC_VECTOR ( 0 to 1 );
  signal gen_pad_i : STD_LOGIC;
  signal gen_r_i : STD_LOGIC_VECTOR ( 0 to 1 );
  signal gen_scp_i : STD_LOGIC;
  signal gen_snf_i : STD_LOGIC;
  signal gen_suf_i : STD_LOGIC;
  signal gen_v_i : STD_LOGIC_VECTOR ( 0 to 1 );
  signal got_v_i : STD_LOGIC;
  signal gt_reset_sync_init_clk : STD_LOGIC;
  signal gt_wrapper_i_n_27 : STD_LOGIC;
  signal gt_wrapper_i_n_28 : STD_LOGIC;
  signal gt_wrapper_i_n_29 : STD_LOGIC;
  signal gt_wrapper_i_n_33 : STD_LOGIC;
  signal gt_wrapper_i_n_34 : STD_LOGIC;
  signal gt_wrapper_i_n_35 : STD_LOGIC;
  signal gt_wrapper_i_n_36 : STD_LOGIC;
  signal gt_wrapper_i_n_37 : STD_LOGIC;
  signal gt_wrapper_i_n_38 : STD_LOGIC;
  signal gt_wrapper_i_n_39 : STD_LOGIC;
  signal gt_wrapper_i_n_40 : STD_LOGIC;
  signal gt_wrapper_i_n_41 : STD_LOGIC;
  signal gt_wrapper_i_n_42 : STD_LOGIC;
  signal gt_wrapper_i_n_43 : STD_LOGIC;
  signal gt_wrapper_i_n_44 : STD_LOGIC;
  signal gt_wrapper_i_n_45 : STD_LOGIC;
  signal gt_wrapper_i_n_46 : STD_LOGIC;
  signal gt_wrapper_i_n_47 : STD_LOGIC;
  signal gt_wrapper_i_n_48 : STD_LOGIC;
  signal gt_wrapper_i_n_49 : STD_LOGIC;
  signal gt_wrapper_i_n_50 : STD_LOGIC;
  signal gt_wrapper_i_n_51 : STD_LOGIC;
  signal gtrxreset_i : STD_LOGIC;
  signal hard_err_i : STD_LOGIC;
  signal hard_err_reset_i : STD_LOGIC;
  signal \lane_init_sm_i/begin_r0\ : STD_LOGIC;
  signal link_reset_r : STD_LOGIC;
  signal new_pkt_r : STD_LOGIC;
  signal \nfc_module_i/nfc_counter_r_reg\ : STD_LOGIC_VECTOR ( 0 to 0 );
  signal p_0_in : STD_LOGIC_VECTOR ( 3 downto 0 );
  signal p_0_in_0 : STD_LOGIC;
  signal reset_lanes_i : STD_LOGIC;
  signal reset_sync_init_clk : STD_LOGIC;
  signal reset_sync_user_clk : STD_LOGIC;
  signal rx_char_is_comma_i : STD_LOGIC_VECTOR ( 1 downto 0 );
  signal rx_ecp_i : STD_LOGIC;
  signal rx_ll_i_n_11 : STD_LOGIC;
  signal rx_ll_i_n_12 : STD_LOGIC;
  signal \rx_ll_pdu_datapath_i/FRAME_ERR_Buffer0\ : STD_LOGIC;
  signal \rx_ll_pdu_datapath_i/in_frame_r\ : STD_LOGIC;
  signal \rx_ll_pdu_datapath_i/storage_v_r\ : STD_LOGIC;
  signal rx_pad_i : STD_LOGIC;
  signal rx_pe_data_i : STD_LOGIC_VECTOR ( 0 to 15 );
  signal rx_pe_data_v_i : STD_LOGIC;
  signal rx_polarity_i : STD_LOGIC;
  signal rx_realign_i : STD_LOGIC;
  signal rx_suf_i : STD_LOGIC;
  signal soft_err_flop_r0 : STD_LOGIC;
  signal standard_cc_module_i_n_1 : STD_LOGIC;
  signal \^sys_reset_out\ : STD_LOGIC;
  signal tx_dst_rdy : STD_LOGIC;
  signal \tx_ll_control_i/D\ : STD_LOGIC;
  signal \^tx_lock\ : STD_LOGIC;
  signal tx_pe_data_i : STD_LOGIC_VECTOR ( 0 to 15 );
  signal tx_pe_data_v_i : STD_LOGIC;
  signal tx_reset_i : STD_LOGIC;
  signal \ufc_filter_i/ufc_count_r_reg\ : STD_LOGIC_VECTOR ( 0 to 3 );
begin
  CHANNEL_UP <= \^channel_up\;
  LANE_UP <= \^lane_up\;
  LINK_RESET_OUT <= \^link_reset_out\;
  M_AXI_RX_FC_NB(3 downto 0) <= \^m_axi_rx_fc_nb\(3 downto 0);
  M_AXI_RX_SNF <= \^m_axi_rx_snf\;
  M_AXI_RX_TKEEP(1) <= \^m_axi_rx_tkeep\(1);
  M_AXI_RX_TKEEP(0) <= \<const0>\;
  M_AXI_UFC_RX_TKEEP(1) <= \<const0>\;
  M_AXI_UFC_RX_TKEEP(0) <= \<const0>\;
  S_AXI_NFC_ACK <= \^s_axi_nfc_ack\;
  gt0_qpllreset_out <= \<const0>\;
  sys_reset_out <= \^sys_reset_out\;
  tx_lock <= \^tx_lock\;
GND: unisim.vcomponents.GND
     port map (
      G => \<const0>\
    );
aurora_lane_0_i: entity work.aurora_8b10b_x1_16b_AURORA_LANE
     port map (
      D(15) => rx_pe_data_i(0),
      D(14) => rx_pe_data_i(1),
      D(13) => rx_pe_data_i(2),
      D(12) => rx_pe_data_i(3),
      D(11) => rx_pe_data_i(4),
      D(10) => rx_pe_data_i(5),
      D(9) => rx_pe_data_i(6),
      D(8) => rx_pe_data_i(7),
      D(7 downto 4) => \^m_axi_rx_fc_nb\(3 downto 0),
      D(3) => rx_pe_data_i(12),
      D(2) => rx_pe_data_i(13),
      D(1) => rx_pe_data_i(14),
      D(0) => rx_pe_data_i(15),
      FRAME_ERR_Buffer0 => \rx_ll_pdu_datapath_i/FRAME_ERR_Buffer0\,
      HPCNT_RESET => HPCNT_RESET,
      LANE_UP => \^lane_up\,
      LINK_RESET_OUT => \^link_reset_out\,
      M_AXI_RX_SNF => \^m_axi_rx_snf\,
      Q(3) => \ufc_filter_i/ufc_count_r_reg\(0),
      Q(2) => \ufc_filter_i/ufc_count_r_reg\(1),
      Q(1) => \ufc_filter_i/ufc_count_r_reg\(2),
      Q(0) => \ufc_filter_i/ufc_count_r_reg\(3),
      \RX_CHAR_IS_COMMA_R_reg[1]\(1 downto 0) => rx_char_is_comma_i(1 downto 0),
      RX_ECP_Buffer_reg => aurora_lane_0_i_n_36,
      \RX_FC_NB_Buffer_reg[1]\(3 downto 0) => p_0_in(3 downto 0),
      RX_SCP_Buffer_reg => aurora_lane_0_i_n_39,
      SR(0) => reset_lanes_i,
      TXCHARISK(1 downto 0) => TXCHARISK_IN(1 downto 0),
      TXDATA(15 downto 0) => TXDATA_IN(15 downto 0),
      begin_r0 => \lane_init_sm_i/begin_r0\,
      bucket_full_r_reg => \err_detect_i/bucket_full_r\,
      ena_comma_align_i => ena_comma_align_i,
      \fc_nb_r_reg[0]\(3) => fc_nb_i(0),
      \fc_nb_r_reg[0]\(2) => fc_nb_i(1),
      \fc_nb_r_reg[0]\(1) => fc_nb_i(2),
      \fc_nb_r_reg[0]\(0) => fc_nb_i(3),
      first_v_received_r_reg => aurora_lane_0_i_n_37,
      gen_a_i => gen_a_i,
      gen_cc_i => gen_cc_i,
      gen_ecp_i => gen_ecp_i,
      \gen_k_r_reg[0]\(1) => gen_k_i(0),
      \gen_k_r_reg[0]\(0) => gen_k_i(1),
      gen_pad_i => gen_pad_i,
      \gen_r_r_reg[0]\(1) => gen_r_i(0),
      \gen_r_r_reg[0]\(0) => gen_r_i(1),
      gen_scp_i => gen_scp_i,
      gen_snf_i => gen_snf_i,
      gen_suf_i => gen_suf_i,
      \gen_v_r_reg[0]\(1) => gen_v_i(0),
      \gen_v_r_reg[0]\(0) => gen_v_i(1),
      got_v_i => got_v_i,
      hard_err_flop_r0 => \err_detect_i/hard_err_flop_r0\,
      hard_err_i => hard_err_i,
      hard_err_reset_i => hard_err_reset_i,
      in_frame_r => \rx_ll_pdu_datapath_i/in_frame_r\,
      init_clk_in => init_clk_in,
      left_aligned_r_reg => aurora_lane_0_i_n_29,
      left_aligned_r_reg_0 => gt_wrapper_i_n_49,
      reset_count_r_reg => gt_wrapper_i_n_29,
      rx_ecp_i => rx_ecp_i,
      rx_pad_i => rx_pad_i,
      rx_pe_data_v_i => rx_pe_data_v_i,
      rx_polarity_i => rx_polarity_i,
      rx_realign_i => rx_realign_i,
      rx_suf_i => rx_suf_i,
      soft_err_flop_r0 => soft_err_flop_r0,
      \soft_err_r_reg[0]\(1 downto 0) => \err_detect_i/p_2_out\(1 downto 0),
      storage_v_r => \rx_ll_pdu_datapath_i/storage_v_r\,
      \tx_pe_data_r_reg[0]\(15) => tx_pe_data_i(0),
      \tx_pe_data_r_reg[0]\(14) => tx_pe_data_i(1),
      \tx_pe_data_r_reg[0]\(13) => tx_pe_data_i(2),
      \tx_pe_data_r_reg[0]\(12) => tx_pe_data_i(3),
      \tx_pe_data_r_reg[0]\(11) => tx_pe_data_i(4),
      \tx_pe_data_r_reg[0]\(10) => tx_pe_data_i(5),
      \tx_pe_data_r_reg[0]\(9) => tx_pe_data_i(6),
      \tx_pe_data_r_reg[0]\(8) => tx_pe_data_i(7),
      \tx_pe_data_r_reg[0]\(7) => tx_pe_data_i(8),
      \tx_pe_data_r_reg[0]\(6) => tx_pe_data_i(9),
      \tx_pe_data_r_reg[0]\(5) => tx_pe_data_i(10),
      \tx_pe_data_r_reg[0]\(4) => tx_pe_data_i(11),
      \tx_pe_data_r_reg[0]\(3) => tx_pe_data_i(12),
      \tx_pe_data_r_reg[0]\(2) => tx_pe_data_i(13),
      \tx_pe_data_r_reg[0]\(1) => tx_pe_data_i(14),
      \tx_pe_data_r_reg[0]\(0) => tx_pe_data_i(15),
      tx_pe_data_v_i => tx_pe_data_v_i,
      tx_reset_i => tx_reset_i,
      \ufc_count_r_reg[0]\ => rx_ll_i_n_11,
      \ufc_count_r_reg[1]\ => rx_ll_i_n_12,
      user_clk => user_clk,
      \word_aligned_control_bits_r_reg[0]\ => gt_wrapper_i_n_28,
      \word_aligned_control_bits_r_reg[1]\ => gt_wrapper_i_n_27,
      \word_aligned_data_r_reg[0]\(7) => gt_wrapper_i_n_41,
      \word_aligned_data_r_reg[0]\(6) => gt_wrapper_i_n_42,
      \word_aligned_data_r_reg[0]\(5) => gt_wrapper_i_n_43,
      \word_aligned_data_r_reg[0]\(4) => gt_wrapper_i_n_44,
      \word_aligned_data_r_reg[0]\(3) => gt_wrapper_i_n_45,
      \word_aligned_data_r_reg[0]\(2) => gt_wrapper_i_n_46,
      \word_aligned_data_r_reg[0]\(1) => gt_wrapper_i_n_47,
      \word_aligned_data_r_reg[0]\(0) => gt_wrapper_i_n_48,
      \word_aligned_data_r_reg[8]\(7) => gt_wrapper_i_n_33,
      \word_aligned_data_r_reg[8]\(6) => gt_wrapper_i_n_34,
      \word_aligned_data_r_reg[8]\(5) => gt_wrapper_i_n_35,
      \word_aligned_data_r_reg[8]\(4) => gt_wrapper_i_n_36,
      \word_aligned_data_r_reg[8]\(3) => gt_wrapper_i_n_37,
      \word_aligned_data_r_reg[8]\(2) => gt_wrapper_i_n_38,
      \word_aligned_data_r_reg[8]\(1) => gt_wrapper_i_n_39,
      \word_aligned_data_r_reg[8]\(0) => gt_wrapper_i_n_40
    );
axi_to_ll_pdu_i: entity work.aurora_8b10b_x1_16b_AXI_TO_LL
     port map (
      new_pkt_r => new_pkt_r,
      new_pkt_r_reg_0 => axi_to_ll_pdu_i_n_0,
      user_clk => user_clk
    );
core_reset_logic_i: entity work.aurora_8b10b_x1_16b_RESET_LOGIC
     port map (
      CHANNEL_UP => \^channel_up\,
      SYSTEM_RESET_reg_0 => \^sys_reset_out\,
      S_AXI_TX_TLAST => S_AXI_TX_TLAST,
      S_AXI_TX_TVALID => S_AXI_TX_TVALID,
      gt_rxresetdone_r2_reg_0 => gt_wrapper_i_n_50,
      gt_txresetdone_r2_reg_0 => gt_wrapper_i_n_51,
      init_clk_in => init_clk_in,
      link_reset_r => link_reset_r,
      new_pkt_r => new_pkt_r,
      new_pkt_r_reg => axi_to_ll_pdu_i_n_0,
      \out\ => reset_sync_user_clk,
      tx_dst_rdy => tx_dst_rdy,
      tx_lock => \^tx_lock\,
      user_clk => user_clk
    );
global_logic_i: entity work.aurora_8b10b_x1_16b_GLOBAL_LOGIC
     port map (
      CHANNEL_UP => \^channel_up\,
      HARD_ERR => HARD_ERR,
      LANE_UP => \^lane_up\,
      POWER_DOWN => POWER_DOWN,
      SOFT_ERR => SOFT_ERR,
      SR(0) => reset_lanes_i,
      START_RX_Buffer_reg_inv(0) => clear,
      begin_r0 => \lane_init_sm_i/begin_r0\,
      gen_a_i => gen_a_i,
      gen_k_flop_0_i(1) => gen_k_i(0),
      gen_k_flop_0_i(0) => gen_k_i(1),
      gen_r_flop_0_i(1) => gen_r_i(0),
      gen_r_flop_0_i(0) => gen_r_i(1),
      gen_v_flop_0_i(1) => gen_v_i(0),
      gen_v_flop_0_i(0) => gen_v_i(1),
      got_v_i => got_v_i,
      gtrxreset_i => gtrxreset_i,
      hard_err_i => hard_err_i,
      hard_err_reset_i => hard_err_reset_i,
      lfsr_last_flop_i => \^sys_reset_out\,
      p_0_in => p_0_in_0,
      soft_err_flop_r0 => soft_err_flop_r0,
      user_clk => user_clk
    );
gt_reset_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync
     port map (
      AR(0) => gt_reset_sync_init_clk,
      GT_RESET => GT_RESET,
      HPCNT_RESET => HPCNT_RESET,
      init_clk_in => init_clk_in,
      \out\ => reset_sync_init_clk
    );
gt_wrapper_i: entity work.aurora_8b10b_x1_16b_GT_WRAPPER
     port map (
      AR(0) => gt_reset_sync_init_clk,
      DRPADDR_IN(8 downto 0) => DRPADDR_IN(8 downto 0),
      DRPDI_IN(15 downto 0) => DRPDI_IN(15 downto 0),
      DRPDO_OUT(15 downto 0) => DRPDO_OUT(15 downto 0),
      DRPEN_IN => DRPEN_IN,
      DRPRDY_OUT => DRPRDY_OUT,
      DRPWE_IN => DRPWE_IN,
      \GENERATE_LEVEL_P_S_CDC.SINGLE_BIT.s_level_out_d3_reg\ => gt_wrapper_i_n_51,
      LINK_RESET_OUT => \^link_reset_out\,
      LOOPBACK(2 downto 0) => LOOPBACK(2 downto 0),
      POWER_DOWN => POWER_DOWN,
      RXN => RXN,
      RXP => RXP,
      RX_RESETDONE_OUT => RX_RESETDONE_OUT,
      TXCHARISK(1 downto 0) => TXCHARISK_IN(1 downto 0),
      TXDATA(15 downto 0) => TXDATA_IN(15 downto 0),
      TXN => TXN,
      TXP => TXP,
      TX_OUT_CLK => TX_OUT_CLK,
      TX_RESETDONE_OUT => TX_RESETDONE_OUT,
      drpclk_in => drpclk_in,
      ena_comma_align_i => ena_comma_align_i,
      gt_qpllclk_quad1_in => gt_qpllclk_quad1_in,
      gt_qpllrefclk_quad1_in => gt_qpllrefclk_quad1_in,
      gt_refclk1 => gt_refclk1,
      gtrxreset_i => gtrxreset_i,
      gtxe2_i(1 downto 0) => rx_char_is_comma_i(1 downto 0),
      gtxe2_i_0 => gt_wrapper_i_n_27,
      gtxe2_i_1 => gt_wrapper_i_n_28,
      gtxe2_i_2 => gt_wrapper_i_n_29,
      gtxe2_i_3(1 downto 0) => \err_detect_i/p_2_out\(1 downto 0),
      gtxe2_i_4(7) => gt_wrapper_i_n_33,
      gtxe2_i_4(6) => gt_wrapper_i_n_34,
      gtxe2_i_4(5) => gt_wrapper_i_n_35,
      gtxe2_i_4(4) => gt_wrapper_i_n_36,
      gtxe2_i_4(3) => gt_wrapper_i_n_37,
      gtxe2_i_4(2) => gt_wrapper_i_n_38,
      gtxe2_i_4(1) => gt_wrapper_i_n_39,
      gtxe2_i_4(0) => gt_wrapper_i_n_40,
      gtxe2_i_5(7) => gt_wrapper_i_n_41,
      gtxe2_i_5(6) => gt_wrapper_i_n_42,
      gtxe2_i_5(5) => gt_wrapper_i_n_43,
      gtxe2_i_5(4) => gt_wrapper_i_n_44,
      gtxe2_i_5(3) => gt_wrapper_i_n_45,
      gtxe2_i_5(2) => gt_wrapper_i_n_46,
      gtxe2_i_5(1) => gt_wrapper_i_n_47,
      gtxe2_i_5(0) => gt_wrapper_i_n_48,
      gtxe2_i_6 => gt_wrapper_i_n_49,
      hard_err_flop_r0 => \err_detect_i/hard_err_flop_r0\,
      hard_err_flop_r_reg => \err_detect_i/bucket_full_r\,
      init_clk_in => init_clk_in,
      left_aligned_r_reg => aurora_lane_0_i_n_29,
      left_aligned_r_reg_0 => aurora_lane_0_i_n_37,
      link_reset_r => link_reset_r,
      rx_polarity_i => rx_polarity_i,
      rx_realign_i => rx_realign_i,
      rxfsm_rxresetdone_r3_reg_0 => gt_wrapper_i_n_50,
      sync_clk => sync_clk,
      tx_lock => \^tx_lock\,
      tx_reset_i => tx_reset_i,
      user_clk => user_clk
    );
hpcnt_reset_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_0
     port map (
      RESET => RESET,
      init_clk_in => init_clk_in,
      \out\ => reset_sync_init_clk
    );
reset_sync_user_clk_cdc_sync: entity work.aurora_8b10b_x1_16b_cdc_sync_1
     port map (
      RESET => RESET,
      \out\ => reset_sync_user_clk,
      user_clk => user_clk
    );
rx_ll_i: entity work.aurora_8b10b_x1_16b_RX_LL
     port map (
      D(15) => rx_pe_data_i(0),
      D(14) => rx_pe_data_i(1),
      D(13) => rx_pe_data_i(2),
      D(12) => rx_pe_data_i(3),
      D(11) => rx_pe_data_i(4),
      D(10) => rx_pe_data_i(5),
      D(9) => rx_pe_data_i(6),
      D(8) => rx_pe_data_i(7),
      D(7 downto 4) => \^m_axi_rx_fc_nb\(3 downto 0),
      D(3) => rx_pe_data_i(12),
      D(2) => rx_pe_data_i(13),
      D(1) => rx_pe_data_i(14),
      D(0) => rx_pe_data_i(15),
      D_0 => \tx_ll_control_i/D\,
      FRAME_ERR => FRAME_ERR,
      FRAME_ERR_Buffer0 => \rx_ll_pdu_datapath_i/FRAME_ERR_Buffer0\,
      M_AXI_RX_SNF => \^m_axi_rx_snf\,
      M_AXI_RX_TDATA(15 downto 0) => M_AXI_RX_TDATA(15 downto 0),
      M_AXI_RX_TKEEP(0) => \^m_axi_rx_tkeep\(1),
      M_AXI_RX_TLAST => M_AXI_RX_TLAST,
      M_AXI_RX_TVALID => M_AXI_RX_TVALID,
      M_AXI_UFC_RX_TDATA(15 downto 0) => M_AXI_UFC_RX_TDATA(15 downto 0),
      M_AXI_UFC_RX_TLAST => M_AXI_UFC_RX_TLAST,
      M_AXI_UFC_RX_TVALID => M_AXI_UFC_RX_TVALID,
      Q(0) => \nfc_module_i/nfc_counter_r_reg\(0),
      RX_EOF_N_Buffer_reg => aurora_lane_0_i_n_36,
      SR(0) => clear,
      in_frame_r => \rx_ll_pdu_datapath_i/in_frame_r\,
      in_frame_r_reg => aurora_lane_0_i_n_39,
      rx_ecp_i => rx_ecp_i,
      rx_pad_i => rx_pad_i,
      rx_pe_data_v_i => rx_pe_data_v_i,
      rx_suf_i => rx_suf_i,
      storage_v_r => \rx_ll_pdu_datapath_i/storage_v_r\,
      tx_dst_rdy => tx_dst_rdy,
      \ufc_count_r_reg[0]\(3) => \ufc_filter_i/ufc_count_r_reg\(0),
      \ufc_count_r_reg[0]\(2) => \ufc_filter_i/ufc_count_r_reg\(1),
      \ufc_count_r_reg[0]\(1) => \ufc_filter_i/ufc_count_r_reg\(2),
      \ufc_count_r_reg[0]\(0) => \ufc_filter_i/ufc_count_r_reg\(3),
      \ufc_count_r_reg[0]_0\(3 downto 0) => p_0_in(3 downto 0),
      \ufc_count_r_reg[2]\ => rx_ll_i_n_11,
      \ufc_count_r_reg[3]\ => rx_ll_i_n_12,
      user_clk => user_clk
    );
standard_cc_module_i: entity work.aurora_8b10b_x1_16b_STANDARD_CC_MODULE
     port map (
      DO_CC_reg_0 => \^sys_reset_out\,
      Q => DO_CC_I,
      S_AXI_NFC_REQ => S_AXI_NFC_REQ,
      S_AXI_UFC_TX_REQ => S_AXI_UFC_TX_REQ,
      WARN_CC => WARN_CC,
      s_axi_ufc_tx_tvalid => standard_cc_module_i_n_1,
      \ufc_message_count_r_reg[2]\ => \^s_axi_nfc_ack\,
      user_clk => user_clk
    );
tx_ll_i: entity work.aurora_8b10b_x1_16b_TX_LL
     port map (
      D => \tx_ll_control_i/D\,
      \FC_NB_Buffer_reg[0]\(3) => fc_nb_i(0),
      \FC_NB_Buffer_reg[0]\(2) => fc_nb_i(1),
      \FC_NB_Buffer_reg[0]\(1) => fc_nb_i(2),
      \FC_NB_Buffer_reg[0]\(0) => fc_nb_i(3),
      Q => DO_CC_I,
      S_AXI_NFC_NB(3 downto 0) => S_AXI_NFC_NB(3 downto 0),
      S_AXI_NFC_REQ => S_AXI_NFC_REQ,
      S_AXI_TX_TDATA(15 downto 0) => S_AXI_TX_TDATA(15 downto 0),
      S_AXI_TX_TKEEP(1 downto 0) => S_AXI_TX_TKEEP(1 downto 0),
      S_AXI_TX_TLAST => S_AXI_TX_TLAST,
      S_AXI_TX_TREADY => S_AXI_TX_TREADY,
      S_AXI_TX_TVALID => S_AXI_TX_TVALID,
      S_AXI_UFC_TX_MS(2 downto 0) => S_AXI_UFC_TX_MS(2 downto 0),
      S_AXI_UFC_TX_REQ => S_AXI_UFC_TX_REQ,
      TX_DST_RDY_N_Buffer_reg(0) => \nfc_module_i/nfc_counter_r_reg\(0),
      \TX_PE_DATA_Buffer_reg[0]\(15) => tx_pe_data_i(0),
      \TX_PE_DATA_Buffer_reg[0]\(14) => tx_pe_data_i(1),
      \TX_PE_DATA_Buffer_reg[0]\(13) => tx_pe_data_i(2),
      \TX_PE_DATA_Buffer_reg[0]\(12) => tx_pe_data_i(3),
      \TX_PE_DATA_Buffer_reg[0]\(11) => tx_pe_data_i(4),
      \TX_PE_DATA_Buffer_reg[0]\(10) => tx_pe_data_i(5),
      \TX_PE_DATA_Buffer_reg[0]\(9) => tx_pe_data_i(6),
      \TX_PE_DATA_Buffer_reg[0]\(8) => tx_pe_data_i(7),
      \TX_PE_DATA_Buffer_reg[0]\(7) => tx_pe_data_i(8),
      \TX_PE_DATA_Buffer_reg[0]\(6) => tx_pe_data_i(9),
      \TX_PE_DATA_Buffer_reg[0]\(5) => tx_pe_data_i(10),
      \TX_PE_DATA_Buffer_reg[0]\(4) => tx_pe_data_i(11),
      \TX_PE_DATA_Buffer_reg[0]\(3) => tx_pe_data_i(12),
      \TX_PE_DATA_Buffer_reg[0]\(2) => tx_pe_data_i(13),
      \TX_PE_DATA_Buffer_reg[0]\(1) => tx_pe_data_i(14),
      \TX_PE_DATA_Buffer_reg[0]\(0) => tx_pe_data_i(15),
      WARN_CC => WARN_CC,
      do_nfc_r_reg => \^s_axi_nfc_ack\,
      gen_cc_i => gen_cc_i,
      gen_ecp_i => gen_ecp_i,
      gen_pad_i => gen_pad_i,
      gen_scp_i => gen_scp_i,
      gen_snf_i => gen_snf_i,
      gen_suf_i => gen_suf_i,
      p_0_in => p_0_in_0,
      storage_pad_r_reg => axi_to_ll_pdu_i_n_0,
      tx_dst_rdy => tx_dst_rdy,
      tx_pe_data_v_i => tx_pe_data_v_i,
      ufc_header_r_reg => S_AXI_UFC_TX_ACK,
      \ufc_message_count_r_reg[2]\ => standard_cc_module_i_n_1,
      user_clk => user_clk
    );
end STRUCTURE;
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
entity aurora_8b10b_x1_16b is
  port (
    s_axi_tx_tdata : in STD_LOGIC_VECTOR ( 15 downto 0 );
    s_axi_tx_tvalid : in STD_LOGIC;
    s_axi_tx_tready : out STD_LOGIC;
    s_axi_tx_tkeep : in STD_LOGIC_VECTOR ( 1 downto 0 );
    s_axi_tx_tlast : in STD_LOGIC;
    m_axi_rx_tdata : out STD_LOGIC_VECTOR ( 15 downto 0 );
    m_axi_rx_tvalid : out STD_LOGIC;
    m_axi_rx_tkeep : out STD_LOGIC_VECTOR ( 1 downto 0 );
    m_axi_rx_tlast : out STD_LOGIC;
    s_axi_nfc_tx_tvalid : in STD_LOGIC;
    s_axi_nfc_tx_tdata : in STD_LOGIC_VECTOR ( 3 downto 0 );
    s_axi_nfc_tx_tready : out STD_LOGIC;
    m_axi_nfc_rx_tvalid : out STD_LOGIC;
    m_axi_nfc_rx_tdata : out STD_LOGIC_VECTOR ( 3 downto 0 );
    s_axi_ufc_tx_tvalid : in STD_LOGIC;
    s_axi_ufc_tx_tdata : in STD_LOGIC_VECTOR ( 2 downto 0 );
    s_axi_ufc_tx_tready : out STD_LOGIC;
    m_axi_ufc_rx_tdata : out STD_LOGIC_VECTOR ( 15 downto 0 );
    m_axi_ufc_rx_tkeep : out STD_LOGIC_VECTOR ( 1 downto 0 );
    m_axi_ufc_rx_tvalid : out STD_LOGIC;
    m_axi_ufc_rx_tlast : out STD_LOGIC;
    rxp : in STD_LOGIC_VECTOR ( 0 to 0 );
    rxn : in STD_LOGIC_VECTOR ( 0 to 0 );
    txp : out STD_LOGIC_VECTOR ( 0 to 0 );
    txn : out STD_LOGIC_VECTOR ( 0 to 0 );
    gt_refclk1 : in STD_LOGIC;
    frame_err : out STD_LOGIC;
    hard_err : out STD_LOGIC;
    soft_err : out STD_LOGIC;
    channel_up : out STD_LOGIC;
    lane_up : out STD_LOGIC_VECTOR ( 0 to 0 );
    user_clk : in STD_LOGIC;
    sync_clk : in STD_LOGIC;
    reset : in STD_LOGIC;
    power_down : in STD_LOGIC;
    loopback : in STD_LOGIC_VECTOR ( 2 downto 0 );
    gt_reset : in STD_LOGIC;
    tx_lock : out STD_LOGIC;
    sys_reset_out : out STD_LOGIC;
    init_clk_in : in STD_LOGIC;
    tx_resetdone_out : out STD_LOGIC;
    rx_resetdone_out : out STD_LOGIC;
    link_reset_out : out STD_LOGIC;
    drpclk_in : in STD_LOGIC;
    drpaddr_in : in STD_LOGIC_VECTOR ( 8 downto 0 );
    drpdi_in : in STD_LOGIC_VECTOR ( 15 downto 0 );
    drpdo_out : out STD_LOGIC_VECTOR ( 15 downto 0 );
    drpen_in : in STD_LOGIC;
    drprdy_out : out STD_LOGIC;
    drpwe_in : in STD_LOGIC;
    gt0_qplllock_in : in STD_LOGIC;
    gt0_qpllrefclklost_in : in STD_LOGIC;
    gt0_qpllreset_out : out STD_LOGIC;
    gt_qpllclk_quad1_in : in STD_LOGIC;
    gt_qpllrefclk_quad1_in : in STD_LOGIC;
    tx_out_clk : out STD_LOGIC;
    pll_not_locked : in STD_LOGIC
  );
  attribute NotValidForBitStream : boolean;
  attribute NotValidForBitStream of aurora_8b10b_x1_16b : entity is true;
end aurora_8b10b_x1_16b;

architecture STRUCTURE of aurora_8b10b_x1_16b is
  signal \<const0>\ : STD_LOGIC;
  signal \<const1>\ : STD_LOGIC;
  signal \^m_axi_rx_tkeep\ : STD_LOGIC_VECTOR ( 1 to 1 );
  signal NLW_U0_gt0_qpllreset_out_UNCONNECTED : STD_LOGIC;
  signal NLW_U0_M_AXI_RX_TKEEP_UNCONNECTED : STD_LOGIC_VECTOR ( 0 to 0 );
  signal NLW_U0_M_AXI_UFC_RX_TKEEP_UNCONNECTED : STD_LOGIC_VECTOR ( 1 downto 0 );
  attribute CC_FREQ_FACTOR : integer;
  attribute CC_FREQ_FACTOR of U0 : label is 24;
  attribute EXAMPLE_SIMULATION : integer;
  attribute EXAMPLE_SIMULATION of U0 : label is 0;
  attribute SIM_GTRESET_SPEEDUP : string;
  attribute SIM_GTRESET_SPEEDUP of U0 : label is "TRUE";
begin
  gt0_qpllreset_out <= \<const0>\;
  m_axi_rx_tkeep(1) <= \^m_axi_rx_tkeep\(1);
  m_axi_rx_tkeep(0) <= \<const1>\;
  m_axi_ufc_rx_tkeep(1) <= \<const1>\;
  m_axi_ufc_rx_tkeep(0) <= \<const1>\;
GND: unisim.vcomponents.GND
     port map (
      G => \<const0>\
    );
U0: entity work.aurora_8b10b_x1_16b_core
     port map (
      CHANNEL_UP => channel_up,
      DRPADDR_IN(8 downto 0) => drpaddr_in(8 downto 0),
      DRPDI_IN(15 downto 0) => drpdi_in(15 downto 0),
      DRPDO_OUT(15 downto 0) => drpdo_out(15 downto 0),
      DRPEN_IN => drpen_in,
      DRPRDY_OUT => drprdy_out,
      DRPWE_IN => drpwe_in,
      FRAME_ERR => frame_err,
      GT_RESET => gt_reset,
      HARD_ERR => hard_err,
      LANE_UP => lane_up(0),
      LINK_RESET_OUT => link_reset_out,
      LOOPBACK(2 downto 0) => loopback(2 downto 0),
      M_AXI_RX_FC_NB(3 downto 0) => m_axi_nfc_rx_tdata(3 downto 0),
      M_AXI_RX_SNF => m_axi_nfc_rx_tvalid,
      M_AXI_RX_TDATA(15 downto 0) => m_axi_rx_tdata(15 downto 0),
      M_AXI_RX_TKEEP(1) => \^m_axi_rx_tkeep\(1),
      M_AXI_RX_TKEEP(0) => NLW_U0_M_AXI_RX_TKEEP_UNCONNECTED(0),
      M_AXI_RX_TLAST => m_axi_rx_tlast,
      M_AXI_RX_TVALID => m_axi_rx_tvalid,
      M_AXI_UFC_RX_TDATA(15 downto 0) => m_axi_ufc_rx_tdata(15 downto 0),
      M_AXI_UFC_RX_TKEEP(1 downto 0) => NLW_U0_M_AXI_UFC_RX_TKEEP_UNCONNECTED(1 downto 0),
      M_AXI_UFC_RX_TLAST => m_axi_ufc_rx_tlast,
      M_AXI_UFC_RX_TVALID => m_axi_ufc_rx_tvalid,
      PLL_NOT_LOCKED => '0',
      POWER_DOWN => power_down,
      RESET => reset,
      RXN => rxn(0),
      RXP => rxp(0),
      RX_RESETDONE_OUT => rx_resetdone_out,
      SOFT_ERR => soft_err,
      S_AXI_NFC_ACK => s_axi_nfc_tx_tready,
      S_AXI_NFC_NB(3 downto 0) => s_axi_nfc_tx_tdata(3 downto 0),
      S_AXI_NFC_REQ => s_axi_nfc_tx_tvalid,
      S_AXI_TX_TDATA(15 downto 0) => s_axi_tx_tdata(15 downto 0),
      S_AXI_TX_TKEEP(1 downto 0) => s_axi_tx_tkeep(1 downto 0),
      S_AXI_TX_TLAST => s_axi_tx_tlast,
      S_AXI_TX_TREADY => s_axi_tx_tready,
      S_AXI_TX_TVALID => s_axi_tx_tvalid,
      S_AXI_UFC_TX_ACK => s_axi_ufc_tx_tready,
      S_AXI_UFC_TX_MS(2 downto 0) => s_axi_ufc_tx_tdata(2 downto 0),
      S_AXI_UFC_TX_REQ => s_axi_ufc_tx_tvalid,
      TXN => txn(0),
      TXP => txp(0),
      TX_OUT_CLK => tx_out_clk,
      TX_RESETDONE_OUT => tx_resetdone_out,
      drpclk_in => drpclk_in,
      gt0_qplllock_in => '0',
      gt0_qpllrefclklost_in => '0',
      gt0_qpllreset_out => NLW_U0_gt0_qpllreset_out_UNCONNECTED,
      gt_qpllclk_quad1_in => gt_qpllclk_quad1_in,
      gt_qpllrefclk_quad1_in => gt_qpllrefclk_quad1_in,
      gt_refclk1 => gt_refclk1,
      init_clk_in => init_clk_in,
      sync_clk => sync_clk,
      sys_reset_out => sys_reset_out,
      tx_lock => tx_lock,
      user_clk => user_clk
    );
VCC: unisim.vcomponents.VCC
     port map (
      P => \<const1>\
    );
end STRUCTURE;
