# Create project
create_project $project_name ./$project_name -part $part -force
add_files $src_files
add_files $constraints_files
set_property top $top_name [current_fileset]

# Set other project properties
set obj [get_projects $project_name]
set_property "default_lib" "xil_defaultlib" $obj
set_property "simulator_language" "Mixed" $obj
set_property "target_language" "VHDL" $obj
# Disabling IP Cache !
config_ip_cache -disable_cache

# Launch Synthesis
launch_runs synth_1
wait_on_run synth_1

# Launch Implementation
#set_property strategy Performance_Explore [get_runs impl_1]
launch_runs impl_1
wait_on_run impl_1

# Generate Bitstream + Bin
open_checkpoint ./${project_name}/${project_name}.runs/impl_1/${top_name}_routed.dcp
write_bitstream -force -bin_file $project_name.bit
write_debug_probes -force $project_name.ltx

# Create MCS File (VC707)
# (https://scholar.princeton.edu/jbalkind/blog/programming-vc707-virtex-7-bpi-flash)
# VC707 flash is mt28gu01gaax1e (alias 28f00ag18f)
set mcs_file "$project_name.mcs"
write_cfgmem -force -format mcs -interface $SPI_N -size 128 -loadbit "up 0x0 $project_name.bit" -file $mcs_file

# #connect_hw_server -host localhost -port 60001
# open_hw
# connect_hw_server
# open_hw_target
# set_property PROGRAM.FILE $project_name/$project_name.runs/impl_1/$top_name.bit [lindex [get_hw_devices] 0]
# current_hw_device [lindex [get_hw_devices] 0]
# program_hw_devices [lindex [get_hw_devices] 0]
exit