# ---------------------------------------------
# ---------------------------------------------
# ---------------------------------------------
#  PINOUT
# ---------------------------------------------
# ---------------------------------------------
# ---------------------------------------------

# ---------------------------------------------
#  EXTERNAL CLOCKS
# ---------------------------------------------
set_property PACKAGE_PIN F17     [get_ports ext_clk100mhz]
set_property IOSTANDARD LVCMOS33 [get_ports ext_clk100mhz]

set_property PACKAGE_PIN D6 [get_ports clk156_p]
set_property PACKAGE_PIN D5 [get_ports clk156_n]

# ---------------------------------------------
#  EXTERNAL RESET
# ---------------------------------------------
set_property PACKAGE_PIN AC16    [get_ports ext_reset]
set_property IOSTANDARD LVCMOS18 [get_ports ext_reset]

# ---------------------------------------------
#  SFP
# ---------------------------------------------
set_property PACKAGE_PIN H2 [get_ports sfp_tx_p]
set_property PACKAGE_PIN H1 [get_ports sfp_tx_n]
set_property PACKAGE_PIN J4 [get_ports sfp_rx_p]
set_property PACKAGE_PIN J3 [get_ports sfp_rx_n]

# ---------------------------------------------
#  LEDS
# ---------------------------------------------
set_property PACKAGE_PIN AA2 [get_ports user_led[0]]
set_property PACKAGE_PIN AD5 [get_ports user_led[1]]
set_property PACKAGE_PIN W10 [get_ports user_led[2]]
set_property PACKAGE_PIN Y10 [get_ports user_led[3]]
set_property PACKAGE_PIN AE10 [get_ports user_led[4]]
set_property PACKAGE_PIN W11 [get_ports user_led[5]]
set_property PACKAGE_PIN V11 [get_ports user_led[6]]
set_property PACKAGE_PIN Y12 [get_ports user_led[7]]
set_property IOSTANDARD LVCMOS18 [get_ports user_led*]



# ---------------------------------------------
# ---------------------------------------------
# ---------------------------------------------
#  BITSTREAM SETTINGS
# ---------------------------------------------
# ---------------------------------------------
# ---------------------------------------------

# Virtex 7 Configuration Device options : bitstream compression, clock @ 33MHz, SPI mode x1
set_property BITSTREAM.GENERAL.COMPRESS TRUE [current_design]
set_property BITSTREAM.CONFIG.CONFIGRATE 33 [current_design]
set_property CONFIG_MODE SPIx1 [current_design]



# ---------------------------------------------
# ---------------------------------------------
# ---------------------------------------------
#  Timing Constraints start here !
# ---------------------------------------------
# ---------------------------------------------
# ---------------------------------------------

# ---------------------------------------------
#  External Clocks
# ---------------------------------------------
create_clock -period 10.0 -name ext_clk100mhz [get_ports ext_clk100mhz]
create_clock -period 6.4  -name clk156_p      [get_ports clk156_p]
create_clock -period 12.800	 [get_pins -filter {REF_PIN_NAME=~*TXOUTCLK} -of_objects [get_cells -hierarchical -filter {NAME =~ *gt_wrapper_i*aurora_8b10b_x1_32b_multi_gt_i*gt0_aurora_8b10b_x1_32b_i*gtxe2_i*}]]

# ---------------------------------------------
#  Clock Groups
# ---------------------------------------------


# ---------------------------------------------
#  External Reset
# ---------------------------------------------
set_false_path -from [get_ports ext_reset] -to *

# ---------------------------------------------
#  LEDS Pins - False Paths
# ---------------------------------------------
set_false_path -from * -to [get_ports user_led*]

# Aurora CDC
set_false_path -to [get_pins -hier *aurora_8b10b_x1_32b_cdc_to*/D]
#
set_false_path -to [get_cells -hierarchical -filter {NAME =~ *data_sync_reg1}]
set_false_path -to [get_cells -hierarchical -filter {NAME =~ *ack_sync_reg1}]
