----------------------------------------------------------------------------------------------------
-- Copyright (c) ReFLEX CES 1998-2012
--
-- Use of this source code through a simulator and/or a compiler tool
-- is illegal if not authorised through ReFLEX CES License agreement.
----------------------------------------------------------------------------------------------------
-- Project     : 
----------------------------------------------------------------------------------------------------
-- Top level   : top.vhd
-- File        : if_to_axi.vhd
-- Author      : flavenant@reflexces.com
-- Company     : ReFLEX CES
--               2, rue du gevaudan
--               91047 LISSES
--               FRANCE
--               http://www.reflexces.com
-- Plateforme  : Windows XP
-- Simulator   : Mentor Graphics ModelSim
-- Synthesis   : Quartus II
-- Target      : Stratix IV
-- Dependency  :
----------------------------------------------------------------------------------------------------
-- Description :
-- Convert "generic" interface to AXI.
--
----------------------------------------------------------------------------------------------------
-- Version      Date            Author              Description
-- 0.1          2012/01/17      FLA                 Creation
----------------------------------------------------------------------------------------------------
library ieee;
use     ieee.std_logic_1164.all;
use     ieee.numeric_std.all;

entity if_to_axi is
    generic (
       NB_LANES   : integer :=  1;   -- Number of 16/32bits lanes.
       LANE_WIDTH : integer := 16    -- 16 or 32
    );
    port (
        -- Reset and clocks
          rst_n                 : in    std_logic     -- asynchronous active low reset
        ; clk                   : in    std_logic     -- clock
        
        -- Input interface (SOP + EOP)
        ; din_d                 : in    std_logic_vector(LANE_WIDTH  *NB_LANES-1 downto 0)
        ; din_vld               : in    std_logic
        ; din_bena              : in    std_logic_vector(LANE_WIDTH/8*NB_LANES-1 downto 0)
        ; din_sop               : in    std_logic
        ; din_eop               : in    std_logic
        ; din_rdy               : out   std_logic
        
        -- Output AXI interface
        ; axi_d                 : out   std_logic_vector(LANE_WIDTH  *NB_LANES-1 downto 0)
        ; axi_keep              : out   std_logic_vector(LANE_WIDTH/8*NB_LANES-1 downto 0)
        ; axi_last              : out   std_logic
        ; axi_vld               : out   std_logic
        ; axi_rdy               : in    std_logic   := '1'
    );
end entity if_to_axi;

architecture rtl of if_to_axi is
	----------------------------------------------------------------
	-- Type declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Function declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Component declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Constant declarations
	----------------------------------------------------------------

	----------------------------------------------------------------
	-- Signal declarations
	----------------------------------------------------------------

begin

    axi_d    <= din_d;
    axi_keep <= din_bena;
    axi_last <= din_eop;
    axi_vld  <= din_vld;
    din_rdy  <= axi_rdy;
    
end architecture rtl;
