----------------------------------------------------------------------------------------------------
-- Copyright (c) ReFLEX CES 1998-2012
--
-- Use of this source code through a simulator and/or a compiler tool
-- is illegal if not authorised through ReFLEX CES License agreement.
----------------------------------------------------------------------------------------------------
-- Project     : 
----------------------------------------------------------------------------------------------------
-- Top level   : top.vhd
-- File        : if_from_axi.vhd
-- Author      : flavenant@reflexces.com
-- Company     : ReFLEX CES
--               2, rue du gevaudan
--               91047 LISSES
--               FRANCE
--               http://www.reflexces.com
-- Plateforme  : Windows XP
-- Simulator   : Mentor Graphics ModelSim
-- Synthesis   : Quartus II
-- Target      : Stratix IV
-- Dependency  :
----------------------------------------------------------------------------------------------------
-- Description :
-- Convert AXI interface to a "generic" one.
--
----------------------------------------------------------------------------------------------------
-- Version      Date            Author              Description
-- 0.1          2012/01/17      FLA                 Creation
----------------------------------------------------------------------------------------------------
library ieee;
use     ieee.std_logic_1164.all;
use     ieee.numeric_std.all;

entity if_from_axi is
    generic (
      NB_LANES   : integer :=  1;  -- Number of 16/32bits lanes
      LANE_WIDTH : integer := 16   -- 16 or 32
    );
    port (
        -- Reset and clocks
          rst_n                 : in    std_logic     -- asynchronous active low reset
        ; clk                   : in    std_logic     -- clock
        
        -- Input AXI interface
        ; axi_d                 : in    std_logic_vector(LANE_WIDTH  *NB_LANES-1 downto 0)
        ; axi_keep              : in    std_logic_vector(LANE_WIDTH/8*NB_LANES-1 downto 0)
        ; axi_last              : in    std_logic
        ; axi_vld               : in    std_logic
        ; axi_rdy               : out   std_logic
        
        -- Output interface (SOP + EOP)
        ; dout_d                : out   std_logic_vector(LANE_WIDTH  *NB_LANES-1 downto 0)
        ; dout_vld              : out   std_logic
        ; dout_bena             : out   std_logic_vector(LANE_WIDTH/8*NB_LANES-1 downto 0)
        ; dout_sop              : out   std_logic
        ; dout_eop              : out   std_logic
        ; dout_rdy              : in    std_logic
    );
end entity if_from_axi;

architecture rtl of if_from_axi is
	----------------------------------------------------------------
	-- Type declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Function declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Component declarations
	----------------------------------------------------------------
    
	----------------------------------------------------------------
	-- Constant declarations
	----------------------------------------------------------------

	----------------------------------------------------------------
	-- Signal declarations
	----------------------------------------------------------------
    signal s_sop   : std_logic;
    
begin

    dout_d    <= axi_d;
    dout_bena <= axi_keep;
    dout_sop  <= s_sop;
    dout_eop  <= axi_last;
    dout_vld  <= axi_vld;
    axi_rdy   <= dout_rdy;
    
    p_sof : process (rst_n, clk)
    begin
    if rst_n='0' then
        s_sop <= '1';
    elsif rising_edge(clk) then
           if axi_vld='1' and axi_last='0' and dout_rdy='1' then s_sop <= '0';
        elsif axi_vld='1' and axi_last='1' and dout_rdy='1' then s_sop <= '1'; end if;
    end if;
    end process p_sof;
    
end architecture rtl;
