///////////////////////////////////////////////////////////////////////////////
// (c) Copyright 2023 Advanced Micro Devices, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Advanced Micro Devices, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// AMD, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND AMD HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) AMD shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or AMD had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// AMD products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of AMD products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
//
///////////////////////////////////////////////////////////////////////////////
//
//  UFC_FILTER
//
//
//  Description: The UFC module separates data into UFC data and regular data.
//
//               This module supports 1 2-byte lane designs.
//

`timescale 1 ns / 1 ps

module aurora_8b10b_x1_16b_UFC_FILTER
(
    // Aurora Channel Interface

    RX_PAD,
    RX_PE_DATA,
    RX_PE_DATA_V,
    RX_SCP,
    RX_ECP,
    RX_SUF,
    RX_FC_NB,

    // PDU Datapath Interface

    PDU_DATA,
    PDU_DATA_V,
    PDU_PAD,
    PDU_SCP,
    PDU_ECP,

    // UFC Datapath Interface

    UFC_DATA,
    UFC_DATA_V,
    UFC_MESSAGE_START,
    UFC_START,

    // System Interface

    USER_CLK,
    RESET

 );

`define DLY #1


//***********************************Port Declarations*******************************

    // Aurora Channel Interface

input              RX_PAD;
input   [0:15]     RX_PE_DATA;
input              RX_PE_DATA_V;
input              RX_SCP;
input              RX_ECP;
input              RX_SUF;
input   [0:3]      RX_FC_NB;

    // PDU Datapath Interface

output  [0:15]     PDU_DATA;
output             PDU_DATA_V;
output             PDU_PAD;
output             PDU_SCP;
output             PDU_ECP;

    // UFC Datapath Interface

output  [0:15]     UFC_DATA;
output             UFC_DATA_V;
output             UFC_MESSAGE_START;
output             UFC_START;


    // System Interface

    input              USER_CLK;
    input              RESET;



//****************************Internal Register Declarations*************************

    reg     [0:3]      ufc_command_decode_c;
    reg     [0:3]      ufc_count_r;


//*********************************Main Body of Code*********************************



    // UFC data is invalid pdu data.

    assign  PDU_DATA_V  =   RX_PE_DATA_V && (ufc_count_r == 4'h0);


    // The UFC counter is a 4 bit counter that is loaded only when an SUF arrives.

    always @(posedge USER_CLK)
        if(RESET)                   ufc_count_r <=  `DLY    4'h0;
        else if(RX_SUF)             ufc_count_r <=  `DLY    ufc_command_decode_c;
        else if(ufc_count_r > 0)    ufc_count_r <=  `DLY    ufc_count_r - 4'h1;


    // The command decoder for UFC converts the FC_NB code to a starting count value.

    always @(RX_FC_NB[0:2])
        case(RX_FC_NB[0:2])
            3'h0    :   ufc_command_decode_c  =   4'h1;
            3'h1    :   ufc_command_decode_c  =   4'h2;
            3'h2    :   ufc_command_decode_c  =   4'h3;
            3'h3    :   ufc_command_decode_c  =   4'h4;
            3'h4    :   ufc_command_decode_c  =   4'h5;
            3'h5    :   ufc_command_decode_c  =   4'h6;
            3'h6    :   ufc_command_decode_c  =   4'h7;
            3'h7    :   ufc_command_decode_c  =   4'h8;
            default :   ufc_command_decode_c  =   4'h0;
        endcase


    // Pipe the remaining signals through.

    assign  PDU_PAD             =   RX_PAD;
    assign  PDU_DATA            =   RX_PE_DATA;
    assign  PDU_SCP             =   RX_SCP;
    assign  PDU_ECP             =   RX_ECP;

    assign  UFC_DATA            =   RX_PE_DATA;
    assign  UFC_DATA_V          =   (ufc_count_r != 4'h0);
    assign  UFC_MESSAGE_START   =   RX_SUF;
    assign  UFC_START           =   RX_SUF;



endmodule
