///////////////////////////////////////////////////////////////////////////////
// (c) Copyright 2023 Advanced Micro Devices, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Advanced Micro Devices, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// AMD, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND AMD HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) AMD shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or AMD had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// AMD products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of AMD products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
//
///////////////////////////////////////////////////////////////////////////////
//
//  RX_LL
//
//
//  Description: The RX_LL module receives data from the Aurora Channel,
//               converts it to LocalLink and sends it to the user interface.
//               It also handles NFC and UFC messages.
//
//               This module supports 1 2-byte lane designs.
//
//               This module supports Immediate Mode Native Flow Control.
//               This module supports User Flow Control.
//

`timescale 1 ns / 1 ps

module aurora_8b10b_x1_16b_RX_LL
(
    // LocalLink PDU Interface
    RX_D,
    RX_REM,
    RX_SRC_RDY_N,
    RX_SOF_N,
    RX_EOF_N,

    // UFC Interface
    UFC_RX_DATA,
    UFC_RX_REM,
    UFC_RX_SRC_RDY_N,
    UFC_RX_SOF_N,
    UFC_RX_EOF_N,

    // Global Logic Interface
    START_RX,


    // Aurora Lane Interface
    RX_PAD,
    RX_PE_DATA,
    RX_PE_DATA_V,
    RX_SCP,
    RX_ECP,
    RX_SNF,
    RX_SUF,
    RX_FC_NB,

    // TX_LL Interface
    DECREMENT_NFC,

    TX_WAIT,

    // Error Interface
    FRAME_ERR,


    // System Interface
    USER_CLK


);

`define DLY #1


//***********************************Port Declarations*******************************


    // LocalLink PDU Interface
output  [0:15]     RX_D;
output             RX_REM;
output             RX_SRC_RDY_N;
output             RX_SOF_N;
output             RX_EOF_N;

    // UFC Interface
output  [0:15]     UFC_RX_DATA;
output             UFC_RX_REM;
output             UFC_RX_SRC_RDY_N;
output             UFC_RX_SOF_N;
output             UFC_RX_EOF_N;

    // Global Logic Interface
input              START_RX;


    // Aurora Lane Interface
input              RX_PAD;
input   [0:15]     RX_PE_DATA;
input              RX_PE_DATA_V;
input              RX_SCP;
input              RX_ECP;
input              RX_SNF;
input              RX_SUF;
input   [0:3]      RX_FC_NB;

    // TX_LL Interface
input              DECREMENT_NFC;

output             TX_WAIT;

    // Error Interface
output             FRAME_ERR;

    // System Interface
input              USER_CLK;


//*********************************Wire Declarations**********************************

wire               pdu_pad_i;
wire    [0:15]     pdu_data_i;
wire               pdu_data_v_i;
wire               pdu_scp_i;
wire               pdu_ecp_i;

wire               ufc_message_start_i;
wire    [0:15]     ufc_data_i;
wire               ufc_data_v_i;
wire               ufc_start_i;



wire               rx_ll_rst;

//*********************************Main Body of Code**********************************

   assign rx_ll_rst = ~START_RX;

    //_______________________________NFC processing_________________________________

    aurora_8b10b_x1_16b_RX_LL_NFC nfc_module_i
    (
        // Aurora Lane Interface
        .RX_SNF(RX_SNF),
        .RX_FC_NB(RX_FC_NB),


        // TX_LL Interface
        .DECREMENT_NFC(DECREMENT_NFC),

        .TX_WAIT(TX_WAIT),

        // Global Logic Interface
        .CHANNEL_UP(START_RX),


        // USER Interface
        .USER_CLK(USER_CLK)

    );


    //____________________ Separate UFC traffic from regular data_____________________

    aurora_8b10b_x1_16b_UFC_FILTER ufc_filter_i
    (
        // Aurora Channel Interface
        .RX_PAD(RX_PAD),
        .RX_PE_DATA(RX_PE_DATA),
        .RX_PE_DATA_V(RX_PE_DATA_V),
        .RX_SCP(RX_SCP),
        .RX_ECP(RX_ECP),
        .RX_SUF(RX_SUF),
        .RX_FC_NB(RX_FC_NB),


        // PDU Datapath Interface
        .PDU_DATA(pdu_data_i),
        .PDU_DATA_V(pdu_data_v_i),
        .PDU_PAD(pdu_pad_i),
        .PDU_SCP(pdu_scp_i),
        .PDU_ECP(pdu_ecp_i),


        // UFC Datapath Interface
        .UFC_DATA(ufc_data_i),
        .UFC_DATA_V(ufc_data_v_i),
        .UFC_MESSAGE_START(ufc_message_start_i),
        .UFC_START(ufc_start_i),


        // System Interface
        .USER_CLK(USER_CLK),
        .RESET(rx_ll_rst)
    );




    //____________________________ Datapath for user PDUs_____________________________

    aurora_8b10b_x1_16b_RX_LL_PDU_DATAPATH rx_ll_pdu_datapath_i
    (

        // Traffic Separator Interface
        .PDU_DATA(pdu_data_i),
        .PDU_DATA_V(pdu_data_v_i),
        .PDU_PAD(pdu_pad_i),
        .PDU_SCP(pdu_scp_i),
        .PDU_ECP(pdu_ecp_i),


        // LocalLink PDU Interface
        .RX_D(RX_D),
        .RX_REM(RX_REM),
        .RX_SRC_RDY_N(RX_SRC_RDY_N),
        .RX_SOF_N(RX_SOF_N),
        .RX_EOF_N(RX_EOF_N),


        // Error Interface
        .FRAME_ERR(FRAME_ERR),


        // System Interface
        .USER_CLK(USER_CLK),
        .RESET(rx_ll_rst)
    );



    //_______________________Datapath for UFC PDUs___________________________________

    aurora_8b10b_x1_16b_RX_LL_UFC_DATAPATH rx_ll_ufc_datapath_i
    (
        // Traffic Separator Interface
        .UFC_DATA(ufc_data_i),
        .UFC_DATA_V(ufc_data_v_i),
        .UFC_MESSAGE_START(ufc_message_start_i),
        .UFC_START(ufc_start_i),


        // LocalLink PDU Interface
        .UFC_RX_DATA(UFC_RX_DATA),
        .UFC_RX_REM(UFC_RX_REM),
        .UFC_RX_SRC_RDY_N(UFC_RX_SRC_RDY_N),
        .UFC_RX_SOF_N(UFC_RX_SOF_N),
        .UFC_RX_EOF_N(UFC_RX_EOF_N),


        // System Interface
        .USER_CLK(USER_CLK),
        .RESET(rx_ll_rst)
    );

endmodule
